package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.dao.ChtUserDataDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cmn.model.RequestModel;

/**
 * <br>[機  能] 添付ファイルをダウンロードすることが出来るかを判定する
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtDownloadCheckBiz {

    /** ダウンロードチェック エラーコード OK*/
    public static final int DOWNLOADCHECK_CODE_OK = 0;
    /** ダウンロードチェック エラーコード 存在しない*/
    public static final int DOWNLOADCHECK_CODE_NONE = 1;

    /** リクエスト情報 */
    private RequestModel reqMdl__;
    /** コネクション */
    private Connection con__;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl 1:ユーザ, 2:グループ
     * @param con コネクション
     */
    public ChtDownloadCheckBiz(RequestModel reqMdl, Connection con) {
        reqMdl__ = reqMdl;
        con__ = con;
    }

    /**
     * <br>[機  能] ダウンロード権限チェック
     * <br>[解  説] 指定したメッセージと選択しているチャットSIDの組み合わせに不正がないことを確認する
     * <br>[備  考] 論理削除済みは有効として返す
     * @param kbn 1:ユーザ, 2:グループ
     * @param partnerSid チャット相手のユーザSIDまたはチャットグループSID
     * @param messageSid メッセージSID
     * @return 0 :ダウンロード可能 1:不正なアクセス 2：メッセージが論理削除
     * @throws SQLException SQL実行時例外
     */
    public int downloadCheck(int kbn, int partnerSid, long messageSid) throws SQLException {
        int sessionSid = reqMdl__.getSmodel().getUsrsid();

        int selectSid;
        if (kbn == GSConstChat.CHAT_KBN_GROUP) {
            selectSid = partnerSid;
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            //グループメンバーチェック
            int cnt = cguDao.getAuthority(sessionSid, partnerSid);
            if (cnt == 0) {
                return 1;
            }
            //グループ存在チェック
            ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
            ChtGroupInfModel cgiMdl = cgiDao.select(partnerSid);
            if (cgiMdl.getCgiDelFlg() == GSConstChat.CHAT_MODE_DELETE) {
                return 1;
            }

        } else {
            ChtUserPairDao cupDao = new ChtUserPairDao(con__);
            selectSid = cupDao.select(sessionSid, partnerSid);
            //不正なチャット相手を指定
            if (selectSid == 0) {
                return DOWNLOADCHECK_CODE_NONE;
            }
        }
        List<Long> mesSidList = Arrays.asList(new Long[]{messageSid});
        /**指定したチャットルームSID添付ファイル付きチャット件数 */
        Map<Long, Integer> mesStateMap;
        if (kbn == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            mesStateMap = cgdDao.selectBinMessageStateMap(mesSidList, selectSid);
        } else {
            ChtUserDataDao cudDao = new ChtUserDataDao(con__);
            mesStateMap = cudDao.selectBinMessageStateMap(mesSidList, selectSid);
        }

        //有効チャット件数が1件もない場合、ダウンロード不可（不正なメッセージを指定している）
        if (mesStateMap.size() <= 0) {
            return DOWNLOADCHECK_CODE_NONE;
        }
        return DOWNLOADCHECK_CODE_OK;
    }
}
