package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cht.dao.ChtGroupDataMentionDao;
import jp.groupsession.v2.cht.dao.ChtUserDataMentionDao;
import jp.groupsession.v2.cht.model.ChtGroupDataMentionModel;
import jp.groupsession.v2.cht.model.ChtUserDataMentionModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;

/**
 * <br>[機  能] チャットプラグインで使用される、メンション用ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtMentionBiz {

     /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtMentionBiz.class);

    /**
     * <br>[機  能] 指定されたグループチャットメッセージのメンション情報を取得します。
     * <br>[解  説] 
     * <br>[備  考]
     * @param messageSid メッセージSID一覧
     * @param con コネクション
     * @return Map<Long, List<Integer>> メッセージSID：メンションを行ったユーザリストを格納したマップ
     * @throws SQLException 
     */
    public Map<Long, List<CmnUserModel>> getGroupMentionData(
        List<Long> messageSid, Connection con) throws SQLException {

        Map<Long, List<CmnUserModel>> ret = new HashMap<Long, List<CmnUserModel>>();
        Map<Long, List<Integer>> userSidMap = new HashMap<Long, List<Integer>>();
        List<Integer> allUserSids = new ArrayList<Integer>();
        log__.info(("グループチャットのメンション情報の取得開始"));
        ChtGroupDataMentionDao cgmDao = new ChtGroupDataMentionDao(con);
        List<ChtGroupDataMentionModel> cgmList = cgmDao.select(messageSid);
        
        List<Integer> usrSidList;
        for (ChtGroupDataMentionModel cgmMdl : cgmList) {
            usrSidList = userSidMap.get(cgmMdl.getCgdSid());
            if (usrSidList == null) {
                usrSidList = new ArrayList<Integer>();
            }
            usrSidList.add(cgmMdl.getUsrSid());
            userSidMap.put(cgmMdl.getCgdSid(), usrSidList);

            allUserSids.add(cgmMdl.getUsrSid());
        }

        ret = __getUserMap(userSidMap, allUserSids, con);
        
        log__.info(("グループチャットのメンション情報の取得終了"));

        return ret;
    }

    /**
     * <br>[機  能] 指定されたユーザチャットメッセージのメンション情報を取得します。
     * <br>[解  説] 
     * <br>[備  考]
     * @param messageSid メッセージSID一覧
     * @param con コネクション
     * @return Map<Long, List<Integer>> メッセージSID：メンションを行ったユーザリストを格納したマップ
     * @throws SQLException 
     */
    public Map<Long, List<CmnUserModel>> getUserMentionData(
        List<Long> messageSid, Connection con) throws SQLException {

        Map<Long, List<CmnUserModel>> ret = new HashMap<Long, List<CmnUserModel>>();
        Map<Long, List<Integer>> userSidMap = new HashMap<Long, List<Integer>>();
        List<Integer> allUserSids = new ArrayList<Integer>();
        log__.info(("ユーザチャットのメンション情報の取得開始"));
        ChtUserDataMentionDao cumDao = new ChtUserDataMentionDao(con);
        List<ChtUserDataMentionModel> cgmList = cumDao.select(messageSid);
        
        List<Integer> usrSidList;
        for (ChtUserDataMentionModel cumMdl : cgmList) {
            usrSidList = userSidMap.get(cumMdl.getCudSid());
            if (usrSidList == null) {
                usrSidList = new ArrayList<Integer>();
            }
            usrSidList.add(cumMdl.getUsrSid());
            userSidMap.put(cumMdl.getCudSid(), usrSidList);
            allUserSids.add(cumMdl.getUsrSid());
        }

        ret = __getUserMap(userSidMap, allUserSids, con);
        
        log__.info(("ユーザチャットのメンション情報の取得終了"));

        return ret;
    }

    private Map<Long, List<CmnUserModel>> __getUserMap(Map<Long, List<Integer>> userSidMap,
        List<Integer> allUserSids, Connection con) throws SQLException {

        Map<Long, List<CmnUserModel>> ret = new HashMap<Long, List<CmnUserModel>>();
        allUserSids = allUserSids.stream()
        .distinct()
        .collect(Collectors.toList());

        UserSearchDao userDao = new UserSearchDao(con);
        List<CmnUserModel> userList = userDao.getUsersDataList(allUserSids, true);

        List<CmnUserModel> userInfo;
        CmnUsrmInfModel allInfModel = new CmnUsrmInfModel();
        allInfModel.setUsrSid(-1);
        CmnUserModel allUser = new CmnUserModel(allInfModel, null);

        for (Map.Entry<Long, List<Integer>> entry : userSidMap.entrySet()) {
            List<Integer> userSidList = entry.getValue();
            userInfo = new ArrayList<CmnUserModel>();

            if (userSidList.contains(-1)) {
                userInfo.add(allUser);
            }
            userInfo.addAll(userList.stream()
                .filter(mdl -> userSidList.contains(mdl.getUsrSid()))
                .collect(Collectors.toList()));

            ret.put(entry.getKey(), userInfo);
        }

        return ret;
    }
}
