package jp.groupsession.v2.cht.biz;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.mail.internet.AddressException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.StringUtilHtml;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUconfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.dao.ChtUserUconfDao;
import jp.groupsession.v2.cht.model.ChatMessageModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtPushRequestModel;
import jp.groupsession.v2.cht.model.ChtUserPairModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.PushRequestModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.rap.mbh.push.IPushServiceOperator;
import jp.groupsession.v2.rap.mbh.push.PushServiceOperator;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.wml.biz.WmlPushSender;

public class ChtPushSender {

    /** ロギングクラス */
    private static Log log__ = LogFactory.getLog(WmlPushSender.class);

    /** リクエスト情報 */
    private RequestModel reqMdl__ = null;
    /** コネクション */
    private Connection con__ = null;
    /** メッセージSID */
    private int messageKbn__;
    /** メッセージ情報 */
    private ChatMessageModel messageModel__;

    /**
     * コンストラクタ
     * @param reqMdl
     * @param con
     * @param messageKbn メッセージ区分
     * @param messageModel メッセージ情報
     */
    public ChtPushSender(
        RequestModel reqMdl, Connection con, int messageKbn, ChatMessageModel messageModel) {

        reqMdl__ = reqMdl;
        con__ = con;
        messageKbn__ = messageKbn;
        messageModel__ = messageModel;
    }

    /**
     * 送信済みのメッセージからPush通知を送信する
     * @throws SQLException SQL実行に失敗
     * @throws UnsupportedEncodingException 個人名のエンコードに失敗
     * @throws AddressException 構文解析に失敗
     * @throws InterruptedException 
     */
    public void sendPush() throws SQLException,
        AddressException, UnsupportedEncodingException, InterruptedException {

        log__.info("チャット プッシュ通知送信開始");

        IPushServiceOperator psOpe = PushServiceOperator.getInstance(
                con__, reqMdl__.getDomain());
        
        if (!psOpe.isUseable()) {
            //プッシュ通知が使用できない場合は処理を終了する
            log__.info("プッシュ通知が利用できないため処理を終了");
            return;
        }

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        // データの送信
        List<Integer> member = new ArrayList<Integer>();
        String roomId = "";
        if (messageKbn__ == GSConstChat.CHAT_KBN_GROUP) {
            // グループチャット
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            member = cguDao.membersOfChatGroup(messageModel__.getSelectSid());
            member.removeAll(List.of(sessionUsrSid));

            ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
            ChtGroupInfModel groupMdl = cgiDao.select(messageModel__.getSelectSid());
            roomId = groupMdl.getCgiId();

        } else if (messageKbn__ == GSConstChat.CHAT_KBN_USER) {
            ChtUserPairDao cupDao = new ChtUserPairDao(con__);
            ChtUserPairModel cupMdl = cupDao.select(messageModel__.getSelectSid());
            //自身しかいないチャットにメッセージを送信時は何もしない
            if (cupMdl.getCupUidF() == sessionUsrSid && cupMdl.getCupUidS() == sessionUsrSid) {
                return;
            }
            int usrSid;
            if (cupMdl.getCupUidF() == sessionUsrSid) {
                usrSid = cupMdl.getCupUidS();
            } else {
                usrSid = cupMdl.getCupUidF();
            }
            member.add(usrSid);

            CmnUsrmDao usrDao = new CmnUsrmDao(con__);
            CmnUsrmModel usrMdl = usrDao.select(sessionUsrSid);
            roomId = usrMdl.getUsrLgid();
        }

        // プラグイン使用確認
        CommonBiz biz = new CommonBiz();
        member = biz.getCanUsePluginUser(con__, GSConstChat.PLUGIN_ID_CHAT, member);

        GsMessage gsMsg = new GsMessage(reqMdl__);
        List<PushRequestModel> pushMdlList = new ArrayList<PushRequestModel>();

        Map<Integer, Integer> muteMap;
        long messageSid = messageModel__.getMessageSid();
        if (messageKbn__ == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con__);
            muteMap = cguDao.getMuteKbn(member, messageSid);
        } else {
            ChtUserUconfDao ccuDao = new ChtUserUconfDao(con__);
            muteMap = ccuDao.getMuteKbn(member, messageSid);
        }
        for (int usrSid : member) {
            if (muteMap.get(usrSid) != null && muteMap.get(usrSid) == GSConstChat.CHAT_MUTE_ON) {
                continue;
            }
            ChtPushRequestModel pushMdl = new ChtPushRequestModel();
            //通知情報を設定
            StringBuilder title = new StringBuilder();
            title.append("【" + gsMsg.getMessage("cht.01") + "】");
            title.append(StringUtilHtml.transToTextBrFirst(messageModel__.getUsrName()));
            pushMdl.setPushTitle(title.toString());

            String text = "";
            
            //メンション情報を通知テキストに追加
            List<CmnUserModel> mentionUsers = messageModel__.getMentionUserInfo();
            if (mentionUsers != null && !mentionUsers.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                CmnUserModel userMdl;
                for (int idx = 0; idx < mentionUsers.size(); idx++) {
                    userMdl = mentionUsers.get(idx);
                    if (idx != 0) {
                        sb.append("、");
                    }
                    sb.append("@");
                    if (userMdl.getUsrSid() == GSConstChat.MENTION_ALL) {
                        sb.append(gsMsg.getMessage("cht.cht010.80"));
                    } else {
                        sb.append(userMdl.getUsiName());
                    }
                }
                String mention = sb.toString();
                if (mention.length() > 25) {
                    mention = mention.substring(0, 25) + "...";
                }
                text += mention;
                text += "\r\n";
            }

            if (messageModel__.getStampSid() != 0) {
                //メッセージの内容にスタンプを追加
                text += gsMsg.getMessage("cht.cht160.19");
            } else {
                List<CmnBinfModel> binMdlList = messageModel__.getBinMdlList();

                //メッセージの内容を通知テキストに追加
                if (messageModel__.getMessageText() != null) {
                    text += StringUtilHtml.transToTextBrFirst(messageModel__.getMessageText());
                    if (binMdlList != null && !binMdlList.isEmpty()) {
                        text += "\r\n";
                    }
                }

                //添付ファイル名を通知テキストに追加
                if (binMdlList != null && !binMdlList.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (int idx = 0; idx < binMdlList.size(); idx++) {
                        if (idx != 0) {
                            sb.append("\r\n");
                        }
                        sb.append(binMdlList.get(idx).getBinFileName());
                    }
                    text += sb.toString();
                }
            }

            if (text.length() > 100) {
                text = text.substring(0, 100) + "...";
            }

            pushMdl.setPushMessage(text);
            Map<String, String> pushParamMap = new HashMap<>();
            pushParamMap.put("plugin", GSConst.PLUGIN_ID_CHAT);
            pushParamMap.put("roomtype", String.valueOf(messageKbn__));
            pushParamMap.put("roomid", roomId);
            pushMdl.setPushParam(pushParamMap);
            pushMdl.setPushUser(usrSid);
            pushMdl.setAppId(GSConst.APP_GS_MOBILE);
            pushMdlList.add(pushMdl);
        }

        psOpe.sendMessage(con__, reqMdl__, pushMdlList, GSConst.PLUGIN_ID_CHAT);

        log__.info("チャット プッシュ通知送信終了");
    }
}

