package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cht.dao.ChtGroupDataReactionDao;
import jp.groupsession.v2.cht.dao.ChtUserDataReactionDao;
import jp.groupsession.v2.cht.model.ChtGroupDataReactionModel;
import jp.groupsession.v2.cht.model.ChtReactionModel;
import jp.groupsession.v2.cht.model.ChtUserDataReactionModel;

/**
 * <br>[機  能] チャットプラグインで使用される、リアクション用ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtReactionBiz {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtReactionBiz.class);

    /**
     * <br>[機  能] 指定されたグループチャットメッセージのリアクション情報を取得します。
     * <br>[解  説] 
     * <br>[備  考]
     * @param messageSid メッセージSID一覧
     * @param con コネクション
     * @return Map<Long, List<ChtReactionModel>> メッセージSID：リアクション情報リストを格納したマップ
     * @throws SQLException 
     */
    public Map<Long, List<ChtReactionModel>> getGroupReactionData(
        List<Long> messageSid, Connection con) throws SQLException {

        ChtGroupDataReactionDao cgrDao = new ChtGroupDataReactionDao(con);
        log__.info(("グループチャットのリアクション情報の取得開始"));
        List<ChtGroupDataReactionModel> cgrMdlList = cgrDao.getGroupReactionData(messageSid);
        log__.info(("グループチャットのリアクション情報の取得終了"));
        //リアクションSID順に並び替える
        Collections.sort(cgrMdlList,
            Comparator.comparingInt(ChtGroupDataReactionModel::getCgrReactionNo));

        Map<Long, List<ChtReactionModel>> reactionMap = new HashMap<Long, List<ChtReactionModel>>();
        ChtReactionModel reactionMdl = null;
        List<ChtReactionModel> reactionList = null;
        for (ChtGroupDataReactionModel cgrMdl : cgrMdlList) {
            reactionList = reactionMap.get(cgrMdl.getCgdSid());
            if (reactionList == null) {
                reactionList = new ArrayList<ChtReactionModel>();
            }

            Optional<ChtReactionModel> result = reactionList.stream()
                .filter(mdl -> mdl.getRacSid() == cgrMdl.getCgrReactionNo())
                .findFirst();
            
            if (result.isPresent()) {
                //要素がある場合
                reactionMdl = result.get();
            } else {
                reactionMdl = new ChtReactionModel();
                reactionMdl.setRacSid(cgrMdl.getCgrReactionNo());
                reactionList.add(reactionMdl);
            }
            reactionMdl.getUsrSidList().add(cgrMdl.getUsrSid());
            reactionMap.put(cgrMdl.getCgdSid(), reactionList);
        }

        return reactionMap;
    }

    /**
     * <br>[機  能] 指定されたユーザチャットメッセージのリアクション情報を取得します。
     * <br>[解  説] 
     * <br>[備  考]
     * @param messageSid メッセージSID一覧
     * @param con コネクション
     * @return Map<Long, List<ChtReactionModel>> メッセージSID：リアクション情報リストを格納したマップ
     * @throws SQLException 
     */
    public Map<Long, List<ChtReactionModel>> getUserReactionData(
        List<Long> messageSid, Connection con) throws SQLException {

        ChtUserDataReactionDao curDao = new ChtUserDataReactionDao(con);
        log__.info("ユーザチャットのリアクション情報の取得開始");
        List<ChtUserDataReactionModel> curMdlList = curDao.getUserReactionData(messageSid);
        log__.info("ユーザチャットのリアクション情報の取得開始");
        //リアクションSID順に並び替える
        Collections.sort(curMdlList,
            Comparator.comparingInt(ChtUserDataReactionModel::getCurReactionNo));

        Map<Long, List<ChtReactionModel>> reactionMap = new HashMap<Long, List<ChtReactionModel>>();
        ChtReactionModel reactionMdl = null;
        List<ChtReactionModel> reactionList = null;
        for (ChtUserDataReactionModel curMdl : curMdlList) {
            reactionList = reactionMap.get(curMdl.getCudSid());
            if (reactionList == null) {
                reactionList = new ArrayList<ChtReactionModel>();
            }

            Optional<ChtReactionModel> result = reactionList.stream()
                .filter(mdl -> mdl.getRacSid() == curMdl.getCurReactionNo())
                .findFirst();
            
            if (result.isPresent()) {
                //要素がある場合
                reactionMdl = result.get();
            } else {
                reactionMdl = new ChtReactionModel();
                reactionMdl.setRacSid(curMdl.getCurReactionNo());
                reactionList.add(reactionMdl);
            }
            reactionMdl.getUsrSidList().add(curMdl.getUsrSid());
            reactionMap.put(curMdl.getCudSid(), reactionList);
        }

        return reactionMap;
    }
}
