package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.model.ChatUserInfModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.dao.base.CmnMyGroupMsDao;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.usr.GSConstUser;

public class ChtSelectPartnerLoader {
    /** コネクション*/
    private Connection con__;
    /** グループSID指定 -2:削除済みユーザ 数値: グループ M{数値}:マイグループ */
    private String groupSid__;
    /** セッションユーザSID */
    private int sessionUsrSid__;
    /** ユーザSID指定 */
    private int userSid__;

    /** 結果全件数 */
    private int max__ = 0;
    /** 結果一覧 */
    private List<ChatUserInfModel> result__ = List.of();

    /**
     * @param con コネクション
     * @param groupSid グループSID指定 -2:削除済みユーザ 数値: グループ M{数値}:マイグループ
     * @param sessionUsrSid セッションユーザSID
     */
    public ChtSelectPartnerLoader(Connection con, String groupSid,
            int sessionUsrSid) {
        con__ = con;
        groupSid__ = groupSid;
        sessionUsrSid__ = sessionUsrSid;
    }

    /**
     * @param con コネクション
     * @param partnerSid チャット相手のユーザSID
     * @param sessionUsrSid セッションユーザSID
     */
    public ChtSelectPartnerLoader(Connection con, int sessionUsrSid, int partnerSid) {
        con__ = con;
        userSid__ = partnerSid;
        sessionUsrSid__ = sessionUsrSid;
    }

    /**
     *
     * 送信先チャット一覧を取得を実行し
     * resultに格納する
     * @throws SQLException
     */
    public void exexute() throws SQLException {
        exexute(-1, -1);
    }

    /**
     * 指定したユーザとのチャット情報取得を実行しresultに格納する
     * @throws SQLException
     */
    public void execute() throws SQLException {
        ChatDao chtDao = new ChatDao(con__);

        List<Integer> users = new ArrayList<Integer>();
        users.add(userSid__);

        UserBiz usrBiz = new UserBiz();
        List<CmnUsrmInfModel> uList = usrBiz.getUserList(con__, users);
        if (uList.isEmpty()) {
            return;
        }

        result__ = chtDao.getUserCntList(sessionUsrSid__, uList);
    }

    /**
     *
     * 送信先チャット一覧を取得を実行し
     * resultに格納する
     * @param limit
     * @param offset
     * @throws SQLException
     */
    public void exexute(int limit, int offset) throws SQLException {
        ChatDao chtDao = new ChatDao(con__);

        //グループSIDから所属ユーザ一覧を作成
        if (StringUtil.isNullZeroString(groupSid__)) {
            GroupBiz grpBiz = new GroupBiz();
            groupSid__ = String.valueOf(grpBiz.getDefaultGroupSid(sessionUsrSid__, con__));
        }
        int grpSid = getDspGroupSid(groupSid__);
        List<Integer> users = new ArrayList<Integer>();
        if (isMyGroupSid(groupSid__)) {
            //マイグループから作成
            CmnMyGroupMsDao mgmsDao = new CmnMyGroupMsDao(con__);
            users = mgmsDao.selectMyGroupUsers(sessionUsrSid__, grpSid);

        } else if (grpSid == -2) {
            //削除済みユーザと過去にユーザ間チャットしているかを取得する
            ArrayList<CmnUsrmInfModel> delUserList = chtDao.getDeleteUser(sessionUsrSid__);

            for (CmnUsrmInfModel mdl : delUserList) {
                users.add(mdl.getUsrSid());
            }
        } else {
            //通常グループから作成
            CmnBelongmDao cmnbDao = new CmnBelongmDao(con__);
            users = cmnbDao.selectBelongUserSid(getDspGroupSid(groupSid__));
        }
        if (grpSid != -2) {
            //チャットプラグインを使用していないユーザを除外する。
            CommonBiz cmnBiz = new CommonBiz();
            users = cmnBiz.getCanUseChatUser(con__, users);

            //システムメールとGS管理者を除外する
            users = users.stream()
                .filter(usid ->
                    (usid != GSConstUser.SID_ADMIN
                        && usid != GSConstUser.SID_SYSTEM_MAIL)
                )
                .collect(Collectors.toList());

        }
        //ユーザ情報を取得
        List<CmnUsrmInfModel> uList = new ArrayList<CmnUsrmInfModel>();
        if (grpSid != -2) {


            if (users != null && users.size() > 0) {
                //ユーザ情報一覧を作成
                UserBiz usrBiz = new UserBiz();
                uList = usrBiz.getUserList(con__, users);
            }
        } else {
            if (users != null && users.size() > 0) {
                //ユーザ情報一覧を作成
                UserBiz usrBiz = new UserBiz();
                List<String> sSid = new ArrayList<String>();
                for (Integer sid : users) {
                    sSid.add(sid.toString());
                }
                String[] sidList = sSid.toArray(new String[sSid.size()]);
                uList = usrBiz.getUserList(con__, sidList, GSConst.JTKBN_DELETE);
                for (int idx = 0; idx < uList.size(); idx++) {
                    uList.get(idx).setUsrJkbn(GSConst.JTKBN_DELETE);
                }
            }
        }

        max__ = uList.size();
        result__ = List.of();
        if (uList.size() == 0) {
            return;
        }
        if (limit >= 0) {
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            if (start >= max__) {
                return;
            }
            int end = start + limit;
            if (end >= max__) {
                end = max__;
            }

            uList = uList.subList(start, end);
        }

        result__ = chtDao.getUserCntList(sessionUsrSid__, uList);

    }
    /**
     * パラメータ.グループコンボ値からグループSID又はマイグループSIDを取得する
     * <br>[機  能]
     * <br>[解  説]
     * <br>[備  考]
     * @param gpSid グループSID
     * @return int グループSID又はマイグループSID
     */
    public static int getDspGroupSid(String gpSid) {
        int ret = 0;
        if (gpSid == null) {
            return ret;
        }

        if (isMyGroupSid(gpSid)) {
            return Integer.parseInt(gpSid.substring(1));
        } else {
            return Integer.parseInt(gpSid);
        }
    }

    /**
     * パラメータ.グループコンボ値がグループSIDかマイグループSIDかを判定する
     * <br>[機  能]先頭文字に"M"が有る場合、マイグループSID
     * <br>[解  説]
     * <br>[備  考]
     * @param gpSid グループSID
     * @return boolean true:マイグループ false=通常のグループ
     */
    public static boolean isMyGroupSid(String gpSid) {
        boolean ret = false;
        if (gpSid == null) {
            return ret;
        }
        // 置換対象文字列が存在する場所を取得
        int index = gpSid.indexOf("M");

        // 先頭文字に"M"が有る場合はマイグループ
        if (index == 0) {
            return true;
        } else {
            return ret;
        }
    }

    /**
     * @return the max
     */
    public int getMax() {
        return max__;
    }

    /**
     * @param max the max to set
     */
    public void setMax(int max) {
        max__ = max;
    }

    /**
     * @return the result
     */
    public List<ChatUserInfModel> getResult() {
        return result__;
    }

    /**
     * @param result the result to set
     */
    public void setResult(List<ChatUserInfModel> result) {
        result__ = result;
    }



}
