package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.co.sjts.util.DataSizeUtil;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.cht010.Cht010MessageJsonModel;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataMentionDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataPinDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataReactionDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataTempDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.dao.ChtGroupViewDao;
import jp.groupsession.v2.cht.dao.ChtLogCountDao;
import jp.groupsession.v2.cht.dao.ChtSpaccessPermitDao;
import jp.groupsession.v2.cht.dao.ChtSpaccessTargetDao;
import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.cht.dao.ChtUserDataDao;
import jp.groupsession.v2.cht.dao.ChtUserDataMentionDao;
import jp.groupsession.v2.cht.dao.ChtUserDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserDataReactionDao;
import jp.groupsession.v2.cht.dao.ChtUserDataTempDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.dao.ChtUserViewDao;
import jp.groupsession.v2.cht.model.ChatMessageModel;
import jp.groupsession.v2.cht.model.ChatSendEditModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupDataMentionModel;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupDataReactionModel;
import jp.groupsession.v2.cht.model.ChtGroupDataTempModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtGroupViewModel;
import jp.groupsession.v2.cht.model.ChtLogCountModel;
import jp.groupsession.v2.cht.model.ChtReactionModel;
import jp.groupsession.v2.cht.model.ChtStampModel;
import jp.groupsession.v2.cht.model.ChtUserDataMentionModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.model.ChtUserDataReactionModel;
import jp.groupsession.v2.cht.model.ChtUserDataTempModel;
import jp.groupsession.v2.cht.model.ChtUserPairModel;
import jp.groupsession.v2.cht.model.ChtUserViewModel;
import jp.groupsession.v2.cht.model.EnumReactionFlg;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.base.CmnBinfDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] メッセージの送信, 編集, 削除処理を実行する
 * <br>[解  説]
 * <br>[備  考] メッセージに対する権限チェックも行う
 *
 * @author JTS
 */
public class ChtSendViewBiz {

    /** リクエスト情報 */
    private RequestModel reqMdl__;
    /** コネクション */
    private Connection con__;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl 1:ユーザ, 2:グループ
     * @param con コネクション
     */
    public ChtSendViewBiz(RequestModel reqMdl, Connection con) {
        reqMdl__ = reqMdl;
        con__ = con;
    }

    /**
     * <br>[機  能] 送信権限チェック
     * <br>[解  説]
     * <br>[備  考]
     * @param selectSid チャット送信先(ユーザの場合：ユーザSID, グループの場合：グループSID)
     * @param kbn 1:ユーザ, 2:グループ
     * @param messageSid メッセージSID(編集，削除時，メッセージ取得判定に必須)
     * @param isNotEdit true:メッセージ自体の編集，削除を行わない(リアクションの変更，メッセージの取得), false:メッセージの編集，削除を行う
     * @return エラーメッセージ
     * @throws SQLException
     * @throws Exception 例外
     */
    public String sendCheck(
        int selectSid, int kbn, long messageSid, boolean isNotEdit) throws SQLException {

        String ret = "";
        GsMessage gsMsg = new GsMessage(reqMdl__);
        // グループ情報の登録
        int sessionSid = reqMdl__.getSmodel().getUsrsid();

        // 編集または削除時
        if (messageSid > 0) {
            boolean existMsg = false;
            int senderSid = -1;
            int messageState = -1;
            int messagePartnerSid = 0;
            if (kbn == GSConstChat.CHAT_KBN_USER) {
                ChtUserDataDao cudDao = new ChtUserDataDao(con__);
                ChtUserDataModel cudMdl  = cudDao.select((long) messageSid);
                if (cudMdl != null) {
                    existMsg = true;
                    senderSid = cudMdl.getCudSendUid();
                    messageState = cudMdl.getCudStateKbn();
                    ChtUserPairDao cupDao = new ChtUserPairDao(con__);
                    ChtUserPairModel cupMdl = cupDao.select(cudMdl.getCupSid());
                    if (cupMdl == null) {
                        existMsg = false;
                    }
                    if (cupMdl.getCupUidF() != sessionSid
                        && cupMdl.getCupUidS() != sessionSid) {
                        existMsg = false;
                    }
                    if (cupMdl.getCupUidF() == sessionSid
                        && cupMdl.getCupUidS() == sessionSid) {
                        messagePartnerSid = sessionSid;
                    } else if (cupMdl.getCupUidF() != sessionSid) {
                        messagePartnerSid = cupMdl.getCupUidF();
                    } else if (cupMdl.getCupUidS() != sessionSid) {
                        messagePartnerSid = cupMdl.getCupUidS();
                    }
                }
            } else if (kbn == GSConstChat.CHAT_KBN_GROUP) {
                ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
                ChtGroupDataModel cgdMdl = cgdDao.select((long) messageSid);
                if (cgdMdl != null) {
                    existMsg = true;
                    senderSid = cgdMdl.getCgdSendUid();
                    messageState = cgdMdl.getCgdStateKbn();
                    messagePartnerSid = cgdMdl.getCgiSid();
                }

            }
            if (!isViewPartner(sessionSid, messagePartnerSid, kbn)) {
                return gsMsg.getMessage("cht.cht010.43");
            }

            // メッセージが存在しない
            if (!existMsg) {
                return gsMsg.getMessage("cht.cht010.43");
            // 自分が送信したメッセージでない
            } else if (!isNotEdit && senderSid != sessionSid) {
                return gsMsg.getMessage("cht.cht010.44");
            // 削除済み
            } else if (messageState == GSConstChat.TOUKOU_STATUS_DELETE) {
                return gsMsg.getMessage("cht.cht010.45");
            }
        }

        if (kbn == GSConstChat.CHAT_KBN_USER) {
            ChatDao cDao = new ChatDao(con__);
            if (selectSid == GSConst.SYSTEM_USER_ADMIN || selectSid == GSConst.SYSTEM_USER_MAIL) {
                return gsMsg.getMessage("cht.cht010.08");
            }

            //ユーザ削除チェック
            CmnUsrmInfModel cuiMdl = cDao.getUser(selectSid);
            if (cuiMdl == null || cuiMdl.getUsrJkbn() == GSConst.JTKBN_DELETE) {
                return gsMsg.getMessage("cht.cht010.07");
            }
            //特例アクセスチェック
            if (sessionSid != selectSid) {
                ChtSpaccessTargetDao cstDao = new ChtSpaccessTargetDao(con__);
                ArrayList<Integer> spList = cstDao.selectSid(selectSid);
                if (spList.size() != 0) {
                    ChtSpaccessPermitDao cspDao = new ChtSpaccessPermitDao(con__);
                    int cntSid = cspDao.selectCount(spList, sessionSid);
                    if (cntSid == 0) {
                        return gsMsg.getMessage("cht.cht010.08");
                    }
                }
            }
            //ユーザチャット制限チェック
            ChtBiz cBiz = new ChtBiz(con__, reqMdl__);
            ChtAdmConfModel aMdl = cBiz.getChtAconf();
            if (aMdl.getCacChatFlg() == GSConstChat.LIMIT_BETWEEN_USERS) {
                return gsMsg.getMessage("cht.cht010.05");
            }

            //プラグイン使用権限
            CommonBiz cmnBiz = new CommonBiz();
            List<String> menuPluginIdList = cmnBiz.getCanUsePluginIdList(con__, selectSid);
            if (!menuPluginIdList.isEmpty()) {
                boolean bAccess = false;
                for (String pId : menuPluginIdList) {
                    if (pId.equals(GSConstChat.PLUGIN_ID_CHAT)) {
                        bAccess = true;
                        break;
                    }
                }
                if (!bAccess) {
                    return gsMsg.getMessage("cht.cht010.39");
                }
            } else {
                return gsMsg.getMessage("cht.cht010.39");
            }

        } else {
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            //グループメンバーチェック
            int cnt = cguDao.getAuthority(sessionSid, selectSid);
            if (cnt == 0) {
                return gsMsg.getMessage("cht.cht010.37");
            }
            //グループ存在チェック・アーカイブチェック
            ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
            ChtGroupInfModel cgiMdl = cgiDao.select(selectSid);
            if (cgiMdl.getCgiDelFlg() == GSConstChat.CHAT_MODE_DELETE) {
                return gsMsg.getMessage("cht.cht010.37");
            } else if (cgiMdl.getCgiCompFlg() == GSConstChat.CHAT_ARCHIVE_MODE) {
                return gsMsg.getMessage("cht.cht010.06");
            }
        }
        return ret;
    }

    /**
     * <p> 相手ユーザおよびグループの閲覧権限チェック
     * @param sessionUsrSid セッションユーザSID
     * @param chtPartnerSid 相手ユーザ/グループSID
     * @param chtKbn 0：ユーザ、1：グループ
     * @return 正常終了：true、権限エラー：false
     * @throws SQLException SQL実行例外
     * */
    public boolean isViewPartner(int sessionUsrSid, int chtPartnerSid, int chtKbn)
            throws SQLException {
        // ユーザの場合、相手ユーザの権限チェック
        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            if (chtPartnerSid == GSConst.SYSTEM_USER_ADMIN
                || chtPartnerSid == GSConst.SYSTEM_USER_MAIL) {
                return false;
            }
            // ユーザ削除チェック
            ChatDao cDao = new ChatDao(con__);
            CmnUsrmInfModel cuiMdl = cDao.getUser(chtPartnerSid);
            if (cuiMdl == null) {
                return false;
            }
        //グループの場合閲覧権限チェック
        } else if (chtKbn == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            if (cguDao.getAuthority(sessionUsrSid, chtPartnerSid) == 0) {
                return false;
            }
            ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
            ChtGroupInfModel cgiMdl = cgiDao.select(chtPartnerSid);
            if (cgiMdl == null
                    || cgiMdl.getCgiDelFlg() == GSConstChat.CHAT_MODE_DELETE) {
                return false;
            }
        }
        return true;
    }

    /**
     * <br>[機  能] チャットの投稿を行う
     * <br>[解  説] DB登録しWebSocketで送信する
     * <br>[備  考]
     * @param messageModel 送信メッセージ情報
     * @param cntCon コントローラ
     * @param binList バイナリリスト
     * @throws Exception 実行例外
     * @return ret メッセージSID
     */
    public List<Long> sendMessage(ChatSendEditModel messageModel,
            MlCountMtController cntCon, List<Long> binList)
        throws Exception {

        List<Long> ret = new ArrayList<Long>();
        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        long cdSid = -1;
        List<ChtUserDataModel> cudList = null;
        List<ChtGroupDataModel> cgdList = null;
        List<ChtUserDataMentionModel> cumList = null;
        List<ChtGroupDataMentionModel> cgmList = null;
        long messageSid;
        // DB保管部 -------------------------------------------------------------------------
        con__.setAutoCommit(false);

        ChtUsedDataBiz usedDataBiz = new ChtUsedDataBiz(con__);
        if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_USER) {
            int nPair = -1;
            /*ユーザ間チャット*/
            ChtUserPairCreateBiz cupBiz = new ChtUserPairCreateBiz();
            nPair = cupBiz.getCupSidAutoCreate(
                reqMdl__, con__, sessionUsrSid, messageModel.getSelectPartner());
            //ユーザCHT_USER_DATAにデータを登録する
            ChtUserDataDao cudDao = new ChtUserDataDao(con__);

            //メッセージ情報の登録
            cudList = __createMessageUserData(messageModel, cntCon, nPair);
            List<Long> cudSidList = new ArrayList<Long>();
            long dataSize = 0;
            if (cudList.size() > 0) {
                for (ChtUserDataModel cudMdl : cudList) {
                    cudDao.insert(cudMdl);
                    cdSid = cudMdl.getCudSid();
                    cudSidList.add(cudMdl.getCudSid());
                    dataSize += DataSizeUtil.getUseDBsize(cudMdl.getCudText());
                }
            }

            //スタンプ送信時、添付ファイル情報は登録しない
            if (messageModel.getStampSid() == 0) {
                //添付ファイル情報を登録する
                List<ChtUserDataTempModel> tempList = __createTempUserData(cdSid, binList);
                ChtUserDataTempDao tempDao = new ChtUserDataTempDao(con__);
                tempDao.insertTempData(tempList);
            }

            //ユーザCHT_USER_VIEWにdeleteinsertする
            ChtUserViewDao cuvDao = new ChtUserViewDao(con__);
            cuvDao.delete(nPair, sessionUsrSid);

            ChtUserViewModel cuvMdl = new ChtUserViewModel();
            cuvMdl.setCupSid(nPair);
            cuvMdl.setCuvUid(sessionUsrSid);
            cuvMdl.setCudSid(cdSid);
            cuvMdl.setCuvViewcnt(cudDao.countTarget(nPair, cdSid));
            cuvDao.insert(cuvMdl);

            //メンション情報を登録 (メッセージが複数ある場合は、最初の投稿にメンション情報を追加)
            cumList = __createMentionUserData(messageModel, cudSidList.get(0));
            ChtUserDataMentionDao cumDao = new ChtUserDataMentionDao(con__);
            cumDao.insert(cumList);

            //チャット投稿情報のデータ使用量を登録
            usedDataBiz.insertChtDataSize(cudSidList, dataSize);

            messageSid = cudSidList.get(cudSidList.size() - 1);
            ret = cudSidList;
        } else {
            /*グループチャット*/
            //CHT_GROUP_DATAにデータを登録する
            ChtGroupDataDao grpDataDao = new ChtGroupDataDao(con__);
            cgdList =  __createMessageGroupData(messageModel, cntCon);
            List<Long> cgdSidList = new ArrayList<Long>();
            long dataSize = 0;
            if (cgdList.size() > 0) {
                for (ChtGroupDataModel cgdMdl : cgdList) {
                    grpDataDao.insert(cgdMdl);
                    cdSid = cgdMdl.getCgdSid();
                    cgdSidList.add(cgdMdl.getCgdSid());
                    dataSize += DataSizeUtil.getUseDBsize(cgdMdl.getCgdText());
                }
            }

            //スタンプ送信時、添付ファイル情報は登録しない
            if (messageModel.getStampSid() == 0) {
                //添付ファイル情報を登録する
                List<ChtGroupDataTempModel> tempList = __createTempGroupData(cdSid, binList);
                ChtGroupDataTempDao tempDao = new ChtGroupDataTempDao(con__);
                tempDao.insertTempData(tempList);
            }

            //CHT_GROUP_VIEWのデータをdeleteinsertする
            ChtGroupViewDao cgvDao = new ChtGroupViewDao(con__);
            cgvDao.delete(messageModel.getSelectPartner(), sessionUsrSid);
            ChtGroupViewModel cgvMdl = new ChtGroupViewModel();
            cgvMdl.setCgiSid(messageModel.getSelectPartner());
            cgvMdl.setCgvUid(sessionUsrSid);
            cgvMdl.setCgdSid(cdSid);
            cgvMdl.setCgvViewcnt(grpDataDao.countTarget(messageModel.getSelectPartner(), cdSid));

            //メンション情報を登録 (メッセージが複数ある場合は、最初の投稿にメンション情報を追加)
            cgmList = __createMentionGroupData(messageModel, cgdSidList.get(0));
            ChtGroupDataMentionDao cgmDao = new ChtGroupDataMentionDao(con__);
            cgmDao.insert(cgmList);

            //チャット投稿情報のデータ使用量を登録
            usedDataBiz.insertChtDataSize(cgdSidList, dataSize);

            cgvDao.insert(cgvMdl);
            messageSid = cgdSidList.get(cgdSidList.size() - 1);
            ret = cgdSidList;
        }
        //メッセージを送信した場合、それまでの全てのメッセージを既読にする
        messageModel.setKidokuMessageSid(messageSid);

        //統計データ用の登録処理
        ChtLogCountDao clcDao =  new ChtLogCountDao(con__);
        ChtLogCountModel clcMdl = new ChtLogCountModel();
        clcMdl.setClcChatKbn(messageModel.getSelectKbn());
        clcMdl.setClcUsrSid(sessionUsrSid);
        UDate now = new UDate();
        clcMdl.setClcDate(now);
        clcDao.insert(clcMdl);

        con__.setAutoCommit(true);

        // WebSocketで送信 -------------------------------------------------------------------------
        int kbn = messageModel.getSelectKbn();
        int selectSid = messageModel.getSelectPartner();
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();

        ChatMessageModel cm = null;
        if (cudList != null) {
            boolean pushFlg = true;
            for (ChtUserDataModel cudMdl : cudList) {
                cm = __messageDisp(messageModel, cntCon, cudMdl.getCudSid(), adminMdl);
                __sendMessageWS(selectSid, kbn, cm, pushFlg);
                pushFlg = false;
            }
            //"送信したメッセージまでの全てのメッセージを既読にした旨"をチャット相手に送信する
                    //チャット相手に既読状態をWebSocketで送る
            if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_USER
                && messageModel.getSelectPartner() != reqMdl__.getSmodel().getUsrsid()) {
                sendKidokuWs(con__, reqMdl__,
                    messageModel.getSelectPartner(),
                    messageModel.getKidokuMessageSid());
            }

        }
        if (cgdList != null) {
            boolean pushFlg = true;
            for (ChtGroupDataModel cgdMdl : cgdList) {
                cm = __messageDisp(messageModel, cntCon, cgdMdl.getCgdSid(), adminMdl);
                __sendMessageWS(selectSid, kbn, cm, pushFlg);
                pushFlg = false;
            }
        }

        ChtPushSender sender = new ChtPushSender(reqMdl__, con__, messageModel.getSelectKbn(), cm);
        sender.sendPush();

        return ret;
    }

    /**
     * <br>[機  能] メッセージ編集処理
     * <br>[解  説] DB更新後 WebSocket送信
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @throws Exception 実行例外
     * @return ChatMessageModel
     */
    public ChatMessageModel messageEdit(ChatSendEditModel messageModel)throws Exception {

        // DB保管部 -------------------------------------------------------------------------
        int sessionUserSid = reqMdl__.getSmodel().getUsrsid();
        ChatMessageModel mdl = new ChatMessageModel();
        if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataDao cudDao = new ChtUserDataDao(con__);
            mdl = cudDao.updateStateKbn(messageModel.getEditMessageSid(),
                    GSConstChat.TOUKOU_STATUS_EDIT, sessionUserSid, messageModel.getBodyText());
        } else if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            mdl = cgdDao.updateStateKbn(messageModel.getEditMessageSid(),
                    GSConstChat.TOUKOU_STATUS_EDIT, sessionUserSid, messageModel.getBodyText());
        }
        // WebSocketで送信 -------------------------------------------------------------------------

        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "message");
        jsonData.element("msgContent",
                StringUtilHtml.transToHTmlPlusAmparsantAndLink(
                        String.valueOf(messageModel.getBodyText())));
        BaseUserModel smodel = reqMdl__.getSmodel();
        jsonData.element("senderSid", String.valueOf(smodel.getUsrsid()));
        jsonData.element("senderId", smodel.getLgid());
        jsonData.element("selectSid", String.valueOf(messageModel.getSelectPartner()));
        jsonData.element("selectKbn", String.valueOf(messageModel.getSelectKbn()));
        jsonData.element("updateDay", mdl.getUpdateDay());
        jsonData.element("updateTime", mdl.getUpdateTime());
        jsonData.element("messageSid", messageModel.getEditMessageSid());
        jsonData.element("command", "edit");

        // WebSocketへデータを送信
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con__, reqMdl__);
        wsBiz.sendToWebSocket(jsonData);

        return mdl;
    }

    /**
     * <br>[機  能] メッセージ削除処理
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @throws Exception 実行例外
     */
    public void messageDelete(ChatSendEditModel messageModel)throws Exception {

        // DB保管部 -------------------------------------------------------------------------
        int sessionUserSid = reqMdl__.getSmodel().getUsrsid();
        List<Long> binSidList = null;
        long delMessageSid = messageModel.getEditMessageSid();
        if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataDao cudDao = new ChtUserDataDao(con__);
            cudDao.updateStateKbn(
                delMessageSid, GSConstChat.TOUKOU_STATUS_DELETE, sessionUserSid, "");

            ChtUserDataTempDao cutDao = new ChtUserDataTempDao(con__);
            //削除対象となるBIN_SIDを取得
            binSidList = cutDao.getBinSid(new ArrayList<Long>(List.of(delMessageSid)));
            cutDao.deleteTempData(delMessageSid);

            //リアクション情報を削除
            ChtUserDataReactionDao curDao = new ChtUserDataReactionDao(con__);
            curDao.deleteUserReactionData(Arrays.asList(new Long[]{delMessageSid}));

            //メンション情報を削除
            ChtUserDataMentionDao cumDao = new ChtUserDataMentionDao(con__);
            cumDao.deleteUserMentionData(Arrays.asList(new Long[]{delMessageSid}));

            //ピンどめ情報を削除
            ChtUserDataPinDao pinDao = new ChtUserDataPinDao(con__);
            ChtUserPairDao pairDao = new ChtUserPairDao(con__);
            int pairSid = pairDao.select(sessionUserSid, messageModel.getSelectPartner());
            pinDao.delete(pairSid, delMessageSid);

        } else if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            cgdDao.updateStateKbn(
                delMessageSid, GSConstChat.TOUKOU_STATUS_DELETE, sessionUserSid, "");

            ChtGroupDataTempDao cgtDao = new ChtGroupDataTempDao(con__);
            binSidList = cgtDao.getBinSid(new ArrayList<Long>(List.of(delMessageSid)));
            cgtDao.deleteTempData(delMessageSid);

            //リアクション情報を削除
            ChtGroupDataReactionDao cgrDao = new ChtGroupDataReactionDao(con__);
            cgrDao.deleteGroupReactionData(Arrays.asList(new Long[]{delMessageSid}));

            //メンション情報を削除
            ChtGroupDataMentionDao cgmDao = new ChtGroupDataMentionDao(con__);
            cgmDao.deleteGroupMentionData(Arrays.asList(new Long[]{delMessageSid}));

            //ピンどめ情報を削除
            ChtGroupDataPinDao pinDao = new ChtGroupDataPinDao(con__);
            pinDao.delete(messageModel.getSelectPartner(), delMessageSid);
        }

        //添付ファイルの論理削除
        CmnBinfDao binfDao = new CmnBinfDao(con__);
        CmnBinfModel binfMdl = new CmnBinfModel();
        binfMdl.setBinUpdate(new UDate());
        binfMdl.setBinJkbn(GSConst.JTKBN_DELETE);
        binfMdl.setBinUpuser(sessionUserSid);
        binfDao.updateJKbn(binfMdl, binSidList);


        // WebSocketで送信 -------------------------------------------------------------------------

        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");

        //トランザクショントークン設定
        jsonData.element("type", "message");
        BaseUserModel smodel = reqMdl__.getSmodel();
        jsonData.element("senderSid", String.valueOf(smodel.getUsrsid()));
        jsonData.element("senderId", smodel.getLgid());
        jsonData.element("selectSid", String.valueOf(messageModel.getSelectPartner()));
        jsonData.element("selectKbn", String.valueOf(messageModel.getSelectKbn()));
        jsonData.element("messageSid", messageModel.getEditMessageSid());
        jsonData.element("command", "delete");

        // WebSocketへデータを送信
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con__, reqMdl__);
        wsBiz.sendToWebSocket(jsonData);
    }

    /**
     * <br>[機  能] グループ投稿情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @param cntCon コントローラ
     * @throws Exception 実行例外
     * @return grpDataMdl チャットグループ投稿情報
     */
    private List<ChtGroupDataModel> __createMessageGroupData(ChatSendEditModel messageModel,
            MlCountMtController cntCon)

        throws Exception {
        List<ChtGroupDataModel> ret = new ArrayList<ChtGroupDataModel>();
        List<String> msgList = new ArrayList<String>();

        String msg = messageModel.getBodyText();

        if (!StringUtil.isNullZeroString(msg)) {
            msgList = __getMessageList(msg);
        } else {
            msgList.add(null);
        }

        Iterator<String> itMsg = msgList.iterator();

        UDate now = new UDate();
        ChtGroupDataModel grpDataMdl = null;
        boolean isFirst = true;

        Pattern urlPattern = Pattern.compile(StringUtil.URL_PATTERN);
        Matcher matcher;
        while (itMsg.hasNext()) {
            String spmsg = itMsg.next();
            grpDataMdl = new ChtGroupDataModel();
            int userSid = reqMdl__.getSmodel().getUsrsid();
            long newId = cntCon.getSaibanNumber("chat", "grpMessageSid", userSid);
            grpDataMdl.setCgdAdate(now);
            grpDataMdl.setCgdAuid(userSid);
            grpDataMdl.setCgdEdate(now);
            grpDataMdl.setCgdEuid(userSid);
            grpDataMdl.setCgdSendUid(userSid);
            grpDataMdl.setCgdSid(newId);
            grpDataMdl.setCgdStateKbn(GSConstChat.TOUKOU_STATUS_NORMAL);
            grpDataMdl.setCgdText(spmsg);
            grpDataMdl.setCgiSid(messageModel.getSelectPartner());
            grpDataMdl.setCstSid(messageModel.getStampSid());
            if (isFirst) {
                grpDataMdl.setCgdReplySid(messageModel.getReplyMessageSid());
                isFirst = false;
            }

            if (spmsg != null) {
                matcher = urlPattern.matcher(spmsg);
                if (matcher.find()) {
                    grpDataMdl.setCgdUrlFlg(1);
                }
            }

            ret.add(grpDataMdl);
        }
        return ret;
    }

    /**
     * <br>[機  能] 登録用のユーザメッセージ情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @param cntCon コントローラ
     * @param nPair ペアSID
     * @throws Exception 実行例外
     * @return grpDataMdl チャットグループ投稿情報
     * @throws SQLException
     */
    private List<ChtUserDataModel> __createMessageUserData(
        ChatSendEditModel messageModel, MlCountMtController cntCon, int nPair) throws SQLException {
        List<ChtUserDataModel> ret = new ArrayList<ChtUserDataModel>();
        List<String> msgList = new ArrayList<String>();

        String msg = messageModel.getBodyText();

        if (!StringUtil.isNullZeroString(msg)) {
            msgList = __getMessageList(msg);
        } else {
            msgList.add(null);
        }

        Iterator<String> itMsg = msgList.iterator();

        //メッセージ情報の作成
        long messageSid;
        UDate now = new UDate();
        ChtUserDataModel usrDataMdl = null;
        boolean isFirst = true;

        Pattern urlPattern = Pattern.compile(StringUtil.URL_PATTERN);
        Matcher matcher;
        while (itMsg.hasNext()) {
            String spmsg = itMsg.next();
            usrDataMdl = new ChtUserDataModel();
            int userSid = reqMdl__.getSmodel().getUsrsid();
            messageSid = cntCon.getSaibanNumber("chat", "usrMessageSid", userSid);
            usrDataMdl.setCudSid(messageSid);
            usrDataMdl.setCupSid(0);
            usrDataMdl.setCudText(spmsg);
            usrDataMdl.setCudSendUid(userSid);
            usrDataMdl.setCudStateKbn(GSConstChat.TOUKOU_STATUS_NORMAL);
            usrDataMdl.setCudAdate(now);
            usrDataMdl.setCudAuid(userSid);
            usrDataMdl.setCudEdate(now);
            usrDataMdl.setCudEuid(userSid);
            usrDataMdl.setCupSid(nPair);
            usrDataMdl.setCstSid(messageModel.getStampSid());
            if (isFirst) {
                usrDataMdl.setCudReplySid(messageModel.getReplyMessageSid());
                isFirst = false;
            }
            if (spmsg != null) {
                matcher = urlPattern.matcher(spmsg);
                if (matcher.find()) {
                    usrDataMdl.setCudUrlFlg(1);
                }
            }

            ret.add(usrDataMdl);
        }

        return ret;
    }

    /**
     * <br>[機  能] 絵文字を考慮し、3000文字ごとに区切った文字列リストを取得する
     * <br>[解  説] 結合されている絵文字がある場合、3000文字付近で分割されないようにしています。
     * <br>[備  考] 絵文字がある場合、内部的な文字列をカウントします。
     *              例) 😀は2バイトのため、2文字としてカウントします。4バイトの絵文字は4文字としてカウントします。
     * @param msg メッセージ
     * @return List<String>
     */
    private List<String> __getMessageList(String msg) {

        List<String> ret = new ArrayList<String>();
        if (StringUtil.isNullZeroString(msg)) {
            return ret;
        }

        int[] codePoints = msg.codePoints().toArray();
        int idx = 0;

        StringBuilder sb = new StringBuilder();
        String prevStr = "";
        String nowStr = "";

        int nextCode;
        while (idx < codePoints.length) {
            sb.append(Character.toChars((codePoints[idx])));

            nextCode = 0;
            if (idx != codePoints.length - 1) {
                nextCode = codePoints[idx + 1];
            }
            if (!GSConst.EMOJI_COMBINE_CODE.contains(nextCode) && codePoints[idx] != 0x200D) {
                nowStr = sb.toString();

                if (nowStr.length() == GSConstChat.MAX_LENGTH_MESSAGE) {
                    ret.add(nowStr);
                    sb = new StringBuilder();
                    prevStr = "";
                } else if (nowStr.length() > GSConstChat.MAX_LENGTH_MESSAGE) {
                    ret.add(prevStr);
                    sb = new StringBuilder();
                    prevStr = nowStr.replaceAll(prevStr, "");
                    sb.append(prevStr);
                } else {
                    prevStr = sb.toString();
                }
            }
            idx++;
        }

        if (sb.length() != 0) {
            ret.add(sb.toString());
        }

        return ret;
    }

    /**
     * <br>[機  能] ユーザの添付情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageSid メッセージSID
     * @param binList 添付ファイルリスト
     * @return 添付ファイル情報
     */
    private List<ChtUserDataTempModel> __createTempUserData(long messageSid, List<Long> binList) {

        List<ChtUserDataTempModel> ret = new ArrayList<ChtUserDataTempModel>();

        if (binList == null || binList.isEmpty()) {
            return ret;
        }

        ChtUserDataTempModel mdl = null;
        for (long binSid : binList) {
            mdl = new ChtUserDataTempModel();
            mdl.setCudSid(messageSid);
            mdl.setBinSid(binSid);
            ret.add(mdl);
        }

        return ret;
    }

    /**
     * <br>[機  能] ユーザの添付情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageSid メッセージSID
     * @param binList 添付ファイルリスト
     * @return 添付ファイル情報
     */
    private List<ChtGroupDataTempModel> __createTempGroupData(long messageSid, List<Long> binList) {

        List<ChtGroupDataTempModel> ret = new ArrayList<ChtGroupDataTempModel>();

        if (binList == null || binList.isEmpty()) {
            return ret;
        }

        ChtGroupDataTempModel mdl = null;
        for (long binSid : binList) {
            mdl = new ChtGroupDataTempModel();
            mdl.setCgdSid(messageSid);
            mdl.setBinSid(binSid);
            ret.add(mdl);
        }

        return ret;
    }

    /**
     * <br>[機  能] ユーザのメンション情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @param cudSid メッセージSID
     * @return ユーザチャットのメンション情報
     */
    private List<ChtUserDataMentionModel> __createMentionUserData(
        ChatSendEditModel messageModel, long cudSid) {

        List<ChtUserDataMentionModel> ret = new ArrayList<ChtUserDataMentionModel>();
        List<Integer> usrSidList = messageModel.getMentionUserSids();

        ChtUserDataMentionModel cumMdl;
        for (int usrSid : usrSidList) {
            cumMdl = new ChtUserDataMentionModel();
            cumMdl.setCudSid(cudSid);
            cumMdl.setUsrSid(usrSid);
            ret.add(cumMdl);
        }

        return ret;
    }

    /**
     * <br>[機  能] グループのメンション情報の作成を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @param cudSid メッセージSID
     * @return ユーザチャットのメンション情報
     */
    private List<ChtGroupDataMentionModel> __createMentionGroupData(
        ChatSendEditModel messageModel, long cudSid) {

        List<ChtGroupDataMentionModel> ret = new ArrayList<ChtGroupDataMentionModel>();
        List<Integer> usrSidList = messageModel.getMentionUserSids();

        ChtGroupDataMentionModel cumMdl;
        for (int usrSid : usrSidList) {
            cumMdl = new ChtGroupDataMentionModel();
            cumMdl.setCgdSid(cudSid);
            cumMdl.setUsrSid(usrSid);
            ret.add(cumMdl);
        }

        return ret;
    }

    /**
     * <br>[機  能] 画面再表示用データ取得
     * <br>[解  説]
     * <br>[備  考]
     * @param messageModel メッセージ情報
     * @param cntCon コントローラ
     * @param messageSid メッセージSID
     * @param adminMdl 管理者モデル
     * @throws Exception 実行例外
     * @return ret メッセージリスト
     */
    private ChatMessageModel __messageDisp(ChatSendEditModel messageModel,
            MlCountMtController cntCon, long messageSid, ChtAdmConfModel adminMdl)
        throws Exception {

        ChatMessageSearchRequest sReq;
        if (messageModel.getSelectKbn() == GSConstChat.CHAT_KBN_USER) {
            sReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    con__,
                    reqMdl__,
                    messageModel.getSelectPartner());
        } else {
            sReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    reqMdl__,
                    messageModel.getSelectPartner());
        }

        sReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    ChatMessageSearchFilter.EnumType.message,
                    String.valueOf(messageSid))
                )
        );
        try {
            ChatMessageSearchResult result =
                new ChatMessageSearcher(
                con__,
                sReq,
                adminMdl)
                .execute();

            if (result.getList().size() == 0) {
                return null;
            }
            return result.getList().get(0);
        } catch (TargetMessageWrongException e) {
            //メッセージポジション指定ではないためこの例外は発生しない
            throw new RuntimeException(e);
        }
    }

    /**
     * <br>[機  能] WebSocketによる既読情報変更の送信を行う
     * <br>[解  説]
     * <br>[備  考] チャット相手の画面にて、リアルタイムで"既読"を表示するための情報を送信する
     * @param con コネクション
     * @param reqMdl リクエスト情報
     * @param partnerSid チャット相手SID
     * @param messageSid メッセージSID
     * @throws Exception 実行例外
     */
    public void sendKidokuWs(
        Connection con, RequestModel reqMdl,
        int partnerSid, long messageSid) throws Exception {

        ChtBiz chtBiz = new ChtBiz(con);
        ChtAdmConfModel aconfMdl = chtBiz.getChtAconf();
        if (aconfMdl.getCacReadFlg() != GSConstChat.KIDOKU_DISP) {
            return;
        }
        JSONObject jsonData = new JSONObject();
        jsonData.element("plugin", "chat");
        jsonData.element("type", "message");
        jsonData.element("success", true);

        jsonData.element("selectSid", partnerSid);
        jsonData.element("selectKbn", GSConstChat.CHAT_KBN_USER);
        BaseUserModel usrMdl = reqMdl.getSmodel();
        jsonData.element("senderSid", usrMdl.getUsrsid());
        jsonData.element("senderId", usrMdl.getLgid());
        jsonData.element("readMsgSid", messageSid);
        jsonData.element("command", "kidoku");

        // WebSocketへデータ送信
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con, reqMdl);
        wsBiz.sendToWebSocket(jsonData);
    }

    /**
     * <br>[機  能] メッセージ送信処理
     * <br>[解  説] jsonを生成しwebSocketで送信
     * <br>[備  考]
     * @param selectSid チャットルームSID
     * @param kbn 区分
     * @param mes メッセージ
     * @param pushFlg true:プッシュ通知する, false:プッシュ通知しない
     * @throws Exception 実行時例外
     */
    private void __sendMessageWS(int selectSid, int kbn,
        ChatMessageModel mes, boolean pushFlg) throws Exception {

        if (mes == null) {
            return;
        }
        BaseUserModel smodel = reqMdl__.getSmodel();
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "message");
        jsonData.element("senderSid", smodel.getUsrsid());
        jsonData.element("senderId", smodel.getLgid());
        jsonData.element("selectSid", selectSid);
        jsonData.element("selectKbn", kbn);
        jsonData.element("size", 1);

        jsonData.element("messageSid", mes.getMessageSid());
        jsonMessageInfo(jsonData, List.of(mes), con__);

        jsonData.element("command", "add");
        jsonData.element("pushFlg", pushFlg);

        jsonData.element("isMessageSend", true);
        // WebSocket通信
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con__, reqMdl__);
        wsBiz.sendToWebSocket(jsonData);

    }

    /**
     * <br>[機  能] 画面再描画用のメッセージ情報, 添付ファイル情報をjsonに設定する
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param mesList メッセージ情報
     * @param con コネクション
     * @throws Exception 実行時例外
     * @return JSONオブジェクト
     * @throws SQLException
     */
    public JSONObject jsonMessageInfo(JSONObject jsonData,
        List<ChatMessageModel> mesList, Connection con) throws SQLException {

        if (mesList.isEmpty()) {
            return jsonData;
        }

        for (ChatMessageModel messageMdl : mesList) {
            __setMessageName(messageMdl);
        }
        Cht010MessageJsonModel messageJsonModel = new Cht010MessageJsonModel(mesList, con);
        jsonData.element("messageList", messageJsonModel.getMessageJson());
        jsonData.element("reactionUserList", messageJsonModel.getReactionUserJson());
        return jsonData;
    }

    /**
     * <br>[機  能] 名前，メッセージを表示用に置き換える
     * <br>[解  説] 返信を行っている投稿の場合、返信元の投稿情報の名前とメッセージも変更する
     * <br>[備  考]
     * @param messageMdl メッセージ情報
     * @throws Exception 実行時例外
     */
    private void __setMessageName(ChatMessageModel messageMdl) {
        if (messageMdl == null) {
            return;
        }

        messageMdl.setUsrName(StringUtilHtml.transToHTmlPlusAmparsant(messageMdl.getUsrName()));
        messageMdl.setMessageText(
            StringUtilHtml.transToHTmlPlusAmparsantAndLink(messageMdl.getMessageText()));

        __setMessageName(messageMdl.getReplyMessageInfo());
    }

    /**
     * <br>[機  能] 指定したスタンプが使用可能かを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @param stampSid スタンプSID
     * @return true:使用可能, false:使用不可能
     * @throws SQLException SQL実行時例外
     */
    public boolean canUseStamp(
        RequestModel reqMdl, Connection con, int stampSid) throws SQLException {

        ChtStampDao stampDao = new ChtStampDao(con);
        ChtStampModel stampMdl = stampDao.select(stampSid);
        if (stampMdl == null
            || stampMdl.getCstJkbn() == GSConstChat.STAMP_JKBN_DELETE
            || stampMdl.getCstUseKbn() == GSConstChat.STAMP_USE_KBN_UNUSED) {
            return false;
        }
        return true;
    }

    /**
     * <br>[機  能] 返信元投稿にアクセスが可能かを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @param replyMessageSid 返信元投稿SID
     * @param selectKbn 1:ユーザ, 2:グループ
     * @param partnerSid 送信先SID
     * @return true:返信元投稿にアクセスが可能, false:返信元投稿にアクセスが不可能
     * @throws SQLException SQL実行時例外
     */
    public boolean canReplyTarget(
        RequestModel reqMdl, Connection con,
        long replyMessageSid, int selectKbn, int partnerSid) throws SQLException {

        if (replyMessageSid == 0) {
            return true;
        }

        if (selectKbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataDao cudDao = new ChtUserDataDao(con);
            ChtUserDataModel cudMdl = cudDao.select(replyMessageSid);
            int sessionUserSid = reqMdl.getSmodel().getUsrsid();
            if (cudMdl == null) {
                return false;
            }

            ChtUserPairDao cupDao = new ChtUserPairDao(con);
            int cupSid = cupDao.select(sessionUserSid, partnerSid);
            if (cudMdl.getCupSid() != cupSid) {
                return false;
            }
        } else {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con);
            ChtGroupDataModel cgdMdl = cgdDao.select(replyMessageSid);

            if (cgdMdl == null || cgdMdl.getCgiSid() != partnerSid) {
                return false;
            }
        }

        return true;
    }

    /**
     * <br>[機  能] メンションのチェック
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @param mentionUser メンションユーザSID
     * @param kbn 1:ユーザ, 2:グループ
     * @param selectSid メッセージ送信先
     * @return true:メンション指定先が正常, false:メンション指定先が不正
     * @throws SQLException SQL実行時例外
     */
    public boolean checkMention(
        RequestModel reqMdl, Connection con,
        List<Integer> mentionUser, int kbn, int selectSid) throws SQLException {

        if (mentionUser == null || mentionUser.isEmpty()) {
            return true;
        }

        //全員が選択されているのに、その他にも入力がされている
        //または、重複して入力されている
        if (mentionUser.contains(-1) && mentionUser.size() != 1
            || mentionUser.size() != new HashSet<Integer>(mentionUser).size()) {
            return false;
        }

        //全員が選択されている場合は存在チェックを行わない
        if (mentionUser.contains(-1)) {
            return true;
        }

        CmnUsrmDao usrmDao = new CmnUsrmDao(con);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(mentionUser);
        int cnt = usrmDao.getCountDeleteUser(arrayList);
        if (cnt > 0) {
            //削除済みユーザがいる場合エラー
            return false;
        } else if (kbn == GSConstChat.CHAT_KBN_USER) {
            //チャットルームに存在しないユーザを選択した場合に、エラー
            int sessionUserSid = reqMdl.getSmodel().getUsrsid();
            for (int sid : mentionUser) {
                if (sid != sessionUserSid && sid != selectSid) {
                    return false;
                }
            }
        } else {
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con);
            List<Integer> groupMember = cguDao.membersOfChatGroup(selectSid);
            if (!groupMember.containsAll(mentionUser)) {
                return false;
            }
        }
        return true;
    }

    /**
     * <br>[機  能] 指定したメッセージを編集する際に、テキストの入力が必要かを判定する
     * <br>[解  説]
     * <br>[備  考] 指定したメッセージに添付ファイルが設定されていない場合は、テキストの入力が必要
     * @param editMessageSid 編集対象のメッセージSID
     * @param kbn 1:ユーザ, 2:グループ
     * @param con コネクション
     * @return true:テキストの入力が必要, false:テキストの入力が必要ではない
     * @throws SQLException SQL実行時例外
     */
    public boolean isNeedEditText(
        long editMessageSid, int kbn, Connection con) throws SQLException {

        boolean ret = true;
        //添付ファイルがない場合、文字列は入力必須
        List<Long> messageSid = new ArrayList<Long>(List.of(editMessageSid));
        if (kbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataTempDao cutDao = new ChtUserDataTempDao(con);
            List<Long> binSidList = cutDao.getBinSid(messageSid);
            if (!binSidList.isEmpty()) {
                ret = false;
            }
        } else if (kbn == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataTempDao cgtDao = new ChtGroupDataTempDao(con);
            List<Long> binSidList = cgtDao.getBinSid(messageSid);
            if (!binSidList.isEmpty()) {
                ret = false;
            }
        }

        return ret;
    }
    /**
     * リアクションの変更を行う
     * 実行後、WebSocketでチャット相手へ通知を行う。
     * @param kbn
     * @param partnerSid
     * @param messageSid
     * @param reactionSid
     * @param enumReactionFlg 設定するリアクション状態 nullの場合は自動でtoggle動作とする
     * @throws SQLException
     */
    public void putReaction(
        int kbn,
        int partnerSid,
        long messageSid,
        int reactionSid,
        EnumReactionFlg enumReactionFlg) throws SQLException {

        int usrSid = reqMdl__.getSmodel().getUsrsid();
        // DB保管部 -------------------------------------------------------------------------
        boolean defCommit = con__.getAutoCommit();
        JDBCUtil.autoCommitOff(con__);
        boolean toggle = false;
        if (kbn == GSConstChat.CHAT_KBN_USER) {
            //ユーザチャットのリアクション情報の変更
            ChtUserDataReactionDao curDao = new ChtUserDataReactionDao(con__);
            ChtUserDataReactionModel curMdl = curDao.select(messageSid, usrSid, reactionSid);
            if (curMdl == null
                && (enumReactionFlg == null || enumReactionFlg == EnumReactionFlg.ON)) {
                ChtUserDataReactionModel insertMdl = new ChtUserDataReactionModel();
                insertMdl.setCudSid(messageSid);
                insertMdl.setUsrSid(usrSid);
                insertMdl.setCurReactionNo(reactionSid);
                insertMdl.setCurAdate(new UDate());
                curDao.insert(insertMdl);
                toggle = true;
            }
            if (curMdl != null
                && (enumReactionFlg == null || enumReactionFlg == EnumReactionFlg.OFF)) {
                curDao.delete(messageSid, usrSid, reactionSid);
                toggle = true;
            }
        } else {
            //グループチャットのリアクション情報の変更
            ChtGroupDataReactionDao cgrDao = new ChtGroupDataReactionDao(con__);
            ChtGroupDataReactionModel cgrMdl = cgrDao.select(messageSid, usrSid, reactionSid);
            if (cgrMdl == null
                && (enumReactionFlg == null || enumReactionFlg == EnumReactionFlg.ON)) {
                ChtGroupDataReactionModel insertMdl = new ChtGroupDataReactionModel();
                insertMdl.setCgdSid(messageSid);
                insertMdl.setUsrSid(usrSid);
                insertMdl.setCgrReactionNo(reactionSid);
                insertMdl.setCgrAdate(new UDate());
                cgrDao.insert(insertMdl);
                toggle = true;
            }
            if (cgrMdl != null
                && (enumReactionFlg == null || enumReactionFlg == EnumReactionFlg.OFF)) {
                cgrDao.delete(messageSid, usrSid, reactionSid);
                toggle = true;
            }
        }
        con__.commit();
        if (defCommit) {
            JDBCUtil.autoCommitOn(con__);
        }

        // WebSocket通知部 -------------------------------------------------------------------------
        if (toggle) {
            __sendReaction(kbn, partnerSid, messageSid, reactionSid);
        }

    }
    /**
     * <br>[機  能] リアクションの登録/削除の結果を各ユーザに送信する
     * <br>[解  説]
     * <br>[備  考]
     * @param kbn
     * @param partnerSid
     * @param messageSid
     * @param reactionSid
     * @throws SQLException
     */
    private void __sendReaction(
        int kbn,
        int partnerSid,
        long messageSid,
        int reactionSid
    ) throws SQLException  {

        BaseUserModel usrMdl = reqMdl__.getSmodel();

        // WebSocketで送信 -------------------------------------------------------------------------
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "message");
        jsonData.element("senderSid", String.valueOf(usrMdl.getUsrsid()));
        jsonData.element("senderId", usrMdl.getLgid());
        jsonData.element("selectSid", String.valueOf(partnerSid));
        ChtReactionBiz reactionBiz = new ChtReactionBiz();
        List<Long> msgSidList = Arrays.asList(new Long[] {messageSid});

        Map<Long, List<ChtReactionModel>> reactionMap;
        if (kbn == GSConstChat.CHAT_KBN_USER) {
            reactionMap = reactionBiz.getUserReactionData(msgSidList, con__);
        } else {
            reactionMap = reactionBiz.getGroupReactionData(msgSidList, con__);
        }
        ChatMessageModel msgMdl = new ChatMessageModel();
        List<ChtReactionModel> reactionList = reactionMap.get(messageSid);
        msgMdl.setReactionList(reactionList);
        List<ChatMessageModel> msgList = Arrays.asList(new ChatMessageModel[] {msgMdl});

        jsonMessageInfo(jsonData, msgList, con__);
        jsonData.element("selectKbn", String.valueOf(kbn));
        jsonData.element("messageSid", messageSid);
        jsonData.element("command", "reaction");

        // WebSocketへデータを送信
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con__, reqMdl__);
        try {
            wsBiz.sendToWebSocket(jsonData);
        } catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException) e;
            }
            throw new RuntimeException(e);
        }
    }

    /**
     * 既読状態の登録を行う
     * 実行後、WebSocketでチャット相手へ通知を行う。
     * @param kbn
     * @param partnerSid
     * @param messageSid
     * @return 最新の未読件数
     * @throws SQLException
     */
    public int updateViewMessage(
        int kbn,
        int partnerSid,
        long messageSid) throws SQLException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        // DB保管部 -------------------------------------------------------------------------
        boolean defCommit = con__.getAutoCommit();
        JDBCUtil.autoCommitOff(con__);
        ChatDao cDao = new ChatDao(con__);
        int cnt = 0;
        int delNum = 0;

        /** WebSocket既読情報を送るかどうか 他のユーザとのチャット時のみ送信する */
        boolean sendSocket = false;
        if (kbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserPairDao cupDao = new ChtUserPairDao(con__);
            int cupSid = cupDao.select(sessionUsrSid, partnerSid);
            ChtUserViewDao cuvDao = new ChtUserViewDao(con__);
            // 既存のメッセージSIDより大きい場合削除して挿入 削除対象のレコードが存在しない場合は"1"が返ってくる
            delNum = cuvDao.deleteIfMax(cupSid, sessionUsrSid, messageSid);
            if (delNum > 0) {
                ChtUserDataDao cudDao = new ChtUserDataDao(con__);
                ChtUserViewModel mdl = new ChtUserViewModel();
                mdl.setCudSid(messageSid);
                mdl.setCupSid(cupSid);
                mdl.setCuvUid(sessionUsrSid);
                mdl.setCuvViewcnt(cudDao.countTarget(cupSid, messageSid));
                cuvDao.insert(mdl);
                cnt = cDao.getMidokuCountPair(sessionUsrSid, cupSid);

                if (sessionUsrSid != partnerSid) {
                    sendSocket = true;
                }
            }
        } else if (kbn == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupViewDao cgvDao = new ChtGroupViewDao(con__);
            // 既存のメッセージSIDより大きい場合削除して挿入 削除対象のレコードが存在しない場合は"1"が返ってくる
            delNum = cgvDao.deleteIfMax(partnerSid, sessionUsrSid, messageSid);
            if (delNum > 0) {
                ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
                ChtGroupViewModel mdl = new ChtGroupViewModel();
                mdl.setCgdSid(messageSid);
                mdl.setCgiSid(partnerSid);
                mdl.setCgvUid(sessionUsrSid);
                mdl.setCgvViewcnt(cgdDao.countTarget(partnerSid, messageSid));
                cgvDao.insert(mdl);
                cnt = cDao.getMidokuCountGroup(sessionUsrSid, partnerSid);
            }
        }
        con__.commit();
        if (defCommit) {
            JDBCUtil.autoCommitOn(con__);
        }

        // WebSocket通知部 -------------------------------------------------------------------------
        if (sendSocket) {
            try {
                sendKidokuWs(con__, reqMdl__,
                    partnerSid,
                    messageSid);
            } catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException) e;
                }
                throw new RuntimeException(e);
            }
        }
        return cnt;
    }


}
