package jp.groupsession.v2.cht.biz;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserDataPinDao;
import jp.groupsession.v2.cht.model.ChtGroupDataPinModel;
import jp.groupsession.v2.cht.model.ChtUserDataPinModel;
import jp.groupsession.v2.cmn.model.RequestModel;

public class ChtUserPinSortChanger {
    /** コネクション*/
    private Connection con__;

    /** リクエストモデル*/
    private RequestModel reqMdl__;

    /** ペアSID*/
    private int pairSid__;

    /** グループSID*/
    private int chatGroupSid__;

    /** コンストラクタ */
    private ChtUserPinSortChanger() {

    }

    /**
     *
     * @param con
     * @param reqMdl
     * @param pairSid
     * @return ユーザチャット用インスタンス取得
    */
    public static ChtUserPinSortChanger getInstanceForUserChat(
        Connection con, RequestModel reqMdl, int pairSid
        ) {
        ChtUserPinSortChanger ret = new ChtUserPinSortChanger();
        ret.con__ = con;
        ret.reqMdl__ = reqMdl;
        ret.pairSid__ = pairSid;
        return ret;

    }

    /**
     *
     * @param con
     * @param reqMdl
     * @param chatGroupSid
     * @return グループチャット用インスタンス取得
    */
    public static ChtUserPinSortChanger getInstanceForGroupChat(
        Connection con, RequestModel reqMdl, int chatGroupSid
        ) {
        ChtUserPinSortChanger ret = new ChtUserPinSortChanger();
        ret.con__ = con;
        ret.reqMdl__ = reqMdl;
        ret.chatGroupSid__ = chatGroupSid;
        return ret;
    }
    /**
     * ソート順の変更を実行
     * @param startSort
     * @param endSort
     * @throws SQLException
    */
    public void sort(int startSort, int endSort)
            throws SQLException {
        int sessionUserSid = reqMdl__.getSmodel().getUsrsid();
        int sortKbn = GSConstChat.CHAT_ORDER_ASC;
        if (startSort > endSort) {
            //移動前の並び順 > 移動後の並び順 となる時、値を入れ替える
            sortKbn = GSConstChat.CHAT_ORDER_DESC;
            int escSort = startSort;
            startSort = endSort;
            endSort = escSort;
        }

        if (pairSid__ > 0) {

            ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con__);
            //更新対象となるピンどめ一覧を取得
            List<ChtUserDataPinModel> uPinMdlList = uPinDao.sortRangeSelect(
                sessionUserSid, pairSid__, startSort, endSort, sortKbn);

            //並び順変更
            ChtUserDataPinModel doUPinMdl = null;
            for (ChtUserDataPinModel uPinMdl : uPinMdlList) {
                if (doUPinMdl == null) {
                    //移動対象となるスタンプを退避
                    doUPinMdl = uPinMdl;
                    continue;
                }
                int escSort = doUPinMdl.getCudpSort();
                doUPinMdl.setCudpSort(uPinMdl.getCudpSort());
                uPinMdl.setCudpSort(escSort);
                //並び順を1つ移動させる。
                uPinDao.update(uPinMdl);
            }
            //最後に移動対象となるスタンプを更新
            uPinDao.update(doUPinMdl);
        }
        if (chatGroupSid__ > 0) {
            ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con__);

            //更新対象となるピンどめ一覧を取得
            List<ChtGroupDataPinModel> uPinMdlList = gPinDao.sortRangeSelect(
                sessionUserSid, chatGroupSid__,
                startSort, endSort, sortKbn);

            //並び順変更
            ChtGroupDataPinModel doGPinMdl = null;
            for (ChtGroupDataPinModel uPinMdl : uPinMdlList) {
                if (doGPinMdl == null) {
                    //移動対象となるスタンプを退避
                    doGPinMdl = uPinMdl;
                    continue;
                }
                int escSort = doGPinMdl.getCgdpSort();
                doGPinMdl.setCgdpSort(uPinMdl.getCgdpSort());
                uPinMdl.setCgdpSort(escSort);
                //並び順を1つ移動させる。
                gPinDao.update(uPinMdl);
            }
            //最後に移動対象となるスタンプを更新
            gPinDao.update(doGPinMdl);
        }
    }
}
