package jp.groupsession.v2.cht.biz;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUconfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.dao.ChtGroupViewDao;
import jp.groupsession.v2.cht.dao.ChtPriConfDao;
import jp.groupsession.v2.cht.dao.ChtUserUconfDao;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtGroupViewModel;
import jp.groupsession.v2.cht.model.ChtPriConfModel;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.cmn.websocket.IWebSocketSender;
import jp.groupsession.v2.cmn.websocket.WebSocketSender;
import jp.groupsession.v2.usr.GSConstUser;

/**
 *
 * <br>[機  能] チャットプラグインで使用するWebSocket通信ロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtWebSocketBiz {

    /** DBコネクション */
    private Connection con__ = null;
    /** リクエスト情報 */
    private RequestModel reqMdl__ = null;

    /**
     * リクエスト用グループモデル
     **/
    public static class GroupInfoReqModel {
        /** グループSID */
        private int chatGroupSid__;
        /** グループ名 */
        private String chatGroupName__;
        /** アーカイブフラグ */
        private int chatGroupArchiveFlg__;
        /** メッセージ件数 */
        private int messageCount__;
        /** 最終投稿日時 */
        private String messageLastDate__;
        /**
         * @return the chatGroupSid
         */
        public int getChatGroupSid() {
            return chatGroupSid__;
        }
        /**
         * @param chatGroupSid the chatGroupSid to set
         */
        public void setChatGroupSid(int chatGroupSid) {
            chatGroupSid__ = chatGroupSid;
        }
        /**
         * @return the chatGroupName
         */
        public String getChatGroupName() {
            return chatGroupName__;
        }
        /**
         * @param chatGroupName the chatGroupName to set
         */
        public void setChatGroupName(String chatGroupName) {
            chatGroupName__ = chatGroupName;
        }
        /**
         * @return the chatGroupArchiveFlg
         */
        public int getChatGroupArchiveFlg() {
            return chatGroupArchiveFlg__;
        }
        /**
         * @param chatGroupArchiveFlg the chatGroupArchiveFlg to set
         */
        public void setChatGroupArchiveFlg(int chatGroupArchiveFlg) {
            chatGroupArchiveFlg__ = chatGroupArchiveFlg;
        }
        /**
         * @return the messageCount
         */
        public int getMessageCount() {
            return messageCount__;
        }
        /**
         * @param messageCount the messageCount to set
         */
        public void setMessageCount(int messageCount) {
            messageCount__ = messageCount;
        }
        /**
         * @return the messageLastDateStr
         */
        public String getMessageLastDate() {
            return messageLastDate__;
        }
        /**
         * @param messageLastDateStr the messageLastDateStr to set
         */
        public void setMessageLastDate(String messageLastDateStr) {
            messageLastDate__ = messageLastDateStr;
        }



    }

    /**
     * <p>コンストラクタ
     * @param con コネクション
     * @param reqMdl リクエスト情報
     * */
    public ChtWebSocketBiz(Connection con, RequestModel reqMdl) {
        con__ = con;
        reqMdl__ = reqMdl;
    }
    /**
     *
     * <br>[機  能] List<Integer>をint[]に変換
     * <br>[解  説]
     * <br>[備  考]
     * @param memberList ユーザSIDリスト
     * @return int配列
     */
    private int[] __toIntArr(List<Integer> memberList) {

        int[] msgTo = new int[memberList.size()];
        for (int i = 0; i < memberList.size(); i++) {
            msgTo[i] = memberList.get(i);
        }
        return msgTo;
    }


    /**
     *
     * <br>[機  能] チャットグループの表示を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param procMode 処理タイプ
     * @param model 送信グループ情報モデル
     * @param members 所属ユーザ
     * @param oldMembers 編集前の所属ユーザ
     * @throws Exception Exception
     */
    public void editChatGroup(
            int procMode,
            GroupInfoReqModel model,
            String[] members,
            String[] oldMembers)
            throws Exception {

        if (members == null) {
            return;
        }
        // gsドメイン
        String domain = reqMdl__.getDomain();

        // 送信先メンバー
        List<Integer> memberList = new ArrayList<Integer>();
        for (String str : members) {
            int sid = NullDefault.getInt(str, 0);
            if (sid <= 0) {
                continue;
            }
            memberList.add(sid);
        }

        IWebSocketSender sender =  WebSocketSender.getInstance();

        ChtGroupInfDao groupDao = new ChtGroupInfDao(con__);
        ChtGroupInfModel groupMdl = groupDao.select(model.getChatGroupSid());
        String grpId = "";
        if (groupMdl != null) {
            grpId = groupMdl.getCgiId();
        }

        // 新規登録
        if (procMode == GSConstChat.CHAT_MODE_ADD) {
            // プラグイン使用確認
            List<Integer> permitMemberList = permitPluginUser(memberList, domain);

            sender.sendText(
                domain, __toIntArr(permitMemberList), __createDataNewGroup(model, grpId));

        // 編集
        } else if (procMode == GSConstChat.CHAT_MODE_EDIT) {
            // プラグイン使用確認
            List<Integer> permitMemberList = permitPluginUser(memberList, domain);

            Map<Integer, Integer> midokuCountMap = __createMidokuCountMap(model, permitMemberList);

            for (int memSid : permitMemberList) {
                sender.sendText(domain,
                new int[] {memSid},
                __createDataEditGroup(model, grpId, midokuCountMap.get(memSid)));
            }
            // メンバーから外れたユーザ
            List<Integer> oldMemberList = new ArrayList<Integer>();

            for (String str : oldMembers) {
                int sid = NullDefault.getInt(str, 0);
                if (sid <= 0) {
                    continue;
                }
                oldMemberList.add(sid);
            }
            oldMemberList.removeAll(permitMemberList);

            List<Integer> oldPermitMemberList = permitPluginUser(oldMemberList, domain);

            sender.sendText(domain,
                __toIntArr(oldPermitMemberList),
                __createDataDeleteGroup(model, grpId));

        //削除
        } else if (procMode == GSConstChat.CHAT_MODE_DELETE) {
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            List<Integer> memberSid = cguDao.membersOfChatGroup(model.getChatGroupSid());
            List<Integer> permitMemberList = permitPluginUser(memberSid, domain);

            sender.sendText(domain,
                __toIntArr(permitMemberList),
                __createDataDeleteGroup(model, grpId));
        }

    }
    /**
     * グループ追加の送信メッセージを生成
     * @param model
     * @param grpId グループID
     * @return 送信文字列
     */
    private String __createDataNewGroup(GroupInfoReqModel model, String grpId) {
        JSONObject jsonData = JSONObject.fromObject(model);

        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "chatGroup");
        jsonData.element("chatGroupName",
            StringUtilHtml.transToHTmlPlusAmparsant(model.getChatGroupName()));
        jsonData.element("chatGroupProcMode", 0);
        jsonData.element("chatGroupId", grpId);

        return jsonData.toString();
    }
    /**
     * 指定SIDと未読件数のMapを生成する
     * @param model
     * @param permitMemberList
     * @return 指定SIDと未読件数のMap
     * @throws SQLException
     */
    private Map<Integer, Integer> __createMidokuCountMap(
        GroupInfoReqModel model,
        Collection<Integer> permitMemberList) throws SQLException {

        Map<Integer, Integer> ret = new HashMap<>();

        ChtGroupViewDao cgvDao = new ChtGroupViewDao(con__);
        List<ChtGroupViewModel> vList =
            cgvDao.selectFromUserSids(
                model.getChatGroupSid(), permitMemberList);

        int maxCount = model.getMessageCount();

        for (int usrSid : permitMemberList) {
            ret.put(usrSid, maxCount);
        }
        for (ChtGroupViewModel vmodel : vList) {
            ret.put(
                vmodel.getCgvUid(),
                maxCount - vmodel.getCgvViewcnt());
        }
        return ret;

    }
    /**
     * グループ編集の送信メッセージを生成
     * @param model
     * @param grpId グループID
     * @param midokuCount
     * @return 送信文字列
     */
    private String __createDataEditGroup(GroupInfoReqModel model, String grpId, int midokuCount) {
        JSONObject jsonData = JSONObject.fromObject(model);
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "chatGroup");
        jsonData.element("chatGroupProcMode", 1);
        jsonData.element("chatGroupName",
            StringUtilHtml.transToHTmlPlusAmparsant(model.getChatGroupName()));
        jsonData.element("remove", false);
        jsonData.element("messageCount", midokuCount);
        jsonData.element("chatGroupId", grpId);

        return jsonData.toString();
    }

    /**
     * グループ削除の送信メッセージを生成
     * @param model
     * @param grpId グループID
     * @return 送信文字列
     */
    private String __createDataDeleteGroup(GroupInfoReqModel model, String grpId) {
        JSONObject jsonData = JSONObject.fromObject(model);
        jsonData.element("success", true);
        jsonData.element("plugin", "chat");
        jsonData.element("type", "chatGroup");
        jsonData.element("chatGroupName",
            StringUtilHtml.transToHTmlPlusAmparsant(model.getChatGroupName()));
        jsonData.element("chatGroupProcMode", 1);
        jsonData.element("remove", true);
        jsonData.element("chatGroupId", grpId);

        String removeMsg = jsonData.toString();
        return removeMsg;
    }
    /**
     * <p>プラグインを使用できるユーザ一覧を取得
     * @param targetMember メンバー一覧
     * @param domain ドメイン名
     * @throws SQLException SQL実行例外
     * @throws IOException 入出力実行例外
     * @return ユーザ一覧
      */
    public List<Integer> permitPluginUser(
            List<Integer> targetMember, String domain)
            throws SQLException, IOException {

        if (targetMember.size() <= 0) {
            return new ArrayList<Integer>();
        }

        CommonBiz biz = new CommonBiz();

        List<Integer> member = targetMember;
        member = biz.getCanUsePluginUser(con__, GSConstChat.PLUGIN_ID_CHAT, member);

        List<Integer> ret = member;

        return ret;
    }

    /**
     * <p>WebSocketへデータを送信します
     * <p> jsonDataのtype,commandパラメータで送信先などが変更されます
     * @param jsonData 送信先や送信内容などを含むデータ
     * @throws Exception Exception
     * */
    public void sendToWebSocket(JSONObject jsonData)
            throws Exception {
        // メッセージの種類
        String type = jsonData.getString("type");
        String command = jsonData.getString("command");
        // gsドメイン
        String domain = reqMdl__.getDomain();
        // チャットメッセージ送信
        if (type.equals("message")) {
            // メッセージ送信先区分( 1:ユーザ 2:グループ)
            int selectKbn = jsonData.getInt("selectKbn");
            // メッセージ送信先のSID
            int selectSid = Integer.parseInt(jsonData.getString("selectSid"));
            // メッセージ送信者のユーザSID
            int senderSid = Integer.parseInt(jsonData.getString("senderSid"));

            List<Integer> member = new ArrayList<Integer>();

            // データの送信
            if (selectKbn == GSConstChat.CHAT_KBN_GROUP) {

                  // グループチャット
                  ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
                  member = cguDao.membersOfChatGroup(selectSid);

                  //selectIdの設定
                  ChtGroupInfDao groupDao = new ChtGroupInfDao(con__);
                  ChtGroupInfModel groupMdl = groupDao.select(jsonData.getInt("selectSid"));
                  String grpId = "";
                  if (groupMdl != null) {
                    grpId = groupMdl.getCgiId();
                  }
                  jsonData.put("selectId", grpId);

            } else if (selectKbn == GSConstChat.CHAT_KBN_USER) {
                if (Objects.equals(command, "kidoku")) {
                    //既読通知を受ける側に合わせてselectSidを変更
                    jsonData.put("selectSid", senderSid);
                    member.add(selectSid);
                } else {
                    // 送信者自身
                    member.add(senderSid);
                    if (senderSid != selectSid) {
                        // 送信先
                        member.add(selectSid);
                    }
                }

                //selectIdの設定
                int usrSid = jsonData.getInt("selectSid");
                CmnUsrmDao usrDao = new CmnUsrmDao(con__);
                CmnUsrmModel usrMdl = usrDao.select(usrSid);
                String usrId = "";
                if (usrMdl != null) {
                    usrId = usrMdl.getUsrLgid();
                }
                jsonData.put("selectId", usrId);
            }

            // プラグイン使用確認
            member =  permitPluginUser(member, domain);

            IWebSocketSender sender =  WebSocketSender.getInstance();
            if (jsonData.optBoolean("isMessageSend", false)) {
                //メッセージ送信時の場合個人設定, ミュート設定から、通知を行うか,通知する時間を取得する
                ChtPriConfDao cpcDao = new ChtPriConfDao(con__);
                List<ChtPriConfModel> cpcList = cpcDao.selectBrowserTuuti(member);
                Map<Integer, ChtPriConfModel> cpcMap = cpcList.stream()
                    .collect(Collectors.toMap(ChtPriConfModel::getCpcPriUid, mdl -> mdl));
                long messageSid = Long.parseLong(jsonData.getString("messageSid"));

                //チャットルーム名の設定を行う
                Map<Integer, String> userChatNameMap = new HashMap<Integer, String>();
                if (selectKbn == GSConstChat.CHAT_KBN_USER) {
                    String[] userSids = member.stream()
                        .map(String::valueOf)
                        .toArray(String[]::new);
                    UserBiz userBiz = new UserBiz();
                    List<CmnUsrmInfModel> userList =
                        userBiz.getUserList(con__, userSids, GSConstUser.USER_JTKBN_ALL);

                    CmnUsrmInfModel usrMdl;
                    if (userList.size() == 1) {
                        usrMdl = userList.get(0);
                        userChatNameMap.put(usrMdl.getUsrSid(),
                            StringUtilHtml.transToHTmlPlusAmparsant(usrMdl.getUsiName()));
                    } else if (userList.size() > 1) {
                        userChatNameMap.put(userList.get(0).getUsrSid(),
                            StringUtilHtml.transToHTmlPlusAmparsant(userList.get(1).getUsiName()));
                        userChatNameMap.put(userList.get(1).getUsrSid(),
                            StringUtilHtml.transToHTmlPlusAmparsant(userList.get(0).getUsiName()));
                    }
                }

                String groupChatName = "";
                if (selectKbn == GSConstChat.CHAT_KBN_GROUP) {
                    ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
                    ChtGroupInfModel groupMdl = cgiDao.select(selectSid);
                    if (groupMdl != null) {
                        groupChatName =
                            StringUtilHtml.transToHTmlPlusAmparsant(groupMdl.getCgiName());
                    }
                }

                Map<Integer, Integer> muteMap;
                ChtPriConfModel cpcMdl;
                JSONObject messageJson;

                if (selectKbn == GSConstChat.CHAT_KBN_GROUP) {
                    ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con__);
                    muteMap = cguDao.getMuteKbn(member, messageSid);
                } else {
                    ChtUserUconfDao ccuDao = new ChtUserUconfDao(con__);
                    muteMap = ccuDao.getMuteKbn(member, messageSid);
                }
                for (int usrSid : member) {
                    cpcMdl = cpcMap.get(usrSid);
                    messageJson = JSONObject.fromObject(jsonData);
                    if (cpcMdl == null) {
                        messageJson.element("dspFlg", GSConstChat.CHAT_PUSH_FLG_YES);
                        messageJson.element("dspTime", GSConstChat.CHAT_PUSH_DEFAULT_TIME);
                    } else {
                        messageJson.element("dspFlg", cpcMdl.getCpcPushFlg());
                        messageJson.element("dspTime", cpcMdl.getCpcPushTime());
                    }
                    if (muteMap.get(usrSid) != null) {
                        messageJson.element("muteKbn", muteMap.get(usrSid));
                    } else {
                        messageJson.element("muteKbn", GSConstChat.CHAT_MUTE_OFF);
                    }
                    messageJson.element("ownUserSid", usrSid);
                    if (selectKbn == GSConstChat.CHAT_KBN_USER) {
                        messageJson.element("chatName", userChatNameMap.get(usrSid));
                    } else {
                        messageJson.element("chatName", groupChatName);
                    }

                    sender.sendText(domain, new int[] {usrSid}, messageJson.toString());
                }
                return;
            }

            int[] msgTo = new int[member.size()];
            for (int i = 0; i < member.size(); i++) {
                msgTo[i] = member.get(i);
            }
            String message = jsonData.toString();
            sender.sendText(domain, msgTo, message);
        }
    }
}

