package jp.groupsession.v2.cht.cht010;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.LabelValueBean;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.json.JSONArray;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtMemberBiz;
import jp.groupsession.v2.cht.biz.ChtSelectPartnerLoader;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.biz.ChtUserPairCreateBiz;
import jp.groupsession.v2.cht.biz.ChtUserPinSortChanger;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataPinDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataSumDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataTempDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupTargetDao;
import jp.groupsession.v2.cht.dao.ChtGroupUconfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.dao.ChtGroupViewDao;
import jp.groupsession.v2.cht.dao.ChtPriConfDao;
import jp.groupsession.v2.cht.dao.ChtSpaccessPermitDao;
import jp.groupsession.v2.cht.dao.ChtSpaccessTargetDao;
import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.cht.dao.ChtUserDataDao;
import jp.groupsession.v2.cht.dao.ChtUserDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserDataTempDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.dao.ChtUserUconfDao;
import jp.groupsession.v2.cht.dao.ChtUserViewDao;
import jp.groupsession.v2.cht.model.ChatGroupComboModel;
import jp.groupsession.v2.cht.model.ChatGroupInfModel;
import jp.groupsession.v2.cht.model.ChatInformationModel;
import jp.groupsession.v2.cht.model.ChatMessageModel;
import jp.groupsession.v2.cht.model.ChatMidokuModel;
import jp.groupsession.v2.cht.model.ChatSendEditModel;
import jp.groupsession.v2.cht.model.ChatUserInfModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtFavoriteModel;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupDataPinModel;
import jp.groupsession.v2.cht.model.ChtGroupDataSumModel;
import jp.groupsession.v2.cht.model.ChtGroupDataTempModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtGroupUconfModel;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cht.model.ChtGroupViewModel;
import jp.groupsession.v2.cht.model.ChtPriConfModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.model.ChtUserDataPinModel;
import jp.groupsession.v2.cht.model.ChtUserDataTempModel;
import jp.groupsession.v2.cht.model.ChtUserUconfModel;
import jp.groupsession.v2.cht.model.ChtUserViewModel;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cht.search.position.AfterMessage;
import jp.groupsession.v2.cht.search.position.ArroundMessage;
import jp.groupsession.v2.cht.search.position.BeforeMessage;
import jp.groupsession.v2.cht.search.position.MidokuPosition;
import jp.groupsession.v2.cht.search.position.OffsetPosition;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.dao.base.CmnMyGroupDao;
import jp.groupsession.v2.cmn.model.CmnLabelValueModel;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.UserSearchModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnMyGroupModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;
import jp.groupsession.v2.usr.UserUtil;


/**
 * <br>[機  能] チャット一覧のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cht010Biz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cht010Biz.class);
    /** ダウンロードチェック エラーコード ZIPエラー*/
    public static final int DOWNLOADCHECK_CODE_ZIPERROR = 3;

    /** コネクション */
    private Connection con__ = null;
    /** リクエストモデル*/
    RequestModel reqMdl__ = null;

    /**
     * コンストラクタ
     * @param con コネクション
     * @param reqMdl リクエストモデル
     */
    public Cht010Biz(Connection con, RequestModel reqMdl) {
        con__ = con;
        reqMdl__ = reqMdl;
    }

    /**
     * コンストラクタ
     */
    public Cht010Biz() {

    }

    /**
     * <br>[機  能]初期設定
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param admin 管理者フラグ
     * @param cmd コマンド
     * @throws SQLException SQLException
     */
    public void setInitData(Cht010ParamModel paramMdl,
            boolean admin, String cmd)
            throws SQLException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        paramMdl.setCht010EditUsrSid(sessionUsrSid);

        //管理者か設定
        if (admin) {
            paramMdl.setAdminFlg(1);
        } else {
            paramMdl.setAdminFlg(0);
        }

        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();

        //個人設定の取得（デフォルト表示を取得）
        ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);

        /*左メニュー情報の取得*/
        //グループの編集権限があるか判定する
        if (admin || adminMdl.getCacGroupFlg() == GSConstChat.PERMIT_CREATE_GROUP) {
            paramMdl.setCht010GroupEditFlg(GSConstChat.CHAT_GROUP_EDIT);
        } else {
            ChtGroupTargetDao cgtDao = new ChtGroupTargetDao(con__);
            int cnt = cgtDao.select(sessionUsrSid);
            if ((adminMdl.getCacGroupKbn() == GSConstChat.TARGET_PERMIT && cnt > 0)
                    || (adminMdl.getCacGroupKbn() == GSConstChat.TARGET_LIMIT && cnt == 0)) {
                paramMdl.setCht010GroupEditFlg(GSConstChat.CHAT_GROUP_EDIT);
            } else {
                ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
                int adminCnt = cguDao.getGroupEditUser(sessionUsrSid);
                if (adminCnt > 0) {
                    paramMdl.setCht010GroupEditFlg(GSConstChat.CHAT_GROUP_EDIT);
                } else {
                    paramMdl.setCht010GroupEditFlg(GSConstChat.CHAT_GROUP_NOT_EDIT);
                }
            }
        }

        //未読件数の取得
        ChatDao chtDao = new ChatDao(con__);
        int midokuCount = chtDao.getMidokuCount(sessionUsrSid);
        paramMdl.setCht010MidokuCount(midokuCount);

        boolean onlyNoRead = (paramMdl.getCht010TimelineDspOnlyNoRead() > 0);

        //未読リストの取得
        UDate now = new UDate();
        ArrayList<ChatMidokuModel> mList = new ArrayList<ChatMidokuModel>();
        if (midokuCount == 0 && onlyNoRead) {
            paramMdl.setCht010MidokuList(mList);
        } else {
            mList =
                chtDao.getTimelineList(
                    sessionUsrSid,
                    now,
                    onlyNoRead,
                    GSConstChat.MIDOKU_COUNT);
            //もっとみる表示チェック
            int cnt = chtDao.getTimelineListCount(sessionUsrSid, now, onlyNoRead);
            if (cnt > mList.size()) {
                paramMdl.setCht010MoreView(1);
            }
        }
        paramMdl.setCht010MidokuList(mList);

        //お気に入り情報の取得
        //チャットグループ
        ChtGroupInfDao groupInfDao = new ChtGroupInfDao(con__);
        ArrayList<ChatGroupInfModel> gInfMdlList = chtDao.favoriteGroupSelect(sessionUsrSid);
        paramMdl.setCht010FavoriteGroup(gInfMdlList);
        //ユーザ
        ArrayList<Integer> userSidList = chtDao.favoriteUserSelect(sessionUsrSid);
        UserBiz userBiz = new UserBiz();
        String[] userSids = userSidList.stream()
            .map(mdl -> String.valueOf(mdl))
            .toArray(String[]::new);
        List<CmnUsrmInfModel> userList =
            userBiz.getUserList(con__, userSids, GSConstUser.USER_JTKBN_ALL);
        ArrayList<ChatUserInfModel> cmnUserList = chtDao.getUserCntList(sessionUsrSid, userList);
        paramMdl.setCht010FavoriteUser(cmnUserList);

        //チャットグループ情報の取得
        //チャットグループ
        ArrayList<ChatGroupInfModel> groupInfList =  groupInfDao.selectGroup(sessionUsrSid);
        paramMdl.setCht010GroupList(groupInfList);

        //ユーザ情報の取得
        getUser(paramMdl, sessionUsrSid);
        int chtKbn = 0;
        int chtSid = 0;
        /*右チャット一覧情報の取得*/
        if (cmd.equals("pushDsp") || cmd.equals("back")) {
            chtKbn = paramMdl.getCht010SelectKbn();
            chtSid = paramMdl.getCht010SelectPartner();
            if (chtKbn == 0 || chtSid == 0) {
                chtKbn = userMdl.getCpcChatKbn();
                chtSid = userMdl.getCpcSelSid();
            }
            if (cmd.equals("back")) {
                paramMdl.setCht010InitFlg(GSConstChat.DSP_ALREADY);
            }
        } else if (cmd.equals("reload")) {
            // 再読み込みボタン押下
            chtKbn = paramMdl.getCht010SelectKbn();
            chtSid = paramMdl.getCht010SelectPartner();
            paramMdl.setCht010InitFlg(GSConstChat.DSP_RELOAD);
            paramMdl.setCht010FromMain(GSConstChat.FROM_NOT_MAIN);
        } else {
            //デフォルト表示の取得
            chtKbn = userMdl.getCpcChatKbn();
            chtSid = userMdl.getCpcSelSid();
            // メイン画面から遷移してきた場合
            if (cmd.equals("fromMain")) {
                paramMdl.setCht010FromMain(GSConstChat.FROM_MAIN);
            }

        }
        if (chtKbn == GSConstChat.CHAT_KBN_GROUP) {
            //削除されたグループが選択されていないかのチェック
            ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
            ChtGroupInfModel cgiMdl = cgiDao.select(chtSid);
            if (cgiMdl == null
                    || cgiMdl.getCgiDelFlg() == GSConstChat.CHAT_MODE_DELETE) {
                chtKbn = GSConstChat.CHAT_KBN_USER;
                chtSid = sessionUsrSid;
            }
            ChtGroupUserDao cguDao = new ChtGroupUserDao(con__);
            //グループメンバーチェック
            int cnt = cguDao.getAuthority(sessionUsrSid, chtSid);
            if (cnt == 0) {
                chtKbn = GSConstChat.CHAT_KBN_USER;
                chtSid = sessionUsrSid;
            }
        } else if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            //選択ユーザの存在確認チェック
            UserBiz usrBiz = new UserBiz();
            String[] userSid = new String[] {String.valueOf(chtSid)};
            List<CmnUsrmInfModel> uList =
                usrBiz.getUserList(con__, userSid, GSConstUser.USER_JTKBN_ALL);
            if (uList.size() == 0) {
                //ユーザが存在しない
                chtKbn = GSConstChat.CHAT_KBN_USER;
                chtSid = sessionUsrSid;
            } else {
                if (uList.get(0).getUsrJkbn() == GSConst.JTKBN_DELETE) {
                    //ユーザが削除済みだった場合過去にそのユーザとチャットを行っていれば表示
                    ChtUserPairDao cupDao = new ChtUserPairDao(con__);
                    if (cupDao.select(sessionUsrSid, chtSid) == 0) {
                        chtKbn = GSConstChat.CHAT_KBN_USER;
                        chtSid = sessionUsrSid;
                    }
                }
            }
        }
        paramMdl.setCht010SelectKbn(chtKbn);
        paramMdl.setCht010SelectPartner(chtSid);
        paramMdl.setCht010SelectTab(userMdl.getCpcSelTab());
        paramMdl.setCht010RightpaneFlg(userMdl.getCpcRightpaneFlg());

        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            //チャット情報の取得
            getUserInfo(paramMdl, sessionUsrSid, chtSid);

            //メッセージ（投稿情報）の取得
            getUserMessageDataInit(paramMdl, sessionUsrSid, chtSid, adminMdl);

        } else {
            //グループチャット情報の取得
            getGroupInfo(paramMdl, chtSid);

            //メッセージ（投稿情報）の取得
            getGroupMessageDataInit(paramMdl, sessionUsrSid, chtSid);

        }

        //メッセージリストから描画に使用しない情報を取り除き、JSONに格納する
        JSONObject obj = new JSONObject();
        ChtSendViewBiz viewBiz = new ChtSendViewBiz(reqMdl__, con__);
        viewBiz.jsonMessageInfo(obj, paramMdl.getCht010MessageList(), con__);
        if (obj.get("messageList") instanceof JSONArray) {
            paramMdl.setCht010MessageJson(obj.getJSONArray("messageList").toString());
        } else {
            paramMdl.setCht010MessageJson("");
        }

        if (obj.get("reactionUserList") instanceof JSONArray) {
            paramMdl.setCht010ReactionUserJson(obj.getJSONArray("reactionUserList").toString());
        } else {
            paramMdl.setCht010ReactionUserJson("");
        }


        //チャットメンバー一覧の取得
        paramMdl.setCht010MemberList(
            __createChatMemberMap(paramMdl.getCht010ChtInfMdl())
            .values()
            .stream()
            .collect(Collectors.toList())
            );

        //初回投稿情報
        getFirstSend(paramMdl, sessionUsrSid, chtKbn, chtSid);

        //お気に入り情報, ミュート情報の取得
        getTalkroomCondition(paramMdl, sessionUsrSid, chtKbn, chtSid);

        //メッセージ送信スペース表示設定
        getMessageSendSpace(paramMdl, chtKbn, chtSid, sessionUsrSid, adminMdl);

        //Enterキー送信フラグ
        paramMdl.setCht010EnterSendFlg(userMdl.getCpcEnterFlg());

        //スタンプ一覧取得
        ChtStampDao stampDao = new ChtStampDao(con__);
        paramMdl.setCht010StampList(stampDao.getStampSortList(GSConstChat.STAMP_USE_KBN_USE));
    }

    /**
     *
     * <br>[機  能]ユーザ一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionUsrSid セッションユーザSID
     * @throws SQLException SQLException
     */
    public void getUser(Cht010ParamModel paramMdl, int sessionUsrSid)
            throws SQLException {
        ChatDao chtDao = new ChatDao(con__);
        //削除済みユーザと過去にユーザ間チャットしているかを取得する
        boolean delUserHave = false;
        ArrayList<CmnUsrmInfModel> delUserList = chtDao.getDeleteUser(sessionUsrSid);
        if (delUserList.size() > 0) {
            delUserHave = true;
        }

        //グループ情報を取得する
        GroupBiz gpBiz = new GroupBiz();
        CmnMyGroupDao cmgDao = new CmnMyGroupDao(con__);
        List<CmnMyGroupModel> cmgList = cmgDao.getMyGroupList(sessionUsrSid);
        List<CmnLabelValueModel> dspGrpList = new ArrayList<CmnLabelValueModel>();
        //マイグループリストをセット
        for (CmnMyGroupModel cmgMdl : cmgList) {
            dspGrpList.add(
                    new CmnLabelValueModel(
                            cmgMdl.getMgpName(), "M" + String.valueOf(cmgMdl.getMgpSid()),
                            "1", false));
        }
        GsMessage gsMsg = new GsMessage(reqMdl__);
        List<LabelValueBean> grpLabelList = gpBiz.getGroupCombLabelList(con__, true, gsMsg);
        for (LabelValueBean bean : grpLabelList) {
            dspGrpList.add(
                new CmnLabelValueModel(
                    bean.getLabel(),
                     bean.getValue(),
                      "0",
                       true)
                       );
        }
        if (delUserHave) {
            dspGrpList.add(
                new CmnLabelValueModel(
                    gsMsg.getMessage("cmn.deleted.user"),
                     "-2",
                      "0",
                       true)
                    );
        }

        paramMdl.setCht010ComboGroupList(dspGrpList);

        //グループSIDから所属ユーザ一覧を作成
        String groupSid = paramMdl.getCht010GroupSid();
        if (StringUtil.isNullZeroString(groupSid)) {
            GroupBiz grpBiz = new GroupBiz();
            groupSid = String.valueOf(grpBiz.getDefaultGroupSid(sessionUsrSid, con__));
            paramMdl.setCht010GroupSid(groupSid);
        }

        ChtSelectPartnerLoader pl = new ChtSelectPartnerLoader(con__, groupSid, sessionUsrSid);
        pl.exexute();
        List<ChatUserInfModel> cmList = pl.getResult();

        paramMdl.setCht010UserList(cmList);
    }

    /**
     * <br>[機  能]個人設定の更新
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @throws SQLException SQLException
     */
    public void updatePriConf(Cht010ParamModel paramMdl) throws SQLException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        //個人設定の取得（デフォルト表示を取得）
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);

        if (userMdl.getCpcDefFlg() == GSConstChat.PRI_DEF_FLG_LAST) {
            userMdl.setCpcChatKbn(paramMdl.getCht010SelectKbn());
            userMdl.setCpcSelSid(paramMdl.getCht010SelectPartner());
            ChtPriConfDao confDao = new ChtPriConfDao(con__);
            if (confDao.updateDefaultDsp(userMdl) == 0) {
                confDao.insert(userMdl);
            }
        }
    }

    /**
     * <br>[機  能]初回投稿の取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionUsrSid ユーザSID
     * @param chtKbn チャット区分 1:ユーザ 2:グループ
     * @param chtSid 選択相手SID
     * @throws SQLException SQLException
     */
    public void getFirstSend(Cht010ParamModel paramMdl,
            int sessionUsrSid, int chtKbn, int chtSid) throws SQLException {

        String entryDay = "";
        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataDao usrDao = new ChtUserDataDao(con__);
            entryDay = usrDao.getFirstDate(sessionUsrSid, chtSid);
        } else {
            ChtGroupDataDao grpDao = new ChtGroupDataDao(con__);
            entryDay = grpDao.getFirstDate(chtSid);
        }
        paramMdl.setCht010FirstEntryDay(entryDay);

    }

    /**
     * <br>[機  能] お気に入り情報など、トークルームの状態の取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionUsrSid ユーザSID
     * @param chtKbn チャット区分 1:ユーザ 2:グループ
     * @param chtSid 選択相手SID
     * @throws SQLException SQLException
     */
    public void getTalkroomCondition(Cht010ParamModel paramMdl,
            int sessionUsrSid, int chtKbn, int chtSid) throws SQLException {

        //ミュート情報の取得
        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserPairDao cupDao = new ChtUserPairDao(con__);
            int cupSid = cupDao.select(sessionUsrSid, chtSid);

            ChtUserUconfDao cuuDao = new ChtUserUconfDao(con__);
            ChtUserUconfModel cuuMdl = cuuDao.select(sessionUsrSid, cupSid);
            if (cuuMdl == null) {
                paramMdl.setCht010MuteFlg(GSConstChat.CHAT_MUTE_OFF);
                paramMdl.setCht010FavoriteFlg(GSConstChat.CHAT_NOT_FAVORITE);
            } else {
                paramMdl.setCht010MuteFlg(cuuMdl.getCuucMuteKbn());
                paramMdl.setCht010FavoriteFlg(cuuMdl.getCuucFavoriteKbn());
            }
        } else {
            ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con__);
            ChtGroupUconfModel cguMdl = cguDao.select(sessionUsrSid, chtSid);
            if (cguMdl == null) {
                paramMdl.setCht010MuteFlg(GSConstChat.CHAT_MUTE_OFF);
                paramMdl.setCht010FavoriteFlg(GSConstChat.CHAT_NOT_FAVORITE);
            } else {
                paramMdl.setCht010MuteFlg(cguMdl.getCgucMuteKbn());
                paramMdl.setCht010FavoriteFlg(cguMdl.getCgucFavoriteKbn());
            }
        }
    }

    /**
     * <br>[機  能]メッセージ送信スペース表示設定
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param chtKbn チャット区分 1:ユーザ 2:グループ
     * @param chtSid 選択相手SID
     * @param sessionUsrSid セッションユーザSID
     * @param adminMdl 管理者モデル
     * @throws SQLException SQLException
     */
    public void getMessageSendSpace(Cht010ParamModel paramMdl,
            int chtKbn, int chtSid, int sessionUsrSid,
            ChtAdmConfModel adminMdl) throws SQLException {

      //ユーザ間チャットの場合相手が特例ユーザかつ自分が権限をもっているかのチェック
        boolean accessUser = true;
        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            if (chtSid != sessionUsrSid) {
                ChtSpaccessTargetDao cstDao = new ChtSpaccessTargetDao(con__);
                ArrayList<Integer> spList = cstDao.selectSid(chtSid);
                if (spList.size() != 0) {
                    ChtSpaccessPermitDao cspDao = new ChtSpaccessPermitDao(con__);
                    int cntSid = cspDao.selectCount(spList, sessionUsrSid);
                    if (cntSid == 0) {
                        accessUser = false;
                    }
                }
            }
        }
        //メッセージ送信スペース表示設定
        if (chtKbn == GSConstChat.CHAT_KBN_USER
                && adminMdl.getCacChatFlg() == GSConstChat.LIMIT_BETWEEN_USERS) {
            paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_USER_SEIGEN);
        }
        if (chtKbn == GSConstChat.CHAT_KBN_GROUP
                && paramMdl.getCht010ChtInfMdl().getChatArchive()
                == GSConstChat.CHAT_ARCHIVE_MODE) {
            paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_ARCHIVE);

        }
        if (chtKbn == GSConstChat.CHAT_KBN_USER
                && paramMdl.getCht010ChtInfMdl().getChatArchive()
                == GSConstChat.CHAT_ARCHIVE_MODE) {
            paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_DELETE_USER);
        }
        if (chtKbn == GSConstChat.CHAT_KBN_USER
                && !accessUser) {
            paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_SPACCESS);
        }
        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            CommonBiz cmnBiz = new CommonBiz();
            List<String> menuPluginIdList = cmnBiz.getCanUsePluginIdList(con__, chtSid);
            if (!menuPluginIdList.isEmpty()) {
                boolean bAccess = false;
                for (String pId : menuPluginIdList) {
                    if (pId.equals(GSConstChat.PLUGIN_ID_CHAT)) {
                        bAccess = true;
                        break;
                    }
                }
                if (!bAccess) {
                    paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_ACCESS);
                }
            } else {
                paramMdl.setCht010MessageAreaDisp(GSConstChat.NOT_SEND_ACCESS);
            }
        }
    }


    /**
     * <br>[機  能] チャット相手の名称取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @return 名称
     * @throws SQLException SQLException
     */
    public String getPartnerName(Cht010ParamModel paramMdl)
            throws SQLException {

        int usrSid = reqMdl__.getSmodel().getUsrsid();
        int partnerSid = paramMdl.getCht010SelectPartner();
        int partnerKbn = paramMdl.getCht010SelectKbn();
        if (partnerKbn == GSConstChat.CHAT_KBN_USER) {
            getUserInfo(paramMdl, usrSid, partnerSid);
        } else {
            getGroupInfo(paramMdl, partnerSid);
        }
        String name = "";
        if (paramMdl.getCht010ChtInfMdl() != null) {
            name = paramMdl.getCht010ChtInfMdl().getChatName();
        }
        return name;
    }

    /**
     * <br>[機  能] ユーザ情報の取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionUsrSid ユーザSID
     * @param partnerUsrSid 相手ユーザSID
     * @throws SQLException SQLException
     */
    public void getUserInfo(Cht010ParamModel paramMdl, int sessionUsrSid, int partnerUsrSid)
            throws SQLException {

        ChtUserPairDao cupDao = new ChtUserPairDao(con__);
        int pairSid = cupDao.select(sessionUsrSid, partnerUsrSid);
        ChatDao chtDao = new ChatDao(con__);
        CmnUsrmInfModel usrMdl = chtDao.getUser(partnerUsrSid);
        ChatInformationModel cimMdl = new ChatInformationModel();
        cimMdl.setChatKbn(GSConstChat.CHAT_KBN_USER);
        cimMdl.setChatSid(pairSid);
        cimMdl.setChatName(usrMdl.getUsiSei() + " " + usrMdl.getUsiMei());
        ArrayList<CmnUsrmInfModel> userList = new ArrayList<CmnUsrmInfModel>();
        userList.add(usrMdl);
        cimMdl.setGeneralMember(userList);
        if (usrMdl.getUsrJkbn() == GSConst.JTKBN_DELETE) {
            cimMdl.setChatArchive(GSConstChat.CHAT_ARCHIVE_MODE);
        }
        paramMdl.setCht010ChtInfMdl(cimMdl);
    }

    /**
     * <br>[機  能]ユーザチャットのメッセージを取得
     * <br>[解  説] チャットルーム初期化用
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionSid セッションユーザSID
     * @param partnerUsrSid 相手ユーザSID
     * @param adminMdl 管理者model
     * @throws SQLException SQLException
     */
    public void getUserMessageDataInit(Cht010ParamModel paramMdl, int sessionSid,
            int partnerUsrSid,
            ChtAdmConfModel adminMdl)
            throws SQLException {

        try {
            getUserMessageData(paramMdl, sessionSid, partnerUsrSid, adminMdl, false);
        } catch (TargetMessageWrongException e) {
            // 初期化時にはメッセージSID基準の検索を行わないためこの例外は発生しない
            throw new RuntimeException(e);
        }
    }
    /**
     * <br>[機  能]ユーザチャットのメッセージを取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionSid セッションユーザSID
     * @param partnerUsrSid 相手ユーザSID
     * @param adminMdl 管理者model
     * @param scrollFlg スクロールフラグ
     * @throws SQLException SQLException
     * @throws TargetMessageWrongException メッセージSID基準の検索に失敗した場合の例外
     */
    public void getUserMessageData(Cht010ParamModel paramMdl, int sessionSid,
            int partnerUsrSid,
            ChtAdmConfModel adminMdl, boolean scrollFlg)
            throws SQLException, TargetMessageWrongException {


        ChatMessageSearchRequest searchReq = null;

        searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
            con__,
            reqMdl__,
            partnerUsrSid);


        if (scrollFlg) {
            if (paramMdl.getCht010ReadFlg() == GSConstChat.CHAT_TOP_SCROLL) {
                searchReq.setPosition(
                    new BeforeMessage(paramMdl.getCht010MessageMaxMinSid())
                );

            } else {
                searchReq.setPosition(
                    new AfterMessage(paramMdl.getCht010MessageMaxMinSid())
                );
            }
        } else {
            searchReq.setPosition(
                new MidokuPosition()
            );
        }
        searchReq.setLimit(GSConstChat.CHAT_GET_MESSAGE_NUMBER);

        searchReq.setOrder(GSConst.ORDER_KEY_ASC);


        ChatMessageSearchResult result =
         new ChatMessageSearcher(
            con__,
            searchReq,
            adminMdl)
            .execute();

        paramMdl.setCht010MessageList(result.getList());

        //今取得したメッセージリストが最新まで取得しているかのチェック
        if (GSConstChat.CHAT_TOP_SCROLL != paramMdl.getCht010ReadFlg()) {

            if (result.getResultOffset() + result.getList().size()
                    < result.getHitCount()) {
                paramMdl.setCht010AllDispFlg(0);
            } else {
                paramMdl.setCht010AllDispFlg(1);
            }
        }
    }

    /**
     * <br>[機  能]グループ情報の取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param chtSid 選択グループSID
     * @throws SQLException SQLException
     */
    public void getGroupInfo(Cht010ParamModel paramMdl, int chtSid) throws SQLException {

        ChatDao chtDao = new ChatDao(con__);
        //チャット情報の取得
        ChatInformationModel cimMdl = chtDao.getGroupInfoData(chtSid);
        cimMdl.setChatKbn(GSConstChat.CHAT_KBN_GROUP);
        //管理者ユーザの取得
        ArrayList<CmnUsrmInfModel> adminList = new ArrayList<CmnUsrmInfModel>();
        adminList = chtDao.getGroupUser(chtSid, GSConstChat.CHAT_GROUP_ADMIN);
        cimMdl.setAdminMember(adminList);
        ArrayList<CmnGroupmModel> adminGroupList = new ArrayList<CmnGroupmModel>();
        adminGroupList = chtDao.getGroup(chtSid, GSConstChat.CHAT_GROUP_ADMIN);
        cimMdl.setAdminGroup(adminGroupList);
        //一般ユーザの取得
        ArrayList<CmnUsrmInfModel> generalList = new ArrayList<CmnUsrmInfModel>();
        generalList = chtDao.getGroupUser(chtSid, GSConstChat.CHAT_GROUP_NOT_ADMIN);
        cimMdl.setGeneralMember(generalList);
        ArrayList<CmnGroupmModel> genaralGroupList = new ArrayList<CmnGroupmModel>();
        genaralGroupList = chtDao.getGroup(chtSid, GSConstChat.CHAT_GROUP_NOT_ADMIN);
        cimMdl.setGeneralGroup(genaralGroupList);
        cimMdl.setChatName(cimMdl.getChatName());
        paramMdl.setCht010ChtInfMdl(cimMdl);
    }
    /**
     * <br>[機  能]グループチャットのメッセージを取得
     * <br>[解  説] チャットルーム初期化用
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionSid セッションユーザSID
     * @param chtGroupSid チャットグループSID
     * @throws SQLException SQLException
     */
    public void getGroupMessageDataInit(Cht010ParamModel paramMdl, int sessionSid,
            int chtGroupSid) throws SQLException {
        try {
            getGroupMessageData(paramMdl, sessionSid, chtGroupSid, false);
        } catch (TargetMessageWrongException e) {
                // 初期化時にはメッセージSID基準の検索を行わないためこの例外は発生しない
                throw new RuntimeException(e);
        }
    }


    /**
     * <br>[機  能]グループチャットのメッセージを取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param sessionSid セッションユーザSID
     * @param chtGroupSid チャットグループSID
     * @param scrollFlg スクロールフラグ
     * @throws SQLException SQLException
     * @throws TargetMessageWrongException メッセージSID基準の検索に失敗した場合の例外
     */
    public void getGroupMessageData(Cht010ParamModel paramMdl, int sessionSid,
            int chtGroupSid, boolean scrollFlg)
        throws SQLException, TargetMessageWrongException {

        ChatMessageSearchRequest searchReq = null;

        searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
            reqMdl__,
            chtGroupSid);


        if (scrollFlg) {
            if (paramMdl.getCht010ReadFlg() == GSConstChat.CHAT_TOP_SCROLL) {
                searchReq.setPosition(
                    new BeforeMessage(paramMdl.getCht010MessageMaxMinSid())
                );

            } else {
                searchReq.setPosition(
                    new AfterMessage(paramMdl.getCht010MessageMaxMinSid())
                );
            }
        } else {
            searchReq.setPosition(
                new MidokuPosition()
            );
        }
        searchReq.setLimit(GSConstChat.CHAT_GET_MESSAGE_NUMBER);

        searchReq.setOrder(GSConst.ORDER_KEY_ASC);


        ChatMessageSearchResult result =
            new ChatMessageSearcher(
            con__,
            searchReq,
            null)
            .execute();

        paramMdl.setCht010MessageList(result.getList());

        //今取得したメッセージリストが最新まで取得しているかのチェック
        if (GSConstChat.CHAT_TOP_SCROLL != paramMdl.getCht010ReadFlg()) {

            if (result.getResultOffset() + result.getList().size()
                    < result.getHitCount()) {
                paramMdl.setCht010AllDispFlg(0);
            } else {
                paramMdl.setCht010AllDispFlg(1);
            }
        }
    }

    /**
     * <br>[機  能]チャット相手切り替え時の処理を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @return 正常終了true 権限エラーfalse
     * @throws SQLException SQLException
     */
    public boolean partnerChange(Cht010ParamModel paramMdl) throws SQLException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        int chtPartnerSid = paramMdl.getCht010SelectPartner();
        int chtKbn = paramMdl.getCht010SelectKbn();

        // 切り替え先の権限チェック
        ChtSendViewBiz checkBiz = new ChtSendViewBiz(reqMdl__, con__);
        if (!checkBiz.isViewPartner(sessionUsrSid, chtPartnerSid, chtKbn)) {
            return false;
        }

        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        //個人設定の取得
        ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);
        paramMdl.setCht010EnterSendFlg(userMdl.getCpcEnterFlg());

        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            getUserInfo(paramMdl, sessionUsrSid, chtPartnerSid);
            getUserMessageDataInit(paramMdl, sessionUsrSid, chtPartnerSid, adminMdl);
        }

        if (chtKbn == GSConstChat.CHAT_KBN_GROUP) {
            getGroupInfo(paramMdl, chtPartnerSid);
            getGroupMessageDataInit(paramMdl, sessionUsrSid, chtPartnerSid);
        }

        //チャットメンバー一覧の取得
        paramMdl.setCht010MemberList(
            __createChatMemberMap(paramMdl.getCht010ChtInfMdl())
            .values()
            .stream()
            .collect(Collectors.toList())
            );

        //メッセージ送信スペースの取得
        getMessageSendSpace(paramMdl, chtKbn, chtPartnerSid, sessionUsrSid, adminMdl);
        //初回送信日付
        getFirstSend(paramMdl, sessionUsrSid, chtKbn, chtPartnerSid);
        //お気に入り情報, ミュート情報の取得
        getTalkroomCondition(paramMdl, sessionUsrSid, chtKbn, chtPartnerSid);
        if (userMdl.getCpcDefFlg() == GSConstChat.PRI_DEF_FLG_LAST) {
            userMdl.setCpcChatKbn(chtKbn);
            userMdl.setCpcSelSid(chtPartnerSid);
            ChtPriConfDao confDao = new ChtPriConfDao(con__);
            if (confDao.updateDefaultDsp(userMdl) == 0) {
                confDao.insert(userMdl);
            }
        }
        ChtStampDao stampDao = new ChtStampDao(con__);
        paramMdl.setCht010StampList(stampDao.getStampSortList(GSConstChat.STAMP_USE_KBN_USE));
        return true;
    }

    /**
     * <br>[機  能]スクロール時の処理を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @throws SQLException SQLException
     * @throws TargetMessageWrongException
     */
    public void scrollRead(Cht010ParamModel paramMdl)
        throws SQLException, TargetMessageWrongException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        int chtPartnerSid = paramMdl.getCht010SelectPartner();
        int chtKbn = paramMdl.getCht010SelectKbn();
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        //個人設定の取得
        ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);
        paramMdl.setCht010EnterSendFlg(userMdl.getCpcEnterFlg());

        if (chtKbn == GSConstChat.CHAT_KBN_USER) {
            getUserMessageData(paramMdl, sessionUsrSid, chtPartnerSid, adminMdl, true);
        }
        if (chtKbn == GSConstChat.CHAT_KBN_GROUP) {
            getGroupMessageData(paramMdl, sessionUsrSid, chtPartnerSid, true);
        }
    }

    /**
     * <br>[機  能]既読アップデート処理を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @return アップデート件数 権限エラーの場合は-1を返す
     * @throws SQLException SQLException
     */
    public int kidokuUpdate(Cht010ParamModel paramMdl) throws SQLException {

        int chtPartnerSid = paramMdl.getCht010SelectPartner();
        int chtKbn = paramMdl.getCht010SelectKbn();
        long msgSid = paramMdl.getCht010MessageSid();

        int cnt = 0;

        ChtSendViewBiz sendBiz = new ChtSendViewBiz(reqMdl__, con__);
        cnt = sendBiz.updateViewMessage(chtKbn, chtPartnerSid, msgSid);

        return cnt;
    }

    /**
     *
     * <br>[機  能] 既読処理時のアクセス権限チェック
     * <br>[解  説] チャット相手に対するアクセス権限がない場合、
     *              もしくは既読にするメッセージがチャット相手とのものではない場合エラーメッセージを返す
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @return エラーメッセージ
     * @throws SQLException SQL実行例外
     */
    public String kidokuAccessCheck(Cht010ParamModel paramMdl) throws SQLException {
        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        int chtPartnerSid = paramMdl.getCht010SelectPartner();
        int chtKbn = paramMdl.getCht010SelectKbn();
        long msgSid = paramMdl.getCht010MessageSid();
        ChtUserPairDao cupDao = new ChtUserPairDao(con__);
        int cupSid = cupDao.select(sessionUsrSid, chtPartnerSid);
        GsMessage gsMsg = new GsMessage(reqMdl__);

        // 権限チェック
        ChtSendViewBiz checkBiz = new ChtSendViewBiz(reqMdl__, con__);
        if (!checkBiz.isViewPartner(sessionUsrSid, chtPartnerSid, chtKbn)
                || !__isMatchPartner(chtKbn, chtPartnerSid, cupSid, msgSid)) {
            return gsMsg.getMessage("cht.cht010.47");
        }

        return "";
    }

    /**
     * <br>[機  能] チャット相手と対象メッセージとの整合性を判定
     * <br>[解  説]
     * <br>[備  考]
     * @param kbn 0:ユーザ間チャット、1:グループチャット
     * @param chtPartnerSid チャット相手のSID
     * @param cupSid ペアSID(ユーザ間チャットのみ使用)
     * @param msgSid メッセージSID
     * @return 対象のメッセージがチャット相手との間に存在しなければfalse
     * @throws SQLException SQL実行例外
     */
    private boolean __isMatchPartner(int kbn, int chtPartnerSid, int cupSid, long msgSid)
            throws SQLException {
        if (kbn == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataDao cudDao = new ChtUserDataDao(con__);
            ChtUserDataModel cudMdl = cudDao.select(msgSid);
            if (cudMdl == null || cudMdl.getCupSid() != cupSid) {
                return false;
            }
        } else if (kbn == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            ChtGroupDataModel cgdMdl = cgdDao.select(msgSid);
            if (cgdMdl == null || cgdMdl.getCgiSid() != chtPartnerSid) {
                return false;
            }
        }
        return true;
    }

    /**
     * <br>[機  能] 未読取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @param usrSid ユーザSID
     * @throws SQLException SQLException
     */
    public void changeGrp(Cht010ParamModel paramMdl,
            int usrSid) throws SQLException {
        getUser(paramMdl, usrSid);
    }

    /**
     * <br>[機  能] 未読取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @throws SQLException SQLException
     */
    public void moreView(Cht010ParamModel paramMdl) throws SQLException {

        ChatDao chtDao = new ChatDao(con__);
        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        UDate lastDate = new UDate();
        if (!StringUtil.isNullZeroStringSpace(paramMdl.getCht010MidokuLastDate())) {
            lastDate.setTimeStamp(paramMdl.getCht010MidokuLastDate());
        }
        boolean onlyNoRead = (paramMdl.getCht010TimelineDspOnlyNoRead() > 0);
        ArrayList<ChatMidokuModel> list =
                chtDao.getTimelineList(
                    sessionUsrSid,
                    lastDate,
                    onlyNoRead,
                    GSConstChat.MIDOKU_COUNT);

        paramMdl.setCht010MidokuList(list);
        //もっとみる表示チェック
        int cnt = chtDao.getTimelineListCount(sessionUsrSid, lastDate, onlyNoRead);
        if (cnt > list.size()) {
            paramMdl.setCht010MoreView(1);
        }
    }

    /**
     * <br>[機  能] グループ名取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @throws SQLException SQLException
     */
    public void getGroupName(Cht010ParamModel paramMdl) throws SQLException {

        ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
        ChtGroupInfModel cgiMdl = cgiDao.select(paramMdl.getCht010SelectPartner());
        ChatInformationModel cifMdl = new ChatInformationModel();
        cifMdl.setChatName(cgiMdl.getCgiName());
        paramMdl.setCht010ChtInfMdl(cifMdl);
    }

    /**
     * <br>[機  能] Enter送信更新
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Cht010ParamModel
     * @throws SQLException SQLException
     */
    public void enterSend(Cht010ParamModel paramMdl) throws SQLException {

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        int enterKbn = paramMdl.getCht010EnterSendFlg();
        ChtPriConfDao cpcDao = new  ChtPriConfDao(con__);
        if (cpcDao.updateEnter(enterKbn, sessionUsrSid) == 0) {
            ChtBiz chtBiz = new ChtBiz(con__);
            ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);
            userMdl.setCpcEnterFlg(enterKbn);
            cpcDao.insert(userMdl);
        }
    }

    /**
     * <br>[機  能] メッセージ送信用のモデルを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramModel パラメータ情報
     * @param con コネクション
     * @return メッセージ送信用モデル
     * @throws SQLException 
     */
    protected ChatSendEditModel _createMessageModel(
        Cht010ParamModel paramModel, Connection con) throws SQLException {

        List<Integer> mentionUserSid = new ArrayList<Integer>();
        if (paramModel.getCht010MentionUserSids() != null) {
            mentionUserSid = Arrays.stream(paramModel.getCht010MentionUserSids())
                .map(sid -> NullDefault.getInt(sid, 0))
                .collect(Collectors.toList());
        }        
        return new ChatSendEditModel(
            paramModel.getCht010SelectKbn(), paramModel.getCht010SelectPartner(),
            paramModel.getCht010MessageSid(), paramModel.getCht010Message(),
            paramModel.getCht010StampSid(), mentionUserSid, paramModel.getCht010ReplyMessage());
    }

    /**
     * <br>[機  能] お気に入り変更時処理
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @return エラーチェック
     * @throws Exception 実行例外
     */
    public boolean favoriteChange(Cht010ParamModel paramMdl)throws Exception {

        log__.debug("START");
        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();
        int chtPartnerSid = paramMdl.getCht010SelectPartner();
        int chtKbn = paramMdl.getCht010SelectKbn();

        // お気に入り対象の権限チェック
        ChtSendViewBiz checkBiz = new ChtSendViewBiz(reqMdl__, con__);
        if (!checkBiz.isViewPartner(sessionUsrSid, chtPartnerSid, chtKbn)) {
            return false;
        }

        ChtFavoriteModel cfMdl = new ChtFavoriteModel();
        cfMdl.setChfUid(sessionUsrSid);
        cfMdl.setChfChatKbn(paramMdl.getCht010SelectKbn());
        cfMdl.setChfSid(paramMdl.getCht010SelectPartner());

        int favoriteFlg = GSConstChat.CHAT_NOT_FAVORITE;
        if (paramMdl.getCht010FavoriteFlg() == GSConstChat.CHAT_FAVORITE) {
            favoriteFlg = GSConstChat.CHAT_FAVORITE;
        }

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con__);
            ChtGroupUconfModel cguMdl = cguDao.select(sessionUsrSid, chtPartnerSid);
            if (cguMdl == null) {
                //新規登録
                cguMdl = new ChtGroupUconfModel();
                cguMdl.setUsrSid(sessionUsrSid);
                cguMdl.setCgiSid(chtPartnerSid);
                cguMdl.setCgucFavoriteKbn(favoriteFlg);
                cguMdl.setCgucMuteKbn(GSConstChat.CHAT_MUTE_OFF);
                cguDao.insert(cguMdl);
            } else {
                cguMdl.setCgucFavoriteKbn(favoriteFlg);
                cguDao.update(cguMdl);
            }
        } else {
            ChtUserPairCreateBiz cupBiz = new ChtUserPairCreateBiz();
            int cupSid = cupBiz.getCupSidAutoCreate(reqMdl__, con__, sessionUsrSid, chtPartnerSid);

            ChtUserUconfDao cuuDao = new ChtUserUconfDao(con__);
            ChtUserUconfModel cuuMdl = cuuDao.select(sessionUsrSid, cupSid);
            if (cuuMdl == null) {
                //新規登録
                cuuMdl = new ChtUserUconfModel();
                cuuMdl.setUsrSid(sessionUsrSid);
                cuuMdl.setCupSid(cupSid);
                cuuMdl.setCuucFavoriteKbn(favoriteFlg);
                cuuMdl.setCuucMuteKbn(GSConstChat.CHAT_MUTE_OFF);
                cuuDao.insert(cuuMdl);
            } else {
                cuuMdl.setCuucFavoriteKbn(favoriteFlg);
                cuuDao.update(cuuMdl);
            }
        }

        ChatDao chtDao = new ChatDao(con__);
        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            ArrayList<Integer> userSidList = chtDao.favoriteUserSelect(sessionUsrSid);
            UserBiz userBiz = new UserBiz();
            String[] userSids = userSidList.stream()
                .map(mdl -> String.valueOf(mdl))
                .toArray(String[]::new);
            List<CmnUsrmInfModel> userList =
                userBiz.getUserList(con__, userSids, GSConstUser.USER_JTKBN_ALL);
            ArrayList<ChatUserInfModel> cmnUserList =
                chtDao.getUserCntList(sessionUsrSid, userList);
            paramMdl.setCht010FavoriteUser(cmnUserList);
        } else if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ArrayList<ChatGroupInfModel> gInfMdlList
            = chtDao.favoriteGroupSelect(sessionUsrSid);
            paramMdl.setCht010FavoriteGroup(gInfMdlList);
        }
        log__.debug("End");
        return true;
    }

    /**
     * <br>[機  能] 添付追加
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param mtCon 採番コントローラ
     * @param appRootPath アプリケーションルートパス
     * @param tempDir テンポラリディレクトリパス
     * @return メッセージSID
     * @throws Exception 実行例外
     */
    public List<Long> tempAdd(Cht010ParamModel paramMdl,
            MlCountMtController mtCon,
            String appRootPath,
            String tempDir)throws Exception {

        log__.debug("START");
        int sessionUserSid = reqMdl__.getSmodel().getUsrsid();
        List<Long> ret = new ArrayList<Long>();
        //添付ファイル情報の登録
        UDate now = new UDate();

//        String chtTempDir = getChtTempDir(reqMdl__, tempDir);
        CommonBiz cmnBiz = new CommonBiz();
        List<String> binSid = cmnBiz.insertBinInfo(con__, tempDir, appRootPath,
                mtCon, sessionUserSid, now);
        if (binSid.size() > 0) {
            ret = binSid.stream()
                    .map(sid -> Long.parseLong(sid))
                    .collect(Collectors.toList());

            //sendMessage(paramMdl, mtCon, binSid);
        }
        log__.debug("End");
        return ret;
    }

    /**
     * <br>[機  能] 添付ファイル保存先ディレクトリパスを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param tempDir テンポラリディレクトリパス
     * @return アンケート情報の添付ファイル保存先ディレクトリパス
     */
    public String getChtTempDir(RequestModel reqMdl, String tempDir) {
        //$GSTEMPDIR/chat/セッションID/ユーザSID/
        String saveDir = IOTools.replaceSlashFileSep(tempDir);
        if (!saveDir.endsWith("/")) {
            saveDir += "/";
        }
        saveDir += reqMdl.getSmodel().getUsrsid() + "/";

        return saveDir;
    }

    /**
     * <br>[機  能] グループ管理画面
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param adminFlg システムorプラグイン管理者権限
     * @param usrSid ユーザＳＩＤ
     * @throws Exception 実行例外
     */
    public void setGroupConf(
            Cht010ParamModel paramMdl,
            boolean adminFlg,
            int usrSid)
            throws Exception {
        log__.debug("groupConfInit");
        ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
        // グループ情報一覧を取得
        int archiveFlg = paramMdl.getCht010GrpConfDspArcKbn();
        String keyword = paramMdl.getCht010GrpConfSearchKeyword();
        boolean allDsp = false;
        if (adminFlg) {
            int dspFlg = paramMdl.getCht010GrpConfAllDspKbn();
            if (dspFlg == GSConstChat.CHAT_CONF_DSP_ALL) {
                allDsp = true;
            }
        }
        List<ChtGroupInfModel> grpList
            = infDao.getGroupConfList(allDsp, usrSid, archiveFlg, keyword);
        paramMdl.setCht010GrpConfGroupList(grpList);
    }


    /**
     * 登録編集処理
     * @param paramMdl パラメータモデル
     * @param adminFlg システム管理者orプラグイン管理者
     * @param usrSid ユーザSID
     * @throws SQLException SQL実行例外
     *
     * */
    public void setAddEditData(Cht010ParamModel paramMdl, boolean adminFlg, int usrSid)
            throws SQLException {
        log__.debug("init");
        //編集の場合、データ取得
        ChtBiz biz = new ChtBiz(con__, reqMdl__);
        ChtMemberBiz memberBiz = new ChtMemberBiz(con__);
        if (paramMdl.getCht010GrpConfProcMode() == GSConstChat.CHAT_MODE_EDIT
                ) {
            int cgiSid = paramMdl.getCht010GrpConfCgiSid();
            ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
            ChatInformationModel infMdl = infDao.selectChatGroupInf(cgiSid);
            __setChatInf(paramMdl, infMdl);
            ChtGroupUserDao userDao = new ChtGroupUserDao(con__);
            List<ChtGroupUserModel> userList = userDao.select(cgiSid);
            ChatGroupComboModel chatGrpMdl = memberBiz.setChatGrp(userList);
            paramMdl.setCht010GrpConfMemberAdminSid(chatGrpMdl.getMemberAdminSid());
            paramMdl.setCht010GrpConfMemberGeneralSid(chatGrpMdl.getMemberGeneralSid());
            paramMdl.setCht010GrpConfCgiSid(cgiSid);
        } else {
            // grpId自動採番
            paramMdl.setCht010GrpConfGroupId(biz.getAutoGeneratedId());
            // 管理者メンバー
            paramMdl.setCht010GrpConfMemberAdminSid(
                    new String[] {String.valueOf(usrSid)});
        }
        if (adminFlg) {
            paramMdl.setAdminFlg(GSConst.USER_ADMIN);
        } else {
            paramMdl.setAdminFlg(GSConst.USER_NOT_ADMIN);
        }

    }

    /**
     * グループ情報をパラメータモデルに設定
     * @param paramMdl パラメータモデル
     * @param infMdl ChatInformationModel
     * @throws SQLException SQL実行例外
     *
     * */
    private void __setChatInf(Cht010ParamModel paramMdl, ChatInformationModel infMdl)
            throws SQLException {
        paramMdl.setCht010GrpConfGroupId(infMdl.getChatId());
        paramMdl.setCht010GrpConfGroupName(infMdl.getChatName());
        paramMdl.setCht010GrpConfBiko(infMdl.getChatBiko());
        paramMdl.setCht010GrpConfCategory(infMdl.getCategorySid());
        paramMdl.setCht010GrpConfArchiveKbn(infMdl.getChatArchive());;
    }

    /**
     * <br>[機  能] 登録処理を行います
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param usrSid ユーザSID
     * @param cntCon MlCountMtController
     * @param adminFlg システム・プラグイン管理者判定
     * @throws Exception 例外
     */
    public void insertGroup(Cht010ParamModel paramMdl,
                       int usrSid,
                       MlCountMtController cntCon,
                       boolean adminFlg)
                       throws Exception {
        log__.debug("insert");
        // グループ情報の登録
        ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
        ChtGroupInfModel insertinfMdl
            = createGroupInfMdl(paramMdl, usrSid, cntCon, GSConstChat.CHAT_MODE_ADD, adminFlg);
        infDao.insert(insertinfMdl);

        ChtGroupDataSumDao cgsDao = new ChtGroupDataSumDao(con__);
        ChtGroupDataSumModel cgsModel = new ChtGroupDataSumModel();
        cgsModel.setCgiSid(insertinfMdl.getCgiSid());
        cgsDao.insert(cgsModel);

        // グループユーザ情報の登録
        ChtGroupUserDao userDao = new ChtGroupUserDao(con__);
        List<ChtGroupUserModel> memberList = __createUseMdlList(paramMdl, usrSid);
        for (ChtGroupUserModel model:memberList) {
            userDao.insert(model);
        }
    }

    /**
     * <br>[機  能] 編集処理を行います
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param usrSid ユーザSID
     * @param cntCon MlCountMtController
     * @param adminFlg システム・プラグイン管理者判定
     * @throws Exception 例外
     */
    public void updateGroup(Cht010ParamModel paramMdl,
                       int usrSid,
                       MlCountMtController cntCon,
                       boolean adminFlg)
                       throws Exception {
        log__.debug("insert");
        // グループ情報の編集
        ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
        ChtGroupInfModel insertinfMdl
                = createGroupInfMdl(paramMdl, usrSid, cntCon, GSConstChat.CHAT_MODE_EDIT, adminFlg);
        infDao.updateGrp(insertinfMdl, adminFlg);

        // グループユーザ情報の編集

        // 編集前メンバーの取得
        ChtMemberBiz memberBiz = new ChtMemberBiz(con__);
        String[] oldMembers =  memberBiz.getOldMembers(paramMdl.getCht010GrpConfCgiSid());
        paramMdl.setCht010OldMemberSids(oldMembers);

        // 削除して登録
        ChtGroupUserDao userDao = new ChtGroupUserDao(con__);
        userDao.delete(paramMdl.getCht010GrpConfCgiSid());
        List<ChtGroupUserModel> memberList = __createUseMdlList(paramMdl, usrSid);
        for (ChtGroupUserModel model:memberList) {
            userDao.insert(model);
        }

    }



    /**
     * <br>[機  能] 登録・更新用のmodel作成を行います
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param usrSid ユーザSID
     * @param cntCon MlCountMtController
     * @param mode 登録編集モード
     * @param adminFlg システム・プラグイン管理者判定
     * @return RngTemplateCategoryModel 登録model
     * @throws Exception 例外
     */
    public ChtGroupInfModel createGroupInfMdl(Cht010ParamModel paramMdl,
                                                int usrSid,
                                                MlCountMtController cntCon,
                                                int mode,
                                                boolean adminFlg)
                                                throws Exception {

        UDate date = new UDate();
        ChtGroupInfModel model = new ChtGroupInfModel();
        //登録
        if (mode == GSConstChat.CHAT_MODE_ADD) {
            //グループSID採番
            int cgiSid = (int) cntCon.getSaibanNumber(GSConstChat.SBNSID_CHAT,
                                                       GSConstChat.SBNSID_SUB_CHAT_GROUP,
                                                       usrSid);
            model.setCgiSid(cgiSid);
            model.setCgiCompFlg(GSConstChat.CHAT_ARCHIVE_NOT_MODE);
            paramMdl.setCht010GrpConfCgiSid(cgiSid);
        //更新
        } else  {
            int cgiSid = paramMdl.getCht010GrpConfCgiSid();
            model.setCgiSid(cgiSid);
            model.setCgiCompFlg(paramMdl.getCht010GrpConfArchiveKbn());
        }
        model.setCgiId(paramMdl.getCht010GrpConfGroupId());
        model.setCgiName(paramMdl.getCht010GrpConfGroupName());
        if (adminFlg) {
            model.setChcSid(paramMdl.getCht010GrpConfCategory());
        } else {
            // システム・プラグイン管理者権限を持たないなら、一般ユーザのカテゴリ
            model.setChcSid(GSConstChat.CHAT_CHC_SID_GENERAL);
        }
        model.setCgiContent(paramMdl.getCht010GrpConfBiko());
        model.setCgiAdate(date);
        model.setCgiEdate(date);
        model.setCgiAuid(usrSid);
        model.setCgiEuid(usrSid);
        return model;
    }


    /**
    *
    * <br>[機  能]メンバーリストを作成する
    * <br>[解  説]
    * <br>[備  考]
    * @param paramMdl パラメータモデル
     * @param usrSid ユーザSID
    * @return ChtGroupUserModel
    */
   private ArrayList<ChtGroupUserModel> __createUseMdlList(
           Cht010ParamModel paramMdl,
           int usrSid) {
       log__.debug("__createUseMdl");
       UDate date = new UDate();
       //使用制限対象ユーザ・グループのSIDを取得
       ArrayList<ChtGroupUserModel> useMdlList = new ArrayList<ChtGroupUserModel>();
       // 管理者
       String[] adminList = paramMdl.getCht010GrpConfMemberAdminSid();
       for (String admin:adminList) {
           ChtGroupUserModel mdl = new ChtGroupUserModel();
           if (admin.startsWith("G")) {
               int sid = NullDefault.getInt(admin.substring(1), -1);
               mdl.setCguKbn(GSConstChat.CHAT_KBN_GROUP);
               mdl.setCguSelectSid(sid);
           } else {
               int sid = NullDefault.getInt(admin, -1);
               mdl.setCguKbn(GSConstChat.CHAT_KBN_USER);
               mdl.setCguSelectSid(sid);
           }
           mdl.setCgiSid(paramMdl.getCht010GrpConfCgiSid());
           mdl.setCguAdminFlg(1);
           mdl.setCguAdate(date);
           mdl.setCguEdate(date);
           mdl.setCguAuid(usrSid);
           mdl.setCguEuid(usrSid);
           useMdlList.add(mdl);
       }
       // 一般
       String[] generalList = paramMdl.getCht010GrpConfMemberGeneralSid();
       for (String general:generalList) {
           ChtGroupUserModel mdl = new ChtGroupUserModel();
           if (general.startsWith("G")) {
               int sid = NullDefault.getInt(general.substring(1), -1);
               mdl.setCguKbn(GSConstChat.CHAT_KBN_GROUP);
               mdl.setCguSelectSid(sid);
           } else {
               int sid = NullDefault.getInt(general, -1);
               mdl.setCguKbn(GSConstChat.CHAT_KBN_USER);
               mdl.setCguSelectSid(sid);
           }
           mdl.setCgiSid(paramMdl.getCht010GrpConfCgiSid());
           mdl.setCguAdminFlg(0);
           mdl.setCguAdate(date);
           mdl.setCguEdate(date);
           mdl.setCguAuid(usrSid);
           mdl.setCguEuid(usrSid);
           useMdlList.add(mdl);
       }

       return useMdlList;
   }

   /**
    * <br>[機  能] グループチャットを論理削除します
    * <br>[解  説]
    * <br>[備  考]
    * @param paramMdl パラメータ情報
    * @param usrSid ユーザSID
    * @throws Exception 例外
    */
   public void logicDeleteChtGroup(Cht010ParamModel paramMdl, int usrSid) throws Exception {
       log__.debug("deleteGroupChat");
       UDate now = new UDate();
       ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
       infDao.updateGroupLocgicDelete(paramMdl.getCht010GrpConfCgiSid(), usrSid, now);

   }

   /**
    * [機 能] グループ管理のコンボ・チェックボックスを設定します。
    * [解 説]
    * [備 考]
    * @param paramMdl Cht010ParamModel
    * @param usrSid ユーザSID
    * @throws SQLException SQL実行時例外
    * @throws Exception 実行時例外
    */
   public void setGrpConfFormTag(Cht010ParamModel paramMdl, int usrSid)
           throws SQLException, Exception {
       log__.debug("タグ設定");
       ChtBiz biz = new ChtBiz(con__, reqMdl__);
       // カテゴリ設定
       paramMdl.setCht010GrpConfCategoryList(biz.getCategory(false));
   }

   /**
    *
    * <br>[機  能] バイナリSIDを取得
    * <br>[解  説]
    * <br>[備  考]
    * @param paramMdl 画面パラメータ
    * @return バイナリSID
    * @throws SQLException SQL実行時例外
    */
   public long getDownloadBinSid(Cht010ParamModel paramMdl) throws SQLException {

        long messageSid = paramMdl.getCht010MessageSid();
        long binSid = paramMdl.getCht010BinSid();

        long ret = -1;
        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataTempDao cutDao = new ChtUserDataTempDao(con__);
            ChtUserDataTempModel cutMdl = cutDao.select(messageSid, binSid);
            if (cutMdl != null) {
                ret = cutMdl.getBinSid();
            }
        } else {
            ChtGroupDataTempDao cgtDao = new ChtGroupDataTempDao(con__);
            ChtGroupDataTempModel cgtMdl = cgtDao.select(messageSid, binSid);
            if (cgtMdl != null) {
                ret = cgtMdl.getBinSid();
            }
        }

        return ret;
    }

    /**
     * [機 能] 作成・編集時グループリストに表示するか
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param adminFlg システムorプラグイン管理者権限
     * @param usrSid ユーザＳＩＤ
     * @return 表示判定
     * @throws Exception 実行例外
     */
    public boolean chkDspGroupList(
            Cht010ParamModel paramMdl,
            boolean adminFlg,
            int usrSid)
            throws Exception {
        boolean ret = false;
        ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
        // グループ情報一覧を取得
        int archiveFlg = paramMdl.getCht010GrpConfDspArcKbn();
        String keyword = paramMdl.getCht010GrpConfSearchKeyword();
        boolean allDsp = false;
        if (adminFlg) {
            int dspFlg = paramMdl.getCht010GrpConfAllDspKbn();
            if (dspFlg == GSConstChat.CHAT_CONF_DSP_ALL) {
                allDsp = true;
            }
        }
        ret =  infDao.chkGrpConfGroupDsp(allDsp, usrSid, archiveFlg, keyword,
                paramMdl.getCht010GrpConfCgiSid());
        return ret;
    }

    /**
        * 作成したチャットグループに関するパラメータを生成
        * @param paramMdl パラメータモデル
        * @throws SQLException SQL実行例外
        * */
    public void createNewGroupParam(Cht010ParamModel paramMdl) throws SQLException {

        // POST通信で送られてきたメンバーSID
        ChtMemberBiz memberBiz = new ChtMemberBiz(con__);
        // 管理者メンバーSID
        String[] adminMembers = paramMdl.getCht010GrpConfMemberAdminSid();
        // 一般メンバーSID
        String[] generalMembers = paramMdl.getCht010GrpConfMemberGeneralSid();
        // メンバーユーザSID
        String[] members = memberBiz.createMemberUserSid(adminMembers, generalMembers);

        // パラメータのセット
        paramMdl.setCht010MemberUserSids(members);
        // 編集時はメッセージ件数も取得
        if (paramMdl.getCht010GrpConfProcMode() == GSConstChat.CHAT_MODE_EDIT) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            int msgCnt = cgdDao.getExistMessageCount(paramMdl.getCht010GrpConfCgiSid());
            paramMdl.setCht010MessageCount(msgCnt);
            // メッセージがある場合は最新投稿日時を取得
            if (msgCnt > 0) {
                UDate lastDate = cgdDao.selectLastEntryTime(paramMdl.getCht010GrpConfCgiSid());
                paramMdl.setCht010MessageLastDate(NullDefault.getString(lastDate.toString(), ""));
            } else {
                paramMdl.setCht010MessageLastDate("");
            }
        }
    }

    /**
     * <br>[機  能] メッセージにリアクションを登録/削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @throws Exception 実行例外
     */
    public void changeReaction(Cht010ParamModel paramMdl) throws Exception {

        ChtSendViewBiz sendBiz = new ChtSendViewBiz(reqMdl__, con__);
        sendBiz.putReaction(
            paramMdl.getCht010SelectKbn(),
            paramMdl.getCht010SelectPartner(),
            paramMdl.getCht010MessageSid(),
            paramMdl.getCht010Reaction(),
            null);

    }

    /**
     * <br>[機  能] 返信対象のメッセージ情報を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @return 返信対象のメッセージ情報
     * @throws Exception 実行例外
     */
    public JSONObject getReplyJson(
        Cht010ParamModel paramMdl, RequestModel reqMdl, Connection con) throws Exception {

        ChatDao chatDao = new ChatDao(con);
        ChatMessageModel cmMdl = null;
        long messageSid = paramMdl.getCht010MessageSid();

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            Map<Long, ChatMessageModel> replyMap =
                chatDao.getUserReplyMap(Arrays.asList(new Long[]{messageSid}));
            cmMdl = replyMap.get(messageSid);
        } else {
            Map<Long, ChatMessageModel> replyMap =
                chatDao.getGroupReplyMap(Arrays.asList(new Long[]{messageSid}));
            cmMdl = replyMap.get(messageSid);
        }

        JSONObject jsonData = new JSONObject();
        ChtSendViewBiz viewBiz = new ChtSendViewBiz(reqMdl, con);
        viewBiz.jsonMessageInfo(jsonData, Arrays.asList(new ChatMessageModel[] {cmMdl}), con);

        return jsonData;
    }


    /**
     * <br>[機  能] グループ情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param paramMdl Cht010ParamModel
     * @return jsonData
     */
    private JSONObject __jsonGrpConfInf(JSONObject jsonData,
            Cht010ParamModel paramMdl) {
        jsonData.element("cht010GrpConfCgiSid", paramMdl.getCht010GrpConfCgiSid());
        jsonData.element("cht010GrpConfGroupId",
                StringUtilHtml.transToHTmlPlusAmparsant(
                        paramMdl.getCht010GrpConfGroupId())
                );
        jsonData.element("cht010GrpConfGroupName",
                StringUtilHtml.transToHTmlPlusAmparsant(
                        paramMdl.getCht010GrpConfGroupName())
                );
        jsonData.element("cht010GrpConfCategory", paramMdl.getCht010GrpConfCategory());
        jsonData.element("cht010GrpConfBiko",
                StringUtilHtml.transToHTmlForTextArea(
                        paramMdl.getCht010GrpConfBiko())
                );
        jsonData.element("cht010GrpConfArchiveKbn", paramMdl.getCht010GrpConfArchiveKbn());
        return jsonData;
    }

    /**
     * <br>[機  能] グループ一覧情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param list グループ情報
     * @return jsonData
     */
    private JSONObject __jsonGrpConfGrpList(JSONObject jsonData,
            List<ChtGroupInfModel> list) {
        jsonData.element("size", list.size());
        for (int nIdx = 0; nIdx < list.size(); nIdx++) {
            jsonData.element("cgiSid_"
        + nIdx, String.valueOf(list.get(nIdx).getCgiSid()));
            jsonData.element("groupName_"
        + nIdx, StringUtilHtml.transToHTmlPlusAmparsant(
                String.valueOf(list.get(nIdx).getCgiName())));
            jsonData.element("archiveFlg_"
        + nIdx, String.valueOf(list.get(nIdx).getCgiCompFlg()));
        }

        return jsonData;
    }

    /**
     * <br>[機  能] カテゴリ情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param categoryLabel カテゴリ情報
     * @return jsonData
     */
    private JSONObject __jsonGrpConfCategory(JSONObject jsonData,
            List<LabelValueBean> categoryLabel) {
        jsonData.element("category_size", categoryLabel.size());
        for (int nIdx = 0; nIdx < categoryLabel.size(); nIdx++) {
            jsonData.element("categorySid_"
        + nIdx, String.valueOf(categoryLabel.get(nIdx).getValue()));
            jsonData.element("categoryName_"
        + nIdx, String.valueOf(StringUtilHtml.transToHTmlPlusAmparsant(
                categoryLabel.get(nIdx).getLabel())));
        }
        return jsonData;
    }

    /**
     * <br>[機  能] メンバー設定処理
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param paramModel パラメータ情報
     * @return jsonData
     */
    private JSONObject __jsonGrpConfMember(JSONObject jsonData,
            Cht010ParamModel paramModel) {

        String[] aminSid = paramModel.getCht010GrpConfMemberAdminSid();
        String[] generalSid = paramModel.getCht010GrpConfMemberGeneralSid();
        jsonData.element("adminmemberSid_size", aminSid.length);
        for (int nIdx = 0; nIdx < aminSid.length; nIdx++) {
            jsonData.element("adminmemberSid_"
        + nIdx, String.valueOf(aminSid[nIdx]));
        }
        jsonData.element("generalmemberSid_size", generalSid.length);
        for (int nIdx = 0; nIdx < generalSid.length; nIdx++) {
            jsonData.element("generalmemberSid_"
        + nIdx, String.valueOf(generalSid[nIdx]));
        }
        return jsonData;
    }

    /**
     * <br>[機  能] 登録編集情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param mode 登録編集
     * @return jsonData
     */
    private JSONObject __jsonGrpConfAddEdit(JSONObject jsonData,
            int mode) {
        jsonData.element("grp_procmode", mode);
        return jsonData;
    }

    /**
     * <br>[機  能] 管理者権限情報情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param adminFlg 管理者権限
     * @return jsonData
     */
    private JSONObject __jsonAdminFlg(JSONObject jsonData,
            int adminFlg) {
        jsonData.element("adminFlg", adminFlg);
        return jsonData;
    }

    /**
     * <br>[機  能] グループ作成権限情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param grpFlg グループ作成権限
     * @return jsonData
     */
    private JSONObject __jsonLimitChtGrpFlg(JSONObject jsonData,
            int grpFlg) {
        jsonData.element("limitGrpFlg", grpFlg);
        return jsonData;
    }

    /**
     * <br>[機  能] エラー情報設定
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param messageList エラーメッセージ
     * @return jsonData
     */
    private JSONObject __jsonError(JSONObject jsonData, List<String> messageList) {

        jsonData.element("errMessage_size", messageList.size());
        for (int nIdx = 0; nIdx < messageList.size(); nIdx++) {
        jsonData.element("errMessage_"
        + nIdx, String.valueOf(messageList.get(nIdx)));
        }
        return jsonData;
    }

    /**
     * <br>[機  能] グループチャット情報リアルタイム変更
     * <br>[解  説]
     * <br>[備  考]
     * @param jsonData JSONObject
     * @param paramMdl グループチャットSID
     * @return jsonData
     */
    private JSONObject __jsonRealTimeUpdateChtGroup(
            JSONObject jsonData,
            Cht010ParamModel paramMdl) {
        jsonData.element("plugin", "chat");
        jsonData.element("type", "chatGroup");
        jsonData.element("chatGroupSid", paramMdl.getCht010GrpConfCgiSid());
        jsonData.element("chatGroupName", StringUtilHtml.transToHTmlPlusAmparsant(
                paramMdl.getCht010GrpConfGroupName()));
        jsonData.element("chatGroupArchiveFlg", paramMdl.getCht010GrpConfArchiveKbn());
        jsonData.element("realTimeFlg", GSConstChat.REAL_TIME_YES);
        jsonData.element("messageCount", paramMdl.getCht010MessageCount());
        jsonData.element("messageLastDate", paramMdl.getCht010MessageLastDate());
        String[] usrSids = paramMdl.getCht010MemberUserSids();
        jsonData.element("usrSidssize", usrSids.length);
        String[] oldSids = paramMdl.getCht010OldMemberSids();
        jsonData.element("oldMembersize", oldSids.length);
        jsonData.element("ownUserSid", reqMdl__.getSmodel().getUsrsid());

        return jsonData;
    }

    /**
     *
     * <br>[機  能] チャットグループがないエラー時 レスポンスjson生成
     * <br>[解  説]
     * <br>[備  考]
     * @param messageList エラーメッセージ
     * @return json
     */
    public JSONObject createJsonGroupConfGrpNotExist(List<String> messageList) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("validate_notExist", true);
        __jsonError(jsonData, messageList);
        return jsonData;
    }
    /**
     *
     * <br>[機  能] その他エラー時 レスポンスjson生成
     * <br>[解  説]
     * <br>[備  考]
     * @param messageList エラーメッセージ
     * @return json
     */
    public JSONObject createJsonGroupConfError(List<String> messageList) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("validate_error", true);
        __jsonError(jsonData, messageList);
        return jsonData;
    }
    /**
     *
     * <br>[機  能] グループ設定初期化 レスポンスjson生成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json
     */
    public JSONObject createJsonGroupConfInit(Cht010ParamModel paramMdl) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        __jsonGrpConfGrpList(jsonData, paramMdl.getCht010GrpConfGroupList());
        __jsonAdminFlg(jsonData, paramMdl.getAdminFlg());
        __jsonLimitChtGrpFlg(jsonData, paramMdl.getCht010GroupEditFlg());
        return jsonData;
    }
    /**
     *
     * <br>[機  能] グループ設定編集画面遷移 レスポンスjson生成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json
     */
    public JSONObject createJsonGroupConfAddEdit(Cht010ParamModel paramMdl) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        __jsonGrpConfCategory(jsonData, paramMdl.getCht010GrpConfCategoryList());
        __jsonGrpConfMember(jsonData, paramMdl);
        __jsonGrpConfInf(jsonData, paramMdl);
        __jsonAdminFlg(jsonData, paramMdl.getAdminFlg());
        __jsonGrpConfAddEdit(jsonData, paramMdl.getCht010GrpConfProcMode());
        return jsonData;
    }
    /**
     *
     * <br>[機  能]  グループ設定メンバー変更 レスポンスjson作成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json
     */
    public JSONObject createJsonGroupConfMemberChange(
            Cht010ParamModel paramMdl) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        __jsonGrpConfMember(jsonData, paramMdl);
        __jsonGrpConfAddEdit(jsonData, paramMdl.getCht010GrpConfProcMode());
        return jsonData;
    }
    /**
     *
     * <br>[機  能]  グループ設定 更新確定 レスポンスjson作成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json
     */
    public JSONObject createJsonGroupConfUpdate(Cht010ParamModel paramMdl) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        __jsonGrpConfGrpList(jsonData, paramMdl.getCht010GrpConfGroupList());
        __jsonRealTimeUpdateChtGroup(jsonData, paramMdl);
        return jsonData;
    }
    /**
     *
     * <br>[機  能]  グループ設定 削除確定 レスポンスjson作成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json
     */
    public JSONObject createJsonGroupConfDelete(Cht010ParamModel paramMdl) {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        __jsonGrpConfGrpList(jsonData, paramMdl.getCht010GrpConfGroupList());
        __jsonRealTimeUpdateChtGroup(jsonData, paramMdl);
        return jsonData;
    }

    /**
     *
     * <br>[機  能]  メッセージ送信処理 レスポンスjson作成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return json jsonData
     * @throws SQLException SQL実行時例外
     */
    public JSONObject createJsonSendResp(Cht010ParamModel paramMdl) throws SQLException {
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("selectSid", String.valueOf(paramMdl.getCht010SelectPartner()));
        jsonData.element("selectKbn", String.valueOf(paramMdl.getCht010SelectKbn()));

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            UserSearchDao usrDao = new UserSearchDao(con__);
            UserSearchModel usrMdl = usrDao.getUserInfoJtkb(
                    paramMdl.getCht010SelectPartner(),
                    GSConstUser.USER_JTKBN_ACTIVE);

            jsonData.element("chatName", UserUtil.makeName(usrMdl.getUsiSei(), usrMdl.getUsiMei()));
            jsonData.element("usrJkbn", String.valueOf(usrMdl.getUsrJkbn()));
            jsonData.element("usrUkoFlg", String.valueOf(usrMdl.getUsrUkoFlg()));
        } else {
            getGroupName(paramMdl);
            ChatInformationModel cifMdl = paramMdl.getCht010ChtInfMdl();
            jsonData.element("chatName", cifMdl.getChatName());
            jsonData.element("archive", cifMdl.getChatArchive());


        }

        return jsonData;
    }

    /**
     * <br>[機  能] 左メニュータブ切り替え
     * <br>[解  説] タブ切り替え時に非同期実行される。切り替えたタブの保管のみ行う
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @throws SQLException SQL実行時例外
     */
    public void changeTab(Cht010ParamModel paramMdl) throws SQLException {
        //不正入力判定
        switch (paramMdl.getCht010SelectTab()) {
            case GSConstChat.CHAT_TAB_ALL:
            case GSConstChat.CHAT_TAB_TIMELINE:
                break;
            default:
                return;
        }
        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();

        ChtPriConfDao confDao = new ChtPriConfDao(con__);

        if (confDao.updateTab(
                paramMdl.getCht010SelectTab(),
                sessionUsrSid) == 0) {
            //設定の取得
            ChtBiz chtBiz = new ChtBiz(con__, reqMdl__);
            ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);
            userMdl.setCpcSelTab(paramMdl.getCht010SelectTab());
            confDao.insert(userMdl);
        }
    }

    /***
     * チャットメンバー情報の生成
     * @param info
     * @return チャットメンバーリスト
     * @throws SQLException
     */
    private Map<Integer, Cht010MemberModel> __createChatMemberMap(
        ChatInformationModel info) throws SQLException {
        final Map<Integer, Cht010MemberModel> ret = new LinkedHashMap<>();

        Set<Integer> userSidSet = new HashSet<>();
        userSidSet.addAll(
            info.getGeneralMember()
                .stream()
                .map(usr -> usr.getUsrSid())
                .collect(Collectors.toSet())
        );
        userSidSet.addAll(
            info.getAdminMember()
                .stream()
                .map(usr -> usr.getUsrSid())
                .collect(Collectors.toSet())
        );
        if (info.getGeneralGroup() != null) {
            for (CmnGroupmModel grp : info.getGeneralGroup()) {
                userSidSet.addAll(
                    new CmnBelongmDao(con__)
                    .selectBelongLiveUserSid(
                            Integer.valueOf(grp.getGrpSid()))
                );
            }
        }
        if (info.getAdminGroup() != null) {
            for (CmnGroupmModel grp : info.getAdminGroup()) {
                userSidSet.addAll(
                    new CmnBelongmDao(con__)
                    .selectBelongLiveUserSid(
                            Integer.valueOf(grp.getGrpSid()))
                );
            }
        }
        if (info.getChatKbn() == GSConstChat.CHAT_KBN_USER) {
            userSidSet.add(reqMdl__.getSmodel().getUsrsid());
        }

        LinkedHashMap<Integer, CmnUserModel> userMap = new LinkedHashMap<>();

        new UserSearchDao(con__)
            .getUsersDataList(userSidSet, true)
            .stream()
            .forEach(u -> userMap.put(u.getUsrSid(), u));

        userMap.values()
        .stream()
        .map(usr -> new Cht010MemberModel(
                usr,
                (usr.getUsrSid() == reqMdl__.getSmodel().getUsrsid())
            ))
        .forEach(u -> ret.put(u.getUsrSid(), u));

        return ret;

    }
    /**
     * チャットメッセージの検索を実行する
     * @param paramMdl
     * @return 検索結果
     * @throws SQLException
     * @throws TargetMessageWrongException
     */
    public ChatMessageSearchResult searchMessageData(
        Cht010ParamModel paramMdl) throws SQLException, TargetMessageWrongException {

        ChatMessageSearchRequest searchReq = null;
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                con__,
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        } else {
            searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        }
        if (paramMdl.getCht010MessageMaxMinSid() != null) {
            searchReq.setPosition(
                new BeforeMessage(paramMdl.getCht010MessageMaxMinSid())
            );
        } else {
            searchReq.setPosition(
                new OffsetPosition(0)
            );
        }

        searchReq.setFilterList(
            Stream.concat(
                paramMdl.getCht010SearchFilterList().stream(),
                Stream.of(
                    ChatMessageSearchFilter.createInstance(
                        ChatMessageSearchFilter.EnumType.deletedLess.name()
                    )
                )
            ).collect(Collectors.toList())
        );

        searchReq.setLimit(GSConstChat.CHAT_GET_MESSAGE_NUMBER);

        searchReq.setOrder(GSConst.ORDER_KEY_DESC);

        ChatMessageSearchResult result =
        new ChatMessageSearcher(
            con__,
            searchReq,
            adminMdl)
            .execute();
        return result;
    }

    /**
     * チャットメッセージ指定 遷移結果の取得
     * @param paramMdl
     * @return チャット検索結果モデル
     * @throws SQLException
     * @throws TargetMessageWrongException
    */
    public ChatMessageSearchResult jumpArroundData(
        Cht010ParamModel paramMdl)throws SQLException, TargetMessageWrongException {

        ChatMessageSearchRequest searchReq = null;
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                con__,
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        } else {
            searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        }

        searchReq.setPosition(
            new ArroundMessage(paramMdl.getCht010jumpMessageSid())
        );

        searchReq.setLimit(GSConstChat.CHAT_GET_MESSAGE_NUMBER);

        searchReq.setOrder(GSConst.ORDER_KEY_ASC);


        ChatMessageSearchResult result =
         new ChatMessageSearcher(
            con__,
            searchReq,
            adminMdl)
            .execute();
        return result;
    }

    /**
     * <br>[機  能] ピンどめ状態の変更を行う。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param pinKbn ピン状態変更区分 0=ピンどめを解除 1=ピンどめを行う
     * @throws Exception 実行例外
     */
    public void changeMessagePin(Cht010ParamModel paramMdl, int pinKbn) throws Exception {
        long messageSid = paramMdl.getCht010MessageSid();
        int usrSid = reqMdl__.getSmodel().getUsrsid();

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con__);
            //ペアSIDを取得する
            ChtUserPairDao pairDao = new ChtUserPairDao(con__);
            int pairSid = pairDao.select(usrSid, paramMdl.getCht010SelectPartner());
            if (pinKbn == GSConstChat.CHAT_MESSAGE_PIN_ON) {
                //ピンどめを行う
                if (uPinDao.select(usrSid, pairSid, messageSid) != null) {
                    //既に存在している為、ピンどめを行わない。
                    return;
                }
                ChtUserDataPinModel pinMdl = new ChtUserDataPinModel();
                int maxSort = uPinDao.getMaxSort(usrSid, pairSid);
                pinMdl.setUsrSid(usrSid);
                pinMdl.setCupSid(pairSid);
                pinMdl.setCudSid(messageSid);
                pinMdl.setCudpSort(maxSort + 1);
                uPinDao.insert(pinMdl);
            } else if (pinKbn == GSConstChat.CHAT_MESSAGE_PIN_OFF) {
                //ピンどめを解除
                uPinDao.delete(usrSid, pairSid, messageSid);
            }
        } else if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con__);
            if (pinKbn == GSConstChat.CHAT_MESSAGE_PIN_ON) {
                //ピンどめを行う
                if (gPinDao.select(usrSid, paramMdl.getCht010SelectPartner(), messageSid) != null) {
                    //既に存在している為、ピンどめを行わない。
                    return;
                }
                ChtGroupDataPinModel pinMdl = new ChtGroupDataPinModel();
                int maxSort = gPinDao.getMaxSort(
                                usrSid, paramMdl.getCht010SelectPartner());
                pinMdl.setUsrSid(usrSid);
                pinMdl.setCgiSid(paramMdl.getCht010SelectPartner());
                pinMdl.setCgdSid(messageSid);
                pinMdl.setCgdpSort(maxSort + 1);
                gPinDao.insert(pinMdl);
            } else if (pinKbn == GSConstChat.CHAT_MESSAGE_PIN_OFF) {
                //ピンどめを解除
                gPinDao.delete(usrSid, paramMdl.getCht010SelectPartner(), messageSid);

            }
        }
    }

    /**
     * ピンどめ投稿一覧を取得します
     * @param paramMdl
     * @return 検索結果
     * @throws SQLException
     */
    public ChatMessageSearchResult getPinMessageData(
        Cht010ParamModel paramMdl) throws SQLException {

        ChatMessageSearchRequest searchReq = null;
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con__);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                con__,
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        } else {
            searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
                reqMdl__,
                paramMdl.getCht010SelectPartner());
        }

        searchReq.setPosition(
            new OffsetPosition(paramMdl.getCht010PinOffset())
        );

        searchReq.setTargetPinKbn(GSConstChat.CHAT_MESSAGE_GET_PIN);

        searchReq.setLimit(paramMdl.getCht010PinLimit());

        searchReq.setOrder(GSConst.ORDER_KEY_DESC);
        try {
            ChatMessageSearchResult result =
            new ChatMessageSearcher(
                con__,
                searchReq,
                adminMdl)
                .execute();
            return result;
        } catch (TargetMessageWrongException e) {
            //メッセージポジション指定ではないためこの例外は発生しない
            throw new RuntimeException(e);
        }
    }

    /**
     * <br>[機  能] スタンプの並び替えを行う。
     * <br>[解  説] 移動前から移動後の位置までにあるスタンプを取得し、並び順を更新する。
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @throws Exception SQL実行時例外
     */
    public void sortPinMessage(Cht010ParamModel paramMdl) throws SQLException {

        int sessionUserSid = reqMdl__.getSmodel().getUsrsid();
        try {
            if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_USER) {
                ChtUserPairDao uPairDao = new ChtUserPairDao(con__);
                int pairSid = uPairDao.select(sessionUserSid, paramMdl.getCht010SelectPartner());
                ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con__);
                //移動対象となるピンどめ情報
                ChtUserDataPinModel beforePinMdl = uPinDao.select(
                    sessionUserSid, pairSid, paramMdl.getCht010SortPinBeforeSid());
                //移動先にあるピンどめ情報
                ChtUserDataPinModel afterPinMdl = uPinDao.select(
                    sessionUserSid, pairSid, paramMdl.getCht010SortPinAfterSid());

                ChtUserPinSortChanger sortBiz =
                    ChtUserPinSortChanger.getInstanceForUserChat(con__, reqMdl__, pairSid);

                int startSort = beforePinMdl.getCudpSort();
                int endSort = afterPinMdl.getCudpSort();
                sortBiz.sort(startSort,
                        endSort);
            } else {
                ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con__);
                //移動対象となるピンどめ情報
                ChtGroupDataPinModel beforePinMdl = gPinDao.select(
                    sessionUserSid, paramMdl.getCht010SelectPartner(),
                    paramMdl.getCht010SortPinBeforeSid());
                //移動先にあるピンどめ情報
                ChtGroupDataPinModel afterPinMdl = gPinDao.select(
                    sessionUserSid, paramMdl.getCht010SelectPartner(),
                    paramMdl.getCht010SortPinAfterSid());

                int startSort = beforePinMdl.getCgdpSort();
                int endSort = afterPinMdl.getCgdpSort();

                ChtUserPinSortChanger sortBiz =
                    ChtUserPinSortChanger.getInstanceForGroupChat(
                        con__, reqMdl__, paramMdl.getCht010SelectPartner());

                sortBiz.sort(startSort,
                        endSort);

            }
        } catch (SQLException e) {
            throw e;
        }
    }

    /**
     * <br>[機  能] ミュート切り替え
     * <br>[解  説] 切り替え時に非同期実行される。開閉の保管のみ行う
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @throws Exception
     */
    public void updateMute(
        Cht010ParamModel paramMdl, RequestModel reqMdl, Connection con) throws Exception {

        int usrSid = reqMdl.getSmodel().getUsrsid();
        int selectPartner = paramMdl.getCht010SelectPartner();

        int muteFlg = GSConstChat.CHAT_MUTE_OFF;
        if (paramMdl.getCht010MuteFlg() == GSConstChat.CHAT_MUTE_ON) {
            muteFlg = GSConstChat.CHAT_MUTE_ON;
        }

        if (paramMdl.getCht010SelectKbn() == GSConstChat.CHAT_KBN_GROUP) {
            ChtGroupUconfDao cguDao = new ChtGroupUconfDao(con);
            ChtGroupUconfModel cguMdl = cguDao.select(usrSid, selectPartner);
            if (cguMdl == null) {
                //新規登録
                cguMdl = new ChtGroupUconfModel();
                cguMdl.setUsrSid(usrSid);
                cguMdl.setCgiSid(selectPartner);
                cguMdl.setCgucFavoriteKbn(GSConstChat.CHAT_NOT_FAVORITE);
                cguMdl.setCgucMuteKbn(muteFlg);
                cguDao.insert(cguMdl);
                return;
            }
            cguMdl.setCgucMuteKbn(muteFlg);
            cguDao.update(cguMdl);
        } else {
            ChtUserPairCreateBiz cupBiz = new ChtUserPairCreateBiz();
            int cupSid = cupBiz.getCupSidAutoCreate(reqMdl, con, usrSid, selectPartner);

            ChtUserUconfDao cuuDao = new ChtUserUconfDao(con);
            ChtUserUconfModel cuuMdl = cuuDao.select(usrSid, cupSid);
            if (cuuMdl == null) {
                //新規登録
                cuuMdl = new ChtUserUconfModel();
                cuuMdl.setUsrSid(usrSid);
                cuuMdl.setCupSid(cupSid);
                cuuMdl.setCuucFavoriteKbn(GSConstChat.CHAT_NOT_FAVORITE);
                cuuMdl.setCuucMuteKbn(muteFlg);
                cuuDao.insert(cuuMdl);
                return;
            }
            cuuMdl.setCuucMuteKbn(muteFlg);
            cuuDao.update(cuuMdl);
        }
    }

    /**
     * <br>[機  能] 右開閉切り替え
     * <br>[解  説] 切り替え時に非同期実行される。開閉の保管のみ行う
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @throws SQLException SQL実行時例外
     */
    public void toggleRightpane(Cht010ParamModel paramMdl) throws SQLException {
        //flg
        int paneFlg = paramMdl.getCht010RightpaneFlg();

        switch (paneFlg) {
            case 0:
            case 1:
                break;
            default:
                return;
        }

        int sessionUsrSid = reqMdl__.getSmodel().getUsrsid();

        ChtPriConfDao confDao = new ChtPriConfDao(con__);

        if (confDao.updateRightPane(
                paneFlg,
                sessionUsrSid) == 0) {
            //設定の取得
            ChtBiz chtBiz = new ChtBiz(con__, reqMdl__);
            ChtPriConfModel userMdl = chtBiz.getChtUconf(sessionUsrSid);
            userMdl.setCpcRightpaneFlg(paneFlg);
            confDao.insert(userMdl);
        }
    }
}
