package jp.groupsession.v2.cht.cht010;

import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.usr.GSConstUser;

public class Cht010MemberModel {
    /** ユーザ情報ベース */
    private CmnUserModel usrMdl__;

    /** 閲覧者自身の場合 true */
    private boolean mineFlg__ = false;
    /** ユーザ画像表示モード 定義 */
    public static enum EnumUserImgType {
        /** 未設定画像 */
        Default,
        /** ユーザ画像 */
        Image,
        /** 非公開表示 */
        Hikoukai
    }

    /**
     * コンストラクタ
     * @param user
     * @param mineFlg 閲覧者本人かどうか
     */
    protected Cht010MemberModel(CmnUserModel user, boolean mineFlg) {
        usrMdl__ = user;
        mineFlg__ = mineFlg;
    }

    /**
     * @return ユーザSID
     * @see jp.groupsession.v2.cmn.model.CmnUserModel#getUsrSid()
     */

    public int getUsrSid() {
        return usrMdl__.getUsrSid();
    }

    /**
     * @return ユーザ削除区分
     * @see jp.groupsession.v2.cmn.model.IUserMiniimalInfo#getUsrJkbn()
     */

    public int getUsrJkbn() {
        return usrMdl__.getUsrJkbn();
    }

    /**
     * @return ユーザ名
     * @see jp.groupsession.v2.cmn.model.IUserMiniimalInfo#getUsiName()
     */

    public String getUsiName() {
        return usrMdl__.getUsiName();
    }

    /**
     * @return ユーザログイン停止フラグ
     * @see jp.groupsession.v2.cmn.model.IUserMiniimalInfo#getUsrUkoFlg()
     */

    public int getUsrUkoFlg() {
        return usrMdl__.getUsrUkoFlg();
    }



    /**
     * @return
     * @see jp.groupsession.v2.cmn.model.CmnUserModel#getUsiPictKf()
     */
    public int getUsiPictKf() {
        return usrMdl__.getUsiPictKf();
    }

    /**
     * ユーザ画像SIDを返す
     * @return ユーザ画像SID
     * @see jp.groupsession.v2.cmn.model.CmnUserModel#getBinSid()
     */

    public Long getBinSid() {
        if (mineFlg__ == false && usrMdl__.getUsiPictKf() == GSConstUser.INDIVIDUAL_INFO_CLOSE) {
            return 0l;
        }
        return usrMdl__.getBinSid();
    }

}
