package jp.groupsession.v2.cht.cht010;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.json.JSONArray;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cht.model.ChatMessageModel;
import jp.groupsession.v2.cht.model.ChtReactionModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;

/**
 * <br>[機  能] チャット一覧の描画時に、JSONで渡す情報を格納します
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cht010MessageJsonModel {

    /** メッセージ一覧作成に使用するJSON配列 */
    private JSONArray messageJson__ = null;

    /** リアクションしたユーザ一覧作成に使用するJSON配列 */
    private JSONArray reactionUserJson__ = null;

    /**
     * コンストラクタ
     * @param messageList メッセージ一覧
     * @param con コネクション
     * @throws SQLException 
     */
    public Cht010MessageJsonModel(
        List<ChatMessageModel> messageList, Connection con) throws SQLException {

        messageJson__ = __getMessageJsonArray(messageList);
        reactionUserJson__ = __getUserJsonArray(messageList, con);
    }

    /**
     * <br>[機  能] チャット一覧の描画に使用できる状態に、メッセージ一覧を変形します
     * <br>[解  説]
     * <br>[備  考]
     * @param messageList メッセージ一覧
     * @return メッセージ一覧作成に使用するJSON配列
     */
    private JSONArray __getMessageJsonArray(List<ChatMessageModel> messageList) {
        
        if (messageList == null || messageList.isEmpty()) {
            return new JSONArray();
        }

        JSONArray messageArray = JSONArray.fromObject(messageList);
        JSONObject messageObject;
        //添付ファイル情報から不要な情報を取り除くのに使用する
        JSONArray binArray;

        //返信情報から不要な情報を取り除くのに使用する
        JSONObject replyObj;
        JSONArray replyBinArray;

        //メンション情報から不要な情報を取り除くのに使用する
        JSONArray mentionUserArray;
        JSONObject mentionUserObj;
        JSONObject addMentionObj;
        for (int idx = 0; idx < messageArray.size(); idx++) {
            messageObject = messageArray.getJSONObject(idx);
            if (messageObject.has("binMdlList")) {
                binArray = messageObject.getJSONArray("binMdlList");
                __removeBinInfo(binArray);
            }

            if (messageObject.has("replyMessageInfo")) {
                replyObj = messageObject.getJSONObject("replyMessageInfo");
                if (!replyObj.isNullObject() && replyObj.has("binMdlList")) {
                    replyBinArray = replyObj.getJSONArray("binMdlList");
                    __removeBinInfo(replyBinArray);
                }
            }

            if (messageObject.has("mentionUserInfo")) {
                mentionUserArray = messageObject.getJSONArray("mentionUserInfo");
                for (int mentionIdx = 0; mentionIdx < mentionUserArray.size(); mentionIdx++) {
                    mentionUserObj = mentionUserArray.getJSONObject(mentionIdx);
                    
                    addMentionObj = new JSONObject();
                    addMentionObj.element("usrSid", mentionUserObj.get("usrSid"));
                    addMentionObj.element("usrId", mentionUserObj.get("usrLgid"));
                    addMentionObj.element("usiName", StringUtilHtml.transToHTmlPlusAmparsant(
                        mentionUserObj.getString("usiName")));
                    addMentionObj.element("usrJkbn", mentionUserObj.get("usrJkbn"));
                    addMentionObj.element("usrUkoFlg", mentionUserObj.get("usrUkoFlg"));
                    addMentionObj.element("usiPictKf", mentionUserObj.get("usiPictKf"));
                    addMentionObj.element("binSid", mentionUserObj.get("binSid"));

                    mentionUserArray.element(mentionIdx, addMentionObj);
                }
            }
        }
        return messageArray;
    }

    /**
     * <br>[機  能] チャット一覧の描画に使用できる状態に、ユーザ一覧を変形します
     * <br>[解  説]
     * <br>[備  考]
     * @param messageList メッセージ一覧
     * @param con コネクション
     * @return メッセージ一覧作成に使用するリアクションしたユーザのJSON配列
     * @throws SQLException 
     */
    private JSONArray __getUserJsonArray(
        List<ChatMessageModel> messageList, Connection con) throws SQLException {
        
        JSONArray userArray = new JSONArray();
        if (messageList == null || messageList.isEmpty()) {
            return userArray;
        }
        JSONObject userObj;

        List<Integer> userSidList = new ArrayList<Integer>();
        List<ChtReactionModel> reactionList;
        for (ChatMessageModel cmMdl : messageList) {
            reactionList = cmMdl.getReactionList();
            if (reactionList != null) {
                for (ChtReactionModel crMdl : reactionList) {
                    if (crMdl.getUsrSidList() != null) {
                        userSidList.addAll(crMdl.getUsrSidList());
                    }
                }
            }

        }
        userSidList = userSidList.stream()
            .distinct()
            .collect(Collectors.toList());

        UserSearchDao userDao = new UserSearchDao(con);
        List<CmnUserModel> userList = userDao.getUsersDataList(userSidList, true);
        
        for (CmnUserModel usrMdl : userList) {
            userObj = new JSONObject();
            userObj.element("usrSid", usrMdl.getUsrSid());
            userObj.element("usrId", usrMdl.getUsrLgid());
            userObj.element("usrJkbn", usrMdl.getUsrJkbn());
            userObj.element("usiPictKf", usrMdl.getUsiPictKf());
            userObj.element("usrUkoFlg", usrMdl.getUsrUkoFlg());
            userObj.element("usrBinSid", usrMdl.getBinSid());
            userObj.element("usiName",
                StringUtilHtml.transToHTmlPlusAmparsant(usrMdl.getUsiName()));
            userArray.add(userObj);
        }
        return userArray;
    }

    /**
     * <br>[機  能] 添付ファイル情報を保存したJSONから不要な情報を取り除く
     * <br>[解  説]
     * <br>[備  考]
     * @param binJsonArray 添付ファイル情報を保存したJSON配列
     */
    private void __removeBinInfo(JSONArray binJsonArray) {

        JSONObject binObj;
        for (int binIdx = 0; binIdx < binJsonArray.size(); binIdx++) {
            binObj = binJsonArray.getJSONObject(binIdx);
            binObj.remove("binFilePath");
            binObj.remove("binFileExtension");
            binObj.remove("binAduser");
            binObj.remove("binAddate");
            binObj.remove("binUpuser");
            binObj.remove("binUpdate");
            binObj.remove("binJkbn");
            binObj.remove("binFilekbn");
            binObj.remove("binFileData");
            binObj.remove("binFileDataOid");
            binObj.remove("finalizeRmFilekbn");
        }
    }

    /**
     * @return the messageJson
     */
    public JSONArray getMessageJson() {
        return messageJson__;
    }

    /**
     * @return the reactionUserJson
     */
    public JSONArray getReactionUserJson() {
        return reactionUserJson__;
    }
}
