package jp.groupsession.v2.cht.cht070;

import java.sql.Connection;
import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import jp.co.sjts.util.NullDefault;
import jp.groupsession.v2.cht.AbstractChatAdminAction;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.model.RequestModel;

/**
 * <br>[機  能] チャット統計情報画面アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 */
public class Cht070Action extends AbstractChatAdminAction {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cht070Action.class);

    /**
     * <br>[機  能] アクションを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form ActionForm
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws SQLException SQL実行時例外
     * @see jp.co.sjts.util.struts.AbstractAction
     * @see #executeAction(org.apache.struts.action.ActionMapping,
     *                      org.apache.struts.action.ActionForm,
     *                      javax.servlet.http.HttpServletRequest,
     *                      javax.servlet.http.HttpServletResponse,
     *                      java.sql.Connection)
     */
     public ActionForward executeAction(ActionMapping map,
                                         ActionForm form,
                                         HttpServletRequest req,
                                         HttpServletResponse res,
                                         Connection con) throws SQLException {

         //コマンドパラメータ取得
         String cmd = NullDefault.getString(req.getParameter("CMD"), "");
         log__.debug("CMD = " + cmd);

         ActionForward forward = null;
         Cht070Form thisForm = (Cht070Form) form;

         if (cmd.equals("admTool")) {
             log__.debug("「管理者設定へ戻る」ボタンクリック時");
             forward = __backToMenu(map, thisForm);
         } else if (cmd.equals("pageDate")) {
             log__.debug("集計日付変更");
             thisForm.setCht070NowPage(1);
             forward = __doInit(map, thisForm, req, res, con);
         } else if (cmd.equals("dspNumChange")) {
             log__.debug("表示件数変更");
             thisForm.setCht070NowPage(1);
             forward = __doInit(map, thisForm, req, res, con);
         } else if (cmd.equals("dateUnitChange")) {
             log__.debug("月週日ラジオボタン選択");
             thisForm.setCht070NowPage(1);
             forward = __doInit(map, thisForm, req, res, con);
         } else if (cmd.equals("pageChange")) {
             log__.debug("ページコンボボックス選択時");
             forward = __movePage(map, thisForm, req, res, con, 0);
         } else if (cmd.equals("pageLast")) {
             log__.debug("「前ページ」ボタンクリック時");
             forward = __movePage(map, thisForm, req, res, con, -1);
         } else if (cmd.equals("pageNext")) {
             log__.debug("「次ページ」ボタンクリック時");
             forward = __movePage(map, thisForm, req, res, con, 1);
         } else if (cmd.equals("smail")) {
             log__.debug("「ショートメール」ボタンクリック時");
             forward = map.findForward("statsSmail");
         } else if (cmd.equals("circular")) {
             log__.debug("「回覧板」ボタンクリック時");
             forward = map.findForward("statsCircular");
         } else if (cmd.equals("file")) {
             log__.debug("「ファイル管理」ボタンクリック時");
             forward = map.findForward("statsFile");
         } else if (cmd.equals("webmail")) {
             log__.debug("「WEBメール」ボタンクリック時");
             forward = map.findForward("statsWebmail");
         } else if (cmd.equals("statsMain")) {
             log__.debug("「WEBメール」ボタンクリック時");
             forward = map.findForward("statsMain");
         } else if (cmd.equals("bulletin")) {
             log__.debug("「掲示板」ボタンクリック時");
             forward = map.findForward("statsBulletin");
         } else {
             log__.debug("初期表示");
             forward = __doInit(map, thisForm, req, res, con);
         }

         return forward;
     }



     /**
      * <br>[機  能] 初期表示を行う
      * <br>[解  説]
      * <br>[備  考]
      *
      * @param map アクションマッピング
      * @param form アクションフォーム
      * @param req リクエスト
      * @param res レスポンス
      * @param con コネクション
      * @return ActionForward
      * @throws SQLException SQL実行時例外
      */
    private ActionForward __doInit(ActionMapping map,
                                    Cht070Form form,
                                    HttpServletRequest req,
                                    HttpServletResponse res,
                                    Connection con)
        throws SQLException {

        BaseUserModel buMdl = getSessionUserModel(req);

        con.setAutoCommit(true);
        RequestModel reqMdl = getRequestModel(req);
        Cht070Biz biz = new Cht070Biz(con, reqMdl);

        Cht070ParamModel paramMdl = new Cht070ParamModel();
        paramMdl.setParam(form);
        biz.setInitData(paramMdl, buMdl,
                getPluginConfigForMain(getPluginConfig(req), con, reqMdl));
        paramMdl.setFormData(form);

        con.setAutoCommit(false);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] 戻り先の画面を判別する
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @return ActionForward
     */
    private ActionForward __backToMenu(ActionMapping map, Cht070Form form) {
        ActionForward forward = null;
        String orgnPage = form.getLogCountBack();
        if (orgnPage.equals(GSConst.PLUGINID_SML)) {
            //ショートメール管理者画面
            forward = map.findForward("adminSmail");
        } else if (orgnPage.equals(GSConst.PLUGINID_CIR)) {
            //回覧板管理者画面
            forward  = map.findForward("adminCircular");
        } else if (orgnPage.equals(GSConst.PLUGIN_ID_FILE)) {
            //ファイル管理管理者画面
            forward = map.findForward("adminFile");
        } else if (orgnPage.equals(GSConst.PLUGINID_WML)) {
            //WEBメール管理者画面
            forward = map.findForward("adminWebmail");
        } else if (orgnPage.equals(GSConst.PLUGIN_ID_BULLETIN)) {
            //掲示板管理者画面
            forward  = map.findForward("adminBulletin");
        } else if (orgnPage.equals(GSConst.PLUGINID_MAIN)) {
            //メイン管理者画面
            forward = map.findForward("adminMain");
        }  else {
            forward  = map.findForward("cht020");
        }
        return forward;
    }

    /**
     * <br>[機  能] ページ移動処理
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @param pageNo ページ数
     * @throws SQLException SQL実行時例外
     * @return アクションフォーム
     */
    private ActionForward __movePage(ActionMapping map, Cht070Form form,
                    HttpServletRequest req, HttpServletResponse res, Connection con, int pageNo)
            throws SQLException {
        //ページ数調整
        int page = form.getCht070NowPage();
        page += pageNo;
        if (page < 1) {
            page = 1;
        }
        form.setCht070NowPage(page);

        return __doInit(map, form, req, res, con);
    }


}