package jp.groupsession.v2.cht.cht110;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtMemberBiz;
import jp.groupsession.v2.cht.biz.ChtWebSocketBiz;
import jp.groupsession.v2.cht.biz.ChtWebSocketBiz.GroupInfoReqModel;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.model.ChatGroupComboModel;
import jp.groupsession.v2.cht.model.ChatInformationModel;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cmn.model.RequestModel;

/**
 *
 * <br>[機  能] チャットグループ追加/編集のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cht110Biz {

    /** Loggingインスタンス */
    private static Log log__ = LogFactory.getLog(Cht110Biz.class);
    /** コネクション */
    private Connection con__ = null;
    /** リクエスト情報 */
    private RequestModel reqMdl__ = null;

    /**コンストラクタ
     * @param con コネクション
     * @param reqMdl リクエスト情報
     * */
    public Cht110Biz(Connection con, RequestModel reqMdl) {
        con__ = con;
        reqMdl__ = reqMdl;
    }

    /**
     * 表示処理
     * @param paramMdl パラメータモデル
     * @param usrSid ユーザSID
     * @throws SQLException SQL実行例外
     *
     * */
    public void setInitData(Cht110ParamModel paramMdl, int usrSid)
            throws SQLException {
        log__.debug("init");
        boolean init = false;
        if (paramMdl.getCht110InitFlg() == GSConstChat.DSP_FIRST) {
            init = true;
            paramMdl.setCht110InitFlg(GSConstChat.DSP_ALREADY);
        }
        //編集の場合、データ取得
        ChtBiz biz = new ChtBiz(con__, reqMdl__);
        ChtMemberBiz memberBiz = new ChtMemberBiz(con__);
        // 初期表示
        if (paramMdl.getCht100ProcMode() == GSConstChat.CHAT_MODE_EDIT
                && init) {
            ChtGroupInfDao infDao = new ChtGroupInfDao(con__);
            ChatInformationModel infMdl = infDao.selectChatGroupInf(paramMdl.getCgiSid());
            __setChatInf(paramMdl, infMdl);
            ChtGroupUserDao userDao = new ChtGroupUserDao(con__);
            List<ChtGroupUserModel> userList = userDao.select(paramMdl.getCgiSid());
            ChatGroupComboModel targetList = memberBiz.setChatGrp(userList);

            // リアルタイム通信用のパラメータをセット
            // 元々のメンバーSID
            String[] adminMembers = targetList.getMemberAdminSid();
            String[] generalMembers = targetList.getMemberGeneralSid();
            paramMdl.setCht110memberAdmin(adminMembers);
            paramMdl.setCht110memberNormal(generalMembers);
            paramMdl.setOldMemberSids(biz.createMemberUserSid(adminMembers, generalMembers));
        } else if (paramMdl.getCht100ProcMode() == GSConstChat.CHAT_MODE_ADD
                && init) {
            // grpId自動採番
            paramMdl.setCht110groupId(biz.getAutoGeneratedId());
            // 管理者メンバー
            paramMdl.setCht110memberAdmin(
                        new String[] {String.valueOf(usrSid)});
        }

        // カテゴリ追加
        paramMdl.setCht110CategoryList(biz.getCategory(false));
    }

    /**
     * 作成したチャットグループに関するパラメータを生成
     * @param req リクエスト
     * @param paramMdl パラメータモデル
     * @param usrSid ユーザSID
     * @param oldSids 編集前所属メンバー
     * @throws Exception Exception
     * */
    public void createNewGroupParam(
            HttpServletRequest req,
            Cht110ParamModel paramMdl,
            int usrSid,
            List<Integer> oldSids
            ) throws Exception {

        // メンバー情報
        ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);
        ChatGroupComboModel memberMdl = new ChatGroupComboModel();
        if (paramMdl.getCht100ProcMode() == GSConstChat.CHAT_MODE_ADD
                || cgiDao.isExitGroup(paramMdl.getCgiSid())) {
            ChtGroupUserDao userDao = new ChtGroupUserDao(con__);
             userDao.select(paramMdl.getCgiSid());
            ChtMemberBiz memberBiz = new ChtMemberBiz(con__);
            memberMdl = memberBiz.setChatGrp(userDao.select(paramMdl.getCgiSid()));
        }
        // 管理者メンバーSID
        String[] adminMembers = memberMdl.getMemberAdminSid();
        // 一般メンバーSID
        String[] generalMembers = memberMdl.getMemberGeneralSid();
        // メンバーユーザSID
        ChtBiz chtBiz = new ChtBiz(con__, reqMdl__);
        String[] usrSids = chtBiz.createMemberUserSid(adminMembers, generalMembers);

        // 所属メンバーの画面に反映
        String[] oldMembers = new String[oldSids.size()];
        for (int i = 0; i < oldSids.size(); i++) {
            oldMembers[i] = String.valueOf(oldSids.get(i));
        }

        //WebSocketによる変更通知
        ChtWebSocketBiz wsBiz = new ChtWebSocketBiz(con__, reqMdl__);
        GroupInfoReqModel gmdl = createGroupInfo(paramMdl);

        wsBiz.editChatGroup(
                paramMdl.getCht100ProcMode(),
                gmdl,
                usrSids,
                oldMembers);
    }

    /**
     * 作成したチャットグループに関するパラメータを生成
     * @param paramMdl パラメータモデル
     * @return グループ情報
     * @throws SQLException SQL実行例外
     * */
    public GroupInfoReqModel createGroupInfo(Cht110ParamModel paramMdl) throws SQLException {

        GroupInfoReqModel gmdl = new ChtWebSocketBiz.GroupInfoReqModel();
        gmdl.setChatGroupSid(paramMdl.getCgiSid());
        gmdl.setChatGroupName(
            paramMdl.getCht110groupName());
        gmdl.setChatGroupArchiveFlg(paramMdl.getCht110compFlg());
        // 編集時はメッセージ件数も取得
        if (paramMdl.getCht100ProcMode() == GSConstChat.CHAT_MODE_EDIT) {
            ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
            int msgCnt = cgdDao.getExistMessageCount(paramMdl.getCgiSid());
            gmdl.setMessageCount(msgCnt);
            // メッセージがある場合は最新投稿日時を取得
            if (msgCnt > 0) {
                UDate lastDate = cgdDao.selectLastEntryTime(paramMdl.getCgiSid());
                gmdl.setMessageLastDate(lastDate.toString());
            }
        }        
        return gmdl;
    }

    /**
     * グループ情報をパラメータモデルに設定
     * @param paramMdl パラメータモデル
     * @param infMdl ChatInformationModel
     * @throws SQLException SQL実行例外
     *
     * */
    private void __setChatInf(Cht110ParamModel paramMdl, ChatInformationModel infMdl)
            throws SQLException {
        paramMdl.setCht110groupId(infMdl.getChatId());
        paramMdl.setCht110groupName(infMdl.getChatName());
        paramMdl.setCht110biko(infMdl.getChatBiko());
        paramMdl.setCht110category(infMdl.getCategorySid());
        paramMdl.setCht110compFlg(infMdl.getChatArchive());
        paramMdl.setCht110createDate(infMdl.getStrInsertDate());
        paramMdl.setCht110updateDate(infMdl.getStrLastSendDate());

    }
}
