package jp.groupsession.v2.cht.cht160;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.MessageResources;

import jp.co.sjts.util.Encoding;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.http.TempFileUtil;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cht.AbstractChatAdminAction;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 *
 * <br>[機  能] スタンプ管理 Actionクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cht160Action extends AbstractChatAdminAction {
    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Cht160Action.class);
    /** テンポラリディレクトリID*/
    private static final String TEMP_DIRECTORY_ID = "cht160";
    /** ログイン画面 ロゴ画像名 */
    public String imageFileName__ = "";
    /** ログイン画面 ロゴ画像保存名 */
    public String imageFileSaveName__ = "";

    /**
     * <br>アクション実行
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws Exception 実行例外
     * @return アクションフォーム
     */
    public ActionForward executeAction(ActionMapping map, ActionForm form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {
        ActionForward forward = null;
        Cht160Form thisForm = (Cht160Form) form;

        //コマンドパラメータ取得
        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        log__.debug("CMD = " + cmd);

        if (cmd.equals("backToAdmin")) {
            log__.debug("管理者設定へ戻る");
            forward = map.findForward("cht020");
        } else if (cmd.equals("getImageFile")) {
            log__.debug("スタンプ画像ダウンロード");
            forward = __doGetImageFile(map, thisForm, req, res, con);
        } else if (cmd.equals("addStamp")) {
            log__.debug("スタンプ登録");
            __doAddStamp(map, thisForm, req, res, con);
        } else if (cmd.equals("deleteStamp")) {
            log__.debug("スタンプ削除");
            __doDeleteStamp(map, thisForm, req, res, con);
        } else if (cmd.equals("useStamp")) {
            log__.debug("スタンプ使用");
            __doUpdateStampUseKbn(map, thisForm, req, res, con, GSConstChat.STAMP_USE_KBN_USE);
        } else if (cmd.equals("unusedStamp")) {
            log__.debug("スタンプ未使用");
            __doUpdateStampUseKbn(map, thisForm, req, res, con, GSConstChat.STAMP_USE_KBN_UNUSED);
        } else if (cmd.equals("getStampList")) {
            log__.debug("スタンプ一覧取得");
            __doGetStampList(map, thisForm, req, res, con, GSConstChat.STAMP_USE_KBN_USE);
        } else if (cmd.equals("getUnusedStampList")) {
            log__.debug("未使用スタンプ一覧取得");
            __doGetStampList(map, thisForm, req, res, con, GSConstChat.STAMP_USE_KBN_UNUSED);
        } else if (cmd.equals("sortStamp")) {
            log__.debug("スタンプ並び替え");
            __doSortStamp(map, thisForm, req, res, con);
        } else {
            log__.debug("初期表示");
            forward = __doInit(map, thisForm, req, res, con);
        }

        return forward;
    }

    /**
     * <br>[機  能] 初期表示
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doInit(ActionMapping map, Cht160Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {
        con.setAutoCommit(true);
        Cht160ParamModel paramMdl = new Cht160ParamModel();
        paramMdl.setParam(form);
        Cht160Biz biz = new Cht160Biz(con);
        biz.setInitData(paramMdl);
        paramMdl.setFormData(form);
        con.setAutoCommit(false);

        //テンポラリディレクトリの削除
        GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
        temp.deleteTempPath(getRequestModel(req), GSConstChat.PLUGIN_ID_CHAT, TEMP_DIRECTORY_ID);
        //テンポラリディレクトリの生成
        temp.createTempDir(getRequestModel(req), GSConstChat.PLUGIN_ID_CHAT,
            TEMP_DIRECTORY_ID);
        temp.createTempDir(getRequestModel(req), GSConstChat.PLUGIN_ID_CHAT,
            TEMP_DIRECTORY_ID);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] tempディレクトリの画像を読み込む
     * <br>[解  説]
     * <br>[備  考]
     *
     * @param map マップ
     * @param form フォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con Connection
     * @return ActionForward フォワード
     * @throws Exception 実行時例外
     */
    private ActionForward __doGetImageFile(ActionMapping map,
                                            Cht160Form form,
                                            HttpServletRequest req,
                                            HttpServletResponse res,
                                            Connection con)
        throws Exception {

        if (form.getCht160BinSid() != null) {
            // 一覧表示用
            CommonBiz cmnBiz = new CommonBiz();
            CmnBinfModel cbMdl = null;
    
            cbMdl = cmnBiz.getBinInfo(con, form.getCht160BinSid(),
                    GroupSession.getResourceManager().getDomain(req));
            if (cbMdl != null) {
                JDBCUtil.closeConnectionAndNull(con);
                TempFileUtil.downloadInline(req, res, cbMdl, getAppRootPath(),
                                            Encoding.UTF_8);
            }
        } else if (form.getCht160ImageSaveName() != null
                    && form.getCht160ImageName() != null) {
            // 登録時のプレビュー用
            imageFileSaveName__ = form.getCht160ImageSaveName();
            imageFileName__ = form.getCht160ImageName();
            //imageFileSaveNameの半角数字チェック処理
            if (!ValidateUtil.isNumber(imageFileSaveName__)) {
                return getSubmitErrorPage(map, req);
            }
            RequestModel reqMdl = getRequestModel(req);
            String tempDir = "";
            GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
            tempDir = tempUtil.getTempPath(reqMdl,
                                        GSConstChat.PLUGIN_ID_CHAT,
                                        GSConstChat.DIRID_CHT160);
    
            String fullPath = IOTools.replaceFileSep(
                    tempDir + imageFileSaveName__ + GSConstCommon.ENDSTR_SAVEFILE);
            TempFileUtil.downloadInline(req, res, fullPath, imageFileName__, Encoding.UTF_8);
        }
        return null;
    }

    /**
     * <br>[機  能] スタンプ登録
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __doAddStamp(ActionMapping map, Cht160Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {

        boolean commitFlg = false;
        RequestModel reqMdl = getRequestModel(req);
        JSONObject jsonData = new JSONObject();
        con.setAutoCommit(false);
        try {
            String appRootPath = getAppRootPath();
            MlCountMtController cntCon = getCountMtController(req);
            Cht160Biz biz = new Cht160Biz(con, cntCon, reqMdl);
            int addStampSid = biz.addStamp(appRootPath);
            
            //テンポラリディレクトリのクリアを行う
            GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
            temp.clearTempPath(
                getRequestModel(req), GSConstChat.PLUGIN_ID_CHAT, TEMP_DIRECTORY_ID);
    
            //オペレーションログ出力
            ChtBiz chtBiz = new ChtBiz(con);
            GsMessage gsMsg = new GsMessage(reqMdl);
            String opCode = gsMsg.getMessage("cmn.entry");
            String msg = "[スタンプ名]"
                            + biz.getStampFileName(addStampSid, reqMdl,
                                 GroupSession.getResourceManager().getDomain(req));
            chtBiz.outPutLog(
                    map, opCode, GSConstLog.LEVEL_INFO, msg,
                    reqMdl, String.valueOf(addStampSid),
                    GSConstChat.CHAT_LOG_CODE_STAMPSID);
    
            jsonData.element("success", true);

            con.commit();
            commitFlg = true;
        } catch (Exception e) {
            log__.error("スタンプ登録に失敗しました" + e);
            throw e;
        } finally {
            if (!commitFlg) {
                JDBCUtil.rollback(con);
            }
        }
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗");
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] スタンプ削除
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __doDeleteStamp(ActionMapping map, Cht160Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {

        boolean commitFlg = false;
        RequestModel reqMdl = getRequestModel(req);
        con.setAutoCommit(false);
        JSONObject jsonData = new JSONObject();
        
        //入力チェック
        ActionErrors errors = form.validateDeleteStamp(reqMdl, con);
        if (errors != null && errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            MessageResources mres = getResources(req);
            @SuppressWarnings("unchecked")
            Iterator<ActionMessage> iterator = errors.get();
            while (iterator.hasNext()) {
                ActionMessage error = ((ActionMessage) iterator.next());
                sb.append(mres.getMessage(error.getKey(), error.getValues()));
                jsonData.element("errors", sb.toString());
            }
            jsonData.element("success", false);
        } else {
            try {
                Cht160ParamModel paramMdl = new Cht160ParamModel();
                paramMdl.setParam(form);
                Cht160Biz biz = new Cht160Biz(con);
                //オペログ出力用
                String stampFileName = biz.getStampFileName(form.getCht160DeleteSid(), reqMdl,
                                            GroupSession.getResourceManager().getDomain(req));
                //スタンプ削除
                biz.deleteStamp(paramMdl,
                    GroupSession.getResourceManager().getDomain(req), getSessionUserSid(req));
                paramMdl.setFormData(form);
    
                //オペレーションログ出力
                ChtBiz chtBiz = new ChtBiz(con);
                GsMessage gsMsg = new GsMessage(reqMdl);
                String opCode = gsMsg.getMessage("cmn.delete");
                String msg = "[スタンプ名]"
                                + stampFileName;
                chtBiz.outPutLog(
                        map, opCode, GSConstLog.LEVEL_INFO, msg,
                        reqMdl, String.valueOf(form.getCht160DeleteSid()),
                        GSConstChat.CHAT_LOG_CODE_STAMPSID);
        
                jsonData.element("success", true);
    
                con.commit();
                commitFlg = true;
            } catch (Exception e) {
                log__.error("スタンプ削除に失敗しました" + e);
                throw e;
            } finally {
                if (!commitFlg) {
                    jsonData.element("success", false);
                    JDBCUtil.rollback(con);
                }
            }
        }
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗");
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] スタンプ状態変更
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @param useKbn 使用区分 0:使用 1:未使用
     * @throws Exception 実行時例外
     */
    public void __doUpdateStampUseKbn(ActionMapping map, Cht160Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con, int useKbn)
            throws Exception {

        RequestModel reqMdl = getRequestModel(req);
        con.setAutoCommit(false);
        JSONObject jsonData = new JSONObject();

        //入力チェック
        ActionErrors errors = form.validateUseKbnSid(reqMdl, con, useKbn);
        if (errors != null && errors.size() > 0) {
            StringBuilder sb = new StringBuilder();
            MessageResources mres = getResources(req);
            @SuppressWarnings("unchecked")
            Iterator<ActionMessage> iterator = errors.get();
            while (iterator.hasNext()) {
                ActionMessage error = ((ActionMessage) iterator.next());
                sb.append(mres.getMessage(error.getKey(), error.getValues()));
                jsonData.element("errors", sb.toString());
            }
            jsonData.element("success", false);
        } else {
            boolean commitFlg = false;
            Cht160Biz biz = new Cht160Biz(con);
            try {
                Cht160ParamModel paramMdl = new Cht160ParamModel();
                paramMdl.setParam(form);
                biz.updateStampUseKbn(paramMdl, useKbn);
                paramMdl.setFormData(form);
    
                con.commit();
                commitFlg = true;
            } catch (Exception e) {
                log__.error("スタンプ使用区分の更新に失敗しました" + e);
                throw e;
            } finally {
                if (!commitFlg) {
                    JDBCUtil.rollback(con);
                }
            }
    
            //オペレーションログ出力
            ChtBiz chtBiz = new ChtBiz(con);
            GsMessage gsMsg = new GsMessage(reqMdl);
            String opCode;
            String msg;
            String logCodeText = "";
            if (useKbn == GSConstChat.STAMP_USE_KBN_USE) {
                opCode = gsMsg.getMessage("cmn.use");
                msg = "[スタンプ名]";
                for (int i = 0; i < form.getCht160UseSidList().length; i++) {
                    if (i > 0) {
                        msg += ", ";
                        logCodeText += ", ";
                    }
                    msg += biz.getStampFileName(form.getCht160UseSidList()[i], reqMdl, "");
                    logCodeText += form.getCht160UseSidList()[i];
                }
            } else {
                opCode = gsMsg.getMessage("cmn.unused");
                msg = "[スタンプ名]"
                        + biz.getStampFileName(form.getCht160UnusedSid(), reqMdl, "");
                        logCodeText += form.getCht160UnusedSid();
            }
            chtBiz.outPutLog(
                    map, opCode, GSConstLog.LEVEL_INFO, msg,
                    reqMdl, String.valueOf(logCodeText),
                    GSConstChat.CHAT_LOG_CODE_STAMPSID);
    
            jsonData.element("success", true);
        }
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗");
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] スタンプ並び替え
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __doSortStamp(ActionMapping map, Cht160Form form,
            HttpServletRequest req, HttpServletResponse res, Connection con)
            throws Exception {

        boolean commitFlg = false;
        RequestModel reqMdl = getRequestModel(req);
        JSONObject jsonData = new JSONObject();
        con.setAutoCommit(false);
        try {
            Cht160ParamModel paramMdl = new Cht160ParamModel();
            paramMdl.setParam(form);
            Cht160Biz biz = new Cht160Biz(con);
            biz.sortStamp(paramMdl);
            paramMdl.setFormData(form);

            //オペレーションログ出力
            ChtBiz chtBiz = new ChtBiz(con);
            GsMessage gsMsg = new GsMessage(reqMdl);
            String opCode = gsMsg.getMessage("cmn.change");
            String msg = "[" + gsMsg.getMessage("cmn.sorting") + "]"
                            + "\n"
                            + "[スタンプ名]"
                            + biz.getStampFileName(form.getCht160SortBeforeSid(), reqMdl,
                                    GroupSession.getResourceManager().getDomain(req));
            chtBiz.outPutLog(
                    map, opCode, GSConstLog.LEVEL_INFO, msg,
                    reqMdl, String.valueOf(form.getCht160SortBeforeSid()),
                    GSConstChat.CHAT_LOG_CODE_STAMPSID);
    
            jsonData.element("success", true);

            con.commit();
            commitFlg = true;
        } catch (Exception e) {
            log__.error("スタンプの並び替えに失敗しました" + e);
            throw e;
        } finally {
            if (!commitFlg) {
                JDBCUtil.rollback(con);
            }
        }
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("jsonデータ送信失敗");
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] スタンプリスト取得
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Cht160Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @param useKbn 使用区分
     * @throws Exception 実行時例外
     */
    private void __doGetStampList(ActionMapping map,
                                           Cht160Form form,
                                           HttpServletRequest req,
                                           HttpServletResponse res,
                                           Connection con,
                                           int useKbn) throws Exception {
        Cht160Biz biz = new Cht160Biz(con);
        PrintWriter out = null;
        try {
            JSONObject jsonData = new JSONObject();
            jsonData.element("stampList", biz.getStampList(useKbn));
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(jsonData);
            out.flush();
        } catch (Exception e) {
            log__.error("スタンプリスト取得失敗");
            throw e;
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }
}



