package jp.groupsession.v2.cht.cht160;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtUsedDataBiz;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtStampDao;
import jp.groupsession.v2.cht.dao.ChtUserDataDao;
import jp.groupsession.v2.cht.model.ChtStampModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.base.CmnBinfDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.cmn.exception.TempFileException;

/**
 * <br>[機  能] 
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Cht160Biz {
    /** 画面ID */
    public static final String SCR_ID = "cht160";
    /** DBコネクション */
    public Connection con__ = null;
    /** リクエスト情報 */
    public RequestModel reqMdl__ = null;
    /** 採番コントローラ */
    public MlCountMtController cntCon__ = null;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param con Connection
     * @param cntCon MlCountMtController
     * @param reqMdl RequestModel
     */
    public Cht160Biz(Connection con, MlCountMtController cntCon, RequestModel reqMdl) {
        reqMdl__ = reqMdl;
        con__ = con;
        cntCon__ = cntCon;
    }


    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param con Connection
     */
    public Cht160Biz(Connection con) {
        con__ = con;
    }

    /**
     * <br>[機  能] 描画処理
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return paramMdl
     * @throws Exception SQL実行時例外
     */
    public Cht160ParamModel setInitData(Cht160ParamModel paramMdl) throws Exception {

        // スタンプ一覧取得
        paramMdl.setCht160StampList(getStampList(GSConstChat.STAMP_USE_KBN_USE));

        return paramMdl;
    }

    /**
     * <br>[機  能] スタンプ一覧取得
     * <br>[解  説]
     * <br>[備  考]
     * @param useKbn 使用区分
     * @return スタンプ一覧
     * @throws Exception SQL実行時例外
     */
    public List<ChtStampModel> getStampList(int useKbn) throws SQLException {
        // スタンプ一覧取得
        List<ChtStampModel> stampList = new ArrayList<ChtStampModel>();
        try {
            ChtStampDao stampDao = new ChtStampDao(con__);
            stampList = stampDao.getStampSortList(useKbn);
        } catch (SQLException e) {
            throw e;
        }
        return stampList;
    }

    /**
     * <br>[機  能] スタンプを登録します。
     * <br>[解  説]
     * <br>[備  考]
     * @param appRootPath アプリケーションRoot
     * @return スタンプSID
     * @throws Exception SQL実行時例外
     */
    public int addStamp(String appRootPath) throws SQLException, TempFileException {
        ChtStampDao stampDao = new ChtStampDao(con__);
        ChtStampModel stampMdl = new ChtStampModel();
        int stampSid = 0;
        try {
            //添付ファイルの登録
            CommonBiz biz = new CommonBiz();
            ChtBiz chtBiz = new ChtBiz();
            BaseUserModel usMdl = reqMdl__.getSmodel();
            int sessionUsrSid = usMdl.getUsrsid();
            String tempDir = chtBiz.getTempDir(reqMdl__, GSConstChat.DIRID_CHT160);
            List<Long> binSidList = biz.insertBinInfo(
                    con__, tempDir, appRootPath, cntCon__, sessionUsrSid, new UDate())
                    .stream()
                    .map(str -> Long.parseLong(str))
                    .collect(Collectors.toList());
    
            //フォーラムSID採番
            stampSid = (int) cntCon__.getSaibanNumber(
                            GSConstChat.SBNSID_CHAT,
                            GSConstChat.SBNSID_SUB_STAMPT,
                            sessionUsrSid);
    
            //並び順
            int sort = stampDao.getMaxSort() + 1;
            
            //登録
            stampMdl.setCstSid(stampSid);
            stampMdl.setBinSid(binSidList.get(0));
            stampMdl.setCstDefstampId(0);
            stampMdl.setCstSort(sort);
            stampMdl.setCstJkbn(GSConstChat.STAMP_JKBN_ACTIVE);
            stampMdl.setCstUseKbn(GSConstChat.STAMP_USE_KBN_USE);
            stampDao.insert(stampMdl);

            //データ使用量の登録
            ChtUsedDataBiz usedDataBiz = new ChtUsedDataBiz(con__);
            usedDataBiz.insertChtStampBinSize(binSidList, reqMdl__.getDomain(), true);
        } catch (SQLException e) {
            throw e;
        } catch (TempFileException e) {
            throw e;
        }
        return stampSid;
    }

    /**
     * <br>[機  能] スタンプを削除します。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @param domain ドメイン
     * @param usrSid 実行ユーザSID
     * @throws TempFileException 
     * @throws Exception SQL実行時例外
     */
    public void deleteStamp(Cht160ParamModel paramMdl,
        String domain, int usrSid)throws SQLException, TempFileException {

        try {
            ChtStampDao stampDao = new ChtStampDao(con__);
            ChtGroupDataDao gDao = new ChtGroupDataDao(con__);
            int gCount = gDao.countStamp(paramMdl.getCht160DeleteSid());
            ChtUserDataDao uDao = new ChtUserDataDao(con__);
            int uCount = uDao.countStamp(paramMdl.getCht160DeleteSid());
            if (gCount == 0 && uCount == 0) {
                //削除されていない投稿にて使用されていない場合、物理削除を行う。
                ChtStampModel csmMdl = stampDao.select(paramMdl.getCht160DeleteSid());
                if (csmMdl != null) {
                    //データ使用量の削減
                    List<Long> binSid = Arrays.asList(new Long[] {csmMdl.getBinSid()});
                    ChtUsedDataBiz usedDataBiz = new ChtUsedDataBiz(con__);
                    usedDataBiz.insertChtStampBinSize(binSid, domain, false);

                    //添付ファイルの論理削除
                    CmnBinfModel binMdl = new CmnBinfModel();
                    binMdl.setBinUpuser(usrSid);
                    binMdl.setBinUpdate(new UDate());
                    binMdl.setBinJkbn(GSConst.JTKBN_DELETE);
                    CmnBinfDao binDao = new CmnBinfDao(con__);
                    binDao.updateJKbn(binMdl, binSid);
                }
                stampDao.delete(paramMdl.getCht160DeleteSid());
            } else {
                //削除されていない投稿にて使用されている場合、論理削除を行う。
                ChtStampModel sMdl = stampDao.select(paramMdl.getCht160DeleteSid());
                sMdl.setCstJkbn(GSConstChat.STAMP_JKBN_DELETE);
                stampDao.update(sMdl);
            }
        } catch (SQLException e) {
            throw e;
        }
    }

    /**
     * <br>[機  能] スタンプの使用状態を変更します。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @param cstUseKbn 使用区分
     * @throws Exception SQL実行時例外
     */
    public void updateStampUseKbn(Cht160ParamModel paramMdl, int cstUseKbn) throws SQLException {
        try {
            ChtStampDao stampDao = new ChtStampDao(con__);
            List<Integer> targetSidList = new ArrayList<Integer>();
            if (cstUseKbn == GSConstChat.STAMP_USE_KBN_USE) {
                for (int sid : paramMdl.getCht160UseSidList()) {
                    targetSidList.add(sid);
                };
            } else {
                targetSidList.add(paramMdl.getCht160UnusedSid());
            }
            stampDao.updateUseKbn(targetSidList, cstUseKbn);
        } catch (SQLException e) {
            throw e;
        }
    }

    /**
     * <br>[機  能] スタンプの並び替えを行う。
     * <br>[解  説] 移動前から移動後の位置までにあるスタンプを取得し、並び順を更新する。
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @throws Exception SQL実行時例外
     */
    public void sortStamp(Cht160ParamModel paramMdl) throws SQLException {
        ChtStampDao stampDao = new ChtStampDao(con__);
        try {
            //移動対象となるスタンプ
            ChtStampModel beforeStampMdl = stampDao.select(paramMdl.getCht160SortBeforeSid());
            //移動先にあるスタンプ
            ChtStampModel afterStampMdl = stampDao.select(paramMdl.getCht160SortAfterSid());
            int startSort = beforeStampMdl.getCstSort();
            int endSort = afterStampMdl.getCstSort();
            int sortKbn = GSConstChat.CHAT_ORDER_ASC;
            if (startSort > endSort) {
                //移動前の並び順 > 移動後の並び順 となる時、値を入れ替える
                sortKbn = GSConstChat.CHAT_ORDER_DESC;
                int escSort = startSort;
                startSort = endSort;
                endSort = escSort;
            }
            //更新対象となるスタンプ一覧を取得
            List<ChtStampModel> stampMdlList = stampDao.sortRangeSelect(
                                                    startSort, endSort, sortKbn);

            //並び順変更
            ChtStampModel doStampMdl = null; 
            for (ChtStampModel stampMdl : stampMdlList) {
                if (doStampMdl == null) {
                    //移動対象となるスタンプを退避
                    doStampMdl = stampMdl;
                    continue;
                }
                int escSort = doStampMdl.getCstSort();
                doStampMdl.setCstSort(stampMdl.getCstSort());
                stampMdl.setCstSort(escSort);
                //並び順を1つ移動させる。
                stampDao.update(stampMdl);
            }
            //最後に移動対象となるスタンプを更新
            stampDao.update(doStampMdl);
        } catch (SQLException e) {
            throw e;
        }
    }

    /**
     * <br>[機  能] スタンプのファイル名を取得する。
     * <br>[解  説] オペレーションログ出力用
     * @param stampSid スタンプSID
     * @param reqMdl リクエストモデル
     * @param domain ドメイン情報
     * @return スタンプファイル名
     * @throws Exception SQL実行時例外
     */
    public String getStampFileName(int stampSid, RequestModel reqMdl, String domain)
                throws SQLException, TempFileException {
        ChtStampDao stampDao = new ChtStampDao(con__);
        ChtStampModel stampMdl = stampDao.select(stampSid);
        if (stampMdl.getCstDefstampId() > 0) {
            // 既存スタンプ
            GsMessage gsMsg = new GsMessage(reqMdl);
            return gsMsg.getMessage("cht.stamp.default." + stampMdl.getCstDefstampId());
        } else {
            // 拡張スタンプ
            CommonBiz cmnBiz = new CommonBiz();
            CmnBinfModel cbMdl = cmnBiz.getBinInfo(
                con__, stampMdl.getBinSid(), domain);
            return cbMdl.getBinFileName();
        }
    }
}
