package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.model.ChtGroupDataMentionModel;

/**
 * <p>CHT_GROUP_DATA_MENTION Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtGroupDataMentionDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtGroupDataMentionDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtGroupDataMentionDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtGroupDataMentionDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_GROUP_DATA_MENTION");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_GROUP_DATA_MENTION (");
            sql.addSql("   CGD_SID bigint not null,");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   primary key (CGD_SID,USR_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_GROUP_DATA_MENTION Data Bindding JavaBean
     * @param bean CHT_GROUP_DATA_MENTION Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtGroupDataMentionModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_GROUP_DATA_MENTION(");
            sql.addSql("   CGD_SID,");
            sql.addSql("   USR_SID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(bean.getCgdSid());
            sql.addIntValue(bean.getUsrSid());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_GROUP_DATA_MENTION Data Bindding JavaBean
     * @param beanList CHT_GROUP_DATA_MENTION Data List
     * @throws SQLException SQL実行例外
     */
    public void insert(List<ChtGroupDataMentionModel> beanList) throws SQLException {

        if (beanList == null || beanList.size() <= 0) {
            return;
        }
        List<ChtGroupDataMentionModel> exeList = new ArrayList<>();
        Iterator<ChtGroupDataMentionModel> itr = beanList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(" insert ");
        sb.append(" into ");
        sb.append(" CHT_GROUP_DATA_MENTION(");
        sb.append("   CGD_SID,");
        sb.append("   USR_SID");
        sb.append(" )");
        sb.append(" values");

        Connection con = null;
        con = getCon();

        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500
                    && itr.hasNext()) {
                continue;
            }

            //500件分インサート
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());

            Iterator<ChtGroupDataMentionModel> exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                ChtGroupDataMentionModel bean = exeItr.next();
                sql.addSql(" (");
                sql.addSql("   ?,");
                sql.addSql("   ?");
                sql.addSql(" )");

                sql.addLongValue(bean.getCgdSid());
                sql.addIntValue(bean.getUsrSid());

                if (exeItr.hasNext()) {
                    sql.addSql(",");
                }
            }
            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());) {
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                pstmt.executeUpdate();

            }
            exeList.clear();
        }
    }

    /**
     * <p>Update CHT_GROUP_DATA_MENTION Data Bindding JavaBean
     * @param bean CHT_GROUP_DATA_MENTION Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtGroupDataMentionModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_GROUP_DATA_MENTION");
            sql.addSql(" set ");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   USR_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            //where
            sql.addLongValue(bean.getCgdSid());
            sql.addIntValue(bean.getUsrSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_GROUP_DATA_MENTION All Data
     * @return List in CHT_GROUP_DATA_MENTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtGroupDataMentionModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtGroupDataMentionModel> ret = new ArrayList<ChtGroupDataMentionModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CGD_SID,");
            sql.addSql("   USR_SID");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_DATA_MENTION");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtGroupDataMentionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_GROUP_DATA_MENTION
     * @param cgdSid CGD_SID List
     * @return List in CHT_GROUP_DATA_MENTIONModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtGroupDataMentionModel> select(List<Long> cgdSid) throws SQLException {

        ArrayList<ChtGroupDataMentionModel> ret = new ArrayList<ChtGroupDataMentionModel>();
        if (cgdSid == null || cgdSid.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CGD_SID,");
            sql.addSql("   USR_SID");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_DATA_MENTION");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID in (");
            for (int idx = 0; idx < cgdSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addLongValue(cgdSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtGroupDataMentionFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_GROUP_DATA_MENTION
     * @param cgdSid CGD_SID
     * @param usrSid USR_SID
     * @return CHT_GROUP_DATA_MENTIONModel
     * @throws SQLException SQL実行例外
     */
    public ChtGroupDataMentionModel select(long cgdSid, int usrSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtGroupDataMentionModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CGD_SID,");
            sql.addSql("   USR_SID");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_MENTION");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   USR_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(cgdSid);
            sql.addIntValue(usrSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtGroupDataMentionFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_GROUP_DATA_MENTION
     * @param cgdSid CGD_SID
     * @param usrSid USR_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(long cgdSid, int usrSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_MENTION");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   USR_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(cgdSid);
            sql.addIntValue(usrSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>投稿削除時、該当の投稿に紐づくメンション情報を削除する。
     * <p>実行時関連するCHT_GROUP_DATAが削除前である必要がある
     * @param cgiSidList CGI_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(Collection<Integer> cgiSidList) throws SQLException {

        if (cgiSidList == null || cgiSidList.size() <= 0) {
            return 0;
        }

        int count = 0;

        List<Integer> exeList = new ArrayList<>();
        Iterator<Integer> itr = cgiSidList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(" delete");
        sb.append(" from");
        sb.append("   CHT_GROUP_DATA_MENTION");
        sb.append(" where ");

        Connection con = null;
        con = getCon();

        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500
                    && itr.hasNext()) {
                continue;
            }

            //500件分
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());
            sql.addSql(" CGD_SID in (");
            sql.addSql("   select");
            sql.addSql("     CGD_SID");
            sql.addSql("   from CHT_GROUP_DATA");
            sql.addSql("   where");
            sql.addSql("     CGI_SID in (");

            Iterator<Integer> exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                sql.addSql("   ?");
                sql.addIntValue(exeItr.next());

                if (exeItr.hasNext()) {
                    sql.addSql(",");
                }
            }
            sql.addSql("   )");
            sql.addSql(" )");

            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());) {
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                count += pstmt.executeUpdate();

            }
            exeList.clear();
        }

        return count;
    }


    /**
     * <br>[機  能] 指定されたメッセージのメンション情報を削除
     * <br>[解  説]
     * <br>[備  考]
     * @param messageSid メッセージSID一覧
     * @return 削除件数
     * @throws SQLException
     */
    public int deleteGroupMentionData(List<Long> messageSid) throws SQLException {

        int ret = 0;
        if (messageSid == null || messageSid.isEmpty()) {
            return ret;
        }

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_MENTION");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID in (");
            for (int idx = 0; idx < messageSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addLongValue(messageSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            ret = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Create CHT_GROUP_DATA_MENTION Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtGroupDataMentionModel
     * @throws SQLException SQL実行例外
     */
    private ChtGroupDataMentionModel
        __getChtGroupDataMentionFromRs(ResultSet rs) throws SQLException {

        ChtGroupDataMentionModel bean = new ChtGroupDataMentionModel();
        bean.setCgdSid(rs.getInt("CGD_SID"));
        bean.setUsrSid(rs.getInt("USR_SID"));
        return bean;
    }
}
