package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.model.ChtGroupDataTempModel;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;

/**
 * <p>CHT_GROUP_DATA_TEMP Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtGroupDataTempDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtGroupDataTempDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtGroupDataTempDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtGroupDataTempDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_GROUP_DATA_TEMP");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_GROUP_DATA_TEMP (");
            sql.addSql("   CGD_SID bigint not null,");
            sql.addSql("   BIN_SID bigint not null,");
            sql.addSql("   primary key (CGD_SID,BIN_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_GROUP_DATA_TEMP Data Bindding JavaBean
     * @param bean CHT_GROUP_DATA_TEMP Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtGroupDataTempModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_GROUP_DATA_TEMP(");
            sql.addSql("   CGD_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(bean.getCgdSid());
            sql.addLongValue(bean.getBinSid());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CHT_GROUP_DATA_TEMP Data Bindding JavaBean
     * @param bean CHT_GROUP_DATA_TEMP Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtGroupDataTempModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_GROUP_DATA_TEMP");
            sql.addSql(" set ");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   BIN_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            //where
            sql.addLongValue(bean.getCgdSid());
            sql.addLongValue(bean.getBinSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_GROUP_DATA_TEMP All Data
     * @return List in CHT_GROUP_DATA_TEMPModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtGroupDataTempModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtGroupDataTempModel> ret = new ArrayList<ChtGroupDataTempModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CGD_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_DATA_TEMP");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtGroupDataTempFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_GROUP_DATA_TEMP
     * @param cgdSid CGD_SID
     * @param binSid BIN_SID
     * @return CHT_GROUP_DATA_TEMPModel
     * @throws SQLException SQL実行例外
     */
    public ChtGroupDataTempModel select(long cgdSid, long binSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtGroupDataTempModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CGD_SID,");
            sql.addSql("   BIN_SID");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_TEMP");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   BIN_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(cgdSid);
            sql.addLongValue(binSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtGroupDataTempFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_GROUP_DATA_TEMP
     * @param cgdSid CGD_SID
     * @param binSid BIN_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(long cgdSid, long binSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_TEMP");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");
            sql.addSql(" and");
            sql.addSql("   BIN_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(cgdSid);
            sql.addLongValue(binSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] 添付ファイル情報の登録を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param tempList 添付ファイル情報
     * @throws SQLException SQL実行例外
     */
    public void insertTempData(List<ChtGroupDataTempModel> tempList) throws SQLException {

        if (tempList == null || tempList.isEmpty()) {
            return;
        }

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __createInsertSql();
            sql.addSql(" values");

            ChtGroupDataTempModel mdl = null;
            for (int idx = 0; idx < tempList.size(); idx++) {
                mdl = tempList.get(idx);
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql(" (");
                sql.addSql("   ?,");
                sql.addSql("   ?");
                sql.addSql(" )");

                sql.addLongValue(mdl.getCgdSid());
                sql.addLongValue(mdl.getBinSid());
            }

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] データ登録用のSQLを首都kする
     * <br>[解  説]
     * <br>[備  考]
     * @return データ登録用のSQL
     */
    private SqlBuffer __createInsertSql() {

        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" insert ");
        sql.addSql(" into ");
        sql.addSql(" CHT_GROUP_DATA_TEMP(");
        sql.addSql("   CGD_SID,");
        sql.addSql("   BIN_SID");
        sql.addSql(" )");

        return sql;
    }

    /**
     * <p>Select BIN_SID
     * @param cgdSid CGD_SIDLIST
     * @return CHT_GROUP_DATAModel
     * @throws SQLException SQL実行例外
     */
    public List<Long> getBinSid(List<Long> cgdSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<Long> ret = new ArrayList<Long>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   BIN_SID");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_TEMP");
            sql.addSql(" where ");
            sql.addSql("   CGD_SID IN (");
            for (int idx = 0; idx < cgdSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(" , ");
                }
                sql.addSql(" ? ");
                sql.addLongValue(cgdSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(rs.getLong("BIN_SID"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>バイナリSIDを取得する
     * @param sidList グループSIDリスト
     * @return List in binSidList
     * @throws SQLException SQL実行例外
     */
    public List<Long> selectBinList(List<Integer> sidList) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<Long> ret = new ArrayList<Long>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CHT_GROUP_DATA_TEMP.BIN_SID");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_DATA,");
            sql.addSql("   CHT_GROUP_DATA_TEMP");
            sql.addSql(" where");
            sql.addSql("   CHT_GROUP_DATA.CGD_SID = CHT_GROUP_DATA_TEMP.CGD_SID");
            sql.addSql(" and ");
            sql.addSql("   CHT_GROUP_DATA.CGI_SID IN (");
            for (int idx = 0; idx < sidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql("  , ");
                }
                sql.addSql("  ? ");
                sql.addIntValue(sidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(rs.getLong("BIN_SID"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>メッセージSIDに対するバイナリSIDを取得する
     * @param sidList メッセージSIDリスト
     * @return メッセージSIDに対するバイナリSIDを格納したマップ
     * @throws SQLException SQL実行例外
     */
    public Map<Long, List<CmnBinfModel>> selectBinMap(List<Long> sidList) throws SQLException {

        Map<Long, List<CmnBinfModel>> ret = new HashMap<Long, List<CmnBinfModel>>();
        if (sidList == null || sidList.isEmpty()) {
            return ret;
        }

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CHT_GROUP_DATA_TEMP.CGD_SID,");
            sql.addSql("   CMN_BINF.BIN_SID,");
            sql.addSql("   CMN_BINF.BIN_FILE_NAME,");
            sql.addSql("   CMN_BINF.BIN_FILE_PATH,");
            sql.addSql("   CMN_BINF.BIN_FILE_SIZE");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_DATA_TEMP,");
            sql.addSql("   CMN_BINF");
            sql.addSql(" where");
            sql.addSql("   CHT_GROUP_DATA_TEMP.BIN_SID = CMN_BINF.BIN_SID");
            sql.addSql(" and");
            sql.addSql("   CHT_GROUP_DATA_TEMP.CGD_SID IN (");
            for (int idx = 0; idx < sidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql("  , ");
                }
                sql.addSql("  ? ");
                sql.addLongValue(sidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();

            List<CmnBinfModel> binMdlList = null;
            CommonBiz cmnBiz = new CommonBiz();
            CmnBinfModel binMdl = null;
            while (rs.next()) {
                long cudSid = rs.getLong("CGD_SID");
                binMdlList = ret.get(cudSid);
                if (binMdlList == null) {
                    binMdlList = new ArrayList<CmnBinfModel>();
                }
                binMdl = new CmnBinfModel();
                binMdl.setBinSid(rs.getLong("BIN_SID"));
                binMdl.setBinFileName(rs.getString("BIN_FILE_NAME"));
                binMdl.setBinFilePath(rs.getString("BIN_FILE_PATH"));
                //添付ファイルサイズ設定(表示用)
                long size = rs.getInt("BIN_FILE_SIZE");
                binMdl.setBinFileSize(size);
                String strSize = cmnBiz.getByteSizeString(size);
                binMdl.setBinFileSizeDsp(strSize);

                binMdlList.add(binMdl);
                ret.put(cudSid, binMdlList);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 指定したチャット投稿情報の添付ファイルサイズ合計を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param cgdSidList 投稿SID
     * @return ファイルサイズ合計
     * @throws SQLException SQL実行例外
     */
    public long getTotalFileSize(List<Long> cgdSidList) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        long fileSize = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   sum(CMN_BINF.BIN_FILE_SIZE) as FILE_SIZE");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_DATA_TEMP,");
            sql.addSql("   CMN_BINF");
            sql.addSql(" where");
            sql.addSql("   coalesce(CHT_GROUP_DATA_TEMP.BIN_SID, 0) > 0");
            sql.addSql(" and");
            sql.addSql("   CHT_GROUP_DATA_TEMP.BIN_SID = CMN_BINF.BIN_SID");
            sql.addSql(" and");
            sql.addSql("   CHT_GROUP_DATA_TEMP.CGD_SID in (");

            for (int idx = 0; idx < cgdSidList.size(); idx++) {
                if (idx == 0) {
                    sql.addSql("     ?");
                } else {
                    sql.addSql("     ,?");
                }
                sql.addLongValue(cgdSidList.get(idx));
            }

            sql.addSql("  )");

            log__.info(sql.toLogString());

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();

            if (rs.next()) {
                fileSize = rs.getLong("FILE_SIZE");
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }

        return fileSize;
    }

    /**
     * <br>[機  能] 添付ファイル情報の登録を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param cgdSid グループメッセージSID
     * @throws SQLException SQL実行例外
     */
    public void deleteTempData(long cgdSid) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __createDeleteSql();
            sql.addSql(" where ");
            sql.addSql("   CGD_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(cgdSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] 添付ファイルの削除を行う
     * <br>[解  説] 
     * <br>[備  考] 添付ファイルSIDを指定する
     * @param binSid 添付ファイルSID
     * @throws SQLException SQL実行例外
     */
    public void deleteTempData(List<Long> binSid) throws SQLException {

        if (binSid == null || binSid.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __createDeleteSql();
            sql.addSql(" where ");
            sql.addSql("   BIN_SID in (");
            for (int idx = 0; idx < binSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addLongValue(binSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <br>[機  能] データ削除用のSQLを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return データ登録用のSQL
     */
    private SqlBuffer __createDeleteSql() {

        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" delete ");
        sql.addSql(" from ");
        sql.addSql(" CHT_GROUP_DATA_TEMP");

        return sql;
    }

    /**
     * <p>Create CHT_GROUP_DATA_TEMP Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtGroupDataTempModel
     * @throws SQLException SQL実行例外
     */
    private ChtGroupDataTempModel __getChtGroupDataTempFromRs(ResultSet rs) throws SQLException {
        ChtGroupDataTempModel bean = new ChtGroupDataTempModel();
        bean.setCgdSid(rs.getInt("CGD_SID"));
        bean.setBinSid(rs.getInt("BIN_SID"));
        return bean;
    }
}
