package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.model.ChtGroupUconfModel;

/**
 * <p>CHT_GROUP_UCONF Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtGroupUconfDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtGroupUconfDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtGroupUconfDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtGroupUconfDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_GROUP_UCONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_GROUP_UCONF (");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   CGI_SID integer not null,");
            sql.addSql("   CGUC_FAVORITE_KBN integer not null,");
            sql.addSql("   CGUC_MUTE_KBN integer not null,");
            sql.addSql("   primary key (USR_SID,CGI_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_GROUP_UCONF Data Bindding JavaBean
     * @param bean CHT_GROUP_UCONF Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtGroupUconfModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_GROUP_UCONF(");
            sql.addSql("   USR_SID,");
            sql.addSql("   CGI_SID,");
            sql.addSql("   CGUC_FAVORITE_KBN,");
            sql.addSql("   CGUC_MUTE_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCgiSid());
            sql.addIntValue(bean.getCgucFavoriteKbn());
            sql.addIntValue(bean.getCgucMuteKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CHT_GROUP_UCONF Data Bindding JavaBean
     * @param bean CHT_GROUP_UCONF Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtGroupUconfModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" set ");
            sql.addSql("   CGUC_FAVORITE_KBN=?,");
            sql.addSql("   CGUC_MUTE_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CGI_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCgucFavoriteKbn());
            sql.addIntValue(bean.getCgucMuteKbn());
            //where
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCgiSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_GROUP_UCONF All Data
     * @return List in CHT_GROUP_UCONFModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtGroupUconfModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtGroupUconfModel> ret = new ArrayList<ChtGroupUconfModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   USR_SID,");
            sql.addSql("   CGI_SID,");
            sql.addSql("   CGUC_FAVORITE_KBN,");
            sql.addSql("   CGUC_MUTE_KBN");
            sql.addSql(" from ");
            sql.addSql("   CHT_GROUP_UCONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtGroupUconfFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_GROUP_UCONF
     * @param usrSid USR_SID
     * @param cgiSid CGI_SID
     * @return CHT_GROUP_UCONFModel
     * @throws SQLException SQL実行例外
     */
    public ChtGroupUconfModel select(int usrSid, int cgiSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtGroupUconfModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CGI_SID,");
            sql.addSql("   CGUC_FAVORITE_KBN,");
            sql.addSql("   CGUC_MUTE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CGI_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cgiSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtGroupUconfFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>ミュート設定を取得する
     * @param usrSid ユーザSID
     * @param messageSid メッセージSID
     * @return 0:ミュート無効, 1:ミュート有効
     * @throws SQLException SQL実行時例外
     */
    public Map<Integer, Integer> getMuteKbn(
        List<Integer> usrSid, long messageSid) throws SQLException {

        Map<Integer, Integer> ret = new HashMap<Integer, Integer>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CHT_GROUP_UCONF.CGUC_MUTE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" where ");
            sql.addSql("   CGI_SID = (");
            sql.addSql("     select ");
            sql.addSql("       CGI_SID");
            sql.addSql("     from ");
            sql.addSql("       CHT_GROUP_DATA");
            sql.addSql("     where ");
            sql.addSql("       CGD_SID = ?");
            sql.addSql("   )");
            sql.addLongValue(messageSid);
            sql.addSql(" and ");
            sql.addSql("   USR_SID in (");
            for (int idx = 0; idx < usrSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(usrSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();

            while (rs.next()) {
                ret.put(rs.getInt("USR_SID"), rs.getInt("CGUC_MUTE_KBN"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_GROUP_UCONF
     * @param usrSid USR_SID
     * @param cgiSid CGI_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid, int cgiSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CGI_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cgiSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete CHT_GROUP_UCONF
     * @param usrSid USR_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addIntValue(usrSid);

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>指定したグループのグループ状態を削除する
     * @param cgiSidList グループSIDリスト
     * @return 削除件数
     * @throws SQLException SQL実行時例外
     */
    public int delete(List<Integer> cgiSidList) throws SQLException {

        int count = 0;
        if (cgiSidList == null || cgiSidList.isEmpty()) {
            return count;
        }
        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_GROUP_UCONF");
            sql.addSql(" where ");
            sql.addSql("   CGI_SID in (");
            for (int idx = 0; idx < cgiSidList.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(cgiSidList.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CHT_GROUP_UCONF Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtGroupUconfModel
     * @throws SQLException SQL実行例外
     */
    private ChtGroupUconfModel __getChtGroupUconfFromRs(ResultSet rs) throws SQLException {
        ChtGroupUconfModel bean = new ChtGroupUconfModel();
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setCgiSid(rs.getInt("CGI_SID"));
        bean.setCgucFavoriteKbn(rs.getInt("CGUC_FAVORITE_KBN"));
        bean.setCgucMuteKbn(rs.getInt("CGUC_MUTE_KBN"));
        return bean;
    }
}
