package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.model.ChtStampModel;

/**
 * <p>CHT_STAMP Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtStampDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtStampDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtStampDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtStampDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_STAMP");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_STAMP (");
            sql.addSql("   CST_SID integer not null,");
            sql.addSql("   BIN_SID bigint,");
            sql.addSql("   CST_DEFSTAMP_ID integer not null,");
            sql.addSql("   CST_SORT integer not null,");
            sql.addSql("   CST_JKBN integer not null,");
            sql.addSql("   CST_USE_KBN integer not null,");
            sql.addSql("   primary key (CST_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_STAMP Data Bindding JavaBean
     * @param bean CHT_STAMP Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtStampModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_STAMP(");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCstSid());
            sql.addLongValue(bean.getBinSid());
            sql.addIntValue(bean.getCstDefstampId());
            sql.addIntValue(bean.getCstSort());
            sql.addIntValue(bean.getCstJkbn());
            sql.addIntValue(bean.getCstUseKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CHT_STAMP Data Bindding JavaBean
     * @param bean CHT_STAMP Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtStampModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" set ");
            sql.addSql("   BIN_SID=?,");
            sql.addSql("   CST_DEFSTAMP_ID=?,");
            sql.addSql("   CST_SORT=?,");
            sql.addSql("   CST_JKBN=?,");
            sql.addSql("   CST_USE_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   CST_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addLongValue(bean.getBinSid());
            sql.addIntValue(bean.getCstDefstampId());
            sql.addIntValue(bean.getCstSort());
            sql.addIntValue(bean.getCstJkbn());
            sql.addIntValue(bean.getCstUseKbn());
            //where
            sql.addIntValue(bean.getCstSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>スタンプの使用区分を更新します。
     * @param cstSidList スタンプSIDリスト
     * @param cstUseKbn 0:使用 1:未使用
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int updateUseKbn(List<Integer> cstSidList, int cstUseKbn) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" set ");
            sql.addSql("   CST_USE_KBN=?");
            sql.addIntValue(cstUseKbn);
            sql.addSql(" where ");
            sql.addSql("   CST_SID in (");
            for (int i = 0; i < cstSidList.size(); i++) {
                if (i > 0) {
                    sql.addSql("     ,");
                }
                sql.addSql("     ?");
                sql.addIntValue(cstSidList.get(i));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_STAMP All Data
     * @return List in CHT_STAMPModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtStampModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtStampModel> ret = new ArrayList<ChtStampModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from ");
            sql.addSql("   CHT_STAMP");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtStampFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 並び順を反映させたスタンプ一覧を取得する。
     * <br>[解  説] 削除、または未使用のものは取得しない。
     * <br>[備  考]
     * @param useKbn 使用区分
     * @return スタンプリスト
     * @throws SQLException SQL実行例外
     */
    public List<ChtStampModel> getStampSortList(int useKbn) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtStampModel> ret = new ArrayList<ChtStampModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from ");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_JKBN = ?");
            sql.addSql(" and");
            sql.addSql("   CST_USE_KBN = ?");
            sql.addSql(" order by ");
            sql.addSql("   CST_SORT");
            sql.addIntValue(GSConstChat.STAMP_JKBN_ACTIVE);
            sql.addIntValue(useKbn);

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtStampFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 最大の並び順を取得します。
     * <br>[解  説]
     * <br>[備  考]
     * @return count
     * @exception SQLException SQL実行時例外
     */
    public int getMaxSort() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        int ret = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   max(CST_SORT) as MAX");
            sql.addSql(" from ");
            sql.addSql("   CHT_STAMP");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = rs.getInt("MAX");
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 論理削除されたスタンプ一覧を取得する。
     * <br>[解  説]
     * <br>[備  考]
     * @return スタンプリスト
     * @throws SQLException SQL実行例外
     */
    public List<ChtStampModel> getDelStamp() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<ChtStampModel> ret = new ArrayList<ChtStampModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_JKBN=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(GSConstChat.STAMP_JKBN_DELETE);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtStampFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_STAMP
     * @param cstSid CST_SID
     * @return CHT_STAMPModel
     * @throws SQLException SQL実行例外
     */
    public ChtStampModel select(int cstSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtStampModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cstSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtStampFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_STAMP
     * @param cstSidList SIDリスト
     * @return CHT_STAMPModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtStampModel> select(List<Integer> cstSidList) throws SQLException {
        List<ChtStampModel> ret = new ArrayList<ChtStampModel>();
        if (cstSidList.size() == 0) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_SID in (");
            for (int i = 0; i < cstSidList.size(); i++) {
                if (i > 0) {
                    sql.addSql("   ,");
                }
                sql.addSql("   ?");
                sql.addIntValue(cstSidList.get(i));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtStampFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * 指定したSID間のスタンプ情報を取得する。
     * @param startSort 取得開始地点のソート番号
     * @param endSort 取得終了地点のソート番号
     * @param sortKbn 取得結果のソート順 0:昇順 1:降順
     * @return CHT_STAMPModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtStampModel> sortRangeSelect(int startSort, int endSort, int sortKbn)
                throws SQLException {
        List<ChtStampModel> ret = new ArrayList<ChtStampModel>();

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   CST_SID,");
            sql.addSql("   BIN_SID,");
            sql.addSql("   CST_DEFSTAMP_ID,");
            sql.addSql("   CST_SORT,");
            sql.addSql("   CST_JKBN,");
            sql.addSql("   CST_USE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_SORT BETWEEN ? AND ?");
            sql.addIntValue(startSort);
            sql.addIntValue(endSort);
            sql.addSql(" order by ");
            sql.addSql("   CST_SORT");
            if (sortKbn == GSConstChat.CHAT_ORDER_DESC) {
                sql.addSql("   desc");
            }

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtStampFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_STAMP
     * @param cstSid CST_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cstSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_STAMP");
            sql.addSql(" where ");
            sql.addSql("   CST_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cstSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create CHT_STAMP Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtStampModel
     * @throws SQLException SQL実行例外
     */
    private ChtStampModel __getChtStampFromRs(ResultSet rs) throws SQLException {
        ChtStampModel bean = new ChtStampModel();
        bean.setCstSid(rs.getInt("CST_SID"));
        bean.setBinSid(rs.getInt("BIN_SID"));
        bean.setCstDefstampId(rs.getInt("CST_DEFSTAMP_ID"));
        bean.setCstSort(rs.getInt("CST_SORT"));
        bean.setCstJkbn(rs.getInt("CST_JKBN"));
        bean.setCstUseKbn(rs.getInt("CST_USE_KBN"));
        return bean;
    }
}
