package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.model.ChtUserDataPinModel;

/**
 * <p>CHT_USER_DATA_PIN Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtUserDataPinDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtUserDataPinDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtUserDataPinDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtUserDataPinDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_USER_DATA_PIN");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_USER_DATA_PIN (");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   CUP_SID integer not null,");
            sql.addSql("   CUD_SID bigint not null,");
            sql.addSql("   CUDP_SORT integer not null,");
            sql.addSql("   primary key (USR_SID,CUP_SID,CUD_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_USER_DATA_PIN Data Bindding JavaBean
     * @param bean CHT_USER_DATA_PIN Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtUserDataPinModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_USER_DATA_PIN(");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCupSid());
            sql.addLongValue(bean.getCudSid());
            sql.addIntValue(bean.getCudpSort());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CHT_USER_DATA_PIN Data Bindding JavaBean
     * @param bean CHT_USER_DATA_PIN Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtUserDataPinModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" set ");
            sql.addSql("   CUDP_SORT=?");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUD_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCudpSort());
            //where
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCupSid());
            sql.addLongValue(bean.getCudSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_USER_DATA_PIN All Data
     * @return List in CHT_USER_DATA_PINModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtUserDataPinModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<ChtUserDataPinModel> ret = new ArrayList<ChtUserDataPinModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" from ");
            sql.addSql("   CHT_USER_DATA_PIN");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtUserDataPinFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_USER_DATA_PIN
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @param cudSid CUD_SID
     * @return CHT_USER_DATA_PINModel
     * @throws SQLException SQL実行例外
     */
    public ChtUserDataPinModel select(int usrSid, int cupSid, long cudSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtUserDataPinModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUD_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);
            sql.addLongValue(cudSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtUserDataPinFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

   /**
     * 指定インデックスでピン留め情報を取り出す。<br>
     * indexがピン留め一覧の件数より大きい場合例外が発生する。
     * @param usrSid USR_SID
     * @param cupSid CGI_SID
     * @param index offset
     * @param sortKbn ソート順
     * @return CHT_GROUP_DATA_PINModel
     * @throws SQLException SQL実行例外
     */
    public ChtUserDataPinModel selectIndex(
        int usrSid, int cupSid, int index, int sortKbn) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtUserDataPinModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addSql(" order by ");
            sql.addSql("   CUDP_SORT");
            if (sortKbn == GSConstChat.CHAT_ORDER_DESC) {
                sql.addSql("   desc");
            }

            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);
            sql.setPagingValue(index, 1);
            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtUserDataPinFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_USER_DATA_PIN
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @param cudSidList CUD_SIDリスト
     * @return CHT_USER_DATA_PINModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtUserDataPinModel> selectList(int usrSid, int cupSid, List<Long> cudSidList)
            throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        List<ChtUserDataPinModel> ret = new ArrayList<ChtUserDataPinModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addIntValue(usrSid);
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addIntValue(cupSid);
            sql.addSql(" and");
            sql.addSql("   CUD_SID in (");
            boolean connectFlg = false;
            for (Long cudSid : cudSidList) {
                if (connectFlg) {
                    sql.addSql("     ,");
                } else {
                    connectFlg = true;
                }
                sql.addSql("     ?");
                sql.addLongValue(cudSid);
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtUserDataPinFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * 指定した投稿間のピンどめ情報を取得する。
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @param startSort 取得開始地点のソート番号
     * @param endSort 取得終了地点のソート番号
     * @param sortKbn 取得結果のソート順 0:昇順 1:降順
     * @return CHT_STAMPModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtUserDataPinModel> sortRangeSelect(
        int usrSid, int cupSid, int startSort, int endSort, int sortKbn)
                throws SQLException {
        List<ChtUserDataPinModel> ret = new ArrayList<ChtUserDataPinModel>();

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUD_SID,");
            sql.addSql("   CUDP_SORT");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);
            sql.addSql(" and");
            sql.addSql("   CUDP_SORT BETWEEN ? AND ?");
            sql.addIntValue(startSort);
            sql.addIntValue(endSort);
            sql.addSql(" order by ");
            sql.addSql("   CUDP_SORT");
            if (sortKbn == GSConstChat.CHAT_ORDER_DESC) {
                sql.addSql("   desc");
            }

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtUserDataPinFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] 最大の並び順を取得します。
     * <br>[解  説]
     * <br>[備  考]
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @return count
     * @exception SQLException SQL実行時例外
     */
    public int getMaxSort(int usrSid, int cupSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        int ret = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   max(CUDP_SORT) as MAX");
            sql.addSql(" from ");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);
            sql.setParameter(pstmt);
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = rs.getInt("MAX");
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_USER_DATA_PIN
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @param cudSid CUD_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid, int cupSid, long cudSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUD_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);
            sql.addLongValue(cudSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>投稿削除時、該当の投稿に紐づくピンどめ情報を削除する。
     * @param cupSid CUP_SID
     * @param cudSid CUD_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int cupSid, long cudSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   CUP_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUD_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(cupSid);
            sql.addLongValue(cudSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }
    /**
     * <p>ユーザ削除時、該当のユーザに紐づくピンどめ情報を削除する。
     * @param usrSid USR_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_DATA_PIN");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>投稿削除時、該当の投稿に紐づくピンどめ情報を削除する。
     * @param cupSidList CUP_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(Collection<Integer> cupSidList) throws SQLException {

        if (cupSidList == null || cupSidList.size() <= 0) {
            return 0;
        }

        int count = 0;

        List<Integer> exeList = new ArrayList<>();
        Iterator<Integer> itr = cupSidList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(" delete");
        sb.append(" from");
        sb.append("   CHT_USER_DATA_PIN");
        sb.append(" where ");

        Connection con = null;
        con = getCon();

        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500
                    && itr.hasNext()) {
                continue;
            }

            //500件分
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());

            sql.addSql(" CUP_SID in (");

            Iterator<Integer> exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                sql.addSql("   ?");
                sql.addIntValue(exeItr.next());

                if (exeItr.hasNext()) {
                    sql.addSql(",");
                }
            }
            sql.addSql(" )");
            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());) {
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                count += pstmt.executeUpdate();

            }
            exeList.clear();
        }

        return count;
    }

    /**
     * <p>Create CHT_USER_DATA_PIN Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtUserDataPinModel
     * @throws SQLException SQL実行例外
     */
    private ChtUserDataPinModel __getChtUserDataPinFromRs(ResultSet rs) throws SQLException {
        ChtUserDataPinModel bean = new ChtUserDataPinModel();
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setCupSid(rs.getInt("CUP_SID"));
        bean.setCudSid(rs.getInt("CUD_SID"));
        bean.setCudpSort(rs.getInt("CUDP_SORT"));
        return bean;
    }
}
