package jp.groupsession.v2.cht.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.cht.model.ChtUserUconfModel;

/**
 * <p>CHT_USER_UCONF Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class ChtUserUconfDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(ChtUserUconfDao.class);

    /**
     * <p>Default Constructor
     */
    public ChtUserUconfDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public ChtUserUconfDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table CHT_USER_UCONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table CHT_USER_UCONF (");
            sql.addSql("   USR_SID integer not null,");
            sql.addSql("   CUP_SID integer not null,");
            sql.addSql("   CUUC_FAVORITE_KBN integer not null,");
            sql.addSql("   CUUC_MUTE_KBN integer not null,");
            sql.addSql("   primary key (USR_SID,CUP_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert CHT_USER_UCONF Data Bindding JavaBean
     * @param bean CHT_USER_UCONF Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(ChtUserUconfModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" CHT_USER_UCONF(");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUUC_FAVORITE_KBN,");
            sql.addSql("   CUUC_MUTE_KBN");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCupSid());
            sql.addIntValue(bean.getCuucFavoriteKbn());
            sql.addIntValue(bean.getCuucMuteKbn());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update CHT_USER_UCONF Data Bindding JavaBean
     * @param bean CHT_USER_UCONF Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(ChtUserUconfModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   CHT_USER_UCONF");
            sql.addSql(" set ");
            sql.addSql("   CUUC_FAVORITE_KBN=?,");
            sql.addSql("   CUUC_MUTE_KBN=?");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getCuucFavoriteKbn());
            sql.addIntValue(bean.getCuucMuteKbn());
            //where
            sql.addIntValue(bean.getUsrSid());
            sql.addIntValue(bean.getCupSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Select CHT_USER_UCONF All Data
     * @return List in CHT_USER_UCONFModel
     * @throws SQLException SQL実行例外
     */
    public List<ChtUserUconfModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<ChtUserUconfModel> ret = new ArrayList<ChtUserUconfModel>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select ");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUUC_FAVORITE_KBN,");
            sql.addSql("   CUUC_MUTE_KBN");
            sql.addSql(" from ");
            sql.addSql("   CHT_USER_UCONF");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getChtUserUconfFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select CHT_USER_UCONF
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @return CHT_USER_UCONFModel
     * @throws SQLException SQL実行例外
     */
    public ChtUserUconfModel select(int usrSid, int cupSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ChtUserUconfModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CUP_SID,");
            sql.addSql("   CUUC_FAVORITE_KBN,");
            sql.addSql("   CUUC_MUTE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getChtUserUconfFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>ミュート区分を取得する
     * @param usrSid ユーザSID
     * @param messageSid メッセージSID
     * @return 0:ミュート無効, 1:ミュート有効
     * @throws SQLException SQL実行時例外
     */
    public Map<Integer, Integer> getMuteKbn(
        List<Integer> usrSid, long messageSid) throws SQLException {

        Map<Integer, Integer> ret = new HashMap<Integer, Integer>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" select");
            sql.addSql("   USR_SID,");
            sql.addSql("   CHT_USER_UCONF.CUUC_MUTE_KBN");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_UCONF");
            sql.addSql(" where ");
            sql.addSql("   CUP_SID = (");
            sql.addSql("     select ");
            sql.addSql("       CUP_SID");
            sql.addSql("     from ");
            sql.addSql("       CHT_USER_DATA");
            sql.addSql("     where ");
            sql.addSql("       CUD_SID = ?");
            sql.addSql("   )");
            sql.addLongValue(messageSid);
            sql.addSql(" and ");
            sql.addSql("   USR_SID in (");
            for (int idx = 0; idx < usrSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(usrSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();

            while (rs.next()) {
                ret.put(rs.getInt("USR_SID"), rs.getInt("CUUC_MUTE_KBN"));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete CHT_USER_UCONF
     * @param usrSid USR_SID
     * @param cupSid CUP_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid, int cupSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addSql(" and");
            sql.addSql("   CUP_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(usrSid);
            sql.addIntValue(cupSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Delete CHT_USER_UCONF
     * @param usrSid USR_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int usrSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   CHT_USER_UCONF");
            sql.addSql(" where ");
            sql.addSql("   USR_SID=?");
            sql.addIntValue(usrSid);

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>投稿削除時、該当の投稿に紐づくピンどめ情報を削除する。
     * @param cupSidList CUP_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(Collection<Integer> cupSidList) throws SQLException {

        if (cupSidList == null || cupSidList.size() <= 0) {
            return 0;
        }

        int count = 0;

        List<Integer> exeList = new ArrayList<>();
        Iterator<Integer> itr = cupSidList.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(" delete");
        sb.append(" from");
        sb.append("   CHT_USER_UCONF");
        sb.append(" where ");

        Connection con = null;
        con = getCon();

        while (itr.hasNext()) {
            exeList.add(itr.next());
            if (exeList.size() < 500
                    && itr.hasNext()) {
                continue;
            }

            //500件分
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(sb.toString());

            sql.addSql(" CUP_SID in (");

            Iterator<Integer> exeItr = exeList.iterator();
            while (exeItr.hasNext()) {
                sql.addSql("   ?");
                sql.addIntValue(exeItr.next());

                if (exeItr.hasNext()) {
                    sql.addSql(",");
                }
            }
            sql.addSql(" )");
            try (PreparedStatement pstmt = con.prepareStatement(sql.toSqlString());) {
                sql.setParameter(pstmt);
                log__.info(sql.toLogString());
                count += pstmt.executeUpdate();

            }
            exeList.clear();
        }

        return count;
    }


    /**
     * <p>Create CHT_USER_UCONF Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created ChtUserUconfModel
     * @throws SQLException SQL実行例外
     */
    private ChtUserUconfModel __getChtUserUconfFromRs(ResultSet rs) throws SQLException {
        ChtUserUconfModel bean = new ChtUserUconfModel();
        bean.setUsrSid(rs.getInt("USR_SID"));
        bean.setCupSid(rs.getInt("CUP_SID"));
        bean.setCuucFavoriteKbn(rs.getInt("CUUC_FAVORITE_KBN"));
        bean.setCuucMuteKbn(rs.getInt("CUUC_MUTE_KBN"));
        return bean;
    }
}
