package jp.groupsession.v2.cht.model;

import java.util.List;

/**
 * <br>[機  能] チャットの送信，編集，削除時の内容を保持するクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChatSendEditModel {

    /** メッセージ区分(ユーザ, グループ) */
    private int selectKbn__;
    /** メッセージ送信先 */
    private int selectPartner__;
    /** 編集対象メッセージSID */
    private long editMessageSid__;
    /** 本文 */
    private String bodyText__;
    /** スタンプSID */
    private int stampSid__;
    /** メンション指定先 */
    private List<Integer> mentionUserSids__;
    /** 返信元投稿SID */
    private long replyMessageSid__;
    /** メッセージ送信時の既読化用メッセージSID */
    private long kidokuMessageSid__;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param selectKbn メッセージ区分
     * @param selectPartner メッセージ送信先
     * @param editMessageSid 編集対象メッセージSID
     * @param bodyText 本文
     * @param stampSid スタンプSID
     * @param mentionUserSids メンション指定先
     * @param replyMessageSid 返信元投稿SID
     */
    public ChatSendEditModel(
        int selectKbn, int selectPartner,
        long editMessageSid, String bodyText, int stampSid,
        List<Integer> mentionUserSids, long replyMessageSid) {

        selectKbn__ = selectKbn;
        selectPartner__ = selectPartner;
        if (stampSid == 0) {
            bodyText__ = bodyText;
        } else {
            bodyText__ = null;
        }
        editMessageSid__ = editMessageSid;
        stampSid__ = stampSid;
        mentionUserSids__ = mentionUserSids;
        replyMessageSid__ = replyMessageSid;
    }

    /**
     * @return the selectKbn
     */
    public int getSelectKbn() {
        return selectKbn__;
    }

    /**
     * @return the selectPartner
     */
    public int getSelectPartner() {
        return selectPartner__;
    }

    /**
     * @return the editMessageSid
     */
    public long getEditMessageSid() {
        return editMessageSid__;
    }

    /**
     * @return the bodyText
     */
    public String getBodyText() {
        return bodyText__;
    }

    /**
     * @return the stampSid
     */
    public int getStampSid() {
        return stampSid__;
    }

    /**
     * @return the mentionUserSids
     */
    public List<Integer> getMentionUserSids() {
        return mentionUserSids__;
    }

    /**
     * @return the replyMessageSid
     */
    public long getReplyMessageSid() {
        return replyMessageSid__;
    }

    /**
     * @return the kidokuMessageSid
     */
    public long getKidokuMessageSid() {
        return kidokuMessageSid__;
    }

    /**
     * @param kidokuMessageSid the kidokuMessageSid to set
     */
    public void setKidokuMessageSid(long kidokuMessageSid) {
        kidokuMessageSid__ = kidokuMessageSid;
    }
}
