package jp.groupsession.v2.cht.restapi;

import jp.groupsession.v2.restapi.exception.IReasonCode;

public enum ChtEnumReasonCode implements IReasonCode {
    /** WEBメールが利用できない */
    @ReasonCodeString("CHAT-000")
    PLUGIN_CANT_USE,

    /** 入力パラメータで指定したチャットルームへアクセスできない */
    @ReasonCodeString("CHAT-101")
    RESOURCE_CANT_ACCESS_CHAT,

    /** 対象のメッセージへアクセスできない */
    @ReasonCodeString("CHAT-102")
    RESOURCE_CANT_ACCESS_MESSAGES,

    /** 対象のメッセージの添付ファイルへアクセスできない */
    @ReasonCodeString("CHAT-103")
    RESOURCE_CANT_ACCESS_MESSAGES_TEMPFILE,

    /** 対象のスタンプへアクセスできない */
    @ReasonCodeString("CHAT-104")
    RESOURCE_CANT_ACCESS_STAMP,

    /** 対象のリアクションへアクセスできない */
    @ReasonCodeString("CHAT-105")
    RESOURCE_CANT_ACCESS_REACTION,

    /** 対象のチャットメッセージがピンどめされていない */
    @ReasonCodeString("CHAT-111")
    RESOURCE_CANT_ACCESS_MESSAGES_PINNED,

    /** 入力パラメータで指定したグループチャットがアーカイブされている */
    @ReasonCodeString("CHAT-106")
    RESOURCE_GROUP_ARCHIVE,

    /** 入力パラメータで指定したチャット相手が削除されている */
    @ReasonCodeString("CHAT-107")
    RESOURCE_USER_DELETE,

    /** 入力パラメータで指定したチャット相手へのチャットが特例アクセス設定で制限されている */
    @ReasonCodeString("CHAT-108")
    RESOURCE_USER_SPECIAL_ACCESS,

    /** 管理者設定でユーザ間チャットが停止されている */
    @ReasonCodeString("CHAT-109")
    RESOURCE_USER_CHAT_BAN,

    /** 入力パラメータで指定したチャット相手がチャットプラグインの利用を制限されている */
    @ReasonCodeString("CHAT-110")
    RESOURCE_USER_CANT_ACCESS_CHAT,

    /** 入力パラメータで指定したグループ情報へアクセスできない */
    @ReasonCodeString("CHAT-201")
    PARAM_CANT_ACCESS_GROUP,

    /** 入力パラメータで指定したメッセージへアクセスできない */
    @ReasonCodeString("CHAT-202")
    PARAM_CANT_ACCESS_MESSAGE,

    /** 入力パラメータで指定したスタンプへアクセスできない */
    @ReasonCodeString("CHAT-203")
    PARAM_CANT_ACCESS_STAMP;

}
