package jp.groupsession.v2.cht.restapi.entities;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Parameter;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
/** チャット情報Action */
@Plugin("chat")
public class ChtEntitiesAction extends AbstractRestApiAction {
    /**
     *
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesGetParamModel param,
        RestApiContext ctx) throws SQLException {

        ChtEntitiesGetBiz biz = new ChtEntitiesGetBiz(param,
                ctx);
        biz.execute();
        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .setMax(biz.getMax())
        .build().execute();
    }

    /**
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Get
    @Parameter(name = "type", value = "user")
    public void doGetUserChatInfo(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesGetParamModel param,
        RestApiContext ctx) throws SQLException {

        ChtEntitiesGetBiz biz = new ChtEntitiesGetBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
            .addResultList(biz.getResult())
            .build().execute();
    }

    /**
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Get
    @Parameter(name = "type", value = "group")
    public void doGetGroupChatInfo(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesGetParamModel param,
        RestApiContext ctx) throws SQLException {

        ChtEntitiesGetBiz biz = new ChtEntitiesGetBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
            .addResultList(biz.getResult())
            .build().execute();
    }
}
