package jp.groupsession.v2.cht.restapi.entities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.model.ChatGroupInfModel;
import jp.groupsession.v2.cht.model.ChatUserInfModel;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;

public class ChtEntitiesBiz {

    /**
     * ユーザチャット情報取得
     * [補足] 削除済みユーザに対応
     * @param ctx APIコンテキスト
     * @param sessionUsrSid セッションユーザSID
     * @param userInfList ユーザ情報リスト
     * @return ユーザチャット情報リスト
    */
    public static List<ChtEntitiesResultModel> getChatUserInfList(
                        RestApiContext ctx,
                        int sessionUsrSid,
                        List<CmnUsrmInfModel> userInfList)
                        throws SQLException {

        ChatDao chtDao = new ChatDao(ctx.getCon());
        ChtEntitiesResultModelConverter resultConverter = new ChtEntitiesResultModelConverter(ctx);
        List<ChatUserInfModel> chtInfolist = chtDao.getUserCntList(sessionUsrSid, userInfList);
        return resultConverter.convertUserInfModel(chtInfolist);
    }

    /**
     * グループチャット情報取得
     * [補足] 削除済みユーザに対応
     * @param ctx APIコンテキスト
     * @param sessionUsrSid セッションユーザSID
     * @param groupIdList グループIDリスト
     * @return グループチャット情報リスト
    */
    public static List<ChtEntitiesResultModel> getChatGroupInfList(
                        RestApiContext ctx,
                        int sessionUsrSid,
                        List<String> groupIdList)
                        throws SQLException {

        ChtGroupInfDao cgiDao = new ChtGroupInfDao(ctx.getCon());
        ChtEntitiesResultModelConverter resultConverter = new ChtEntitiesResultModelConverter(ctx);
        ArrayList<ChatGroupInfModel> infoList = cgiDao.selectGroup(sessionUsrSid, groupIdList);
        return resultConverter.convertGroupInfModel(infoList);
    }

    /**
     * メンバー情報ソート関数を生成
     * @param grpSidList
     * @param usrSidList
     * @return メンバー情報ソート関数
    */
    public static Comparator<ChtGroupUserModel> createMemberComparator(
        List<Integer> grpSidList,
        List<Integer> usrSidList) {
        Comparator<ChtGroupUserModel> comp = (mdl1, mdl2) -> {
            if (mdl1.getCguKbn() > mdl2.getCguKbn()) {
                return -1;
            }
            if (mdl1.getCguKbn() < mdl2.getCguKbn()) {
                return 1;
            }
            if (mdl1.getCguKbn() == GSConstChat.CHAT_KBN_GROUP) {
                int idx1 = grpSidList.indexOf(mdl1.getCguSelectSid());
                int idx2 = grpSidList.indexOf(mdl2.getCguSelectSid());
                if (idx1 < idx2) {
                    return -1;
                }
                if (idx1 > idx2) {
                    return 1;
                }
            } else {
                int idx1 = usrSidList.indexOf(mdl1.getCguSelectSid());
                int idx2 = usrSidList.indexOf(mdl2.getCguSelectSid());
                if (idx1 < idx2) {
                    return -1;
                }
                if (idx1 > idx2) {
                    return 1;
                }
            }
            return 0;
        };
        return comp;
    }

}
