package jp.groupsession.v2.cht.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtMemberBiz;
import jp.groupsession.v2.cht.biz.ChtSelectPartnerLoader;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.model.ChatGroupInfModel;
import jp.groupsession.v2.cht.model.ChatMidokuModel;
import jp.groupsession.v2.cht.model.ChatSearchModel;
import jp.groupsession.v2.cht.model.ChatUserInfModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.GroupModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

public class ChtEntitiesGetBiz {
    /** パラメータ*/
    ChtEntitiesGetParamModel param__;
    /** APIコンテキスト*/
    RestApiContext ctx__;

    /** 検索結果*/
    List<ChtEntitiesResultModel> result__ = List.of();
    /** 検索結果件数*/
    int max__ = 0;
    /** DAO チャット全般 */
    private ChatDao chtDao__;
    /** DAO チャットグループメンバー情報 */
    private ChtGroupUserDao cguDao__;
    /** DAO チャットグループ情報 */
    private ChtGroupInfDao cgiDao__;
    /** チャット管理者設定 */
    private ChtAdmConfModel adminConf__;
    /** リザルトモデルコンバータ */
    private ChtEntitiesResultModelConverter resultConverter__;

    /**
     * コンストラクタ
     * @param param パラメータ
     * @param ctx APIコンテキスト
     * @throws SQLException
     */
    public ChtEntitiesGetBiz(ChtEntitiesGetParamModel param,
            RestApiContext ctx) throws SQLException {
        param__ = param;
        ctx__ = ctx;
        Connection con = ctx__.getCon();
        chtDao__ = new ChatDao(con);
        cguDao__ = new ChtGroupUserDao(con);
        cgiDao__ = new ChtGroupInfDao(con);

        ChtBiz cBiz = new ChtBiz(con, ctx__.getRequestModel());
        adminConf__ = cBiz.getChtAconf();

        resultConverter__ = new ChtEntitiesResultModelConverter(ctx);
    }
    /**
     * ビジネスロジックを実行する
     * @throws SQLException
     */
    public void execute() throws SQLException {

        //指定されたユーザチャット情報, グループチャット情報の取得
        if (param__.getType() != null) {
            switch (param__.getType()) {
                case user:
                    __exeUserChatInfo();
                    break;
                case group:
                    __exeGroupChatInfo();
                    break;
                default:
                    break;
            }
            return;
        }

        switch (param__.getListType()) {
            case timeline:
                __exeTimeline();
                break;
            case group:
                __exeGroupChat();
                break;
            case user:
                __exeUserChat();
                break;
            case favorite:
                __exeFavoriteChat();
                break;
            case deleteUser:
                __exeDeletedUserChat();
                break;
            default:
                break;
        }
    }
    /**
     * タイムライン一覧を取得する
     */
    private void __exeTimeline() throws SQLException {


        int sessionUsrSid = ctx__.getRequestUserSid();
        UDate lastDate = param__.getOffsetDatetime();

        max__ = chtDao__.getTimelineListCount(sessionUsrSid, new UDate(), false);

        boolean onlyNoRead = false;

        //ベース情報(指定並び順)
        ArrayList<ChatMidokuModel> chtInfolist =
                chtDao__.getTimelineList(
                    sessionUsrSid,
                    lastDate,
                    onlyNoRead,
                    param__.getLimit());

        Set<Integer> grpChatSids = chtInfolist.stream()
        .filter(mdl -> mdl.getMidokuKbn() == GSConstChat.CHAT_KBN_GROUP)
        .map(ChatMidokuModel::getMidokuSid)
        .collect(Collectors.toSet());

        Set<Integer> usrChatSids = chtInfolist.stream()
        .filter(mdl -> mdl.getMidokuKbn() == GSConstChat.CHAT_KBN_USER)
        .map(ChatMidokuModel::getMidokuSid)
        .collect(Collectors.toSet());

        //チャットグループ情報
        Map<Integer, ChtGroupInfModel> grpInfMap =
            cgiDao__.selectGroupWhereCgiSid(
                grpChatSids.stream()
                    .map(sid -> String.valueOf(sid))
                    .toArray(String[]::new)
            )
            .stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getCgiSid(),
                    mdl -> mdl,
                    (s, a) -> a
                )
            );

        //メンバー情報(グループ)
        Map<Integer, List<ChtGroupUserModel>> grpMemberMap = new HashMap<>();
        Set<Integer> memberSidSet = new HashSet<>();
        for (ChtGroupUserModel cguMdl : cguDao__.select(grpChatSids)) {
            int cgiSid = cguMdl.getCgiSid();
            List<ChtGroupUserModel> list = grpMemberMap.get(cgiSid);
            if (list == null) {
                list = new ArrayList<>();
                grpMemberMap.put(cgiSid, list);
            }
            list.add(cguMdl);
            if (cguMdl.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                memberSidSet.add(cguMdl.getCguSelectSid());
            }
        }
        //メンバー情報(ユーザ)
        memberSidSet.add(sessionUsrSid);
        memberSidSet.addAll(usrChatSids);

        //メンバーグループMap(グループ並び順)
        GroupBiz grpBiz = new GroupBiz();
        final Map<Integer, GroupModel> grpMap = new LinkedHashMap<>();
        for (GroupModel grp: grpBiz.getGroupList(ctx__.getCon())) {
            grpMap.put(grp.getGroupSid(), grp);
        }
        final List<Integer> grpSidList =
            grpMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(memberSidSet, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }
        final List<Integer> usrSidList =
            usrMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバー情報ソート関数
        Comparator<ChtGroupUserModel> comp
                        = ChtEntitiesBiz.createMemberComparator(grpSidList, usrSidList);

        //チャット 特例アクセスにより、アクセスを禁止されているユーザ・グループを取得
        ChtMemberBiz chtMemBiz = new ChtMemberBiz(ctx__.getCon());
        List<Integer> tokureiMemberList
                   = chtMemBiz.getTokureiUser(sessionUsrSid,
                                               chtMemBiz.getTokureiGroup(sessionUsrSid));

        //プラグイン使用可能ユーザSID一覧
        CommonBiz cmnBiz = new CommonBiz();
        List<Integer> canUsePluginUsrSids =
            cmnBiz.getCanUsePluginUser(
                ctx__.getCon(),
                GSConstChat.PLUGIN_ID_CHAT,
                usrSidList
                );
        result__ = new ArrayList<>();
        for (ChatMidokuModel inf : chtInfolist) {
            ChtEntitiesResultModel mdl = new ChtEntitiesResultModel();

            if (inf.getMidokuKbn() == GSConstChat.CHAT_KBN_GROUP) {
                ChtGroupInfModel infMdl = grpInfMap.get(inf.getMidokuSid());
                mdl.setType(EnumChatType.group);
                mdl.setId(inf.getMidokuId());
                mdl.setName(inf.getMidokuName());
                mdl.setMemo(infMdl.getCgiContent());
                mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_NOT_MODE);

                if (infMdl.getCgiCompFlg() == GSConstChat.CHAT_ARCHIVE_MODE) {
                    mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_MODE);
                    mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
                }

                List<ChtEntitiesResultModel.MemberModel> memList =
                    grpMemberMap.get(inf.getMidokuSid())
                    .stream()
                    .sorted(comp)
                    .map(memInf -> {
                        ChtEntitiesResultModel.MemberModel ret = null;
                        if (memInf.getCguKbn() == GSConstChat.CHAT_KBN_GROUP) {
                            GroupModel grp = grpMap.get(memInf.getCguSelectSid());
                            if (grp != null) {
                                ret = new ChtEntitiesResultModel.MemberModel(
                                    grpMap.get(memInf.getCguSelectSid()),
                                    memInf
                                );
                            }
                        } else {
                            ret = new ChtEntitiesResultModel.MemberModel(
                                sessionUsrSid,
                                usrMap.get(memInf.getCguSelectSid()),
                                memInf
                            );
                        }
                        return ret;
                    })
                    .filter(m -> m != null)
                    .collect(Collectors.toList());
                mdl.setMemberConfigArray(memList);
                result__.add(mdl);
            }
            if (inf.getMidokuKbn() == GSConstChat.CHAT_KBN_USER) {
                mdl.setType(EnumChatType.user);
                mdl.setId(inf.getMidokuId());
                mdl.setName(inf.getMidokuName());
                mdl.setMemo("");
                mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_NOT_MODE);

                MinimalUserInfoModel partner;
                partner = new MinimalUserInfoModel(
                    sessionUsrSid,
                    usrMap.get(inf.getMidokuSid())
                );
                mdl.setPartnerInfo(partner);

                if (partner.getUserDeleteFlg() == GSConst.JTKBN_DELETE) {
                    mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_MODE);
                    mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
                }
                if (tokureiMemberList.contains(inf.getMidokuSid())) {
                    mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
                }
                if (canUsePluginUsrSids.contains(inf.getMidokuSid()) == false) {
                    mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
                }
                if (adminConf__.getCacChatFlg() == GSConstChat.LIMIT_BETWEEN_USERS) {
                    mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
                }

                result__.add(mdl);
            }

            mdl.setLastPostDate(inf.getMidokuDate());
            mdl.setNonReadCountNum(inf.getMidokuCount());
            mdl.setArchiveFlg(inf.getArchiveFlg());
            mdl.setMuteFlg(inf.getMuteFlg());
            mdl.setFavoriteFlg(inf.getFavoriteFlg());


        }

    }

    /**
     * ユーザチャット一覧を取得する
     * @throws SQLException
     */
    private void __exeUserChat()  throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();
        String groupSidStr = "";
        if (param__.getGroupId() != null) {
            CmnGroupmDao gdao = new CmnGroupmDao(ctx__.getCon());
            CmnGroupmModel grpMdl = gdao.getGroupInf(param__.getGroupId());
            if (grpMdl == null) {
                groupSidStr = null;
            } else {
                groupSidStr = String.format("%d", grpMdl.getGrpSid());
            }
        } else if (param__.getMyGroupSid() > 0) {
            groupSidStr = String.format("M%d", param__.getMyGroupSid());
        }

        //ベース情報(指定並び順)
        ChtSelectPartnerLoader pl = new ChtSelectPartnerLoader(
            ctx__.getCon(),
            groupSidStr,
            sessionUsrSid);
        pl.exexute(param__.getLimit(), param__.getOffset());
        List<ChatUserInfModel> chtInfolist = pl.getResult();
        max__ = pl.getMax();

        result__ = resultConverter__.convertUserInfModel(chtInfolist);
    }
    
    /**
     * 削除済みユーザチャット一覧を取得する
     * @throws SQLException
     */
    private void __exeDeletedUserChat()  throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();

        //ベース情報(指定並び順)
        ChtSelectPartnerLoader pl = new ChtSelectPartnerLoader(
            ctx__.getCon(),
            "-2",
            sessionUsrSid);
        pl.exexute(param__.getLimit(), param__.getOffset());
        List<ChatUserInfModel> chtInfolist = pl.getResult();
        max__ = pl.getMax();

        result__ = resultConverter__.convertUserInfModel(chtInfolist);
    }

    /**
     *  お気に入り一覧を取得する
     * @throws SQLException
     */
    private void __exeFavoriteChat()  throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();

        int grpCnt = chtDao__.favoriteGroupCount(sessionUsrSid);
        int usrCnt = chtDao__.favoriteUserCount(sessionUsrSid);

        max__ = grpCnt + usrCnt;
        int offset = param__.getOffset();
        int limit = param__.getLimit();
        if (offset >= max__) {
            return;
        }
        if (offset + limit < grpCnt) {
            result__ = __getFavoriteGroupChat(limit, offset);
            return;
        }
        if (offset >= grpCnt) {
            offset -= grpCnt;
            result__ = __getFavoriteUserChat(limit, offset);
            return;
        }

        List<ChtEntitiesResultModel> grpList = __getFavoriteGroupChat(limit, offset);
        limit -= grpList.size();
        offset = 0;
        List<ChtEntitiesResultModel> usrList = __getFavoriteUserChat(limit, offset);
        result__ = grpList;
        result__.addAll(usrList);

    }
    /**
     * グループチャットのお気に入りを取得する
     * @param limit
     * @param offset
     * @return グループチャットのお気に入り
     * @throws SQLException
    */
    private List<ChtEntitiesResultModel> __getFavoriteGroupChat(
        int limit, int offset)  throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();
        List<ChatGroupInfModel> gInfMdlList = chtDao__.favoriteGroupSelect(sessionUsrSid);
        if (gInfMdlList.size() == 0) {
            return List.of();
        }
        if (limit >= 0) {
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            if (start >= gInfMdlList.size()) {
                return List.of();
            }
            int end = start + limit;
            if (end >= gInfMdlList.size()) {
                end = gInfMdlList.size();
            }

            gInfMdlList = gInfMdlList.subList(start, end);
        }

        //ベース情報(指定並び順)
        Set<Integer> sids = gInfMdlList.stream()
                                .map(ChatGroupInfModel::getCgiSid)
                                .collect(Collectors.toSet());

        //チャットグループ情報
        Map<Integer, ChtGroupInfModel> grpInfMap =
            cgiDao__.selectGroupWhereCgiSid(
                sids.stream()
                    .map(sid -> String.valueOf(sid))
                    .toArray(String[]::new)
            )
            .stream()
            .collect(
                Collectors.toMap(
                    mdl -> mdl.getCgiSid(),
                    mdl -> mdl,
                    (s, a) -> a
                )
            );


        //メンバー情報
        Map<Integer, List<ChtGroupUserModel>> grpMemberMap = new HashMap<>();
        Set<Integer> memberSidSet = new HashSet<>();
        for (ChtGroupUserModel cguMdl : cguDao__.select(sids)) {
            int cgiSid = cguMdl.getCgiSid();
            List<ChtGroupUserModel> list = grpMemberMap.get(cgiSid);
            if (list == null) {
                list = new ArrayList<>();
                grpMemberMap.put(cgiSid, list);
            }
            list.add(cguMdl);
            if (cguMdl.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                memberSidSet.add(cguMdl.getCguSelectSid());
            }
        }
        //メンバーグループMap(グループ並び順)
        GroupBiz grpBiz = new GroupBiz();
        final Map<Integer, GroupModel> grpMap = new LinkedHashMap<>();
        for (GroupModel grp: grpBiz.getGroupList(ctx__.getCon())) {
            grpMap.put(grp.getGroupSid(), grp);
        }
        final List<Integer> grpSidList =
            grpMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(memberSidSet, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }
        final List<Integer> usrSidList =
            usrMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバー情報ソート関数
        Comparator<ChtGroupUserModel> comp
                        = ChtEntitiesBiz.createMemberComparator(grpSidList, usrSidList);

        List<ChtEntitiesResultModel> result = new ArrayList<>();
        for (ChatGroupInfModel inf : gInfMdlList) {
            ChtEntitiesResultModel mdl = new ChtEntitiesResultModel();
            ChtGroupInfModel cgiMdl = grpInfMap.get(inf.getCgiSid());

            mdl.setType(EnumChatType.group);
            mdl.setId(cgiMdl.getCgiId());
            mdl.setName(cgiMdl.getCgiName());
            mdl.setMemo(cgiMdl.getCgiContent());
            mdl.setLastPostDate(inf.getChtLastDate());
            mdl.setNonReadCountNum(inf.getChtGroupCount());
            mdl.setArchiveFlg(inf.getCgiCompFlg());
            mdl.setMuteFlg(inf.getCgucMuteKbn());
            mdl.setFavoriteFlg(inf.getCgucFavoriteKbn());

            if (inf.getCgiCompFlg() == GSConstChat.CHAT_ARCHIVE_MODE) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }

            List<ChtEntitiesResultModel.MemberModel> memList =
                grpMemberMap.get(inf.getCgiSid())
                .stream()
                .sorted(comp)
                .map(memInf -> {
                    ChtEntitiesResultModel.MemberModel ret = null;
                    if (memInf.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                        ret = new ChtEntitiesResultModel.MemberModel(
                            sessionUsrSid,
                            usrMap.get(memInf.getCguSelectSid()),
                            memInf
                        );
                    } else {
                        GroupModel grp = grpMap.get(memInf.getCguSelectSid());
                        if (grp != null) {
                            ret = new ChtEntitiesResultModel.MemberModel(
                                grpMap.get(memInf.getCguSelectSid()),
                                memInf
                            );
                        }
                    }
                    return ret;
                })
                .filter(m -> m != null)
                .collect(Collectors.toList());
            mdl.setMemberConfigArray(memList);

            result.add(mdl);

        }
        return result;
    }
    /**
     * ユーザチャットのお気に入りを取得する
     * @param limit
     * @param offset
     * @return ユーザチャットのお気に入り
     * @throws SQLException
    */
    private List<ChtEntitiesResultModel> __getFavoriteUserChat(
        int limit, int offset)  throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();
        ArrayList<Integer> userSidList = chtDao__.favoriteUserSelect(sessionUsrSid);
        UserBiz userBiz = new UserBiz();
        String[] userSids = userSidList.stream()
            .map(mdl -> String.valueOf(mdl))
            .toArray(String[]::new);
        List<CmnUsrmInfModel> userList =
            userBiz.getUserList(ctx__.getCon(), userSids, GSConstUser.USER_JTKBN_ALL);
        if (limit >= 0) {
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            if (start >= userList.size()) {
                return List.of();
            }
            int end = start + limit;
            if (end >= userList.size()) {
                end = userList.size();
            }

            userList = userList.subList(start, end);
        }


        List<ChatUserInfModel> cmnUserList = chtDao__.getUserCntList(sessionUsrSid, userList);
        if (cmnUserList.size() == 0) {
            return List.of();
        }
        Set<Integer> usrChatSids = cmnUserList.stream()
        .map(ChatUserInfModel::getUsrSid)
        .collect(Collectors.toSet());

        //メンバー情報(ユーザ)
        Set<Integer> memberSidSet = new HashSet<>();
        memberSidSet.add(sessionUsrSid);
        memberSidSet.addAll(usrChatSids);
        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(memberSidSet, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }

        //チャット 特例アクセスにより、アクセスを禁止されているユーザ・グループを取得
        ChtMemberBiz chtMemBiz = new ChtMemberBiz(ctx__.getCon());
        List<Integer> tokureiMemberList
                   = chtMemBiz.getTokureiUser(sessionUsrSid,
                                               chtMemBiz.getTokureiGroup(sessionUsrSid));

        //プラグイン使用可能ユーザSID一覧
        CommonBiz cmnBiz = new CommonBiz();
        List<Integer> canUsePluginUsrSids =
            cmnBiz.getCanUsePluginUser(
                ctx__.getCon(),
                GSConstChat.PLUGIN_ID_CHAT,
                usrChatSids.stream()
                    .collect(Collectors.toList())
                );




        List<ChtEntitiesResultModel> result = new ArrayList<>();
        for (ChatUserInfModel inf : cmnUserList) {
            ChtEntitiesResultModel mdl = new ChtEntitiesResultModel();
            CmnUserModel usrMdl = usrMap.get(inf.getUsrSid());

            mdl.setType(EnumChatType.user);
            mdl.setId(usrMdl.getUsrLgid());
            mdl.setName(usrMdl.getUsiName());
            mdl.setMemo("");
            mdl.setLastPostDate(inf.getChtLastDate());
            mdl.setNonReadCountNum(inf.getChtUserCount());
            mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_NOT_MODE);
            mdl.setMuteFlg(inf.getCuucMuteKbn());
            mdl.setFavoriteFlg(inf.getCuucFavoriteKbn());

            MinimalUserInfoModel partner;
            partner = new MinimalUserInfoModel(
                sessionUsrSid,
                usrMdl
            );
            mdl.setPartnerInfo(partner);

            if (partner.getUserDeleteFlg() == GSConst.JTKBN_DELETE) {
                mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_MODE);
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }

            if (tokureiMemberList.contains(inf.getUsrSid())) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }
            if (canUsePluginUsrSids.contains(inf.getUsrSid()) == false) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }
            if (adminConf__.getCacChatFlg() == GSConstChat.LIMIT_BETWEEN_USERS) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }

            result.add(mdl);
        }
        return result;
    }

    /**
     *  チャットグループ情報一覧を取得する
     * @throws SQLException
     */
    private void __exeGroupChat() throws SQLException {
        int sessionUsrSid = ctx__.getRequestUserSid();
        //チャットグループ情報の取得
        ChatSearchModel searchModel = new ChatSearchModel();
        searchModel.setBelongMemberSid(sessionUsrSid);
        searchModel.setCategory(GSConstChat.CHAT_CHC_SID_ALL);
        // 最大件数
        max__ = chtDao__.getChatGroupDataCount(searchModel);

        // １ページの最大表示件数
        int viewCnt = param__.getLimit();
        int offset = param__.getOffset();
        if (offset >= max__) {
            return;
        }

        //ベース情報(指定並び順)
        List<ChatGroupInfModel> chtInfolist = cgiDao__.selectGroup(sessionUsrSid);

        if (viewCnt >= 0) {
            int start = offset;
            if (start < 0) {
                start = 0;
            }
            if (start >= chtInfolist.size()) {
                return;
            }
            int end = start + viewCnt;
            if (end >= chtInfolist.size()) {
                end = chtInfolist.size();
            }

            chtInfolist = chtInfolist.subList(start, end);
        }

        result__ = resultConverter__.convertGroupInfModel(chtInfolist);

    }

    /**
     *  指定したグループチャットの情報を取得する
     * @throws SQLException
     */
    private void __exeGroupChatInfo()  throws SQLException {

        //存在しない/アクセスできないグループの場合、エラーを返す
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);
        ceiBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());

        int sessionUsrSid = ctx__.getRequestUserSid();
        //チャットグループ情報の取得
        List<String> groupIdList = Arrays.asList(new String[]{param__.getChatGroupId()});
        result__ = ChtEntitiesBiz.getChatGroupInfList(ctx__, sessionUsrSid, groupIdList);
    }

    /**
     *  指定したユーザチャットの情報を取得する
     * @throws SQLException
     */
    private void __exeUserChatInfo()  throws SQLException {

        //指定したユーザの情報を取得する(取得できない場合エラーを返す)
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);
        CmnUsrmModel usrMdl = ceiBiz.getUserChatInf(param__.getUserId());

        int sessionUsrSid = ctx__.getRequestUserSid();
        //ユーザチャット情報の取得
        CmnUsrmInfDao uInfDao = new CmnUsrmInfDao(ctx__.getCon());
        ArrayList<CmnUsrmInfModel> userList = new ArrayList<CmnUsrmInfModel>();
        userList.add(uInfDao.select(usrMdl.getUsrSid()));
        result__ = ChtEntitiesBiz.getChatUserInfList(ctx__, sessionUsrSid, userList);
    }

    /**
     *
     * @return APIレスポンスモデル
     */
    public List<ChtEntitiesResultModel> getResult() {
        return result__;
    }

    /**
     *
     * @return 検索結果件数
     */
    public int getMax() {
        return max__;
    }

}
