package jp.groupsession.v2.cht.restapi.entities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnMyGroupDao;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnMyGroupModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.ReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat.Format;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtEntitiesGetParamModel {
    /** 取得件数 */
    @Default("50")
    @MaxValue(100)
    @MinValue(1)
    private int limit__;

    /** 取得開始位置 */
    @Default("0")
    @MinValue(0)
    private int offset__;

    /**チャット一覧タイプ */
    @Default("timeline")
    @Selectable({
        /**タイムライン */
        "timeline",
        /**グループ */
        "group",
        /**ユーザ */
        "user",
        /**お気に入り */
        "favorite",
        /** 削除済みユーザ */
        "deleteUser"
    })
    private EnumChatListType listType__;

    /**所属グループID */
    private String groupId__;

    /**マイグループID */
    @Default("0")
    private int myGroupSid__;


    /** 取得開始位置(日時) */
    @UDateFormat(Format.DATETIME_SLUSH)
    private UDate offsetDatetime__ = new UDate();

    /** チャットタイプ(パスパラメータ) */
    private EnumChatType type__;

    /** ユーザID(パスパラメータ) */
    private String userId__;
    /** グループID(パスパラメータ) */
    private String chatGroupId__;

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }

    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * @return the listType
     */
    public EnumChatListType getListType() {
        return listType__;
    }

    /**
     * @param listType the listType to set
     */
    public void setListType(EnumChatListType listType) {
        listType__ = listType;
    }

    /**
     * @return the groupId
     */
    public String getGroupId() {
        return groupId__;
    }

    /**
     * @param groupId the groupId to set
     */
    public void setGroupId(String groupId) {
        groupId__ = groupId;
    }

    /**
     * @return the offsetDatetime
     */
    public UDate getOffsetDatetime() {
        return offsetDatetime__;
    }

    /**
     * @param offsetDatetime the offsetDatetime to set
     */
    public void setOffsetDatetime(UDate offsetDatetime) {
        offsetDatetime__ = offsetDatetime;
    }

    /**
     * @return the myGroupId
     */
    public int getMyGroupSid() {
        return myGroupSid__;
    }

    /**
     * @param myGroupSid the myGroupId to set
     */
    public void setMyGroupSid(int myGroupSid) {
        myGroupSid__ = myGroupSid;
    }

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }

    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }

    /**
     *  入力チェック
     * @param ctx
     * @throws SQLException
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException  {
        List<RestApiValidateException> errors = new ArrayList<>();
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());

        if (getListType() == EnumChatListType.user
             && NullDefault.getString(groupId__, "").length() == 0
             && myGroupSid__ < 1) {
            errors.add(new RestApiValidateException(
                            ReasonCode.EnumError.PARAM_REQUIRED,
                            "error.input.comp.text.either.need",
                            "groupId",
                            "myGroupSid"));
            throw new RestApiValidateExceptionNest(
                errors
            );
        } else if (getListType() == EnumChatListType.user
            && !StringUtil.isNullZeroString(groupId__)) {

            //指定グループIDの存在チェック
            CmnGroupmDao grpDao = new CmnGroupmDao(ctx.getCon());

            List<CmnGroupmModel> grpList = grpDao.selectGrpData(
                new String[] {groupId__},
                 GSConst.JTKBN_TOROKU);

            if (grpList.size() == 0) {
                errors.add(new RestApiValidateException(
                        ChtEnumReasonCode.PARAM_CANT_ACCESS_GROUP,
                        "search.data.notfound",
                        gsMsg.getMessage("cmn.group")
                        )
                        .setParamName("groupId"));
            }
            //グループIDが入力されている時は、myGroupSidを使用しない
        } else if (getListType() == EnumChatListType.user && myGroupSid__ > 0) {
            CmnMyGroupDao myGrpDao = new CmnMyGroupDao(ctx.getCon());
            int sessionUsrSid = ctx.getRequestUserSid();
            List<CmnMyGroupModel> myGrpList =
                myGrpDao.getMyGroupList(sessionUsrSid, String.valueOf(myGroupSid__));
            
            if (myGrpList.isEmpty()) {
                errors.add(new RestApiValidateException(
                    ChtEnumReasonCode.PARAM_CANT_ACCESS_GROUP,
                    "search.data.notfound",
                    gsMsg.getMessage("cmn.mygroup")
                    )
                    .setParamName("myGroupSid"));
            }
        }
        if (errors.size() > 0) {
            //複数の入力チェック例外をまとめて返す
            throw new RestApiValidateExceptionNest(
                errors
                );
        }


    }



}
