package jp.groupsession.v2.cht.restapi.entities;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

import jp.groupsession.v2.cht.dao.ChtGroupInfDao;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 指定したユーザ/グループチャット情報を取得するクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtEntitiesInfoBiz {

    /** コネクション */
    private Connection con__;
    /** メッセージ */
    private GsMessage gsMsg__;

    /**
     * <br>[機  能] 機能
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param gsMsg メッセージ
     */
    public ChtEntitiesInfoBiz(Connection con, GsMessage gsMsg) {
        con__ = con;
        gsMsg__ = gsMsg;
    }

    /**
     * <br>[機  能] グループチャット情報を取得する
     * <br>[解  説]
     * <br>[備  考] チャット情報が取得できなかった場合エラーを返す
     * @param groupId グループID
     * @param sessionUsrSid セッションユーザSID
     * @return グループ情報
     * @throws SQLException
     * @throws RestApiPermissionException チャット情報が取得できなかった
     */
    public ChtGroupInfModel getGroupChatInf(
        String groupId, int sessionUsrSid) throws SQLException, RestApiPermissionException {
        ChtGroupInfDao cgiDao = new ChtGroupInfDao(con__);

        ChtGroupInfModel gmdl = cgiDao.selectById(groupId, sessionUsrSid);
        if (gmdl == null) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.33")
            );
        }
        return gmdl;
    }

    /**
     * <br>[機  能] 削除済みのユーザとのチャット情報を取得する
     * <br>[解  説]
     * <br>[備  考] チャット情報が取得できなかった場合エラーを返す
     * @param partnerUsrSid 削除済みユーザSID
     * @param partnerUsrId 削除済みユーザのユーザID
     * @return グループ情報
     * @throws SQLException
     * @throws RestApiPermissionException チャット情報が取得できなかった
     */
    public CmnUsrmModel getDeletedUserChatInf(
        int partnerUsrSid, String partnerUsrId) throws SQLException, RestApiPermissionException {

        if (partnerUsrSid == GSConst.SYSTEM_USER_ADMIN
            || partnerUsrSid == GSConst.SYSTEM_USER_MAIL) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.48")
            );
        }

        CmnUsrmDao usrDao = new CmnUsrmDao(con__);
        CmnUsrmModel umdl = usrDao.select(partnerUsrSid);

        if (umdl == null || !Objects.equals(umdl.getUsrLgid(), partnerUsrId)
                || umdl.getUsrJkbn() != GSConst.JTKBN_DELETE) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.48")
            );
        }
        return umdl;
    }

    /**
     * <br>[機  能] 指定したユーザとのチャット情報を取得する
     * <br>[解  説]
     * <br>[備  考] チャット情報が取得できなかった場合エラーを返す
     * @param userId ユーザID
     * @return グループ情報
     * @throws SQLException
     * @throws RestApiPermissionException チャット情報が取得できなかった
     */
    public CmnUsrmModel getUserChatInf(
        String userId) throws SQLException, RestApiPermissionException {

        CmnUsrmDao usrDao = new CmnUsrmDao(con__);
        CmnUsrmModel umdl = usrDao.select(userId);
        if (umdl == null
            || umdl.getUsrSid() == GSConst.SYSTEM_USER_ADMIN
            || umdl.getUsrSid() == GSConst.SYSTEM_USER_MAIL) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_CHAT,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.48")
            );
        }
        return umdl;
    }

}
