package jp.groupsession.v2.cht.restapi.entities;

import java.util.List;
import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cmn.dao.GroupModel;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat.Format;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.restapi.response.annotation.ChildElementName;


public class ChtEntitiesResultModel {
    /** チャットタイプ */
    EnumChatType type__;
    /** チャットルームID */
    String id__;

    /** チャットルーム名 */
    private String name__;
    /** 備考 */
    private String memo__;
    /** 最終投稿日時 */
    @UDateFormat(Format.DATETIME_SLUSH)
    private UDate lastPostDate__;
    /** 未読件数 */
    private int nonReadCountNum__;
    /** お気に入りフラグ */
    private int favoriteFlg__;
    /** 投稿可能フラグ */
    private int postableFlg__ = 1;
    /** ミュートフラグ */
    private int muteFlg__;
    /** チャット相手情報 */
    MinimalUserInfoModel partnerInfo__;
    /** アーカイブフラグ */
    private int archiveFlg__;
    /** メンバー設定情報 */
    @ChildElementName("memberConfigInfo")
    private List<MemberModel>memberConfigArray__;

    /** メンバー設定情報 */
    public static class MemberModel {
        /** ユーザ */
        private final CmnUserModel usrMdl__;
        /** グループ */
        private final GroupModel  grpMdl__;
        /** グループメンバー設定 */
        private final ChtGroupUserModel grpMemMdl__;

        /** メンバータイプ */
        private final EnumMemberType type__;
        /** セッションユーザSID */
        private final int sessionUsrSid__;

        /**
         * @param sessionUsrSid
         * @param usrMdl
         * @param grpMemMdl
         */
        public MemberModel(
            int sessionUsrSid, CmnUserModel usrMdl, ChtGroupUserModel grpMemMdl) {

            usrMdl__ = usrMdl;
            grpMdl__ = null;
            type__ = EnumMemberType.user;
            grpMemMdl__ = grpMemMdl;
            sessionUsrSid__ = sessionUsrSid;
        }


        /**
         * @param grpMdl
         * @param grpMemMdl
         */
        public MemberModel(GroupModel grpMdl, ChtGroupUserModel grpMemMdl) {
            usrMdl__ = null;
            grpMdl__ = grpMdl;
            type__ = EnumMemberType.group;
            grpMemMdl__ = grpMemMdl;
            sessionUsrSid__ = 0;
        }


        /**
         * @return the id
         */
        public String getId() {
            if (type__ == EnumMemberType.group) {
                return grpMdl__.getGroupId();
            } else {
                return usrMdl__.getUsrLgid();
            }
        }


        /**
         * @return the name
         */
        public String getName() {
            if (type__ == EnumMemberType.group) {
                return grpMdl__.getGroupName();
            } else {
                return usrMdl__.getUsiName();
            }
        }


        /**
         * @return the adminFlg
         */
        public int getAdminFlg() {
            return grpMemMdl__.getCguAdminFlg();
        }


        /**
         * @return the loginStopFlg
         */
        public int getLoginStopFlg() {
            if (type__ == EnumMemberType.group) {
                return 0;
            } else {
                return usrMdl__.getUsrUkoFlg();
            }
        }



        /**
         * @return the userDeleteFlg
         */
        public int getUserDeleteFlg() {
            if (type__ == EnumMemberType.group) {
                return 0;
            } else {
                return usrMdl__.getUsrJkbn();
            }
        }


        /**
         * @return the imageBinSid
         */
        public long getImageBinSid() {
            if (type__ == EnumMemberType.group) {
                return 0;
            } else {
                if (getImageKoukaiFlg() == 1
                    && sessionUsrSid__ != usrMdl__.getUsrSid()) {
                   return 0;
                }
                return usrMdl__.getBinSid();
            }
        }


        /**
         * @return the imageKoukaiFlg
         */
        public int getImageKoukaiFlg() {
            if (type__ == EnumMemberType.group) {
                return 0;
            } else {
                return usrMdl__.getUsiPictKf();
            }
        }


        /**
         * @return the type
         */
        public EnumMemberType getType() {
            return type__;
        }

    }

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id__;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        id__ = id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name__;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        name__ = name;
    }

    /**
     * @return the memo
     */
    public String getMemo() {
        return memo__;
    }

    /**
     * @param memo the memo to set
     */
    public void setMemo(String memo) {
        memo__ = memo;
    }

    /**
     * @return the lastPostDate
     */
    public UDate getLastPostDate() {
        return lastPostDate__;
    }

    /**
     * @param lastPostDate the lastPostDate to set
     */
    public void setLastPostDate(UDate lastPostDate) {
        lastPostDate__ = lastPostDate;
    }

    /**
     * @return the nonReadCountNum
     */
    public int getNonReadCountNum() {
        return nonReadCountNum__;
    }

    /**
     * @param nonReadCountNum the nonReadCountNum to set
     */
    public void setNonReadCountNum(int nonReadCountNum) {
        nonReadCountNum__ = nonReadCountNum;
    }

    /**
     * @return the favoriteFlg
     */
    public int getFavoriteFlg() {
        return favoriteFlg__;
    }

    /**
     * @param favoriteFlg the favoriteFlg to set
     */
    public void setFavoriteFlg(int favoriteFlg) {
        favoriteFlg__ = favoriteFlg;
    }

    /**
     * @return the postableFlg
     */
    public int getPostableFlg() {
        return postableFlg__;
    }

    /**
     * @param postableFlg the postableFlg to set
     */
    public void setPostableFlg(int postableFlg) {
        postableFlg__ = postableFlg;
    }

    /**
     * @return the muteFlg
     */
    public int getMuteFlg() {
        return muteFlg__;
    }

    /**
     * @param muteFlg the muteFlg to set
     */
    public void setMuteFlg(int muteFlg) {
        muteFlg__ = muteFlg;
    }

    /**
     * @return the partnerInfo
     */
    public MinimalUserInfoModel getPartnerInfo() {
        return partnerInfo__;
    }

    /**
     * @param partnerInfo the partnerInfo to set
     */
    public void setPartnerInfo(MinimalUserInfoModel partnerInfo) {
        partnerInfo__ = partnerInfo;
    }

    /**
     * @return the archiveFlg
     */
    public int getArchiveFlg() {
        return archiveFlg__;
    }

    /**
     * @param archiveFlg the archiveFlg to set
     */
    public void setArchiveFlg(int archiveFlg) {
        archiveFlg__ = archiveFlg;
    }

    /**
     * @return the memberConfigArray
     */
    public List<MemberModel> getMemberConfigArray() {
        return memberConfigArray__;
    }

    /**
     * @param memberConfigArray the memberConfigArray to set
     */
    public void setMemberConfigArray(List<MemberModel> memberConfigArray) {
        memberConfigArray__ = memberConfigArray;
    }


}

