package jp.groupsession.v2.cht.restapi.entities;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtMemberBiz;
import jp.groupsession.v2.cht.dao.ChtGroupUserDao;
import jp.groupsession.v2.cht.model.ChatGroupInfModel;
import jp.groupsession.v2.cht.model.ChatUserInfModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupUserModel;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.dao.GroupModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;

public class ChtEntitiesResultModelConverter {
    /** APIコンテキスト*/
    RestApiContext ctx__;
    /** チャット管理者設定 */
    private ChtAdmConfModel adminConf__;

    /**
     * コンストラクタ
     * @param ctx APIコンテキスト
     * @throws SQLException
     */
    public ChtEntitiesResultModelConverter(RestApiContext ctx) throws SQLException {
        ctx__ = ctx;

        ChtBiz cBiz = new ChtBiz(ctx__.getCon(), ctx__.getRequestModel());
        adminConf__ = cBiz.getChtAconf();
    }

    /**
     *
     * @param groupInfList
     * @return レスポンスモデルへ変換して返す
     * @throws SQLException
     */
    public List<ChtEntitiesResultModel> convertGroupInfModel(List<ChatGroupInfModel> groupInfList)
                    throws SQLException {
        List<ChtEntitiesResultModel> result = List.of();

        int sessionUsrSid = ctx__.getRequestUserSid();

        //グループSIDリスト(指定並び順)
        Set<Integer> sids = groupInfList.stream()
                                .map(ChatGroupInfModel::getCgiSid)
                                .collect(Collectors.toSet());

        //メンバー情報
        Map<Integer, List<ChtGroupUserModel>> grpMemberMap = new HashMap<>();
        Set<Integer> memberSidSet = new HashSet<>();
        ChtGroupUserDao cguDao = new ChtGroupUserDao(ctx__.getCon());
        for (ChtGroupUserModel cguMdl : cguDao.select(sids)) {
            int cgiSid = cguMdl.getCgiSid();
            List<ChtGroupUserModel> list = grpMemberMap.get(cgiSid);
            if (list == null) {
                list = new ArrayList<>();
                grpMemberMap.put(cgiSid, list);
            }
            list.add(cguMdl);
            if (cguMdl.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                memberSidSet.add(cguMdl.getCguSelectSid());
            }
        }
        //メンバーグループMap(グループ並び順)
        GroupBiz grpBiz = new GroupBiz();
        final Map<Integer, GroupModel> grpMap = new LinkedHashMap<>();
        for (GroupModel grp: grpBiz.getGroupList(ctx__.getCon())) {
            grpMap.put(grp.getGroupSid(), grp);
        }
        final List<Integer> grpSidList =
            grpMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(memberSidSet, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }
        final List<Integer> usrSidList =
            usrMap.keySet().stream()
            .collect(Collectors.toList());

        //メンバー情報ソート関数
        Comparator<ChtGroupUserModel> comp
                        = ChtEntitiesBiz.createMemberComparator(grpSidList, usrSidList);

        result = new ArrayList<>();
        for (ChatGroupInfModel inf : groupInfList) {
            ChtEntitiesResultModel mdl = new ChtEntitiesResultModel();
            mdl.setType(EnumChatType.group);
            mdl.setId(inf.getCgiId());
            mdl.setName(inf.getCgiName());
            mdl.setMemo(inf.getCgiContent());
            mdl.setLastPostDate(inf.getChtLastDate());
            mdl.setNonReadCountNum(inf.getChtGroupCount());
            mdl.setArchiveFlg(inf.getCgiCompFlg());
            mdl.setMuteFlg(inf.getCgucMuteKbn());
            mdl.setFavoriteFlg(inf.getCgucFavoriteKbn());

            if (inf.getCgiCompFlg() == GSConstChat.CHAT_ARCHIVE_MODE) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }


            List<ChtEntitiesResultModel.MemberModel> memList =
                grpMemberMap.get(inf.getCgiSid())
                .stream()
                .sorted(comp)
                .map(memInf -> {
                    ChtEntitiesResultModel.MemberModel ret = null;
                    if (memInf.getCguKbn() == GSConstChat.CHAT_KBN_USER) {
                        ret = new ChtEntitiesResultModel.MemberModel(
                            sessionUsrSid,
                            usrMap.get(memInf.getCguSelectSid()),
                            memInf
                        );
                    } else {
                        GroupModel grp = grpMap.get(memInf.getCguSelectSid());
                        if (grp != null) {
                            ret = new ChtEntitiesResultModel.MemberModel(
                                grpMap.get(memInf.getCguSelectSid()),
                                memInf
                            );
                        }
                    }
                    return ret;
                })
                .filter(m -> m != null)
                .collect(Collectors.toList());
            mdl.setMemberConfigArray(memList);

            result.add(mdl);
        }
        return result;
    }

    /**
     *
     * @param userInfList
     * @return レスポンスモデルへ変換して返す
     * @throws SQLException
     */
    public List<ChtEntitiesResultModel> convertUserInfModel(List<ChatUserInfModel> userInfList)
                    throws SQLException {

        List<ChtEntitiesResultModel> result = List.of();

        int sessionUsrSid = ctx__.getRequestUserSid();
        Set<Integer> usrChatSids = userInfList.stream()
            .map(ChatUserInfModel::getUsrSid)
            .collect(Collectors.toSet());

        //メンバー情報(ユーザ)
        Set<Integer> memberSidSet = new HashSet<>();
        memberSidSet.add(sessionUsrSid);
        memberSidSet.addAll(usrChatSids);

        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(memberSidSet, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }

        //チャット 特例アクセスにより、アクセスを禁止されているユーザ・グループを取得
        ChtMemberBiz chtMemBiz = new ChtMemberBiz(ctx__.getCon());
        List<Integer> tokureiMemberList
                   = chtMemBiz.getTokureiUser(sessionUsrSid,
                                               chtMemBiz.getTokureiGroup(sessionUsrSid));

        //プラグイン使用可能ユーザSID一覧
        CommonBiz cmnBiz = new CommonBiz();
        List<Integer> canUsePluginUsrSids =
            cmnBiz.getCanUsePluginUser(
                ctx__.getCon(),
                GSConstChat.PLUGIN_ID_CHAT,
                usrChatSids.stream()
                    .collect(Collectors.toList())
                );

        result = new ArrayList<>();
        for (ChatUserInfModel inf : userInfList) {
            ChtEntitiesResultModel mdl = new ChtEntitiesResultModel();
            CmnUserModel usrMdl = usrMap.get(inf.getUsrSid());

            mdl.setType(EnumChatType.user);
            mdl.setId(usrMdl.getUsrLgid());
            mdl.setName(usrMdl.getUsiName());
            mdl.setMemo("");
            mdl.setLastPostDate(inf.getChtLastDate());
            mdl.setNonReadCountNum(inf.getChtUserCount());
            mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_NOT_MODE);
            mdl.setMuteFlg(inf.getCuucMuteKbn());
            mdl.setFavoriteFlg(inf.getCuucFavoriteKbn());

            MinimalUserInfoModel partner;
            partner = new MinimalUserInfoModel(
                sessionUsrSid,
                usrMdl
            );
            mdl.setPartnerInfo(partner);
            if (partner.getUserDeleteFlg() == GSConst.JTKBN_DELETE) {
                mdl.setArchiveFlg(GSConstChat.CHAT_ARCHIVE_MODE);
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }

            if (tokureiMemberList.contains(inf.getUsrSid())) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }
            if (canUsePluginUsrSids.contains(inf.getUsrSid()) == false) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }
            if (adminConf__.getCacChatFlg() == GSConstChat.LIMIT_BETWEEN_USERS) {
                mdl.setPostableFlg(GSConstChat.CHAT_NOT_POSTABLE);
            }

            result.add(mdl);
        }
        return result;
    }
}
