package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.dao.ChtGroupDataDao;
import jp.groupsession.v2.cht.dao.ChtUserDataDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.exception.RestApiException;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 指定したユーザ/グループチャットメッセージ情報を取得するクラス
 * <br>[解  説] 該当情報取得時にAPIアクセス権限エラーをthrowする
 * <br>[備  考]
 *
 * @author JTS
 */
public class ChtEntitiesMessageBiz {

    /** コネクション */
    private final Connection con__;
    /** メッセージ */
    private final GsMessage gsMsg__;
    /** セッションユーザSID */
    private final int sessionUserSid__;

    /**
     * @param con
     * @param gsMsg
     * @param sessionUserSid
     */
    public ChtEntitiesMessageBiz(Connection con, GsMessage gsMsg, int sessionUserSid) {
        con__ = con;
        gsMsg__ = gsMsg;
        sessionUserSid__ = sessionUserSid;
    }
    /**
     * 指定メッセージ情報を取得する
     * @param userId
     * @param messageSid
     * @return メッセージ情報
     * @throws SQLException SQL実行時例外
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtUserDataModel getUserChatMessage(
        String userId, long messageSid) throws SQLException, RestApiPermissionException {
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con__, gsMsg__);
        CmnUsrmModel umdl;
        try {
            umdl = ceiBiz.getUserChatInf(userId);
        } catch (RestApiException e) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }
        return getUserChatMessage(umdl, messageSid);
    }

    /**
     * 指定メッセージ情報を取得する
     * @param userId
     * @param usrSid
     * @param messageSid
     * @return メッセージ情報
     * @throws SQLException SQL実行時例外
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtUserDataModel getDeleteUserChatMessage(
        String userId, int usrSid, long messageSid)
         throws SQLException, RestApiPermissionException {
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con__, gsMsg__);
        CmnUsrmModel umdl;
        try {
            umdl = ceiBiz.getDeletedUserChatInf(usrSid, userId);
        } catch (RestApiException e) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }
        return getUserChatMessage(umdl, messageSid);

    }

    /**
     * 指定メッセージ情報を取得する
     * @param umdl
     * @param messageSid
     * @return 指定メッセージ情報
     * @throws SQLException
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtUserDataModel getUserChatMessage(
        CmnUsrmModel umdl, long messageSid) throws SQLException, RestApiPermissionException {
        return getUserChatMessage(umdl, messageSid, false);
    }

    /**
     * 指定メッセージ情報を取得する
     * @param umdl
     * @param messageSid
     * @param deletedArrow 削除メッセージの取得を許可する
     * @return 指定メッセージ情報
     * @throws SQLException
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtUserDataModel getUserChatMessage(
        CmnUsrmModel umdl, long messageSid, boolean deletedArrow)
         throws SQLException, RestApiPermissionException {

        ChtUserPairDao pairDao = new ChtUserPairDao(con__);

        int pairSid = pairDao.select(sessionUserSid__, umdl.getUsrSid());

        if (pairSid == 0) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }

        ChtUserDataDao cudDao = new ChtUserDataDao(con__);
        ChtUserDataModel ret = cudDao.select(messageSid);
        if (ret == null
            || ret.getCupSid() != pairSid) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }
        if (ret.getCudStateKbn() == GSConstChat.TOUKOU_STATUS_DELETE
            && deletedArrow == false) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg",
                        gsMsg__.getMessage("cht.cht010.43")
                );

        }

        return ret;
    }

    /**
     * 指定メッセージ情報を取得する
     * @param groupId
     * @param messageSid
     * @return 指定メッセージ情報
     * @throws SQLException
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtGroupDataModel getGroupChatMessage(String groupId, long messageSid)
        throws SQLException, RestApiPermissionException {
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con__, gsMsg__);
        ChtGroupInfModel gmdl = null;
        try {
            gmdl = ceiBiz.getGroupChatInf(
                groupId, sessionUserSid__);
        } catch (RestApiException e) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }
        return getGroupChatMessage(gmdl, messageSid);

    }

    /**
     * 指定メッセージ情報を取得する
     * @param gmdl
     * @param messageSid
     * @return 指定メッセージ情報
     * @throws SQLException
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtGroupDataModel getGroupChatMessage(ChtGroupInfModel gmdl, long messageSid)
        throws SQLException, RestApiPermissionException {
        return getGroupChatMessage(gmdl, messageSid, false);
    }
    /**
     * 指定メッセージ情報を取得する
     * @param gmdl
     * @param messageSid
     * @param deletedArrow 削除メッセージの取得を許可する
     * @return 指定メッセージ情報
     * @throws SQLException
     * @throws RestApiPermissionException メッセージ指定が不正
     */
    public ChtGroupDataModel getGroupChatMessage(
        ChtGroupInfModel gmdl, long messageSid, boolean deletedArrow)
        throws SQLException, RestApiPermissionException {
        ChtGroupDataDao cgdDao = new ChtGroupDataDao(con__);
        ChtGroupDataModel gdat = cgdDao.select(messageSid);
        if (gdat == null
                || gdat.getCgiSid() != gmdl.getCgiSid()) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg__.getMessage("cht.cht010.43")
            );
        }
        if (gdat.getCgdStateKbn() == GSConstChat.TOUKOU_STATUS_DELETE
            && deletedArrow == false) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg",
                        gsMsg__.getMessage("cht.cht010.43")
                );

        }
        return gdat;

    }
    /**
     * 送信入力チェック結果で例外をハンドリングする
     * @param msgKey 送信入力チェック結果メッセージキー
     * @see ChtSendViewBiz.sendCheck(int , int , long , boolean )
     */
    public void handleSendException(String msgKey) {
        if (StringUtil.isNullZeroString(msgKey)) {
            return;
        }
        //メッセージ編集権限エラー
        if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.43"))
            || Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.44"))
            || Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.45"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                msgKey
            );
        //入力パラメータで指定したチャット相手へのチャットが特例アクセス設定で制限されている
        } else if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.08"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_USER_SPECIAL_ACCESS,
                "errors.free.msg",
                msgKey
            );
        //入力パラメータで指定したチャット相手が削除されている
        } else if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.07"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_USER_DELETE,
                "errors.free.msg",
                msgKey
            );
        //管理者設定でユーザ間チャットが停止されている
        } else if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.05"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_USER_CHAT_BAN,
                "errors.free.msg",
                msgKey
            );
        //入力パラメータで指定したチャット相手がチャットプラグインの利用を制限されている
        } else if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.39"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_USER_CANT_ACCESS_CHAT,
                "errors.free.msg",
                msgKey
            );
        //入力パラメータで指定したグループチャットがアーカイブされている
        } else if (Objects.equals(msgKey, gsMsg__.getMessage("cht.cht010.06"))) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_GROUP_ARCHIVE,
                "errors.free.msg",
                msgKey
            );
        }

    }

}
