package jp.groupsession.v2.cht.restapi.entities.messages;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Delete;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.controller.annotation.Put;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/** チャット送信Action */
@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesMessagesAction extends AbstractRestApiAction {

    /**
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @param tempPathModel
     * @throws Exception 
     */
    @Post
    public void doPost(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMessagesPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel) throws Exception {

        //テンポラリディレクトリ作成
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        ChtEntitiesMessagesPostBiz biz = new ChtEntitiesMessagesPostBiz(param, ctx, tempPathModel);
        biz.execute();

        //スタンプを使用せずにメッセージを送信時、添付フォルダ破棄
        if (param.getStampSid() == 0) {
            tempUtil.clearTempPath(tempPathModel);
        }

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }

    /**
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @param tempPathModel
     * @throws Exception 
     */
    @Put
    public void doPut(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMessagesPutParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel) throws Exception {

        ChtEntitiesMessagesPutBiz biz = new ChtEntitiesMessagesPutBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .build().execute();
    }

    /**
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws Exception 
     */
    @Delete
    public void doDelete(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMessagesDeleteParamModel param,
        RestApiContext ctx) throws Exception {

        ChtEntitiesMessagesDeleteBiz biz = new ChtEntitiesMessagesDeleteBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResult("OK")
        .build().execute();
    }
}
