package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.SQLException;

import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtEntitiesMessagesDeleteParamModel {

    /** チャットタイプ(パスパラメータ) */
    private EnumChatType type__;

    /** ユーザID(パスパラメータ) */
    private String userId__;
    /** グループID(パスパラメータ) */
    private String chatGroupId__;
    /** 編集対象のメッセージSID */
    private long messageSid__;

    /**
     *  入力チェック
     * @param ctx
     * @throws SQLException
     */
    public void validate(RestApiContext ctx) throws SQLException  {

        RequestModel reqMdl = ctx.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);

        if (messageSid__ <= 0) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                gsMsg.getMessage("cht.cht010.43")
            );
        }
    }

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }
    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }
    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }
    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }
    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }

}
