package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.model.ChatInformationModel;
import jp.groupsession.v2.cht.model.ChatSendEditModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter.EnumType;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesPostBiz {

    /** パラメータ*/
    ChtEntitiesMessagesPostParamModel param__;
    /** APIコンテキスト*/
    RestApiContext ctx__;
    /** テンポラリディレクトリ */
    GSTemporaryPathModel tempPathModel__;
    /** メッセージ情報 */
    ChatSendEditModel messageModel__;

    /** 検索結果*/
    List<ChtEntitiesMessagesResultModel> result__ = List.of();

    /**
     * コンストラクタ
     * @param param パラメータ
     * @param ctx APIコンテキスト
     * @param tempPathModel テンポラリディレクトリ
     * @throws SQLException
     */
    public ChtEntitiesMessagesPostBiz(ChtEntitiesMessagesPostParamModel param,
            RestApiContext ctx, GSTemporaryPathModel tempPathModel) throws SQLException {
        param__ = param;
        ctx__ = ctx;
        tempPathModel__ = tempPathModel;
        messageModel__ = __createMessageModel();
    }

    /**
     * ビジネスロジックを実行する
     * @throws Exception
     */
    public void execute() throws Exception {

        //メッセージが送信可能かを判定する
        __checkCanSend();

        //入力チェックを実行する
        param__.validate(ctx__, tempPathModel__.getTempPath());

        //添付ファイルを登録
        CommonBiz cmnBiz = new CommonBiz();
        Connection con = ctx__.getCon();
        RequestModel reqMdl = ctx__.getRequestModel();

        MlCountMtController cntCon =
            GroupSession.getResourceManager().getCountController(reqMdl);
        List<Long> binList = new ArrayList<Long>();
        if (param__.getStampSid() == 0) {
            try {
                binList = cmnBiz.insertBinInfo(
                    con, tempPathModel__.getTempPath(),
                    ctx__.getAppRootPath(),
                    cntCon,
                    ctx__.getRequestUserSid(),
                    new UDate())
                    .stream()
                    .map(str -> Long.parseLong(str))
                    .collect(Collectors.toList());
            } catch (TempFileException e) {
                throw new RuntimeException("添付ファイル登録に失敗", e);
            }
        }

        ChtSendViewBiz sendBiz = new ChtSendViewBiz(reqMdl, con);

        //最大文字数が3000文字に制限されているため、メッセージは1件のみ
        List<Long> sentMessageSids = sendBiz.sendMessage(messageModel__, cntCon, binList);
        if (!sentMessageSids.isEmpty()) {
            long sendMessage = sentMessageSids.get(0);
            __createResult(sendMessage);
        }

        if (binList.size() > 0) {
            //オペレーションログ出力
            ChtBiz chtBiz = new ChtBiz(con);
            String logFileText = "";
            String logCodeText = "";
            for (Long binSid : binList) {
                CmnBinfModel cbMdl = cmnBiz.getBinInfo(con, binSid, reqMdl.getDomain());
                if (cbMdl != null) {
                    if (logFileText.length() > 0) {
                        logFileText += ",\n";
                        logCodeText += ", ";
                    }
                    logFileText += cbMdl.getBinFileName()
                            + cmnBiz.getByteSizeString(cbMdl.getBinFileSize());
                    logCodeText += String.valueOf(binSid);
                }
            }
            if (logFileText.length() > 0) {
                //ログ出力処理
                String logText = "";
                String partnerText = __getPartnerName(
                    messageModel__.getSelectPartner(), messageModel__.getSelectKbn(), con);

                GsMessage gsMsg = new GsMessage(reqMdl);
                logText = "[" + gsMsg.getMessage("cht.cht010.35") + "]" + partnerText
                        + "\n[" + gsMsg.getMessage("cmn.file") + "]"
                        + logFileText;
                chtBiz.outPutApiLog(
                        "RESTAPI_MESSAGE_SEND", gsMsg.getMessage("cmn.sent"),
                        GSConstLog.LEVEL_INFO, logText,
                        reqMdl, logCodeText, GSConstChat.CHAT_LOG_CODE_BINSID);
            }
        }
    }

    /**
     * <br>[機  能] 入力されたパラメータから、メッセージ送信用のモデルを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @return メッセージ送信用のモデル
     * @throws SQLException
     */
    private ChatSendEditModel __createMessageModel() throws SQLException {

        int sessionUsrSid = ctx__.getRequestUserSid();
        int selectSid;
        int kbn;
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);
        if (param__.getType() == EnumChatType.group) {
            ChtGroupInfModel grpMdl =
                infoBiz.getGroupChatInf(param__.getChatGroupId(), sessionUsrSid);
            selectSid = grpMdl.getCgiSid();
            kbn = GSConstChat.CHAT_KBN_GROUP;
        } else {
            CmnUsrmDao usrDao = new CmnUsrmDao(ctx__.getCon());
            if (usrDao.isDeleteUser(param__.getUserId())) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_USER_DELETE,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.07"));
            }
            CmnUsrmModel usrMdl = infoBiz.getUserChatInf(param__.getUserId());
            selectSid = usrMdl.getUsrSid();
            kbn = GSConstChat.CHAT_KBN_USER;
        }

        List<Integer> mentionUserList = new ArrayList<Integer>();
        if (param__.getMentionAllFlg() == 1) {
            mentionUserList.add(GSConstChat.MENTION_ALL);
        } else if (param__.getMentionUserArray() != null) {
            UserSearchDao userDao = new UserSearchDao(ctx__.getCon());
            String[] mentionUserArray = param__.getMentionUserArray();
            List<CmnUserModel> mentionUser =
                userDao.getUsersDataList(mentionUserArray);
            mentionUserList = mentionUser.stream()
                .map(CmnUserModel::getUsrSid)
                .collect(Collectors.toList());
            //存在しないユーザがメンションに指定されている場合はエラーを返す
            if (mentionUserArray.length != mentionUserList.size()) {
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                    "error.input.notvalidate.data",
                    gsMsg.getMessage("cht.cht010.78"));
            }
        }

        ChatSendEditModel messageModel = new ChatSendEditModel(
            kbn, selectSid, 0, param__.getBodyText(),
            param__.getStampSid(), mentionUserList, param__.getReplyMessageSid());

        return messageModel;
    }

    /**
     * <br>[機  能] メッセージが送信可能かを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException
     */
    private void __checkCanSend() throws SQLException {

        RequestModel reqMdl = ctx__.getRequestModel();
        Connection con = ctx__.getCon();

        GsMessage gsMsg = new GsMessage(reqMdl);
        ChtSendViewBiz biz = new ChtSendViewBiz(reqMdl, con);

        //返信元投稿のチェック
        int kbn = messageModel__.getSelectKbn();
        int selectSid = messageModel__.getSelectPartner();
        boolean canReply = biz.canReplyTarget(
            reqMdl, con, messageModel__.getReplyMessageSid(), kbn, selectSid);
        if (!canReply) {
            throw new RestApiValidateException(
                ChtEnumReasonCode.PARAM_CANT_ACCESS_MESSAGE,
                "search.data.notfound",
                gsMsg.getMessage("cht.cht010.69")
            );
        }

        //メンションのチェック
        String[] mentionUserArray = param__.getMentionUserArray();
        if (mentionUserArray != null && mentionUserArray.length > 0) {
            boolean checkMention = biz.checkMention(
                reqMdl, con, messageModel__.getMentionUserSids(), kbn, selectSid);
            if (!checkMention) {
                throw new RestApiValidateException(
                    EnumError.PARAM_OTHER_INVALID,
                    "error.input.notvalidate.data",
                    gsMsg.getMessage("cht.cht010.78"));
            }
        }


        //送信権限のチェック
        String errorMsg = biz.sendCheck(selectSid, kbn, -1, true);

        new ChtEntitiesMessageBiz(con, gsMsg, ctx__.getRequestUserSid())
            .handleSendException(errorMsg);

    }

    /** 結果モデルの生成
     * @param messageSid 送信したメッセージSID
     * @throws SQLException
     */
    private void __createResult(long messageSid) throws SQLException {
        ChatMessageSearchRequest searchReq;
        if (param__.getType() == EnumChatType.group) {

            searchReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    ctx__.getRequestModel(),
                    messageModel__.getSelectPartner()
                    );

        } else {
            searchReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    ctx__.getCon(),
                    ctx__.getRequestModel(),
                    messageModel__.getSelectPartner());
        }

        searchReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    EnumType.message,
                    String.valueOf(
                        messageSid
                    )
                )
            )
        );
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(ctx__.getCon());
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult searchResult =
            new ChatMessageSearcher(
                ctx__.getCon(),
                searchReq,
                adminMdl)
                .execute();

            if (searchResult.getHitCount() == 0) {
                result__ = null;
                return;
            }

            MessagesResultModelConverter converter =
                new MessagesResultModelConverter(ctx__);

            List<ChtEntitiesMessagesResultModel> resultList =
                converter.execute(searchResult.getList());

            result__ = resultList;
        } catch (TargetMessageWrongException e) {
            result__ = null;
            return;
        }

    }

    /**
     * <br>[機  能] チャット相手の名称取得
     * <br>[解  説]
     * <br>[備  考]
     * @param partnerSid チャット相手のユーザ/グループSID
     * @param partnerKbn 1:ユーザ, 2:グループ
     * @param con コネクション
     * @return 名称
     * @throws SQLException SQLException
     */
    private String __getPartnerName(
        int partnerSid, int partnerKbn, Connection con) throws SQLException {

        ChatDao chtDao = new ChatDao(con);

        String name = "";
        if (partnerKbn == GSConstChat.CHAT_KBN_USER) {
            CmnUsrmInfModel usrMdl = chtDao.getUser(partnerSid);
            name = usrMdl.getUsiName();
        } else {
            ChatInformationModel cimMdl = chtDao.getGroupInfoData(partnerSid);
            name = cimMdl.getChatName();
        }
        return name;
    }

    /**
     * @return the result
     */
    public List<ChtEntitiesMessagesResultModel> getResult() {
        return result__;
    }
}
