package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.SQLException;
import java.util.List;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

import java.sql.Connection;

import jp.co.sjts.util.io.IOTools;
import jp.groupsession.v2.cht.ChatValidate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtEntitiesMessagesPostParamModel {

    /** チャットタイプ(パスパラメータ) */
    private EnumChatType type__;

    /** ユーザID(パスパラメータ) */
    private String userId__;
    /** グループID(パスパラメータ) */
    private String chatGroupId__;

    /** 本文(リクエストボディ) */
    private String bodyText__;
    /** スタンプSID(リクエストボディ) */
    @Default("0")
    private int stampSid__;
    /** メンション全員フラグ(リクエストボディ) */
    @Default("0")
    @Selectable({"0", "1"})
    private int mentionAllFlg__;
    /** メンション指定ユーザ(リクエストボディ) */
    private String[] mentionUserArray__;
    /** リプライ対象(リクエストボディ) */
    @Default("0")
    private long replyMessageSid__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }
    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }
    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }
    /**
     * @return the bodyText
     */
    public String getBodyText() {
        return bodyText__;
    }
    /**
     * @param bodyText the bodyText to set
     */
    public void setBodyText(String bodyText) {
        bodyText__ = bodyText;
    }
    /**
     * @return the stampSid
     */
    public int getStampSid() {
        return stampSid__;
    }
    /**
     * @param stampSid the stampSid to set
     */
    public void setStampSid(int stampSid) {
        stampSid__ = stampSid;
    }
    /**
     * @return the mentionAllFlg
     */
    public int getMentionAllFlg() {
        return mentionAllFlg__;
    }
    /**
     * @param mentionAllFlg the mentionAllFlg to set
     */
    public void setMentionAllFlg(int mentionAllFlg) {
        mentionAllFlg__ = mentionAllFlg;
    }
    /**
     * @return the mentionUserArray
     */
    public String[] getMentionUserArray() {
        return mentionUserArray__;
    }
    /**
     * @param mentionUserArray the mentionUserArray to set
     */
    public void setMentionUserArray(String[] mentionUserArray) {
        mentionUserArray__ = mentionUserArray;
    }
    /**
     * @return the replyMessageSid
     */
    public long getReplyMessageSid() {
        return replyMessageSid__;
    }
    /**
     * @param replyMessageSid the replyMessageSid to set
     */
    public void setReplyMessageSid(long replyMessageSid) {
        replyMessageSid__ = replyMessageSid;
    }

    /**
     *  入力チェック
     * @param ctx
     * @param tempPath
     * @throws SQLException
     */
    public void validate(RestApiContext ctx, String tempPath) throws SQLException  {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();
        GsMessage gsMsg = new GsMessage(reqMdl);
        ChtSendViewBiz biz = new ChtSendViewBiz(reqMdl, ctx.getCon());
        //スタンプ使用可能チェック
        if (stampSid__ != 0) {
            if (!biz.canUseStamp(reqMdl, con, stampSid__)) {
                throw new RestApiValidateException(
                    ChtEnumReasonCode.PARAM_CANT_ACCESS_STAMP,
                    "error.chat.notfound.stamp"
                );
            }
            return;
        }

        //メッセージの入力チェック
        boolean hissuFlg = false;
        List<String> fileList = IOTools.getFileNames(tempPath);
        boolean isFileListEmpty = (fileList == null || fileList.isEmpty());
        if (isFileListEmpty) {
            hissuFlg = true;
        }
        
        ActionErrors errors = ChatValidate.validateChtAllFieldText(
            new ActionErrors(),
            gsMsg.getMessage("cmn.message"),
            bodyText__,
            "message",
            hissuFlg,
            true);
        if (!errors.isEmpty()) {
            ActionMessage errorMsg = (ActionMessage) errors.get().next();
            String message = gsMsg.getMessage("cmn.message");
            switch (errorMsg.getKey()) {
                case "error.input.required.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_REQUIRED, "error.input.required.text", message);
                case "error.input.spase.only":
                    throw new RestApiValidateException(
                        EnumError.PARAM_ONLY_SPACE, "error.input.spase.only", message);
                case "error.input.spase.start":
                    throw new RestApiValidateException(
                        EnumError.PARAM_START_SPACE, "error.input.spase.start", message);
                case "error.input.tab.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_TAB, "error.input.tab.text", message);
                case "error.input.length.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_MAXLENGTH,
                        "error.input.length.text", message, GSConstChat.MAX_LENGTH_MESSAGE);
                default:
                    break;
            }
        }

        //添付ファイル最大数
        if (!isFileListEmpty) {
            if ((fileList.size() / 2) > 10) {
                throw new RestApiValidateException(
                    EnumError.PARAM_MAXLENGTH,
                    "error.input.files.num");
            }
        }
    }
}
