package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.model.ChatSendEditModel;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter.EnumType;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesPutBiz {

    /** パラメータ*/
    ChtEntitiesMessagesPutParamModel param__;
    /** APIコンテキスト*/
    RestApiContext ctx__;
    /** メッセージ情報 */
    ChatSendEditModel messageModel__;

    /** 検索結果*/
    List<ChtEntitiesMessagesResultModel> result__ = List.of();

    /**
     * コンストラクタ
     * @param param パラメータ
     * @param ctx APIコンテキスト
     * @throws SQLException
     */
    public ChtEntitiesMessagesPutBiz(ChtEntitiesMessagesPutParamModel param,
            RestApiContext ctx) throws SQLException {
        param__ = param;
        ctx__ = ctx;
        messageModel__ = __createMessageModel();
    }

    /**
     * ビジネスロジックを実行する
     * @throws Exception
     */
    public void execute() throws Exception {

        //メッセージが送信可能かを判定する
        __checkCanSend();

        //入力チェックを実行する
        param__.validate(ctx__);

        boolean commit = false;
        Connection con = ctx__.getCon();
        try {
            ChtSendViewBiz sendBiz = new ChtSendViewBiz(ctx__.getRequestModel(), con);
            sendBiz.messageEdit(messageModel__);

            con.commit();
            commit = true;
        } catch (SQLException e) {
            throw e;
        } finally {
            if (!commit) {
                con.rollback();
            }
        }


        __createResult(messageModel__.getEditMessageSid());
    }

    /**
     * <br>[機  能] 入力されたパラメータから、メッセージ送信用のモデルを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @return メッセージ送信用のモデル
     * @throws SQLException
     */
    private ChatSendEditModel __createMessageModel() throws SQLException {

        int sessionUsrSid = ctx__.getRequestUserSid();
        int selectSid;
        int kbn;
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        boolean errorChangeFlg = true;
        try {
            if (param__.getType() == EnumChatType.group) {
                ChtGroupInfModel grpMdl =
                    infoBiz.getGroupChatInf(param__.getChatGroupId(), sessionUsrSid);
                selectSid = grpMdl.getCgiSid();
                kbn = GSConstChat.CHAT_KBN_GROUP;
            } else {
                CmnUsrmDao usrDao = new CmnUsrmDao(ctx__.getCon());
                if (usrDao.isDeleteUser(param__.getUserId())) {
                    errorChangeFlg = false;
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_USER_DELETE,
                        "errors.free.msg",
                        new GsMessage(ctx__.getRequestModel()).getMessage("cht.cht010.07"));
                }

                CmnUsrmModel usrMdl = infoBiz.getUserChatInf(param__.getUserId());
                selectSid = usrMdl.getUsrSid();
                kbn = GSConstChat.CHAT_KBN_USER;
            }
        } catch (RestApiPermissionException e) {
            //"ユーザ, グループを取得できなかったエラー"を"メッセージを取得できなかったエラー"に上書きする
            if (errorChangeFlg) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
                );
            }
            //ユーザが削除されている場合のエラーはそのまま投げる
            throw e;
        }


        //編集時はスタンプ, メンション, 返信元は設定しない
        ChatSendEditModel messageModel = new ChatSendEditModel(
            kbn, selectSid, param__.getMessageSid(), param__.getBodyText(), 0, List.of(), 0);

        return messageModel;
    }

    /**
     * <br>[機  能] メッセージが送信可能かを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException
     */
    private void __checkCanSend() throws SQLException {

        RequestModel reqMdl = ctx__.getRequestModel();
        Connection con = ctx__.getCon();

        GsMessage gsMsg = new GsMessage(reqMdl);
        ChtSendViewBiz biz = new ChtSendViewBiz(reqMdl, con);

        //送信権限のチェック
        String errorMsg = biz.sendCheck(
            messageModel__.getSelectPartner(), messageModel__.getSelectKbn(),
            messageModel__.getEditMessageSid(), false);

        new ChtEntitiesMessageBiz(con, gsMsg, ctx__.getRequestUserSid())
            .handleSendException(errorMsg);

    }

    /** 結果モデルの生成
     * @param messageSid 送信したメッセージSID
     * @throws SQLException
     */
    private void __createResult(long messageSid) throws SQLException {
        ChatMessageSearchRequest searchReq;
        if (param__.getType() == EnumChatType.group) {

            searchReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    ctx__.getRequestModel(),
                    messageModel__.getSelectPartner()
                    );

        } else {
            searchReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    ctx__.getCon(),
                    ctx__.getRequestModel(),
                    messageModel__.getSelectPartner());
        }

        searchReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    EnumType.message,
                    String.valueOf(
                        messageSid
                    )
                )
            )
        );
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(ctx__.getCon());
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult searchResult =
            new ChatMessageSearcher(
                ctx__.getCon(),
                searchReq,
                adminMdl)
                .execute();

            if (searchResult.getHitCount() == 0) {
                result__ = null;
                return;
            }

            MessagesResultModelConverter converter =
                new MessagesResultModelConverter(ctx__);

            List<ChtEntitiesMessagesResultModel> resultList =
                converter.execute(searchResult.getList());

            result__ = resultList;
        } catch (TargetMessageWrongException e) {
            result__ = null;
            return;
        }
    }

    /**
     * @return the result
     */
    public List<ChtEntitiesMessagesResultModel> getResult() {
        return result__;
    }
}
