package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.SQLException;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import java.sql.Connection;
import jp.groupsession.v2.cht.ChatValidate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtSendViewBiz;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtEntitiesMessagesPutParamModel {

    /** チャットタイプ(パスパラメータ) */
    private EnumChatType type__;

    /** ユーザID(パスパラメータ) */
    private String userId__;
    /** グループID(パスパラメータ) */
    private String chatGroupId__;
    /** 編集対象のメッセージSID */
    private long messageSid__;

    /** 本文(リクエストボディ) */
    private String bodyText__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }
    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }
    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }
    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }
    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }
    /**
     * @return the bodyText
     */
    public String getBodyText() {
        return bodyText__;
    }
    /**
     * @param bodyText the bodyText to set
     */
    public void setBodyText(String bodyText) {
        bodyText__ = bodyText;
    }

    /**
     *  入力チェック
     * @param ctx
     * @throws SQLException
     */
    public void validate(RestApiContext ctx) throws SQLException  {

        RequestModel reqMdl = ctx.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);

        if (messageSid__ <= 0) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                gsMsg.getMessage("cht.cht010.43")
            );
        }

        int kbn = GSConstChat.CHAT_KBN_USER;
        if (type__ == EnumChatType.group) {
            kbn = GSConstChat.CHAT_KBN_GROUP;
        }
        Connection con = ctx.getCon();
        //添付ファイルがない場合、文字列は入力必須
        ChtSendViewBiz biz = new ChtSendViewBiz(reqMdl, con);
        boolean hissuFlg = biz.isNeedEditText(messageSid__, kbn, con);

        ActionErrors errors = ChatValidate.validateChtAllFieldText(
            new ActionErrors(),
            gsMsg.getMessage("cmn.message"),
            bodyText__,
            "message",
            hissuFlg,
            true);
        if (!errors.isEmpty()) {
            ActionMessage errorMsg = (ActionMessage) errors.get().next();
            String message = gsMsg.getMessage("cmn.message");
            switch (errorMsg.getKey()) {
                case "error.input.required.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_REQUIRED, "error.input.required.text", message);
                case "error.input.spase.only":
                    throw new RestApiValidateException(
                        EnumError.PARAM_ONLY_SPACE, "error.input.spase.only", message);
                case "error.input.spase.start":
                    throw new RestApiValidateException(
                        EnumError.PARAM_START_SPACE, "error.input.spase.start", message);
                case "error.input.tab.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_TAB, "error.input.tab.text", message);
                case "error.input.length.text":
                    throw new RestApiValidateException(
                        EnumError.PARAM_MAXLENGTH,
                        "error.input.length.text", message, GSConstChat.MAX_LENGTH_MESSAGE);
                default:
                    break;
            }
        }
    }
}
