package jp.groupsession.v2.cht.restapi.entities.messages;

import java.util.List;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.restapi.entities.messages.query.MentionInfoModel;
import jp.groupsession.v2.cht.restapi.entities.messages.query.ReactionInfoModel;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat.Format;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.restapi.response.TmpFileInfo;
import jp.groupsession.v2.restapi.response.annotation.ChildElementName;
import jp.groupsession.v2.restapi.response.annotation.ResponceModel;

public class ChtEntitiesMessagesResultModel {

    /** 送信者情報 */
    private final MinimalUserInfoModel senderInfo__;

    /** メッセージSID     */
    private long sid__;
    /** 投稿日時 */
        /** 最終投稿日時 */
    @UDateFormat(Format.DATETIME_SLUSH_HHMM)
    private UDate postDate__;
    /** 投稿編集日時 */
    @UDateFormat(Format.DATETIME_SLUSH_HHMM)
    private UDate editDate__;
    /** 削除済みフラグ */
    private int deleteFlg__;
    /** 本文 */
    private String bodyText__;
    /** 既読フラグ */
    private int readFlg__;
    /** チャット相手既読フラグ */
    private int partnerReadFlg__;
    /** ピン止め並び順 */
    private int pinnedSortNum__;
    /** 添付ファイル配列 */
    @ChildElementName("tmpFileInfo")
    private List<TmpFileInfo> tmpFileArray__ = List.of();

    /** 返信元情報 */
    @ResponceModel(targetField = {
        /** メッセージSID */
        "sid",
        /** 送信者ID */
        "senderId",
        /** 送信者SID */
        "senderSid",
        /** 送信者名 */
        "senderName",
        /** 送信者 ログイン停止フラグ */
        "senderLoginStopFlg",
        /** 送信者 削除フラグ */
        "senderUserDeleteFlg",
        /** 送信者 画像SID */
        "senderImageBinSid",
        /** 送信者 画像公開フラグ */
        "senderImageKoukaiFlg",
        /** 削除済みフラグ */
        "deleteFlg",
        /** 本文 */
        "bodyText",
        /** 添付ファイル配列 */
        "tmpFileArray",
        /** スタンプSID */
        "stampSid",
    })
    private ChtEntitiesMessagesResultModel replyInfo__;

    /** リアクション配列 */
    @ChildElementName("reactionInfo")
    private List<ReactionInfoModel> reactionArray__ = List.of();
    /** メンション配列 */
    @ChildElementName("mentionInfo")
    private List<MentionInfoModel> mentionArray__ = List.of();
    /** スタンプSID */
    private int stampSid__;

    /**
     * @param senderInfo
     */
    public ChtEntitiesMessagesResultModel(MinimalUserInfoModel senderInfo) {
        senderInfo__ = senderInfo;
    }

    /**
     * @return 送信者ID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getId()
     */

    public String getSenderId() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return "";
        }
        return senderInfo__.getId();
    }
    /**
     * @return 送信者SID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getSid()
     */

    public int getSenderSid() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return 0;
        }
        return senderInfo__.getSid();
    }
    /**
     * @return 送信者名
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getName()
     */

    public String getSenderName() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return "";
        }
        return senderInfo__.getName();
    }
    /**
     * @return 送信者 ログイン停止フラグ
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getLoginStopFlg()
     */

    public int getSenderLoginStopFlg() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return 0;
        }
        if (senderInfo__.getUserDeleteFlg() != 0) {
            return 0;
        }
        return senderInfo__.getLoginStopFlg();
    }
    /**
     * @return 送信者 削除フラグ
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getUserDeleteFlg()
     */

    public int getSenderUserDeleteFlg() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return 0;
        }
        return senderInfo__.getUserDeleteFlg();
    }
    /**
     * @return 送信者 画像SID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getImageBinSid()
     */

    public long getSenderImageBinSid() {
        if (deleteFlg__ != 0
        || senderInfo__ == null) {
        return 0;
    }
   return senderInfo__.getImageBinSid();
    }
    /**
     * @return 送信者 画像公開フラグ
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getImageKoukaiFlg()
     */

    public int getSenderImageKoukaiFlg() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return 0;
        }
        return senderInfo__.getImageKoukaiFlg();
    }
    /**
     * @return the sid
     */
    public long getSid() {
        return sid__;
    }
    /**
     * @param sid the sid to set
     */
    public void setSid(long sid) {
        sid__ = sid;
    }
    /**
     * @return the postDate
     */
    public UDate getPostDate() {
        return postDate__;
    }
    /**
     * @param postDate the postDate to set
     */
    public void setPostDate(UDate postDate) {
        postDate__ = postDate;
    }
    /**
     * @return the editDate
     */
    public UDate getEditDate() {
        if (deleteFlg__ != 0
            || senderInfo__ == null) {
            return null;
        }
        return editDate__;
    }
    /**
     * @param editDate the editDate to set
     */
    public void setEditDate(UDate editDate) {
        editDate__ = editDate;
    }
    /**
     * @return the deleteFlg
     */
    public int getDeleteFlg() {
        return deleteFlg__;
    }
    /**
     * @param deleteFlg the deleteFlg to set
     */
    public void setDeleteFlg(int deleteFlg) {
        deleteFlg__ = deleteFlg;
    }
    /**
     * @return the bodyText
     */
    public String getBodyText() {
        if (deleteFlg__ != 0) {
            return "";
        }
        return bodyText__;
    }
    /**
     * @param bodyText the bodyText to set
     */
    public void setBodyText(String bodyText) {
        bodyText__ = bodyText;
    }
    /**
     * @return the readFlg
     */
    public int getReadFlg() {
        return readFlg__;
    }
    /**
     * @param readFlg the readFlg to set
     */
    public void setReadFlg(int readFlg) {
        readFlg__ = readFlg;
    }
    /**
     * @return the partnerReadFlg
     */
    public int getPartnerReadFlg() {
        if (deleteFlg__ != 0) {
            return 0;
        }
        return partnerReadFlg__;
    }
    /**
     * @param partnerReadFlg the partnerReadFlg to set
     */
    public void setPartnerReadFlg(int partnerReadFlg) {
        partnerReadFlg__ = partnerReadFlg;
    }
    /**
     * @return the pinnedSortNum
     */
    public int getPinnedSortNum() {
        if (deleteFlg__ != 0) {
            return 0;
        }
        return pinnedSortNum__;
    }
    /**
     * @param pinnedSortNum the pinnedSortNum to set
     */
    public void setPinnedSortNum(int pinnedSortNum) {
        pinnedSortNum__ = pinnedSortNum;
    }
    /**
     * @return the tmpFileArray
     */
    public List<TmpFileInfo> getTmpFileArray() {
        if (deleteFlg__ != 0) {
            return List.of();
        }
        return tmpFileArray__;
    }
    /**
     * @param tmpFileArray the tmpFileArray to set
     */
    public void setTmpFileArray(List<TmpFileInfo> tmpFileArray) {
        tmpFileArray__ = tmpFileArray;
    }
    /**
     * @return the replyInfo
     */
    public ChtEntitiesMessagesResultModel getReplyInfo() {
        if (deleteFlg__ != 0) {
            return null;
        }
        return replyInfo__;
    }
    /**
     * @param replyInfo the replyInfo to set
     */
    public void setReplyInfo(ChtEntitiesMessagesResultModel replyInfo) {
        replyInfo__ = replyInfo;
    }
    /**
     * @return the reactionArray
     */
    public List<ReactionInfoModel> getReactionArray() {
        if (deleteFlg__ != 0) {
            return List.of();
        }
        return reactionArray__;
    }
    /**
     * @param reactionArray the reactionArray to set
     */
    public void setReactionArray(List<ReactionInfoModel> reactionArray) {
        reactionArray__ = reactionArray;
    }
    /**
     * @return the mentionArray
     */
    public List<MentionInfoModel> getMentionArray() {
        if (deleteFlg__ != 0) {
            return List.of();
        }

        return mentionArray__;
    }
    /**
     * @param mentionArray the mentionArray to set
     */
    public void setMentionArray(List<MentionInfoModel> mentionArray) {
        mentionArray__ = mentionArray;
    }
    /**
     * @return the stampSid
     */
    public int getStampSid() {
        if (deleteFlg__ != 0) {
            return 0;
        }

        return stampSid__;
    }
    /**
     * @param stampSid the stampSid to set
     */
    public void setStampSid(int stampSid) {
        stampSid__ = stampSid;
    }

}
