package jp.groupsession.v2.cht.restapi.entities.messages;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import jp.co.sjts.util.EnumUtil;
import jp.co.sjts.util.EnumUtil.EnumOutRangeException;
import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.model.ChatMessageModel;
import jp.groupsession.v2.cht.model.ChtReactionModel;
import jp.groupsession.v2.cht.model.EnumReactioneCode;
import jp.groupsession.v2.cht.restapi.entities.messages.query.EnumReactionedFlg;
import jp.groupsession.v2.cht.restapi.entities.messages.query.MentionInfoModel;
import jp.groupsession.v2.cht.restapi.entities.messages.query.ReactionInfoModel;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.restapi.response.TmpFileInfo;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

public class MessagesResultModelConverter {
    /** APIコンテキスト */
    private final RestApiContext ctx__;


    /**
     * @param ctx
     */
    public MessagesResultModelConverter(RestApiContext ctx) {
        ctx__ = ctx;
    }
    /**
     *
     * @param list
     * @return レスポンスモデルへ変換して返す
     * @throws SQLException
    */
    public List<ChtEntitiesMessagesResultModel> execute(
            List<ChatMessageModel> list) throws SQLException {

        List<ChtEntitiesMessagesResultModel> ret = new ArrayList<>();

        //ChatMessageModelから使用されるユーザSIDを抽出
        Set<Integer> usrSids = new HashSet<>();
        usrSids.addAll(
            list.stream()
            .map(ChatMessageModel::getUsrSid)
            .filter(sid -> (sid > GSConstUser.USER_RESERV_SID))
            .collect(Collectors.toSet())
        );
        usrSids.addAll(
            list.stream()
            .filter(m -> (m.getMentionUserInfo() != null))
            .flatMap(m -> m.getMentionUserInfo().stream())
            .map(CmnUserModel::getUsrSid)
            .collect(Collectors.toSet())
        );
        usrSids.addAll(
            list.stream()
            .filter(m -> (m.getReplyMessageInfo() != null))
            .map(ChatMessageModel::getReplyMessageInfo)
            .map(ChatMessageModel::getUsrSid)
            .collect(Collectors.toSet())
        );
        //メンバーユーザMap(管理者設定並び順)
        UserSearchDao usrDao = new UserSearchDao(ctx__.getCon());
        final Map<Integer, CmnUserModel> usrMap = new LinkedHashMap<>();
        for (CmnUserModel usrMdl
                    : usrDao.getUsersDataList(usrSids, true)) {
            usrMap.put(usrMdl.getUsrSid(), usrMdl);
        }


        //使用されるユーザSIDを抽出
        for (ChatMessageModel base : list) {
            ChtEntitiesMessagesResultModel mdl =
                __createMessageModel(base, usrMap, false);

            ret.add(mdl);
        }

        return ret;
    }
    /**
     *
     * @param usrMdl
     * @param usrMap
     * @return レスポンス用メンションモデルを生成して返す
    */
    private MentionInfoModel __createMentionInfoModel(
        CmnUserModel usrMdl, Map<Integer, CmnUserModel> usrMap) {
        //メンション（全員）はSIDが-1
        if (usrMdl.getUsrSid() <= 0) {

            return MentionInfoModel.createInstanseTypeAll(
                new GsMessage(
                    ctx__.getRequestModel()
                    )
                );
        }
        int sessionUsrSid = ctx__.getRequestUserSid();
        return MentionInfoModel.createInstanseTypeUser(
            sessionUsrSid,
            usrMap.get(usrMdl.getUsrSid())
        );

    }

    /**
     * @param model
     * @param eutil
     * @return レスポンス用リアクションモデルを生成して返す
     */
    private ReactionInfoModel __createReactionInfoModel(
        ChtReactionModel model, EnumUtil<EnumReactioneCode> eutil) {
        int sessionUsrSid = ctx__.getRequestUserSid();

        ReactionInfoModel ret = new ReactionInfoModel();
        EnumReactioneCode rcode = null;
        try {
            rcode = eutil.valueOf(model.getRacSid());
        } catch (EnumOutRangeException e) {
        }
        if (rcode != null) {
            ret.setCode(rcode);
        }
        ret.setSentFlg(EnumReactionedFlg.NONE);
        if (model.getUsrSidList() != null) {
            ret.setCountNum(model.getUsrSidList().size());
            if (model.getUsrSidList().indexOf(sessionUsrSid) >= 0) {
                ret.setSentFlg(EnumReactionedFlg.REACTIONED);
            }
        }
        return ret;
    }

    /**
     * レスポンス用メッセージ情報を生成して返す
     * この時点ではリプライ情報と共通項目のみ設定する
     * @param base
     * @param usrMap
     * @param replyFlg
     * @return レスポンス用メッセージ情報を生成して返す
    */
    private ChtEntitiesMessagesResultModel __createMessageModel(
            ChatMessageModel base,
            Map<Integer, CmnUserModel> usrMap,
            boolean replyFlg) {
        if (base == null) {
            return null;
        }

        int sessionUsrSid = ctx__.getRequestUserSid();
        CmnUserModel sender = usrMap.get(base.getUsrSid());

        ChtEntitiesMessagesResultModel mdl =
                new ChtEntitiesMessagesResultModel(
                new MinimalUserInfoModel(sessionUsrSid, sender)
                );

        mdl.setSid(base.getMessageSid());
        if (base.getMessageKbn() == GSConstChat.TOUKOU_STATUS_DELETE) {
            mdl.setDeleteFlg(1);
        } else {
            mdl.setDeleteFlg(0);
        }

        mdl.setBodyText(base.getMessageText());

        mdl.setStampSid(base.getStampSid());

        //添付ファイル
        if (base.getBinMdlList() != null
            && base.getBinMdlList().size() > 0) {
            mdl.setTmpFileArray(
                base.getBinMdlList().stream()
                    .map(b -> new TmpFileInfo(b))
                    .collect(Collectors.toList())
            );
        }

        //スタンプ
        mdl.setStampSid(base.getStampSid());

        //リプライ情報に対して以下の情報を設定しない
        if (replyFlg) {
            return mdl;
        }

        //登録日
        UDate adate = UDate.getInstanceStr(base.getEntryDay());
        String[] timeSp =  base.getEntryTime().split(":");
        int hh = Integer.valueOf(timeSp[0]);
        int mm = Integer.valueOf(timeSp[1]);
        adate.setHour(hh);
        adate.setMinute(mm);
        adate.setSecond(0);

        mdl.setPostDate(adate);

        mdl.setReadFlg(base.getOwnKidoku());

        mdl.setPartnerReadFlg(base.getPartnerKidoku());

        mdl.setPinnedSortNum(base.getMessagePinSortNum());

        //更新日
        UDate udate = UDate.getInstanceStr(base.getUpdateDay());
        timeSp =  base.getUpdateTime().split(":");
        hh = Integer.valueOf(timeSp[0]);
        mm = Integer.valueOf(timeSp[1]);
        udate.setHour(hh);
        udate.setMinute(mm);
        udate.setSecond(0);
        if (base.getMessageKbn() == GSConstChat.TOUKOU_STATUS_EDIT) {
            mdl.setEditDate(udate);
        }
        //リプライ
        ChtEntitiesMessagesResultModel reply =
            __createMessageModel(base.getReplyMessageInfo(), usrMap, true);
        mdl.setReplyInfo(reply);

        //メンション
        if (base.getMentionUserInfo() != null && base.getMentionUserInfo().size() > 0) {
            mdl.setMentionArray(
                base.getMentionUserInfo()
                    .stream()
                    .map(u -> __createMentionInfoModel(u, usrMap))
                    .collect(Collectors.toList())
            );
        }

        //リアクション
        if (base.getReactionList() != null && base.getReactionList().size() > 0) {
            EnumUtil<EnumReactioneCode> eutil = new EnumUtil<>(EnumReactioneCode.class);
            mdl.setReactionArray(
                base.getReactionList()
                    .stream()
                    .map(m -> {
                        return __createReactionInfoModel(m, eutil);
                    })
                    .collect(Collectors.toList())
            );
        }
        if (base.getMessagePinKbn() == GSConstChat.CHAT_MESSAGE_PIN_ON) {
            mdl.setPinnedSortNum(base.getMessagePinSortNum());
        }


        return mdl;
    }
}
