package jp.groupsession.v2.cht.restapi.entities.messages.files;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtDownloadCheckBiz;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.response.RestApiAttachementResponseWriter;
import jp.groupsession.v2.struts.msg.GsMessage;

@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesMessagesFilesAction extends AbstractRestApiAction {

    /**
     * メッセージの添付ファイルダウンロード アクションメソッド
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     * @throws TempFileException 
     */
    @Get
    public void doGet(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMessagesFilesGetParamModel param,
        RestApiContext ctx) throws SQLException, TempFileException {

        //ファイルダウンロードが可能かのチェック
        int sessionUsrSid = ctx.getRequestUserSid();
        RequestModel reqMdl = ctx.getRequestModel();
        ChtDownloadCheckBiz biz = new ChtDownloadCheckBiz(reqMdl, ctx.getCon());
        int kbn;
        int partnerSid = -1;
        GsMessage gsMsg = new GsMessage(reqMdl);
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(ctx.getCon(), gsMsg);
        try {
            if (param.getType() == EnumChatType.group) {
                ChtGroupInfModel grpMdl = ceiBiz.getGroupChatInf(param.getChatGroupId(), sessionUsrSid);
                partnerSid = grpMdl.getCgiSid();
                kbn = GSConstChat.CHAT_KBN_GROUP;
            } else {
                CmnUsrmModel usrMdl;
                if (param.getDeleteUserSid() > 0) {
                    usrMdl = ceiBiz.getDeletedUserChatInf(param.getDeleteUserSid(), param.getUserId());
                } else {
                    usrMdl = ceiBiz.getUserChatInf(param.getUserId());
                }
                partnerSid = usrMdl.getUsrSid();
                kbn = GSConstChat.CHAT_KBN_USER;
            }
        } catch (RestApiPermissionException e) {
            //ユーザ，グループ情報が不正な場合のエラーを、"添付ファイルが存在しない"エラーに置き換える
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES_TEMPFILE,
                    "error.nothing.selected",
                    gsMsg.getMessage("cmn.attach.file")
            );
        }

        int checkResult = biz.downloadCheck(kbn, partnerSid, param.getMessageSid());
        if (checkResult == ChtDownloadCheckBiz.DOWNLOADCHECK_CODE_NONE) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES_TEMPFILE,
                    "error.nothing.selected",
                    gsMsg.getMessage("cmn.attach.file")
            );
        }

        //オペレーションログの登録
        ChtEntitiesMessagesFilesGetBiz thisBiz = new ChtEntitiesMessagesFilesGetBiz();
        thisBiz._insertOpLog(ctx, param.getBinSid(), partnerSid, kbn);

        //添付ファイルのダウンロード
        RestApiAttachementResponseWriter.execute(res, req, ctx, param.getBinSid());
    }
}
