package jp.groupsession.v2.cht.restapi.entities.messages.files;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.model.ChatInformationModel;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesFilesGetBiz {

    /**
     * <br>[機  能] ファイルダウンロード時のオペレーションログを登録する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiContext
     * @param binSid 添付ファイルSID
     * @param partnerSid チャット相手のユーザ/グループSID
     * @param kbn 1:ユーザ, 2:グループ
     * @throws SQLException 
     * @throws TempFileException 
     * 
     */
    protected void _insertOpLog(RestApiContext ctx, long binSid,
        int partnerSid, int kbn) throws SQLException, TempFileException {

        //オペレーションログの登録
        RequestModel reqMdl = ctx.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);
        Connection con = ctx.getCon();
        ChtBiz chtBiz = new ChtBiz(con);
        String logFileText = "";
        String logCodeText = "";

        CommonBiz cmnBiz = new CommonBiz();
        CmnBinfModel cbMdl = cmnBiz.getBinInfo(con, binSid, reqMdl.getDomain());
        if (cbMdl != null) {
            if (logFileText.length() > 0) {
                logFileText += ",\n";
                logCodeText += ", ";
            }
            logFileText += cbMdl.getBinFileName()
                    + cmnBiz.getByteSizeString(cbMdl.getBinFileSize());
            logCodeText += String.valueOf(binSid);
        }

        if (logFileText.length() > 0) {
            //ログ出力処理
            String logText = "";
            String partnerText = __getPartnerName(partnerSid, kbn, con);

            logText = "[" + gsMsg.getMessage("cht.cht010.35") + "]" + partnerText
                    + "\n[" + gsMsg.getMessage("cmn.file") + "]"
                    + logFileText;
            chtBiz.outPutApiLog(
                    "RESTAPI_MESSAGE_FILE_DOWNLOAD", gsMsg.getMessage("cmn.download"),
                    GSConstLog.LEVEL_INFO, logText,
                    reqMdl, logCodeText, GSConstChat.CHAT_LOG_CODE_BINSID);
        }
    }

    /**
     * <br>[機  能] チャット相手の名称取得
     * <br>[解  説]
     * <br>[備  考]
     * @param partnerSid チャット相手のユーザ/グループSID
     * @param partnerKbn 1:ユーザ, 2:グループ
     * @param con コネクション
     * @return 名称
     * @throws SQLException SQLException
     */
    private String __getPartnerName(
        int partnerSid, int partnerKbn, Connection con) throws SQLException {

        ChatDao chtDao = new ChatDao(con);

        String name = "";
        if (partnerKbn == GSConstChat.CHAT_KBN_USER) {
            CmnUsrmInfModel usrMdl = chtDao.getUser(partnerSid);
            name = usrMdl.getUsiName();
        } else {
            ChatInformationModel cimMdl = chtDao.getGroupInfoData(partnerSid);
            name = cimMdl.getChatName();
        }
        return name;
    }
}
