package jp.groupsession.v2.cht.restapi.entities.messages.files;

import java.sql.SQLException;
import jp.groupsession.v2.cht.dao.ChtGroupDataTempDao;
import jp.groupsession.v2.cht.dao.ChtUserDataTempDao;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.struts.msg.GsMessage;

@ParamModel
public class ChtEntitiesMessagesFilesGetParamModel {

    /** チャットタイプ */
    private EnumChatType type__;
    /** チャット相手ログインID */
    private String userId__;
    /** チャット相手ログインID */
    private String chatGroupId__;

    /** 削除済みユーザSID */
    private int deleteUserSid__ = -1;

    /** メッセージSID */
    @NotBlank
    private long messageSid__;

    /** 添付ファイルSID */
    @NotBlank
    private long binSid__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }
    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }
    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }
    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }
    /**
     * @return the deleteUserSid
     */
    public int getDeleteUserSid() {
        return deleteUserSid__;
    }
    /**
     * @param deleteUserSid the deleteUserSid to set
     */
    public void setDeleteUserSid(int deleteUserSid) {
        deleteUserSid__ = deleteUserSid;
    }
    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }
    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }
    /**
     * @return the binSid
     */
    public long getBinSid() {
        return binSid__;
    }
    /**
     * @param binSid the binSid to set
     */
    public void setBinSid(long binSid) {
        binSid__ = binSid;
    }

    /**
     *  入力チェック
     * @param ctx
     * @throws SQLException
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException  {

        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        boolean isError = false;
        if (type__ == EnumChatType.group) {
            ChtGroupDataTempDao cgtDao = new ChtGroupDataTempDao(ctx.getCon());
            if (cgtDao.select(messageSid__, binSid__) == null) {
                isError = true;
            }
        } else {
            ChtUserDataTempDao cutDao = new ChtUserDataTempDao(ctx.getCon());
            if (cutDao.select(messageSid__, binSid__) == null) {
                isError = true;
            }
        }

        if (isError) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES_TEMPFILE,
                    "error.nothing.selected",
                    gsMsg.getMessage("cmn.attach.file")
            );
        }
        
    }
}
