package jp.groupsession.v2.cht.restapi.entities.messages.pin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.dao.ChtGroupDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupDataPinModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.model.ChtUserDataPinModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessagesResultModel;
import jp.groupsession.v2.cht.restapi.entities.messages.MessagesResultModelConverter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter.EnumType;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesPinPutBiz {
    /** パラメータ */
    private final ChtEntitiesMessagesPinParamModel param__;

    /** APIコンテキスト */
    private final RestApiContext ctx__;

    /**実行結果 メッセージモデル */
    private ChtEntitiesMessagesResultModel result__;

    /**チャットグループ */
    private ChtGroupInfModel gmdl__ = null;

    /**チャット相手ユーザ情報 */
    private CmnUsrmModel umdl__ = null;

    /**チャット相手 ペアSID */
    private int pairSid__;

    /** メッセージ情報(グループ) */
    private ChtGroupDataModel groupMessageMdl__;

    /** メッセージ情報(ユーザ) */
    private ChtUserDataModel userMessageMdl__;
    /**
     * コンストラクタ
     * @param param
     * @param ctx
     */
    private ChtEntitiesMessagesPinPutBiz(ChtEntitiesMessagesPinParamModel param,
            RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return リクエスト内でシングルトン管理されたビジネスロジッククラス
     */
    public static ChtEntitiesMessagesPinPutBiz getInstance(
        ChtEntitiesMessagesPinParamModel param,
        RestApiContext ctx) {

        ChtEntitiesMessagesPinPutBiz ret = RequestLocal.get(
            ChtEntitiesMessagesPinPutBiz.class,
            ChtEntitiesMessagesPinPutBiz.class);
        if (ret == null) {
            ret = new ChtEntitiesMessagesPinPutBiz(param, ctx);
            RequestLocal.put(ChtEntitiesMessagesPinPutBiz.class,
            ret);
        }
        return ret;
    }

    /**
     * パラメータ入力チェック
     * @throws SQLException
     * @throws RestApiValidateExceptionNest 入力チェック例外
    */
    public void validate() throws SQLException, RestApiValidateExceptionNest {
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());


        ChtGroupInfModel gmdl = null;
        CmnUsrmModel umdl = null;
        List<RestApiValidateException> valErrors = new ArrayList<>();
        //チャット指定権限チェック
        try {
            if (param__.getType() == EnumChatType.group) {
                gmdl = __getGmdl();
            } else {
                umdl = __getUmdl();
            }
        } catch (RestApiPermissionException e) {
            throw
                new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                gsMsg.getMessage("cht.cht010.43")
                ).setParamName("messageSid");
        }

        //グループメッセージ指定権限チェック
        if (gmdl != null) {
            ChtGroupDataModel mesMdl = null;
            try {
                mesMdl = __getGroupMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }

            } catch (RestApiPermissionException e) {
                throw
                    new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.43")
                        ).setParamName("messageSid");
            }

        //ユーザメッセージ指定権限チェック
        } else if (umdl != null) {
            ChtUserDataModel mesMdl = null;
            try {
                mesMdl = __getUserMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }
            } catch (RestApiPermissionException e) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
                    ).setParamName("messageSid");
            }

        }

        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }


    /** ビジネスロジックの実行
     * @throws SQLException */
    public void execute() throws SQLException {
        if (param__.getPinnedFlg() == GSConstChat.CHAT_MESSAGE_PIN_ON) {

            __exePin();

        } else {
            __removePin();
        }

        __createResult();

    }

    /**
     * 対象メッセージモデル(ユーザ)を取得する
     * @return メッセージモデル(ユーザ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtUserDataModel __getUserMessageModel()
        throws RestApiPermissionException, SQLException {
        if (userMessageMdl__ != null) {
            return userMessageMdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        userMessageMdl__ = mesBiz.getUserChatMessage(__getUmdl(), param__.getMessageSid());
        return userMessageMdl__;
    }

    /**
     * 対象メッセージモデル(グループ)を取得する
     * @return メッセージモデル(グループ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtGroupDataModel __getGroupMessageModel()
        throws RestApiPermissionException, SQLException {
        if (groupMessageMdl__ != null) {
            return groupMessageMdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        groupMessageMdl__ = mesBiz.getGroupChatMessage(__getGmdl(), param__.getMessageSid());
        return groupMessageMdl__;
    }

    /** 結果モデルの生成
     * @throws SQLException */
    private void __createResult() throws SQLException {
        ChatMessageSearchRequest searchReq;
        if (param__.getType() == EnumChatType.group) {

            searchReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    ctx__.getRequestModel(),
                    __getGmdl().getCgiSid());

        } else {
            searchReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    ctx__.getCon(),
                    ctx__.getRequestModel(),
                    __getUmdl().getUsrSid());
        }

        searchReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    EnumType.message,
                    String.valueOf(
                        param__.getMessageSid()
                    )
                )
            )
        );
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(ctx__.getCon());
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult searchResult =
            new ChatMessageSearcher(
                ctx__.getCon(),
                searchReq,
                adminMdl)
                .execute();

            if (searchResult.getHitCount() == 0) {
                result__ = null;
                return;
            }

            MessagesResultModelConverter converter =
                new MessagesResultModelConverter(ctx__);

            List<ChtEntitiesMessagesResultModel> resultList =
                converter.execute(searchResult.getList());

            result__ = resultList.get(0);
        } catch (TargetMessageWrongException e) {
            result__ = null;
            return;
        }

    }
    /** ピン留めの実行
     * @throws SQLException */
    private void __exePin() throws SQLException {
        int sessionUserSid = ctx__.getRequestUserSid();
        Connection con = ctx__.getCon();

        if (param__.getType() == EnumChatType.group) {


            ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con);

            ChtGroupInfModel gmdl = __getGmdl();
            if (gPinDao.select(sessionUserSid, gmdl.getCgiSid(), param__.getMessageSid()) != null) {
                //既に存在している為、ピンどめを行わない。
                return;
            }

            ChtGroupDataPinModel pinMdl = new ChtGroupDataPinModel();
            int maxSort = gPinDao.getMaxSort(
                            sessionUserSid, gmdl.getCgiSid());
            pinMdl.setUsrSid(sessionUserSid);
            pinMdl.setCgiSid(gmdl.getCgiSid());
            pinMdl.setCgdSid(param__.getMessageSid());
            pinMdl.setCgdpSort(maxSort + 1);
            gPinDao.insert(pinMdl);

        } else {
            ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con);

            int pairSid = __getPairSid();

            if (uPinDao.select(sessionUserSid, pairSid, param__.getMessageSid()) != null) {
                //既に存在している為、ピンどめを行わない。
                return;
            }
            ChtUserDataPinModel pinMdl = new ChtUserDataPinModel();
            int maxSort = uPinDao.getMaxSort(sessionUserSid, pairSid);
            pinMdl.setUsrSid(sessionUserSid);
            pinMdl.setCupSid(pairSid);
            pinMdl.setCudSid(param__.getMessageSid());
            pinMdl.setCudpSort(maxSort + 1);
            uPinDao.insert(pinMdl);
        }
    }
    /**
     *
     * @return チャット対象のペアSIDを返す
     * @throws SQLException
    */
    private int __getPairSid()
            throws SQLException {
        if (pairSid__ > 0) {
            return pairSid__;
        }
        int sessionUserSid = ctx__.getRequestUserSid();
        Connection con = ctx__.getCon();

        ChtUserPairDao pairDao = new ChtUserPairDao(con);
        CmnUsrmModel umdl = __getUmdl();

        pairSid__ = pairDao.select(sessionUserSid, umdl.getUsrSid());
        return pairSid__;
    }
    /**
     *
     * @return チャット対象のユーザ情報を返す
     * @throws SQLException
    */
    private CmnUsrmModel __getUmdl()
            throws SQLException {

        if (umdl__ != null) {
            return umdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        if (param__.getDeleteUserSid() > 0) {
            int partnerUsrSid = param__.getDeleteUserSid();
            umdl__ = infoBiz.getDeletedUserChatInf(partnerUsrSid, param__.getUserId());
        } else {
            umdl__ = infoBiz.getUserChatInf(param__.getUserId());
        }

        if (umdl__ == null) {
            throw new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.48")
            );
        }
        return umdl__;
    }
    /**
     *
     * @return チャットグループ情報を返す
     * @throws SQLException
     */
    private ChtGroupInfModel __getGmdl()
            throws SQLException {
        if (gmdl__ != null) {
            return gmdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        gmdl__ = infoBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());
        return gmdl__;
    }

    /**
     * ピン留めを解除する
     * @throws SQLException
     */
    private void __removePin() throws SQLException {
        int sessionUserSid = ctx__.getRequestUserSid();
        Connection con = ctx__.getCon();

        if (param__.getType() == EnumChatType.group) {
            ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con);

            ChtGroupInfModel gmdl = __getGmdl();

            gPinDao.delete(sessionUserSid, gmdl.getCgiSid(), param__.getMessageSid());

        } else {
            ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con);

            int pairSid = __getPairSid();

            uPinDao.delete(sessionUserSid, pairSid, param__.getMessageSid());

        }
    }
    /**
     *
     * @return 実行結果 メッセージモデル
    */
    public ChtEntitiesMessagesResultModel getResult() {
        return result__;
    }

}
