package jp.groupsession.v2.cht.restapi.entities.messages.pinnedindex;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.sjts.util.struts.RequestLocal;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.biz.ChtUserPinSortChanger;
import jp.groupsession.v2.cht.dao.ChatDao;
import jp.groupsession.v2.cht.dao.ChtGroupDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserDataPinDao;
import jp.groupsession.v2.cht.dao.ChtUserPairDao;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupDataModel;
import jp.groupsession.v2.cht.model.ChtGroupDataPinModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.model.ChtUserDataModel;
import jp.groupsession.v2.cht.model.ChtUserDataPinModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessagesResultModel;
import jp.groupsession.v2.cht.restapi.entities.messages.MessagesResultModelConverter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter.EnumType;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cht.search.position.OffsetPosition;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesPinnedindexPutBiz {
    /** パラメータ */
    private final ChtEntitiesMessagesPinnedindexParamModel param__;

    /** APIコンテキスト */
    private final RestApiContext ctx__;

    /**実行結果 メッセージモデル */
    private ChtEntitiesMessagesResultModel result__;

    /**チャットグループ */
    private ChtGroupInfModel gmdl__ = null;

    /**チャット相手ユーザ情報 */
    private CmnUsrmModel umdl__ = null;

    /**チャット相手 ペアSID */
    private int pairSid__;

    /** メッセージ情報(グループ) */
    private ChtGroupDataModel groupMessageMdl__;

    /** メッセージ情報(ユーザ) */
    private ChtUserDataModel userMessageMdl__;

    /** ピン留め挿入先ターゲット情報(グループ) */
    private ChtGroupDataPinModel groupMessagePinMdl__;

    /** ピン留め挿入先ターゲット情報(ユーザ) */
    private ChtUserDataPinModel userMessagePinMdl__;


    /** ピン留め挿入先ターゲット情報(グループ) */
    private ChtGroupDataPinModel targetGroupPinMdl__;

    /** ピン留め挿入先ターゲット情報(ユーザ) */
    private ChtUserDataPinModel targetUserPinMdl__;


    /**
     * コンストラクタ
     * @param param
     * @param ctx
     */
    private ChtEntitiesMessagesPinnedindexPutBiz(ChtEntitiesMessagesPinnedindexParamModel param,
            RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }

    /**
     * リクエスト内でビジネスロジックをシングルトンオブジェクトとして取得する
     * 一度もアクセスしていない場合、新規作成
     * @param param
     * @param ctx
     * @return リクエスト内でシングルトン管理されたビジネスロジッククラス
     */
    public static ChtEntitiesMessagesPinnedindexPutBiz getInstance(
        ChtEntitiesMessagesPinnedindexParamModel param,
        RestApiContext ctx) {
        ChtEntitiesMessagesPinnedindexPutBiz ret = RequestLocal.get(
            ChtEntitiesMessagesPinnedindexPutBiz.class,
            ChtEntitiesMessagesPinnedindexPutBiz.class);
        if (ret == null) {
            ret = new ChtEntitiesMessagesPinnedindexPutBiz(param, ctx);
            RequestLocal.put(ChtEntitiesMessagesPinnedindexPutBiz.class,
            ret);
        }
        return ret;
    }


    /**
     * パラメータ入力チェック
     * @throws SQLException
     * @throws RestApiValidateExceptionNest 入力チェック例外
    */
    public void validate() throws SQLException, RestApiValidateExceptionNest {
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());


        ChtGroupInfModel gmdl = null;
        CmnUsrmModel umdl = null;
        List<RestApiValidateException> valErrors = new ArrayList<>();
        //チャット指定権限チェック
        try {
            if (param__.getType() == EnumChatType.group) {
                gmdl = __getGmdl();
            } else {
                umdl = __getUmdl();
            }
        } catch (RestApiPermissionException e) {
            throw
                new RestApiPermissionException(
                ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                "errors.free.msg",
                gsMsg.getMessage("cht.cht010.43")
                ).setParamName("messageSid");
        }

        //グループメッセージ指定権限チェック
        if (gmdl != null) {
            ChtGroupDataModel mesMdl = null;
            try {
                mesMdl = __getGroupMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }

            } catch (RestApiPermissionException e) {
                throw
                    new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.43")
                        ).setParamName("messageSid");
            }
            //メッセージ指定権限チェック（ピンどめされているか）
            ChtGroupDataPinModel beforePinMdl = __getGrpupMessagePinMdl();
            if (beforePinMdl == null) {
                throw
                    new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES_PINNED,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.43")
                        ).setParamName("messageSid");
            }

        //ユーザメッセージ指定権限チェック
        } else if (umdl != null) {
            ChtUserDataModel mesMdl = null;
            try {
                mesMdl = __getUserMessageModel();
                if (mesMdl == null) {
                    throw new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                        "errors.free.msg", "");
                }
            } catch (RestApiPermissionException e) {
                throw new RestApiPermissionException(
                    ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
                    ).setParamName("messageSid");
            }
            //メッセージ指定権限チェック（ピンどめされているか）
            ChtUserDataPinModel beforePinMdl = __getUserMessagePinMdl();
            if (beforePinMdl == null) {
                throw
                    new RestApiPermissionException(
                        ChtEnumReasonCode.RESOURCE_CANT_ACCESS_MESSAGES_PINNED,
                        "errors.free.msg",
                        gsMsg.getMessage("cht.cht010.43")
                        ).setParamName("messageSid");
            }

        }

        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }
    /**
     *
     * @return 操作対象のピンどめモデルを取得する
     * @throws SQLException
     */
    private ChtGroupDataPinModel __getGrpupMessagePinMdl() throws SQLException {
        if (groupMessagePinMdl__ != null) {
            return groupMessagePinMdl__;
        }

        ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(ctx__.getCon());
        groupMessagePinMdl__ = gPinDao.select(
            ctx__.getRequestUserSid(),
            __getGmdl().getCgiSid(),
            param__.getMessageSid());

        return groupMessagePinMdl__;
    }

    /**
     *
     * @return 操作対象のピンどめモデルを取得する
     * @throws SQLException
     */
    private ChtUserDataPinModel __getUserMessagePinMdl() throws SQLException {
        if (userMessagePinMdl__ != null) {
            return userMessagePinMdl__;
        }

        ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(ctx__.getCon());

        int pairSid = __getPairSid();

        //移動対象となるピンどめ情報
        userMessagePinMdl__ = uPinDao.select(
            ctx__.getRequestUserSid(),
            pairSid,
            param__.getMessageSid());
        return userMessagePinMdl__;
    }

    /**
     * 対象メッセージモデル(ユーザ)を取得する
     * @return メッセージモデル(ユーザ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtUserDataModel __getUserMessageModel()
        throws RestApiPermissionException, SQLException {
        if (userMessageMdl__ != null) {
            return userMessageMdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        userMessageMdl__ = mesBiz.getUserChatMessage(__getUmdl(), param__.getMessageSid());
        return userMessageMdl__;
    }

    /**
     * 対象メッセージモデル(グループ)を取得する
     * @return メッセージモデル(グループ)
     * @throws RestApiPermissionException
     * @throws SQLException
     */
    private ChtGroupDataModel __getGroupMessageModel()
        throws RestApiPermissionException, SQLException {
        if (groupMessageMdl__ != null) {
            return groupMessageMdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
            ctx__.getCon(), gsMsg, ctx__.getRequestUserSid());

        groupMessageMdl__ = mesBiz.getGroupChatMessage(__getGmdl(), param__.getMessageSid());
        return groupMessageMdl__;
    }

    /** ビジネスロジックの実行
     * @throws SQLException */
    public void execute() throws SQLException {
        __preloadOldIndexData();

        __changeSortNum();

        __createResult();

    }
    /** 挿入先情報の事前取得
     * @throws SQLException */
    private void __preloadOldIndexData() throws SQLException {
        int sessionUserSid = ctx__.getRequestUserSid();
        Connection con = ctx__.getCon();
        RequestModel reqMdl = ctx__.getRequestModel();

        if (param__.getType() == EnumChatType.group) {

            ChatMessageSearchRequest searchReq = null;

            searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
                reqMdl,
                __getGmdl().getCgiSid());
            searchReq.setPosition(
                new OffsetPosition(param__.getIndexNum())
            );
            searchReq.setTargetPinKbn(GSConstChat.CHAT_MESSAGE_GET_PIN);
            searchReq.setLimit(1);
            searchReq.setOrder(GSConst.ORDER_KEY_DESC);


            ChatDao cDao = new ChatDao(con);
            int mesCnt = cDao.getSearchInfoGroupMessage(searchReq)
                .getHitCnt();
            int index = param__.getIndexNum();
            if (mesCnt <= index) {
                index = mesCnt - 1;
            }
            if (index < 0) {
                index = 0;
            }

            ChtGroupDataPinDao gPinDao = new ChtGroupDataPinDao(con);
            targetGroupPinMdl__ =
                gPinDao.selectIndex(
                    sessionUserSid,
                    __getGmdl().getCgiSid(),
                    index,
                    GSConst.ORDER_KEY_DESC);
        }
        if (param__.getType() == EnumChatType.user) {
            ChatMessageSearchRequest searchReq = null;

            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                con,
                reqMdl,
                __getUmdl().getUsrSid());
            searchReq.setPosition(
                new OffsetPosition(param__.getIndexNum())
            );
            searchReq.setTargetPinKbn(GSConstChat.CHAT_MESSAGE_GET_PIN);
            searchReq.setLimit(1);
            searchReq.setOrder(GSConst.ORDER_KEY_DESC);


            ChatDao cDao = new ChatDao(con);
            int mesCnt = cDao.getSearchInfoUserMessage(searchReq)
                .getHitCnt();

            int index = param__.getIndexNum();
            if (mesCnt <= index) {
                index = mesCnt - 1;
            }
            if (index < 0) {
                index = 0;
            }

            ChtUserDataPinDao uPinDao = new ChtUserDataPinDao(con);

            targetUserPinMdl__ =
                uPinDao.selectIndex(
                    sessionUserSid,
                    __getPairSid(),
                    index,
                    GSConst.ORDER_KEY_DESC
                    );
        }

    }
    /** 結果モデルの生成
     * @throws SQLException */
    private void __createResult() throws SQLException {
        ChatMessageSearchRequest searchReq;
        if (param__.getType() == EnumChatType.group) {

            searchReq =
                ChatMessageSearchRequest.createGroupChatSearchModel(
                    ctx__.getRequestModel(),
                    __getGmdl().getCgiSid());

        } else {
            searchReq =
                ChatMessageSearchRequest.createUserChatSearchModel(
                    ctx__.getCon(),
                    ctx__.getRequestModel(),
                    __getUmdl().getUsrSid());
        }

        searchReq.setFilterList(
            List.of(
                new ChatMessageSearchFilter(
                    EnumType.message,
                    String.valueOf(
                        param__.getMessageSid()
                    )
                )
            )
        );
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(ctx__.getCon());
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult searchResult =
            new ChatMessageSearcher(
                ctx__.getCon(),
                searchReq,
                adminMdl)
                .execute();

            if (searchResult.getHitCount() == 0) {
                result__ = null;
                return;
            }

            MessagesResultModelConverter converter =
                new MessagesResultModelConverter(ctx__);

            List<ChtEntitiesMessagesResultModel> resultList =
                converter.execute(searchResult.getList());

            result__ = resultList.get(0);
        } catch (TargetMessageWrongException e) {
            result__ = null;
            return;
        }

    }

    private int __getPairSid()
            throws SQLException {
        if (pairSid__ > 0) {
            return pairSid__;
        }

        int sessionUserSid = ctx__.getRequestUserSid();

        CmnUsrmModel umdl = __getUmdl();

        ChtUserPairDao pairDao = new ChtUserPairDao(ctx__.getCon());

        pairSid__ = pairDao.select(sessionUserSid, umdl.getUsrSid());

        return pairSid__;
    }
    /**
     *
     * @return チャット対象のユーザ情報を返す
     * @throws SQLException
    */
    private CmnUsrmModel __getUmdl()
            throws SQLException {

        if (umdl__ != null) {
            return umdl__;
        }
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());

        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        if (param__.getDeleteUserSid() > 0) {
            umdl__ = ceiBiz.getDeletedUserChatInf(
                param__.getDeleteUserSid(),
                param__.getUserId());
        } else {
            umdl__ = ceiBiz.getUserChatInf(param__.getUserId());
        }
        return umdl__;
    }
    /**
     *
     * @return チャットグループ情報を返す
     * @throws SQLException
     */
    private ChtGroupInfModel __getGmdl()
            throws SQLException {
        if (gmdl__ != null) {
            return gmdl__;
        }

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        ChtEntitiesInfoBiz infoBiz = new ChtEntitiesInfoBiz(ctx__.getCon(), gsMsg);

        gmdl__ = infoBiz.getGroupChatInf(param__.getChatGroupId(), ctx__.getRequestUserSid());
        return gmdl__;
    }

    /** sortNumの値を更新する
     * @throws SQLException */
    private void __changeSortNum() throws SQLException {
        Connection con = ctx__.getCon();
        RequestModel reqMdl = ctx__.getRequestModel();

        if (param__.getType() == EnumChatType.group) {

            //移動対象となるピンどめ情報
            ChtGroupDataPinModel beforePinMdl = __getGrpupMessagePinMdl();

            //移動先にあるピンどめ情報
            ChtGroupDataPinModel afterPinMdl = targetGroupPinMdl__;

            int startSort = beforePinMdl.getCgdpSort();
            int endSort = afterPinMdl.getCgdpSort();
            ChtUserPinSortChanger sortBiz =
                ChtUserPinSortChanger.getInstanceForGroupChat(
                    con, reqMdl, __getGmdl().getCgiSid());
            sortBiz.sort(startSort,
                    endSort);

        } else {
            int pairSid = __getPairSid();

            //移動対象となるピンどめ情報
            ChtUserDataPinModel beforePinMdl = __getUserMessagePinMdl();
            //移動先にあるピンどめ情報
            ChtUserDataPinModel afterPinMdl = targetUserPinMdl__;

            ChtUserPinSortChanger sortBiz =
                ChtUserPinSortChanger.getInstanceForUserChat(con, reqMdl, pairSid);

            int startSort = beforePinMdl.getCudpSort();
            int endSort = afterPinMdl.getCudpSort();

            sortBiz.sort(startSort,
            endSort);

        }
    }

    /**
     *
     * @return 実行結果 メッセージモデル
    */
    public ChtEntitiesMessagesResultModel getResult() {
        return result__;
    }

}
