package jp.groupsession.v2.cht.restapi.entities.messages.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtEntitiesMessagesAction extends AbstractRestApiAction {
    /**
     * メッセージ一覧検索API アクションメソッド
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Post
    public void doPostQuery(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtEntitiesMessagesQueryParamModel param,
        RestApiContext ctx) throws SQLException {


        ChtEntitiesMessagesQueryBiz biz = new ChtEntitiesMessagesQueryBiz(param,
                ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .setMax(biz.getMax())
        .setAttribute("offset", String.valueOf(biz.getResultOffset()))
        .build().execute();

    }

}
