package jp.groupsession.v2.cht.restapi.entities.messages.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.biz.ChtBiz;
import jp.groupsession.v2.cht.model.ChtAdmConfModel;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessagesResultModel;
import jp.groupsession.v2.cht.restapi.entities.messages.MessagesResultModelConverter;
import jp.groupsession.v2.cht.search.ChatMessageSearchFilter;
import jp.groupsession.v2.cht.search.ChatMessageSearchRequest;
import jp.groupsession.v2.cht.search.ChatMessageSearchResult;
import jp.groupsession.v2.cht.search.ChatMessageSearcher;
import jp.groupsession.v2.cht.search.TargetMessageWrongException;
import jp.groupsession.v2.cht.search.position.AfterMessage;
import jp.groupsession.v2.cht.search.position.ArroundMessage;
import jp.groupsession.v2.cht.search.position.BeforeMessage;
import jp.groupsession.v2.cht.search.position.MidokuPosition;
import jp.groupsession.v2.cht.search.position.OffsetPosition;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.struts.msg.GsMessage;

public class ChtEntitiesMessagesQueryBiz {

    /** パラメータ*/
    private ChtEntitiesMessagesQueryParamModel param__;
    /** APIコンテキスト*/
    private RestApiContext ctx__;

    /** 検索結果*/
    private List<ChtEntitiesMessagesResultModel> result__ = List.of();
    /** 検索結果件数*/
    private int max__ = 0;
    /** 検索結果オフセット位置*/
    private int resultOffset__ = 0;

    /**
     * コンストラクタ
     * @param param
     * @param ctx
     */
    public ChtEntitiesMessagesQueryBiz(ChtEntitiesMessagesQueryParamModel param,
            RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
    }
    /**
     * APIビジネスロジックの実行
     * @throws SQLException
    */
    public void execute() throws SQLException {
        ChatMessageSearchRequest searchReq = null;
        Connection con = ctx__.getCon();
        RequestModel reqMdl = ctx__.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);

        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con, gsMsg);
        if (param__.getType() == EnumChatType.group) {
            ChtGroupInfModel gmdl = ceiBiz.getGroupChatInf(
                param__.getChatGroupId(), ctx__.getRequestUserSid());

            searchReq = ChatMessageSearchRequest.createGroupChatSearchModel(
                ctx__.getRequestModel(),
                gmdl.getCgiSid()
            );
        } else if (param__.getDeleteUserSid() > 0) {
            int partnerUsrSid = param__.getDeleteUserSid();
            //指定したユーザとのチャット情報が取得できない場合、エラーを返す
            ceiBiz.getDeletedUserChatInf(partnerUsrSid, param__.getUserId());

            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                ctx__.getCon(),
                ctx__.getRequestModel(),
                partnerUsrSid);

        } else {
            CmnUsrmModel umdl = ceiBiz.getUserChatInf(param__.getUserId());

            searchReq = ChatMessageSearchRequest.createUserChatSearchModel(
                ctx__.getCon(),
                ctx__.getRequestModel(),
                umdl.getUsrSid());

        }

        switch (param__.getPositionType()) {
            case midoku:
                searchReq.setPosition(
                    new MidokuPosition()
                );
                break;
            case offset:
                searchReq.setPosition(
                    new OffsetPosition(param__.getOffset())
                );
                break;
            case before:
                searchReq.setPosition(
                    new BeforeMessage(param__.getMessageSid())
                );
                break;
            case around:
                searchReq.setPosition(
                    new ArroundMessage(param__.getMessageSid())
                );
                break;
            case after:
                searchReq.setPosition(
                    new AfterMessage(param__.getMessageSid())
                );
                break;
            default:
        }
        searchReq.setLimit(param__.getLimit());
        searchReq.setOrder(param__.getOrder());
        if (param__.getPinnedFlg() == GSConstChat.CHAT_MESSAGE_GET_PIN) {
            searchReq.setPosition(new OffsetPosition(param__.getOffset()));
            searchReq.setTargetPinKbn(param__.getPinnedFlg());
        }

        //検索条件設定

        List<ChatMessageSearchFilter> filters = new ArrayList<>();

        if (StringUtil.isNullZeroString(param__.getKeywordText()) == false) {
            //キーワード検索の追加
            String[] keywords = param__.getKeywordText().split("((\\s)|(　))");
            Stream.of(keywords)
                .forEach(keyword -> {
                    filters.add(
                        new ChatMessageSearchFilter(
                            ChatMessageSearchFilter.EnumType.keyword,
                            keyword
                        ));
                });

        }

        switch (param__.getAttachmentType()) {
            case ATTACHMENTED:
                filters.add(
                    new ChatMessageSearchFilter(
                        ChatMessageSearchFilter.EnumType.attachmentAll,
                        ""
                    ));
                break;
            case NO_ATTACHMENT:
                filters.add(
                    new ChatMessageSearchFilter(
                        ChatMessageSearchFilter.EnumType.attachmentLess,
                        ""
                ));
                break;
            default:
        }

        switch (param__.getUrlType()) {
            case URL:
                filters.add(
                    new ChatMessageSearchFilter(
                        ChatMessageSearchFilter.EnumType.urlAll,
                        ""
                    ));
                break;
            case NO_URL:
                filters.add(
                    new ChatMessageSearchFilter(
                        ChatMessageSearchFilter.EnumType.urlLess,
                        ""
                ));
                break;
            default:
        }

        if (param__.getSenderId() != null && param__.getSenderId().length > 0) {
            //不正なID指定で全件検索になるのを防ぐ
            filters.add(
                new ChatMessageSearchFilter(
                    ChatMessageSearchFilter.EnumType.user,
                    "-1"
            ));

            Stream.of(param__.getSenderId())
                .forEach(usrId -> {
                    CmnUsrmDao usrDao = new CmnUsrmDao(con);

                    CmnUsrmModel umdl;
                    try {
                        umdl = usrDao.select(usrId);
                    } catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                    if (umdl != null) {
                        filters.add(
                            new ChatMessageSearchFilter(
                                ChatMessageSearchFilter.EnumType.user,
                                String.valueOf(umdl.getUsrSid())
                        ));
                    }
                });
        }

        if (param__.getNonMemberType() == EnumNonmemberType.NOMEMBER) {
            filters.add(
                new ChatMessageSearchFilter(
                    ChatMessageSearchFilter.EnumType.outMember,
                    ""
            ));

        }
        //検索時は削除済みメッセージを除外
        if (filters.size() > 0) {
            filters.add(
                new ChatMessageSearchFilter(
                    ChatMessageSearchFilter.EnumType.deletedLess,
                    ""
            ));
        }
        searchReq.setFilterList(filters);
        //管理者設定の取得
        ChtBiz chtBiz = new ChtBiz(con);
        ChtAdmConfModel adminMdl = chtBiz.getChtAconf();
        try {
            ChatMessageSearchResult result =
            new ChatMessageSearcher(
               con,
               searchReq,
               adminMdl)
               .execute();

            max__ = result.getHitCount();

            resultOffset__ = result.getResultOffset();

            MessagesResultModelConverter converter = new MessagesResultModelConverter(ctx__);
            result__ = converter.execute(result.getList());

        } catch (TargetMessageWrongException e) {
            throw new RestApiValidateException(
                ChtEnumReasonCode.PARAM_CANT_ACCESS_MESSAGE,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
            ).setParamName("messageSid");
        }

    }


    /**
     * @return the result
     */
    public List<ChtEntitiesMessagesResultModel> getResult() {
        return result__;
    }
    /**
     * @return the max
     */
    public int getMax() {
        return max__;
    }
    /**
     * @return the resultOffset
     */
    public int getResultOffset() {
        return resultOffset__;
    }




}
