package jp.groupsession.v2.cht.restapi.entities.messages.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;

import jp.co.sjts.util.StringUtil;
import jp.groupsession.v2.cht.ChatValidate;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.cht.model.ChtGroupInfModel;
import jp.groupsession.v2.cht.restapi.ChtEnumReasonCode;
import jp.groupsession.v2.cht.restapi.entities.ChtEntitiesInfoBiz;
import jp.groupsession.v2.cht.restapi.entities.EnumChatType;
import jp.groupsession.v2.cht.restapi.entities.messages.ChtEntitiesMessageBiz;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.ReasonCode;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.exception.RestApiValidateExceptionNest;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.MaxArraySize;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.struts.msg.GsMessage;

/** メッセージ一覧取得API パラメータ */
@ParamModel
public class ChtEntitiesMessagesQueryParamModel {
    /** チャットタイプ */
    private EnumChatType type__;
    /** チャット相手ログインID */
    private String userId__;
    /** チャット相手ログインID */
    private String chatGroupId__;

    /** 削除済みユーザSID */
    private int deleteUserSid__ = -1;

    /** 取得件数 */
    @Default("50")
    @MaxValue(100)
    @MinValue(1)
    private int limit__;

    /** 取得開始位置指定タイプ */

    @Default("midoku")
    @Selectable({
        /** offset数分移動した位置 */
        "offset",

        /** 未読メッセージ以後 */
        "midoku",

        /** 指定メッセージより前のメッセージ */
        "before",

        /** 指定メッセージを含むメッセージ */
        "around",

        /** 指定メッセージより後のメッセージ */
        "after"
    })
    private EnumPositionTypeForApi positionType__;

    /** 取得開始位置 */
    @Default("0")
    @MinValue(0)
    private int offset__;

    /** 位置参照メッセージSID */
    @Default("0")
    private long messageSid__;

    /** ソート昇順降順 */
    @Default("0")
    @Selectable({"0", "1"})
    private int order__;

    /** キーワード */
    @MaxLength(
        GSConstChat.MAX_LENGTH_KEYWORD_MESSAGE * 10
         + GSConstChat.MAX_COUNT_KEYWORD_MESSAGE - 1)
    private String keywordText__;

    /** 送信者ID */
    @MaxArraySize(10)
    private String[] senderId__;

    /** メンバー外送信者検索タイプ */
    @Default("0")
    @Selectable({"0", "1"})
    private EnumNonmemberType nonMemberType__;

    /** URL検索タイプ */
    @Default("0")
    @Selectable({"0", "1", "2"})
    private EnumUrlType urlType__;

    /** 添付ファイル検索タイプ */
    @Default("0")
    @Selectable({"0", "1", "2"})
    private EnumAttachmentType attachmentType__;

    /** ピン留め検索タイプ */
    @Default("0")
    @Selectable({"0", "1"})
    private int pinnedFlg__;

    /**
     * @return the type
     */
    public EnumChatType getType() {
        return type__;
    }

    /**
     * @param type the type to set
     */
    public void setType(EnumChatType type) {
        type__ = type;
    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the chatGroupId
     */
    public String getChatGroupId() {
        return chatGroupId__;
    }

    /**
     * @param chatGroupId the chatGroupId to set
     */
    public void setChatGroupId(String chatGroupId) {
        chatGroupId__ = chatGroupId;
    }

    /**
     * @return the deleteUserSid
     */
    public int getDeleteUserSid() {
        return deleteUserSid__;
    }

    /**
     * @param deleteUserSid the deleteUserSid to set
     */
    public void setDeleteUserSid(int deleteUserSid) {
        deleteUserSid__ = deleteUserSid;
    }

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the positionType
     */
    public EnumPositionTypeForApi getPositionType() {
        return positionType__;
    }

    /**
     * @param positionType the positionType to set
     */
    public void setPositionType(EnumPositionTypeForApi positionType) {
        positionType__ = positionType;
    }

    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }

    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * @return the messageSid
     */
    public long getMessageSid() {
        return messageSid__;
    }

    /**
     * @param messageSid the messageSid to set
     */
    public void setMessageSid(long messageSid) {
        messageSid__ = messageSid;
    }

    /**
     * @return the order
     */
    public int getOrder() {
        return order__;
    }

    /**
     * @param order the order to set
     */
    public void setOrder(int order) {
        order__ = order;
    }

    /**
     * @return the keywordText
     */
    public String getKeywordText() {
        return keywordText__;
    }

    /**
     * @param keywordText the keywordText to set
     */
    public void setKeywordText(String keywordText) {
        keywordText__ = keywordText;
    }

    /**
     * @return the senderId
     */
    public String[] getSenderId() {
        return senderId__;
    }

    /**
     * @param senderId the senderId to set
     */
    public void setSenderId(String[] senderId) {
        senderId__ = senderId;
    }

    /**
     * @return the nonMemberType
     */
    public EnumNonmemberType getNonMemberType() {
        return nonMemberType__;
    }

    /**
     * @param nonMemberType the nonMemberType to set
     */
    public void setNonMemberType(EnumNonmemberType nonMemberType) {
        nonMemberType__ = nonMemberType;
    }

    /**
     * @return the urlType
     */
    public EnumUrlType getUrlType() {
        return urlType__;
    }

    /**
     * @param urlType the urlType to set
     */
    public void setUrlType(EnumUrlType urlType) {
        urlType__ = urlType;
    }

    /**
     * @return the attachmentType
     */
    public EnumAttachmentType getAttachmentType() {
        return attachmentType__;
    }

    /**
     * @param attachmentType the attachmentType to set
     */
    public void setAttachmentType(EnumAttachmentType attachmentType) {
        attachmentType__ = attachmentType;
    }

    /**
     * @return the pinnedType
     */
    public int getPinnedFlg() {
        return pinnedFlg__;
    }

    /**
     * @param pinnedFlg the pinnedType to set
     */
    public void setPinnedFlg(int pinnedFlg) {
        pinnedFlg__ = pinnedFlg;
    }

    /**
     * パラメータ入力チェック
     * @param ctx
     * @throws SQLException
    */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {
        Connection con = ctx.getCon();
        GsMessage gsMsg = new GsMessage(ctx.getRequestModel());
        ChtEntitiesInfoBiz ceiBiz = new ChtEntitiesInfoBiz(con, gsMsg);
        ChtGroupInfModel gmdl = null;
        CmnUsrmModel umdl = null;
        List<RestApiValidateException> valErrors = new ArrayList<>();
        if (getType() == EnumChatType.group) {
            gmdl = ceiBiz.getGroupChatInf(
                getChatGroupId(), ctx.getRequestUserSid());

        } else if (getDeleteUserSid() > 0) {
            int partnerUsrSid = getDeleteUserSid();
            //指定したユーザとのチャット情報が取得できない場合、エラーを返す
            umdl = ceiBiz.getDeletedUserChatInf(partnerUsrSid, getUserId());

        } else {
            umdl = ceiBiz.getUserChatInf(getUserId());
        }

        //指定メッセージへの入力チェック
        if (getPositionType() == EnumPositionTypeForApi.before
            || getPositionType() == EnumPositionTypeForApi.around
            || getPositionType() == EnumPositionTypeForApi.after) {
            ChtEntitiesMessageBiz mesBiz = new ChtEntitiesMessageBiz(
                con, gsMsg, ctx.getRequestUserSid());
            try {
                if (gmdl != null) {
                    mesBiz.getGroupChatMessage(gmdl, getMessageSid(), true);
                } else if (umdl != null) {
                    mesBiz.getUserChatMessage(umdl, getMessageSid(), true);
                }
            } catch (RestApiPermissionException e) {
                valErrors.add(
                    new RestApiValidateException(
                    ChtEnumReasonCode.PARAM_CANT_ACCESS_MESSAGE,
                    "errors.free.msg",
                    gsMsg.getMessage("cht.cht010.43")
                    ).setParamName("messageSid")
                );
            }
        }

        //キーワード入力チェック
        if (StringUtil.isNullZeroString(keywordText__) == false) {
            String[] keywords = keywordText__.split("[\\s]+");
            ActionErrors errors = new ActionErrors();
            errors = ChatValidate.validateChtAllFieldText(
                errors,
                "keywordText",
                keywordText__,
                "filter.keyword",
                false,
                false);

            if (errors.size() > 0) {
                ActionMessage msg = (ActionMessage) errors.get().next();
                valErrors.add(
                    new RestApiValidateException(
                        ReasonCode.EnumError.PARAM_LETER,
                        msg.getKey(),
                        msg.getValues())
                        .setParamName("keywordText"));
            }


            for (String keyword : keywords) {
                //MAX桁チェック
                if (keyword.length() > GSConstChat.MAX_LENGTH_KEYWORD_MESSAGE) {
                    valErrors.add(
                        new RestApiValidateException(
                            ReasonCode.EnumError.PARAM_MAXLENGTH,
                            "error.input.length.text",
                            gsMsg.getMessage("cmn.keyword"),
                            GSConstChat.MAX_LENGTH_KEYWORD_MESSAGE)
                            .setParamName("keywordText")
                    );
                }
            }
            //キーワード件数オーバー
            if (keywords.length > GSConstChat.MAX_COUNT_KEYWORD_MESSAGE) {
                valErrors.add(
                    new RestApiValidateException(
                        ReasonCode.EnumError.PARAM_MAXLENGTH,
                        "error.input.array.size.over",
                        gsMsg.getMessage("cmn.keyword"),
                        GSConstChat.MAX_COUNT_KEYWORD_MESSAGE)
                        .setParamName("keywordText")
                );
            }

        }


        if (valErrors.size() > 0) {
            throw new RestApiValidateExceptionNest(valErrors);
        }

    }
}