package jp.groupsession.v2.cht.restapi.entities.messages.query;

import jp.groupsession.v2.cht.search.position.EnumPositionType;
/** 列挙型 メッセージ取得位置指定タイプ */
public enum EnumPositionTypeForApi {
    /** offset数分移動した位置 */
    offset(EnumPositionType.OFFSET),

    /** 未読メッセージ以後 */
    midoku(EnumPositionType.MIDOKUSTART),

    /** 指定メッセージより前のメッセージ */
    before(EnumPositionType.BEFORE_MESSAGE),

    /** 指定メッセージを含むメッセージ */
    around(EnumPositionType.ARROUND_MESSAGE),

    /** 指定メッセージより後のメッセージ */
    after(EnumPositionType.AFTER_MESSAGE);

    /** 検索ポジションタイプへの紐づけ */
    private final EnumPositionType positionType__;

    EnumPositionTypeForApi(EnumPositionType type) {
        positionType__ = type;
    }

    /**
     * @return the positionType
     */
    public EnumPositionType getForPcType() {
        return positionType__;
    }

}
