package jp.groupsession.v2.cht.restapi.entities.messages.query;

import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.restapi.response.MinimalUserInfoModel;
import jp.groupsession.v2.struts.msg.GsMessage;

public class MentionInfoModel {
    /** ユーザ情報（メンションタイプ：ユーザ時用） */
    private final MinimalUserInfoModel umodel__;
    /** メンション全員時 のテキスト*/
    private String allText__ = null;

    /** メンションタイプ */
    enum EnumMentionType {
        /** 全員*/
        all,
        /** ユーザ*/
        user
    }
    /**
     * コンストラクタ
     * @param minimalUserInfoModel ユーザ情報
     */
    private MentionInfoModel(MinimalUserInfoModel minimalUserInfoModel) {
        umodel__ = minimalUserInfoModel;
    }
    /**
     *
     * @return メンションタイプ 全員 モデル
     */
    public static MentionInfoModel createInstanseTypeAll(GsMessage gsMessage) {
        MentionInfoModel ret = new MentionInfoModel(null);
        ret.type__ = EnumMentionType.all;
        ret.allText__ = gsMessage.getMessage("cht.cht010.80");
        return ret;
    }

    /**
     *
     * @return メンションタイプ 全員 モデル
     * @param sessionUsrSid
     * @param baseModel
     */
    public static MentionInfoModel createInstanseTypeUser(
        int sessionUsrSid, CmnUserModel baseModel) {
        MentionInfoModel ret = new MentionInfoModel(
            new MinimalUserInfoModel(sessionUsrSid, baseModel)
            );
        ret.type__ = EnumMentionType.user;

        return ret;
    }

    /** type */
    private EnumMentionType type__;



    /**
     * @return the type
     */
    public EnumMentionType getType() {
        return type__;
    }

    /**
     * @return ユーザID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getId()
     */

    public String getId() {
        if (type__ == EnumMentionType.all) {
            return "";
        }
        return umodel__.getId();
    }

    /**
     * @return ユーザSID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getSid()
     */

    public int getSid() {
        if (type__ == EnumMentionType.all) {
            return -1;
        }
        return umodel__.getSid();
    }

    /**
     * @return 名称
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getName()
     */

    public String getName() {
        if (type__ == EnumMentionType.all) {
            return allText__;
        }
        return umodel__.getName();
    }

    /**
     * @return チャット相手ログイン停止フラグ
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getLoginStopFlg()
     */

    public int getLoginStopFlg() {
        if (type__ == EnumMentionType.all) {
            return 0;
        }
        return umodel__.getLoginStopFlg();
    }

    /**
     * @return チャット相手ユーザ状態区分
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getUserDeleteFlg()
     */

    public int getUserDeleteFlg() {
        if (type__ == EnumMentionType.all) {
            return 0;
        }
        return umodel__.getUserDeleteFlg();
    }

    /**
     * @return 画像バイナリSID
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getImageBinSid()
     */

    public long getImageBinSid() {
        if (type__ == EnumMentionType.all) {
            return 0;
        }
        return umodel__.getImageBinSid();
    }

    /**
     * @return ユーザ画像公開フラグ
     * @see jp.groupsession.v2.restapi.response.MinimalUserInfoModel#getImageKoukaiFlg()
     */

    public int getImageKoukaiFlg() {
        if (type__ == EnumMentionType.all) {
            return 0;
        }
        return umodel__.getImageKoukaiFlg();
    }



}
