package jp.groupsession.v2.cht.restapi.entities.messages.reactions;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cht.GSConstChat;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Put;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

@Plugin(GSConstChat.PLUGIN_ID_CHAT)
public class ChtReactionAction  extends AbstractRestApiAction {

    /**
     * リアクション状態を変更するAPI アクションメソッド
     * @param req
     * @param res
     * @param param
     * @param ctx
     * @throws SQLException
     */
    @Put
    public void doPut(
        HttpServletRequest req,
        HttpServletResponse res,
        ChtReactionPutParamModel param,
        RestApiContext ctx) throws SQLException {

        JDBCUtil.autoCommitOff(ctx.getCon());

        ChtReactionPutBiz biz = ChtReactionPutBiz.getInstance(
            param,
            ctx);
        biz.execute();

        JDBCUtil.autoCommitOn(ctx.getCon());

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

    }
}
